/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.adl.datamodels.DataModelValidator;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.samplerte.client.APIAdapterApplet;
import org.adl.util.debug.DebugIndicator;

public class CMICategory
implements Serializable {
    protected boolean writeable;
    static /* synthetic */ Class class$0;

    public CMICategory(boolean writeableFlag) {
        this.writeable = writeableFlag;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public String determineElementValue(Object o, String element, DMErrorManager dmErrorMgr) {
        String rtrnString = new String("");
        Class<?> c = o.getClass();
        try {
            Field tmpField = c.getField(element);
            Element e = (Element)tmpField.get(o);
            if (e.isReadable()) {
                rtrnString = e.getValue();
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Element not readable");
                    System.out.println("Value: " + element + " is not readable");
                }
                dmErrorMgr.SetCurrentErrorCode("404");
            }
        }
        catch (NoSuchFieldException nsfe) {
            if (element.equals("_count")) {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Element not an array");
                    System.out.println("Element Cannont have count");
                }
                dmErrorMgr.SetCurrentErrorCode("203");
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Invalid Argument Error");
                    System.out.println("Invalid data model element: " + element);
                }
                dmErrorMgr.SetCurrentErrorCode("201");
            }
        }
        catch (SecurityException se) {
            if (DebugIndicator.ON) {
                System.out.println(se);
                System.out.println("Access to the information is denied");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        catch (IllegalAccessException iae) {
            if (DebugIndicator.ON) {
                System.out.println(iae);
                System.out.println("Underlying constructor is inaccessible");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        return rtrnString;
    }

    public void doSet(Object o, String element, String value, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("CMICategory::doSet()");
            System.out.println("Object: " + o.getClass().getName());
            System.out.println("Element: " + element);
            System.out.println("Value: " + value);
        }
        Class<?> c = o.getClass();
        try {
            Field tmpField = c.getField(element);
            Element e = (Element)tmpField.get(o);
            if (e.isImplemented()) {
                if (e.isWriteable() || APIAdapterApplet.areweloading) {
                    if (this.validateType(o, e, element, value, dmErrorMgr)) {
                        e.setValue(value);
                        dmErrorMgr.SetCurrentErrorCode("0");
                        if (DebugIndicator.ON) {
                            System.out.println("Element: " + element + " was set to [" + value + "]");
                        }
                    } else {
                        if (DebugIndicator.ON) {
                            System.out.println("*** INVALID LMSSetValue() CALL ***");
                            System.out.println("          Invalid Type            ");
                            System.out.println("Element: " + element + " was NOT set!");
                        }
                        dmErrorMgr.SetCurrentErrorCode("405");
                    }
                } else {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - Element not Writeable");
                        System.out.println("Element: " + element + " is not writeable");
                    }
                    dmErrorMgr.SetCurrentErrorCode("403");
                }
            } else if (e.isMandatory()) {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Mandatory Element not Implemented");
                    System.out.println("Mandatory Value: " + element + " was not implemented");
                }
                dmErrorMgr.SetCurrentErrorCode("401");
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Warning - Optional Value Not Implemented");
                    System.out.println("Optional Element: " + element + " was not implemented");
                }
                dmErrorMgr.SetCurrentErrorCode("0");
            }
        }
        catch (NoSuchFieldException nsfe) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Invalid Argument Error");
                System.out.println("Invalid data model element: " + element);
            }
            dmErrorMgr.SetCurrentErrorCode("201");
        }
        catch (SecurityException se) {
            if (DebugIndicator.ON) {
                System.out.println(se);
                System.out.println("Access to the information is denied");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        catch (IllegalAccessException iae) {
            if (DebugIndicator.ON) {
                System.out.println(iae);
                System.out.println("Underlying constructor is inaccessible");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        if (DebugIndicator.ON) {
            System.out.println("Exiting CMICategory::doSet()");
        }
    }

    protected boolean validateType(Object o, Element e, String element, String value, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("   Validating data type of the set value");
            System.out.println("   Check method: " + e.getType());
            System.out.println("   Element: " + element);
            System.out.println("   Value: " + value);
        }
        boolean result = false;
        DataModelValidator dmValidator = new DataModelValidator();
        Class<?> dmClass = dmValidator.getClass();
        Class[] classArray = new Class[2];
        classArray[0] = e.getClass();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        Class[] parameterTypes = classArray;
        Object[] arguments = new Object[]{e, value};
        try {
            Method theMethod = dmClass.getMethod(e.getType(), parameterTypes);
            Boolean theResult = (Boolean)theMethod.invoke((Object)dmValidator, arguments);
            result = theResult;
        }
        catch (NoSuchMethodException nsme) {
            if (DebugIndicator.ON) {
                System.out.println(nsme);
                System.out.println("No Such method: " + e.getType() + "()");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        catch (IllegalAccessException iae) {
            if (DebugIndicator.ON) {
                System.out.println(iae);
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        catch (InvocationTargetException ite) {
            if (DebugIndicator.ON) {
                System.out.println(ite);
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        if (DebugIndicator.ON) {
            System.out.println("   Result from validation: " + result);
        }
        return result;
    }
}

