/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIInteractionData;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIInteractions
extends CMICategory
implements Serializable {
    public Vector interactions = new Vector();

    public CMIInteractions() {
        super(false);
    }

    public Vector getInteractions() {
        return this.interactions;
    }

    public void setInteractions(CMIInteractionData inInteractions, int index) {
        this.interactions.add(index, inInteractions);
    }

    public String getChildren() {
        String children = "id,objectives,time,type,correct_responses,weighting,student_response,result,latency";
        return children;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("\tIn CMIInteractions::performSet()");
        }
        String token = theRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("\tToken being processed: " + token);
        }
        if (theRequest.isAKeywordRequest()) {
            dmErrorMgr.recKeyWordError(token);
        } else {
            int index = -1;
            try {
                Integer tmpInt = new Integer(token);
                index = tmpInt;
                CMIInteractionData tmpInteraction = (CMIInteractionData)this.interactions.elementAt(index);
                tmpInteraction.performSet(theRequest, dmErrorMgr);
                this.interactions.set(index, tmpInteraction);
            }
            catch (NumberFormatException nfe) {
                if (DebugIndicator.ON) {
                    System.out.println("\tError - Data Model Element not implemented");
                    System.out.println("\tInvalid data model element: " + theRequest.getRequest() + " passed to LMSSetValue()");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (DebugIndicator.ON) {
                    System.out.println("\tFirst time setting the interaction data at the given index");
                }
                if (index <= this.interactions.size()) {
                    CMIInteractionData intData = new CMIInteractionData();
                    intData.performSet(theRequest, dmErrorMgr);
                    this.interactions.add(index, intData);
                }
                dmErrorMgr.SetCurrentErrorCode("201");
            }
        }
        theRequest.done();
        if (DebugIndicator.ON) {
            System.out.println("\tCMIInteractions - performSet() exit");
        }
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result;
        block19: {
            result = new String("");
            int tokenCount = theRequest.getTotalNumTokens();
            if (DebugIndicator.ON) {
                System.out.println("\tCMIInteractions::performGet()");
            }
            if (tokenCount == 3 && theRequest.isAChildrenRequest()) {
                if (DebugIndicator.ON) {
                    System.out.println("\tProcessing a _children request");
                }
                result = this.getChildren();
            } else if (theRequest.isACountRequest()) {
                if (DebugIndicator.ON) {
                    System.out.println("\tProcessing a _count request");
                }
                if (tokenCount == 3) {
                    int count = this.howManyInteractions();
                    Integer tmpInt = new Integer(count);
                    result = tmpInt.toString();
                } else {
                    String token = theRequest.getNextToken();
                    if (DebugIndicator.ON) {
                        System.out.println("\tProcessing next token: " + token);
                    }
                    try {
                        Integer tmpInt = new Integer(token);
                        int index = tmpInt;
                        CMIInteractionData intData = (CMIInteractionData)this.interactions.elementAt(index);
                        if (intData.isInitialized()) {
                            result = intData.getCount(theRequest, dmErrorMgr);
                            break block19;
                        }
                        String nextToken = theRequest.getNextToken();
                        if (nextToken.equals("objectives") || nextToken.equals("correct_responses")) {
                            result = "0";
                            break block19;
                        }
                        dmErrorMgr.recGetKeyWordError(theRequest.getElement());
                    }
                    catch (NumberFormatException nfe) {
                        if (DebugIndicator.ON) {
                            System.out.println("\tError - Invalid LMSGetValue() request");
                        }
                        dmErrorMgr.recNotImplementedError(theRequest);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        String nextToken = theRequest.getNextToken();
                        if (tokenCount == 5 && (nextToken.equals("objectives") || nextToken.equals("correct_responses"))) {
                            result = "0";
                            break block19;
                        }
                        dmErrorMgr.recGetKeyWordError(theRequest.getElement());
                        result = "";
                    }
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("\tInvalid LMSGetValue() request: " + theRequest.getRequest());
                    System.out.println("\tSCO is not permitted to call LMSGetValue() for cmi.interactions");
                }
                dmErrorMgr.SetCurrentErrorCode("404");
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("\tReturning: " + result + " from CMIInteractions");
            System.out.println("\tCMIInteractions::performGet() exit");
        }
        theRequest.done();
        return result;
    }

    private int howManyInteractions() {
        int count = 0;
        count = this.interactions.size();
        return count;
    }
}

