// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.


namespace System.Windows.Controls
{
    /// <summary>
    /// Specifies values for the different modes of operation of a Calendar. 
    /// </summary>
    public enum CalendarMode
    {
        /// <summary>
        /// The Calendar displays a month at a time.
        /// </summary>
        Month = 0,

        /// <summary>
        ///  The Calendar displays a year at a time.
        /// </summary>
        Year = 1,
        
        /// <summary>
        /// The Calendar displays a decade at a time.
        /// </summary>
        Decade = 2,
    }
}