﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Text.Json.Serialization;

namespace Roslyn.LanguageServer.Protocol
{
    /// <summary>
    /// Options to signal work done progress support in server capabilities.
    /// </summary>
    /// <remarks>Since LSP 3.15</remarks>
    internal interface IWorkDoneProgressOptions
    {
        /// <summary>
        /// Gets or sets a value indicating whether work done progress is supported.
        /// <para>
        /// See the <see href="https://microsoft.github.io/language-server-protocol/specifications/specification-current/#workDoneProgressOptions">Language Server Protocol specification</see> for additional information.
        /// </para>
        /// </summary>
        /// <remarks>Since LSP 3.15</remarks>
        // NOTE: these JSON attributes are not inherited, they are here as a reference for implementations
        [JsonPropertyName("workDoneProgress")]
        [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
        public bool WorkDoneProgress { get; init; }
    }
}
