#ifndef DUNE_Q1_LOCALCOEFFICIENTS_HH
#define DUNE_Q1_LOCALCOEFFICIENTS_HH

#include <cstddef>
#include <iostream>
#include <vector>

#include <dune/localfunctions/common/localkey.hh>

namespace Dune 
{

  /**@ingroup LocalLayoutImplementation
	 \brief Layout map for Q1 elements

	 \nosubgrouping
     \implements Dune::LocalCoefficientsVirtualImp
  */
    template <int dim>
  class Q1LocalCoefficients 
  {
  public:
	//! \brief Standard constructor
      Q1LocalCoefficients () : li(1<<dim)
	{
            for (std::size_t i=0; i<(1<<dim); i++)
		li[i] = LocalKey(i,dim,0);
	}

	//! number of coefficients
	std::size_t size () const
	{
            return 1<<dim;
	}

	//! get i'th index
	const LocalKey& localKey (std::size_t i) const
	{
	  return li[i];
	} 

  private:
	std::vector<LocalKey> li;
  };

}

#endif
