% Dynare time series class (@dseries)
% Copyright (C) 2011-2014 Dynare Team
%
% A dseries object contains 6 members:
%
%     1. data, a nobs*vobs array of floats, where nobs and vobs are repectively the number of observations and variables.
%     2. nobs, a scalar integer, the number of observations.
%     3. vobs, a scalar integer, the number of variables.
%     4. dates, a @dates object with nobs elements, range of dates.
%     5. name, a vobs*1 cell array of strings, names of the variables.
%     6. tex, a vobs*1 cell array of strings, tex names of the variables.
%
% All these members are public but nobs, vobs, data, name and tex are write protected. Available methods are:
%
%     <a href="matlab: help dseries.dseries">dseries</a>, constructor.
%     <a href="matlab: help dseries.abs">abs</a>, apply absolute value.
%     <a href="matlab: help dseries.align">align</a>, put two dseries objects on the same time range.
%     <a href="matlab: help dseries.baxter_king_filter">baxter_king_filter</a>, apply Baxter and King (1995, NBER Working paper n°5022) band pass filter.
%     <a href="matlab: help dseries.chain">chain</a>, merge two dseries objects along the time dimension.
%     <a href="matlab: help dseries.check">check</a>, sanity check of a dseries object.
%     <a href="matlab: help dseries.cumprod">cumprod</a>, cumulative product along the time dimension.
%     <a href="matlab: help dseries.cumsum">cumsum</a>, cumulative sum along the time dimension.
%     <a href="matlab: help dseries.display">display</a>, overload display function.
%     <a href="matlab: help dseries.disp">disp</a>, overload disp function.
%     <a href="matlab: help dseries.eq">eq</a>, overload the == binary operator.
%     <a href="matlab: help dseries.exp">exp</a>, apply the exponential function.
%     <a href="matlab: help dseries.extract">extract</a>, extract some variables from a dseries object.
%     <a href="matlab: help dseries.horzcat">horzcat</a>, concatenate an arbitrary number of dseries objects.
%     <a href="matlab: help dseries.hpcycle">hpcycle</a>, extract the cycle component from a dseries object using Hodrick Prescott (1997) filter.
%     <a href="matlab: help dseries.hptrend">hptrend</a>, extract the trend component from a dseries object using Hodrick Prescott (1997) filter.
%     <a href="matlab: help dseries.insert">insert</a>, insert a variable in a dseries object.
%     <a href="matlab: help dseries.isempty">isempty</a>, test if a dseries object is empty.
%     <a href="matlab: help dseries.isequal">isequal</a>, test if two dseries are equal.
%     <a href="matlab: help dseries.lag">lag</a>, shift a dseries object backward.
%     <a href="matlab: help dseries.lead">lead</a>, shift a dseries object forward.
%     <a href="matlab: help dseries.log">log</a>, apply the logarithmic function (reciprocical of the exponential function).
%     <a href="matlab: help dseries.merge">merge</a>, merge two time series objects.
%     <a href="matlab: help dseries.minus">minus</a>, overload the - binary operator.
%     <a href="matlab: help dseries.mpower">mpower</a>, overload the ^ binary operator.
%     <a href="matlab: help dseries.mrdivide">mrdivide</a>, overload the / binary operator.
%     <a href="matlab: help dseries.mtimes">mtimes</a>, overload the * binary operator.
%     <a href="matlab: help dseries.ne">ne</a>, overload the ~= binary operator.
%     <a href="matlab: help dseries.numel">numel</a>, overload the numel method.
%     <a href="matlab: help dseries.plot">plot</a>, overload the plot function for dseries objects.
%     <a href="matlab: help dseries.plus">plus</a>, overload the + binary operator.
%     <a href="matlab: help dseries.pop">pop</a>, remove a variable from a dseries object.
%     <a href="matlab: help dseries.qdiff">qdiff</a>, compute quaterly differences.
%     <a href="matlab: help dseries.qgrowth">qgrowth</a>, compute quaterly growth rates.
%     <a href="matlab: help dseries.rename">rename</a>, rename a variable.
%     <a href="matlab: help dseries.save">save</a>, save a dseries object.
%     <a href="matlab: help dseries.set_names">set_names</a>, rename all variables.
%     <a href="matlab: help dseries.size">size</a>, overload the size function.
%     <a href="matlab: help dseries.subsasgn">subsasgn</a>, overload the subsasgn method.
%     <a href="matlab: help dseries.subsref">subsref</a>, overload the subsref method.
%     <a href="matlab: help dseries.tex_rename">tex_rename</a>, change tex name of a variable.
%     <a href="matlab: help dseries.uminus">uminus</a>, overload the - unary operator.
%     <a href="matlab: help dseries.vertcat">vertcat</a>, append observations to a dseries object.
%     <a href="matlab: help dseries.ydiff">ydiff</a>, compute yearly differences.
%     <a href="matlab: help dseries.ygrowth">ygrowth</a>, compute yearly growth rates.
%
% More details about these methods and the overloaded operator are available in the <a href="http://www.dynare.org/manual">manual</a>.