-- $Id: //open/dev/farrago/initsql/createScottSchema.sql#3 $
-- This script creates the SCOTT schema used by some of the unit tests.

!set verbose true

-- create local SCOTT schema
create schema SCOTT;
set schema 'SCOTT';

CREATE TABLE DEPT (
    DEPTNO INTEGER NOT NULL PRIMARY KEY,
    DNAME VARCHAR(14),
    LOC VARCHAR(13));

INSERT INTO DEPT VALUES
    (10, 'ACCOUNTING', 'NEW YORK'),
    (20, 'RESEARCH', 'DALLAS'),
    (30, 'SALES', 'CHICAGO'),
    (40, 'OPERATIONS', 'BOSTON');

CREATE TABLE EMP (
    EMPNO INTEGER NOT NULL PRIMARY KEY,
    ENAME VARCHAR(10),
    JOB VARCHAR(9),
    MGR INTEGER,
    HIREDATE DATE,
    SAL INTEGER,
    COMM INTEGER,
    DEPTNO INTEGER);

INSERT INTO EMP VALUES
    (7369, 'SMITH', 'CLERK', 7902, DATE '1980-12-17', 800, NULL, 20),
    (7499, 'ALLEN', 'SALESMAN', 7698, DATE '1981-2-20', 1600, 300, 30),
    (7521, 'WARD', 'SALESMAN', 7698, DATE '1981-2-22', 1250, 500, 30),
    (7566, 'JONES', 'MANAGER', 7839, DATE '1981-4-2', 2975, NULL, 20),
    (7654, 'MARTIN', 'SALESMAN', 7698, DATE '1981-9-28', 1250, 1400, 30),
    (7698, 'BLAKE', 'MANAGER', 7839, DATE '1981-5-1', 2850, NULL, 30),
    (7782, 'CLARK', 'MANAGER', 7839, DATE '1981-6-9', 2450, NULL, 10),
    (7788, 'SCOTT', 'ANALYST', 7566, DATE '1987-7-13', 3000, NULL, 20),
    (7839, 'KING', 'PRESIDENT', NULL, DATE '1981-11-17', 5000, NULL, 10),
    (7844, 'TURNER', 'SALESMAN', 7698, DATE '1981-9-8', 1500, 0, 30),
    (7876, 'ADAMS', 'CLERK', 7788, DATE '1987-7-13', 1100, NULL, 20),
    (7900, 'JAMES', 'CLERK', 7698, DATE '1981-12-3', 950, NULL, 30),
    (7902, 'FORD', 'ANALYST', 7566, DATE '1981-12-3', 3000, NULL, 20),
    (7934, 'MILLER', 'CLERK', 7782, DATE '1982-1-23', 1300, NULL, 10);

CREATE TABLE BONUS(
    ENAME VARCHAR(10) PRIMARY KEY,
    JOB VARCHAR(9),
    SAL INTEGER,
    COMM INTEGER);

CREATE TABLE SALGRADE (
    GRADE INTEGER PRIMARY KEY,
    LOSAL INTEGER,
    HISAL INTEGER);

INSERT INTO SALGRADE VALUES
    (1, 700, 1200),
    (2, 1201, 1400),
    (3, 1401, 2000),
    (4, 2001, 3000),
    (5, 3001, 9999);

-- End createScottSchema.sql
