/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AAFrequency;
import jalview.analysis.Conservation;
import jalview.analysis.NJTree;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.FeatureSettings;
import jalview.bin.JalviewLite;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Annotation;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.util.Platform;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class AlignViewport {
    int startRes;
    int endRes;
    int startSeq;
    int endSeq;
    boolean cursorMode = false;
    boolean showJVSuffix = true;
    boolean showText = true;
    boolean showColourText = false;
    boolean showBoxes = true;
    boolean wrapAlignment = false;
    boolean renderGaps = true;
    boolean showSequenceFeatures = false;
    boolean showAnnotation = true;
    boolean showConservation = true;
    boolean showQuality = true;
    boolean showConsensus = true;
    boolean upperCasebold = false;
    boolean colourAppliesToAllGroups = true;
    ColourSchemeI globalColourScheme = null;
    boolean conservationColourSelected = false;
    boolean abovePIDThreshold = false;
    SequenceGroup selectionGroup;
    int charHeight;
    int charWidth;
    int wrappedWidth;
    Font font = new Font("SansSerif", 0, 10);
    boolean validCharWidth = true;
    AlignmentI alignment;
    ColumnSelection colSel = new ColumnSelection();
    int threshold;
    int increment;
    NJTree currentTree = null;
    boolean scaleAboveWrapped = true;
    boolean scaleLeftWrapped = true;
    boolean scaleRightWrapped = true;
    public Hashtable featuresDisplayed;
    boolean hasHiddenColumns = false;
    boolean hasHiddenRows = false;
    boolean showHiddenMarkers = true;
    public Hashtable[] hconsensus;
    AlignmentAnnotation consensus;
    AlignmentAnnotation conservation;
    AlignmentAnnotation quality;
    boolean autocalculateConsensus = true;
    public int ConsPercGaps = 25;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    boolean ignoreGapsInConsensusCalculation = false;
    JalviewLite applet;
    Hashtable sequenceColours;
    boolean MAC = false;
    Stack historyList = new Stack();
    Stack redoList = new Stack();
    String sequenceSetID;
    Hashtable hiddenRepSequences;
    ConservationThread conservationThread;
    ConsensusThread consensusThread;
    boolean consUpdateNeeded = false;
    static boolean UPDATING_CONSENSUS = false;
    static boolean UPDATING_CONSERVATION = false;
    boolean updatingConsensus = false;
    boolean updatingConservation = false;
    Frame nullFrame;
    protected FeatureSettings featureSettings = null;
    boolean centreColumnLabels;

    public AlignViewport(AlignmentI al, JalviewLite applet) {
        this.applet = applet;
        this.setAlignment(al);
        this.startRes = 0;
        this.endRes = al.getWidth() - 1;
        this.startSeq = 0;
        this.endSeq = al.getHeight() - 1;
        this.setFont(this.font);
        this.MAC = new Platform().isAMac();
        if (applet != null) {
            String param = applet.getParameter("showFullId");
            if (param != null) {
                this.showJVSuffix = Boolean.valueOf(param);
            }
            if ((param = applet.getParameter("showAnnotation")) != null) {
                this.showAnnotation = Boolean.valueOf(param);
            }
            if ((param = applet.getParameter("showConservation")) != null) {
                this.showConservation = Boolean.valueOf(param);
            }
            if ((param = applet.getParameter("showQuality")) != null) {
                this.showQuality = Boolean.valueOf(param);
            }
            if ((param = applet.getParameter("showConsensus")) != null) {
                this.showConsensus = Boolean.valueOf(param);
            }
            if ((param = applet.getParameter("upperCase")) != null && param.equalsIgnoreCase("bold")) {
                this.upperCasebold = true;
            }
        }
        if (applet != null) {
            String colour = applet.getParameter("defaultColour");
            if (colour == null && (colour = applet.getParameter("userDefinedColour")) != null) {
                colour = "User Defined";
            }
            if (colour != null) {
                this.globalColourScheme = ColourSchemeProperty.getColour(this.alignment, colour);
                if (this.globalColourScheme != null) {
                    this.globalColourScheme.setConsensus(this.hconsensus);
                }
            }
            if (applet.getParameter("userDefinedColour") != null) {
                ((UserColourScheme)this.globalColourScheme).parseAppletParameter(applet.getParameter("userDefinedColour"));
            }
        }
        if (this.hconsensus == null) {
            if (!this.alignment.isNucleotide()) {
                this.conservation = new AlignmentAnnotation("Conservation", "Conservation of total alignment less than " + this.ConsPercGaps + "% gaps", new Annotation[1], 0.0f, 11.0f, 1);
                this.conservation.hasText = true;
                this.conservation.autoCalculated = true;
                if (this.showConservation) {
                    this.alignment.addAnnotation(this.conservation);
                }
                if (this.showQuality) {
                    this.quality = new AlignmentAnnotation("Quality", "Alignment Quality based on Blosum62 scores", new Annotation[1], 0.0f, 11.0f, 1);
                    this.quality.hasText = true;
                    this.quality.autoCalculated = true;
                    this.alignment.addAnnotation(this.quality);
                }
            }
            this.consensus = new AlignmentAnnotation("Consensus", "PID", new Annotation[1], 0.0f, 100.0f, 1);
            this.consensus.hasText = true;
            this.consensus.autoCalculated = true;
            if (this.showConsensus) {
                this.alignment.addAnnotation(this.consensus);
            }
        }
    }

    public void showSequenceFeatures(boolean b) {
        this.showSequenceFeatures = b;
    }

    public boolean getShowSequenceFeatures() {
        return this.showSequenceFeatures;
    }

    public void updateConservation(AlignmentPanel ap) {
        if (this.alignment.isNucleotide() || this.conservation == null) {
            return;
        }
        this.conservationThread = new ConservationThread(ap);
        this.conservationThread.start();
    }

    public void updateConsensus(AlignmentPanel ap) {
        this.consensusThread = new ConsensusThread(ap);
        this.consensusThread.start();
    }

    public SequenceI getConsensusSeq() {
        if (this.consensus == null) {
            return null;
        }
        StringBuffer seqs = new StringBuffer();
        for (int i = 0; i < this.consensus.annotations.length; ++i) {
            if (this.consensus.annotations[i] == null) continue;
            if (this.consensus.annotations[i].description.charAt(0) == '[') {
                seqs.append(this.consensus.annotations[i].description.charAt(1));
                continue;
            }
            seqs.append(this.consensus.annotations[i].displayCharacter);
        }
        Sequence sq = new Sequence("Consensus", seqs.toString());
        sq.setDescription("Percentage Identity Consensus " + (this.ignoreGapsInConsensusCalculation ? " without gaps" : ""));
        return sq;
    }

    public SequenceGroup getSelectionGroup() {
        return this.selectionGroup;
    }

    public void setSelectionGroup(SequenceGroup sg) {
        this.selectionGroup = sg;
    }

    public boolean getConservationSelected() {
        return this.conservationColourSelected;
    }

    public void setConservationSelected(boolean b) {
        this.conservationColourSelected = b;
    }

    public boolean getAbovePIDThreshold() {
        return this.abovePIDThreshold;
    }

    public void setAbovePIDThreshold(boolean b) {
        this.abovePIDThreshold = b;
    }

    public int getStartRes() {
        return this.startRes;
    }

    public int getEndRes() {
        return this.endRes;
    }

    public int getStartSeq() {
        return this.startSeq;
    }

    public void setGlobalColourScheme(ColourSchemeI cs) {
        this.globalColourScheme = cs;
    }

    public ColourSchemeI getGlobalColourScheme() {
        return this.globalColourScheme;
    }

    public void setStartRes(int res) {
        this.startRes = res;
    }

    public void setStartSeq(int seq) {
        this.startSeq = seq;
    }

    public void setEndRes(int res) {
        if (res > this.alignment.getWidth() - 1) {
            res = this.alignment.getWidth() - 1;
        }
        if (res < 0) {
            res = 0;
        }
        this.endRes = res;
    }

    public void setEndSeq(int seq) {
        if (seq > this.alignment.getHeight()) {
            seq = this.alignment.getHeight();
        }
        if (seq < 0) {
            seq = 0;
        }
        this.endSeq = seq;
    }

    public int getEndSeq() {
        return this.endSeq;
    }

    public void setFont(Font f) {
        this.font = f;
        if (this.nullFrame == null) {
            this.nullFrame = new Frame();
            this.nullFrame.addNotify();
        }
        FontMetrics fm = this.nullFrame.getGraphics().getFontMetrics(this.font);
        this.setCharHeight(fm.getHeight());
        this.charWidth = fm.charWidth('M');
        if (this.upperCasebold) {
            Font f2 = new Font(f.getName(), 1, f.getSize());
            fm = this.nullFrame.getGraphics().getFontMetrics(f2);
            this.charWidth = fm.stringWidth("MMMMMMMMMMM") / 10;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public void setCharHeight(int h) {
        this.charHeight = h;
    }

    public int getCharHeight() {
        return this.charHeight;
    }

    public void setWrappedWidth(int w) {
        this.wrappedWidth = w;
    }

    public int getwrappedWidth() {
        return this.wrappedWidth;
    }

    public AlignmentI getAlignment() {
        return this.alignment;
    }

    public void setAlignment(AlignmentI align) {
        this.alignment = align;
    }

    public void setWrapAlignment(boolean state) {
        this.wrapAlignment = state;
    }

    public void setShowText(boolean state) {
        this.showText = state;
    }

    public void setRenderGaps(boolean state) {
        this.renderGaps = state;
    }

    public boolean getColourText() {
        return this.showColourText;
    }

    public void setColourText(boolean state) {
        this.showColourText = state;
    }

    public void setShowBoxes(boolean state) {
        this.showBoxes = state;
    }

    public boolean getWrapAlignment() {
        return this.wrapAlignment;
    }

    public boolean getShowText() {
        return this.showText;
    }

    public boolean getShowBoxes() {
        return this.showBoxes;
    }

    public char getGapCharacter() {
        return this.getAlignment().getGapCharacter();
    }

    public void setGapCharacter(char gap) {
        if (this.getAlignment() != null) {
            this.getAlignment().setGapCharacter(gap);
        }
    }

    public void setThreshold(int thresh) {
        this.threshold = thresh;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setIncrement(int inc) {
        this.increment = inc;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setHiddenColumns(ColumnSelection colsel) {
        this.colSel = colsel;
        if (this.colSel.getHiddenColumns() != null) {
            this.hasHiddenColumns = true;
        }
    }

    public ColumnSelection getColumnSelection() {
        return this.colSel;
    }

    public void resetSeqLimits(int height) {
        this.setEndSeq(height / this.getCharHeight());
    }

    public void setCurrentTree(NJTree tree) {
        this.currentTree = tree;
    }

    public NJTree getCurrentTree() {
        return this.currentTree;
    }

    public void setColourAppliesToAllGroups(boolean b) {
        this.colourAppliesToAllGroups = b;
    }

    public boolean getColourAppliesToAllGroups() {
        return this.colourAppliesToAllGroups;
    }

    public boolean getShowJVSuffix() {
        return this.showJVSuffix;
    }

    public void setShowJVSuffix(boolean b) {
        this.showJVSuffix = b;
    }

    public boolean getShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowAnnotation(boolean b) {
        this.showAnnotation = b;
    }

    public boolean getScaleAboveWrapped() {
        return this.scaleAboveWrapped;
    }

    public boolean getScaleLeftWrapped() {
        return this.scaleLeftWrapped;
    }

    public boolean getScaleRightWrapped() {
        return this.scaleRightWrapped;
    }

    public void setScaleAboveWrapped(boolean b) {
        this.scaleAboveWrapped = b;
    }

    public void setScaleLeftWrapped(boolean b) {
        this.scaleLeftWrapped = b;
    }

    public void setScaleRightWrapped(boolean b) {
        this.scaleRightWrapped = b;
    }

    public void setIgnoreGapsConsensus(boolean b) {
        this.ignoreGapsInConsensusCalculation = b;
        this.updateConsensus(null);
        if (this.globalColourScheme != null) {
            this.globalColourScheme.setThreshold(this.globalColourScheme.getThreshold(), this.ignoreGapsInConsensusCalculation);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String prop, Object oldvalue, Object newvalue) {
        this.changeSupport.firePropertyChange(prop, oldvalue, newvalue);
    }

    public boolean getIgnoreGapsConsensus() {
        return this.ignoreGapsInConsensusCalculation;
    }

    public void hideSelectedColumns() {
        if (this.colSel.size() < 1) {
            return;
        }
        this.colSel.hideSelectedColumns();
        this.setSelectionGroup(null);
        this.hasHiddenColumns = true;
    }

    public void invertColumnSelection() {
        for (int i = 0; i < this.alignment.getWidth(); ++i) {
            if (this.colSel.contains(i)) {
                this.colSel.removeElement(i);
                continue;
            }
            if (this.hasHiddenColumns && !this.colSel.isVisible(i)) continue;
            this.colSel.addElement(i);
        }
    }

    public void hideColumns(int start, int end) {
        if (start == end) {
            this.colSel.hideColumns(start);
        } else {
            this.colSel.hideColumns(start, end);
        }
        this.hasHiddenColumns = true;
    }

    public void hideRepSequences(SequenceI repSequence, SequenceGroup sg) {
        int sSize = sg.getSize();
        if (sSize < 2) {
            return;
        }
        if (this.hiddenRepSequences == null) {
            this.hiddenRepSequences = new Hashtable();
        }
        this.hiddenRepSequences.put(repSequence, sg);
        SequenceI[] seqs = new SequenceI[sSize - 1];
        int index = 0;
        for (int i = 0; i < sSize; ++i) {
            if (sg.getSequenceAt(i) == repSequence) continue;
            if (index == sSize - 1) {
                return;
            }
            seqs[index++] = sg.getSequenceAt(i);
        }
        this.hideSequence(seqs);
    }

    public void hideAllSelectedSeqs() {
        if (this.selectionGroup == null || this.selectionGroup.getSize() < 1) {
            return;
        }
        SequenceI[] seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
        this.hideSequence(seqs);
        this.setSelectionGroup(null);
    }

    public void hideSequence(SequenceI[] seq) {
        if (seq != null) {
            for (int i = 0; i < seq.length; ++i) {
                this.alignment.getHiddenSequences().hideSequence(seq[i]);
            }
            this.hasHiddenRows = true;
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
        }
    }

    public void showColumn(int col) {
        this.colSel.revealHiddenColumns(col);
        if (this.colSel.getHiddenColumns() == null) {
            this.hasHiddenColumns = false;
        }
    }

    public void showAllHiddenColumns() {
        this.colSel.revealAllHiddenColumns();
        this.hasHiddenColumns = false;
    }

    public void showAllHiddenSeqs() {
        if (this.alignment.getHiddenSequences().getSize() > 0) {
            if (this.selectionGroup == null) {
                this.selectionGroup = new SequenceGroup();
                this.selectionGroup.setEndRes(this.alignment.getWidth() - 1);
            }
            Vector tmp = this.alignment.getHiddenSequences().showAll(this.hiddenRepSequences);
            for (int t = 0; t < tmp.size(); ++t) {
                this.selectionGroup.addSequence((SequenceI)tmp.elementAt(t), false);
            }
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
            this.hasHiddenRows = false;
            this.hiddenRepSequences = null;
        }
    }

    public int adjustForHiddenSeqs(int alignmentIndex) {
        return this.alignment.getHiddenSequences().adjustForHiddenSeqs(alignmentIndex);
    }

    public SequenceI[] getSelectionAsNewSequence() {
        SequenceI[] sequences = this.selectionGroup == null ? this.alignment.getSequencesArray() : this.selectionGroup.getSelectionAsNewSequences(this.alignment);
        return sequences;
    }

    public CigarArray getViewAsCigars(boolean selectedRegionOnly) {
        CigarArray selection;
        block14: {
            int end;
            int start;
            block11: {
                int iSize;
                selection = null;
                SequenceI[] seqs = null;
                start = 0;
                end = 0;
                if (selectedRegionOnly && this.selectionGroup != null) {
                    iSize = this.selectionGroup.getSize();
                    seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
                    start = this.selectionGroup.getStartRes();
                    end = this.selectionGroup.getEndRes();
                } else {
                    iSize = this.alignment.getHeight();
                    seqs = this.alignment.getSequencesArray();
                    end = this.alignment.getWidth() - 1;
                }
                CigarSimple[] selseqs = new SeqCigar[iSize];
                for (int i = 0; i < iSize; ++i) {
                    selseqs[i] = new SeqCigar(seqs[i], start, end);
                }
                selection = new CigarArray(selseqs);
                if (!this.hasHiddenColumns) break block11;
                Vector regions = this.colSel.getHiddenColumns();
                int last = start;
                int j = 0;
                while (last < end & j < regions.size()) {
                    block13: {
                        int hideEnd;
                        int hideStart;
                        block12: {
                            int[] region = (int[])regions.elementAt(j);
                            hideStart = region[0];
                            hideEnd = region[1];
                            if (hideStart >= last) break block12;
                            if (hideEnd <= last) break block13;
                            hideStart = last;
                        }
                        if (hideStart > end) break;
                        if (hideEnd > end) {
                            hideEnd = end;
                        }
                        if (hideStart > hideEnd) break;
                        if (last < hideStart) {
                            selection.addOperation('M', hideStart - last);
                        }
                        selection.addOperation('D', 1 + hideEnd - hideStart);
                        last = hideEnd + 1;
                    }
                    ++j;
                }
                if (last < end) {
                    selection.addOperation('M', end - last + 1);
                }
                break block14;
            }
            selection.addOperation('M', end - start + 1);
        }
        return selection;
    }

    AlignmentView getAlignmentView(boolean selectedOnly) {
        CigarArray aligview = this.getViewAsCigars(selectedOnly);
        if (aligview != null) {
            return new AlignmentView(aligview, selectedOnly && this.selectionGroup != null ? this.selectionGroup.getStartRes() : 0);
        }
        return null;
    }

    public String[] getViewAsString(boolean selectedRegionOnly) {
        int iSize;
        String[] selection = null;
        SequenceI[] seqs = null;
        int start = 0;
        int end = 0;
        if (selectedRegionOnly && this.selectionGroup != null) {
            iSize = this.selectionGroup.getSize();
            seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
            start = this.selectionGroup.getStartRes();
            end = this.selectionGroup.getEndRes() + 1;
        } else {
            iSize = this.alignment.getHeight();
            seqs = this.alignment.getSequencesArray();
            end = this.alignment.getWidth();
        }
        selection = new String[iSize];
        for (int i = 0; i < iSize; ++i) {
            if (this.hasHiddenColumns) {
                StringBuffer visibleSeq = new StringBuffer();
                Vector regions = this.colSel.getHiddenColumns();
                int blockStart = start;
                int blockEnd = end;
                for (int j = 0; j < regions.size(); ++j) {
                    int[] region = (int[])regions.elementAt(j);
                    int hideStart = region[0];
                    int hideEnd = region[1];
                    if (hideStart < start) continue;
                    if ((blockStart = Math.min(blockStart, hideEnd + 1)) > (blockEnd = Math.min(blockEnd, hideStart))) break;
                    visibleSeq.append(seqs[i].getSequence(blockStart, blockEnd));
                    blockStart = hideEnd + 1;
                    blockEnd = end;
                }
                if (end > blockStart) {
                    visibleSeq.append(seqs[i].getSequence(blockStart, end));
                }
                selection[i] = visibleSeq.toString();
                continue;
            }
            selection[i] = seqs[i].getSequenceAsString(start, end);
        }
        return selection;
    }

    public boolean getShowHiddenMarkers() {
        return this.showHiddenMarkers;
    }

    public void setShowHiddenMarkers(boolean show) {
        this.showHiddenMarkers = show;
    }

    public Color getSequenceColour(SequenceI seq) {
        if (this.sequenceColours == null || !this.sequenceColours.containsKey(seq)) {
            return Color.white;
        }
        return (Color)this.sequenceColours.get(seq);
    }

    public void setSequenceColour(SequenceI seq, Color col) {
        if (this.sequenceColours == null) {
            this.sequenceColours = new Hashtable();
        }
        if (col == null) {
            this.sequenceColours.remove(seq);
        } else {
            this.sequenceColours.put(seq, col);
        }
    }

    public String getSequenceSetId() {
        if (this.sequenceSetID == null) {
            this.sequenceSetID = this.alignment.hashCode() + "";
        }
        return this.sequenceSetID;
    }

    public void alignmentChanged(AlignmentPanel ap) {
        this.alignment.padGaps();
        if (this.hconsensus != null && this.autocalculateConsensus) {
            this.updateConsensus(ap);
            this.updateConservation(ap);
        }
        int alWidth = this.alignment.getWidth();
        Vector groups = this.alignment.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
                if (sg.getEndRes() <= alWidth) continue;
                sg.setEndRes(alWidth - 1);
            }
        }
        if (this.selectionGroup != null && this.selectionGroup.getEndRes() > alWidth) {
            this.selectionGroup.setEndRes(alWidth - 1);
        }
        this.resetAllColourSchemes();
    }

    void resetAllColourSchemes() {
        ColourSchemeI cs = this.globalColourScheme;
        if (cs != null) {
            if (cs instanceof ClustalxColourScheme) {
                ((ClustalxColourScheme)cs).resetClustalX(this.alignment.getSequences(), this.alignment.getWidth());
            }
            cs.setConsensus(this.hconsensus);
            if (cs.conservationApplied()) {
                Alignment al = (Alignment)this.alignment;
                Conservation c = new Conservation("All", ResidueProperties.propHash, 3, al.getSequences(), 0, al.getWidth() - 1);
                c.calculate();
                c.verdict(false, this.ConsPercGaps);
                cs.setConservation(c);
            }
        }
        int sSize = this.alignment.getGroups().size();
        for (int s = 0; s < sSize; ++s) {
            SequenceGroup sg = (SequenceGroup)this.alignment.getGroups().elementAt(s);
            if (sg.cs != null && sg.cs instanceof ClustalxColourScheme) {
                ((ClustalxColourScheme)sg.cs).resetClustalX(sg.getSequences(this.hiddenRepSequences), sg.getWidth());
            }
            sg.recalcConservation();
        }
    }

    public boolean getCentreColumnLabels() {
        return this.centreColumnLabels;
    }

    public void updateSequenceIdColours() {
        Vector groups = this.alignment.getGroups();
        int igSize = groups.size();
        for (int ig = 0; ig < igSize; ++ig) {
            SequenceGroup sg = (SequenceGroup)groups.elementAt(ig);
            if (sg.idColour == null) continue;
            Vector sqs = sg.getSequences(this.hiddenRepSequences);
            int sSize = sqs.size();
            for (int s = 0; s < sSize; ++s) {
                this.setSequenceColour((SequenceI)sqs.elementAt(s), sg.idColour);
            }
        }
    }

    class ConsensusThread
    extends Thread {
        AlignmentPanel ap;

        public ConsensusThread(AlignmentPanel ap) {
            this.ap = ap;
        }

        public void run() {
            AlignViewport.this.updatingConsensus = true;
            while (UPDATING_CONSENSUS) {
                try {
                    if (this.ap != null) {
                        this.ap.paintAlignment(false);
                    }
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            UPDATING_CONSENSUS = true;
            try {
                int aWidth = AlignViewport.this.alignment.getWidth();
                if (aWidth < 0) {
                    return;
                }
                AlignViewport.this.consensus.annotations = null;
                AlignViewport.this.consensus.annotations = new Annotation[aWidth];
                AlignViewport.this.hconsensus = new Hashtable[aWidth];
                AAFrequency.calculate(AlignViewport.this.alignment.getSequencesArray(), 0, AlignViewport.this.alignment.getWidth(), AlignViewport.this.hconsensus);
                for (int i = 0; i < aWidth; ++i) {
                    float value = 0.0f;
                    value = AlignViewport.this.ignoreGapsInConsensusCalculation ? ((Float)AlignViewport.this.hconsensus[i].get("N")).floatValue() : ((Float)AlignViewport.this.hconsensus[i].get("G")).floatValue();
                    String maxRes = AlignViewport.this.hconsensus[i].get("R").toString();
                    String mouseOver = AlignViewport.this.hconsensus[i].get("R") + " ";
                    if (maxRes.length() > 1) {
                        mouseOver = "[" + maxRes + "] ";
                        maxRes = "+";
                    }
                    mouseOver = mouseOver + (int)value + "%";
                    AlignViewport.this.consensus.annotations[i] = new Annotation(maxRes, mouseOver, ' ', value);
                }
                if (AlignViewport.this.globalColourScheme != null) {
                    AlignViewport.this.globalColourScheme.setConsensus(AlignViewport.this.hconsensus);
                }
            }
            catch (OutOfMemoryError error) {
                AlignViewport.this.alignment.deleteAnnotation(AlignViewport.this.consensus);
                AlignViewport.this.consensus = null;
                AlignViewport.this.hconsensus = null;
                System.out.println("Out of memory calculating consensus!!");
                System.gc();
            }
            UPDATING_CONSENSUS = false;
            AlignViewport.this.updatingConsensus = false;
            if (this.ap != null) {
                this.ap.paintAlignment(true);
            }
        }
    }

    class ConservationThread
    extends Thread {
        AlignmentPanel ap;

        public ConservationThread(AlignmentPanel ap) {
            this.ap = ap;
        }

        public void run() {
            try {
                AlignViewport.this.updatingConservation = true;
                while (UPDATING_CONSERVATION) {
                    try {
                        if (this.ap != null) {
                            this.ap.paintAlignment(false);
                        }
                        Thread.sleep(200L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                UPDATING_CONSERVATION = true;
                int alWidth = AlignViewport.this.alignment.getWidth();
                if (alWidth < 0) {
                    return;
                }
                Conservation cons = new Conservation("All", ResidueProperties.propHash, 3, AlignViewport.this.alignment.getSequences(), 0, alWidth - 1);
                cons.calculate();
                cons.verdict(false, AlignViewport.this.ConsPercGaps);
                if (AlignViewport.this.quality != null) {
                    cons.findQuality();
                }
                char[] sequence = cons.getConsSequence().getSequence();
                float minR = 0.3f;
                float minG = 0.0f;
                float minB = 0.0f;
                float maxR = 1.0f - minR;
                float maxG = 0.9f - minG;
                float maxB = 0.0f - minB;
                float min = 0.0f;
                float max = 11.0f;
                float qmin = 0.0f;
                float qmax = 0.0f;
                AlignViewport.this.conservation.annotations = new Annotation[alWidth];
                if (AlignViewport.this.quality != null) {
                    AlignViewport.this.quality.graphMax = cons.qualityRange[1].floatValue();
                    AlignViewport.this.quality.annotations = new Annotation[alWidth];
                    qmin = cons.qualityRange[0].floatValue();
                    qmax = cons.qualityRange[1].floatValue();
                }
                for (int i = 0; i < alWidth; ++i) {
                    float value = 0.0f;
                    char c = sequence[i];
                    if (Character.isDigit(c)) {
                        value = c - 48;
                    } else if (c == '*') {
                        value = 11.0f;
                    } else if (c == '+') {
                        value = 10.0f;
                    }
                    float vprop = value - min;
                    AlignViewport.this.conservation.annotations[i] = new Annotation(String.valueOf(c), String.valueOf(value), ' ', value, new Color(minR + maxR * (vprop /= max), minG + maxG * vprop, minB + maxB * vprop));
                    if (AlignViewport.this.quality == null) continue;
                    value = ((Double)cons.quality.elementAt(i)).floatValue();
                    vprop = value - qmin;
                    AlignViewport.this.quality.annotations[i] = new Annotation(" ", String.valueOf(value), ' ', value, new Color(minR + maxR * (vprop /= qmax), minG + maxG * vprop, minB + maxB * vprop));
                }
            }
            catch (OutOfMemoryError error) {
                System.out.println("Out of memory calculating conservation!!");
                AlignViewport.this.conservation = null;
                AlignViewport.this.quality = null;
                System.gc();
            }
            UPDATING_CONSERVATION = false;
            AlignViewport.this.updatingConservation = false;
            if (this.ap != null) {
                this.ap.paintAlignment(true);
            }
        }
    }
}

