/* $Id: segment.h,v 1.28 2012-07-04 07:05:43 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SEGMENT_H_INCLUDED
#define __SEGMENT_H_INCLUDED

#include "build_config.h"
#include <stddef.h>
#include <inttypes.h>
#include "compiler.h"

/* ==================== REAL-MODE ==================== */
#if defined(RUNTIME_RM) || defined(INIT_RM) 

#include "assert.h"


extern inline unsigned short
get_cs(void)
{
	unsigned short cs;

	__asm__(
		"movw %%cs, %0\n"
		: "=r" (cs)
	);

	return cs;
}

extern inline unsigned short
get_ss(void)
{
	unsigned short ss;

	__asm__(
		"movw %%ss, %0\n"
		: "=r" (ss)
	);

	return ss;
}

extern inline void
put_byte(unsigned short seg, size_t offset, unsigned char val)
{
	assert((unsigned long) offset < 0x10000);

	asm volatile (
		"movw %0, %%es\n"
		"movb %2, %%es:(%1)\n"
		: /* no output */
		: "r" (seg), "b" (offset), "q" (val)
		: "memory"
	);
}

extern inline void
put_word(unsigned short seg, size_t offset, unsigned short val)
{
	assert((unsigned long) offset < 0x10000);

	asm volatile (
		"movw %0, %%es\n"
		"movw %2, %%es:(%1)\n"
		: /* no output */
		: "r" (seg), "b" (offset), "r" (val)
		: "memory"
	);
}

extern inline void
put_long(unsigned short seg, size_t offset, uint32_t val)
{
	uint16_t val0;
	uint16_t val1;

	assert((unsigned long) offset < 0x10000);

	val0 = (uint16_t) val;
	val1 = (uint16_t) (val>>16);

	asm volatile (
		"movw %0, %%es\n"
		"movw %2, %%es:(%1)\n"
		"movw %3, %%es:2(%1)\n"
		: /* no output */
		: "r" (seg), "b" (offset), "r" (val0), "r" (val1)
		: "memory"
	);
}


extern inline unsigned char
get_byte(unsigned short seg, size_t offset)
{
	unsigned char val;

	assert((unsigned long) offset < 0x10000);

	asm volatile (
		"movw %1, %%es\n"
		"movb %%es:(%2), %0\n"
		: "=q" (val)
		: "r" (seg), "b" (offset)
	);

	return val;
}

extern inline unsigned short
get_word(unsigned short seg, size_t offset)
{
	unsigned short val;

	assert((unsigned long) offset < 0x10000);

	asm volatile (
		"movw %1, %%es\n"
		"movw %%es:(%2), %0\n"
		: "=r" (val)
		: "r" (seg), "b" (offset)
	);

	return val;
}

extern inline uint32_t
get_long(unsigned short seg, size_t offset)
{
	uint32_t val;
	uint16_t val0;
	uint16_t val1;

	assert((unsigned long) offset < 0x10000);

	asm volatile (
		"movw %2, %%es\n"
		"movw %%es:(%3), %0\n"
		"movw %%es:2(%3), %1\n"
		: "=&r" (val0), "=r" (val1)
		: "r" (seg), "b" (offset)
	);

	val = val1;
	val = (val << 16) + val0;

	return val;
}

#endif /* REAL-MODE */
/* ==================== PROTECTED MODE ==================== */
#if defined(RUNTIME_PM)

extern inline void
put_byte(unsigned int seg, size_t offset, uint8_t val)
{
	*((uint8_t *) PTR(seg, offset)) = val;
}

extern inline void
put_word(unsigned int seg, size_t offset, uint16_t val)
{
	*((int16_t *) PTR(seg, offset)) = val;
}

extern inline void
put_long(unsigned int seg, size_t offset, uint32_t val)
{
	*((uint32_t *) PTR(seg, offset)) = val;
}


extern inline uint8_t
get_byte(unsigned int seg, size_t offset)
{
	return *((unsigned char *) PTR(seg, offset));
}

extern inline uint16_t
get_word(unsigned int seg, size_t offset)
{
	return *((uint16_t *) PTR(seg, offset));
}

extern inline uint32_t
get_long(unsigned int seg, size_t offset)
{
	return *((uint32_t *) PTR(seg, offset));
}

#endif /* PROTECTED MODE */

#endif /* __SEGMENT_H_INCLUDED */
