case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . config.sh
    ;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >Makefile <<!GROK!THIS!
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHGRP		=	$chgrp
CHMOD		=	$chmod
CP		=	$cp
DEST		=	\$(DESTDIR)$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $xenlf
LIB		=	$lib
LIB2		= 	$libs
LIBS		=	$termlib $dbm
LINT		=	$lint
MAILGRP		=	$mailgrp
MAILERMODE	=	$mailermode
MAKE		=	$make
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch


!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>Makefile <<'!NO!SUBS!'
#	Variables you may want to manually edit
#		If you want debug logging then you'll
#		want to uncomment the following.
#DEBUG		=	-DDEBUG

#	Other variables
CFLAGS		=	$(CCFLAGS) $(OPTIMIZE) $(DEBUG) $(DACSNET) 

# Definitions of variables
FILTER_SRC	=	actions.c	\
			filter.c	\
			lock.c		\
			parse.c		\
			regexp.c	\
			rules.c		\
			summarize.c	\
			utils.c		\
			audit.c		\
			istrcmp.c	\
			mk_lockname.c	\
			strtokq.c

FILTER_OBJ	=	actions.o	\
			filter.o	\
			lock.o		\
			parse.o		\
			regexp.o	\
			rules.o		\
			summarize.o	\
			utils.o		\
			audit.o		\
			istrcmp.o	\
			mk_lockname.o	\
			strtokq.o


# Standard targets
all:		filter

install:	$(DEST)/filter
	(cd doc && $(MAKE) DESTDIR=$(DESTDIR) $(MFLAGS) install)	

uninstall:	
		$(RM) $(DEST)/filter

clean:		
		$(RM) $(FILTER_OBJ) filter core

reallyclean:	clean
		$(RM) config.sh

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		defs.h 

defs.h:	config.h 
	$(CHMOD) u+w $@
	$(TOUCH) $@


#	Dependencies and rules for C object files
actions.o:		defs.h filter.h s_filter.h
filter.o:		defs.h filter.h s_filter.h version.h
lock.o:			defs.h filter.h s_filter.h
parse.o:		defs.h filter.h s_filter.h
regexp.o:		defs.h regexp.h
rules.o:		defs.h filter.h s_filter.h
summarize.o:		defs.h filter.h s_filter.h
utils.o:		defs.h filter.h s_filter.h
audit.o:		defs.h filter.h s_filter.h

#	Dependencies and rules for compiling programs
filter:	$& $(FILTER_OBJ)
	$(CC) $(LFLAGS) -o $@ $(FILTER_OBJ)

#	Dependencies and rules for installing programs from bin directory
$(DEST)/filter:		filter
			-$(MV) $(DEST)/filter $(DEST)/filter.old
			-$(RM) $(DEST)/filter.old
			$(CP) $? $@
			$(CHGRP) $(MAILGRP) $@
			$(CHMOD) $(MAILERMODE) $@


!NO!SUBS!
chmod 755 Makefile
$eunicefix Makefile
