/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.SourceType;

public class SourceTypeDiscoverer {
    private Map<String, SourceType> mapExtensionOnSourceType = new HashMap<String, SourceType>();

    public SourceTypeDiscoverer() {
        this.initialize();
    }

    private void initialize() {
        this.mapExtensionOnSourceType.put("JSP", SourceType.JSP);
        this.mapExtensionOnSourceType.put("JSPX", SourceType.JSP);
        this.mapExtensionOnSourceType.put("JAVA", SourceType.JAVA_14);
    }

    public SourceType getSourceTypeOfFile(File sourceFile) {
        String fileName = sourceFile.getName();
        return this.getSourceTypeOfFile(fileName);
    }

    public SourceType getSourceTypeOfFile(String fileName) {
        SourceType sourceType = null;
        int extensionIndex = 1 + fileName.lastIndexOf(46);
        if (extensionIndex > 0) {
            String extensionUppercase = fileName.substring(extensionIndex).toUpperCase();
            sourceType = this.mapExtensionOnSourceType.get(extensionUppercase);
        }
        return sourceType;
    }

    public void setSourceTypeOfJavaFiles(SourceType sourceType) {
        this.mapExtensionOnSourceType.put("JAVA", sourceType);
    }

    public SourceType getSourceTypeOfJavaFiles() {
        return this.mapExtensionOnSourceType.get("JAVA");
    }
}

