/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class SingularField
extends AbstractRule {
    private static final PropertyDescriptor CHECK_INNER_CLASSES = new BooleanProperty("CheckInnerClasses", "Check inner classes", false, 1.0f);
    private static final PropertyDescriptor DISALLOW_NOT_ASSIGNMENT = new BooleanProperty("DisallowNotAssignment", "Disallow violations where the first usage is not an assignment", false, 1.0f);

    public Object visit(ASTFieldDeclaration node, Object data) {
        boolean checkInnerClasses = this.getBooleanProperty(CHECK_INNER_CLASSES);
        boolean disallowNotAssignment = this.getBooleanProperty(DISALLOW_NOT_ASSIGNMENT);
        if (node.isPrivate() && !node.isStatic()) {
            List<ASTVariableDeclaratorId> list = node.findChildrenOfType(ASTVariableDeclaratorId.class);
            ASTVariableDeclaratorId declaration = list.get(0);
            List<NameOccurrence> usages = declaration.getUsages();
            SimpleNode decl = null;
            boolean violation = true;
            for (int ix = 0; ix < usages.size(); ++ix) {
                ASTClassOrInterfaceDeclaration clazz;
                NameOccurrence no = usages.get(ix);
                SimpleNode location = no.getLocation();
                ASTPrimaryExpression primaryExpressionParent = location.getFirstParentOfType(ASTPrimaryExpression.class);
                if (ix == 0 && !disallowNotAssignment) {
                    if (primaryExpressionParent.getFirstParentOfType(ASTIfStatement.class) != null) {
                        violation = false;
                        break;
                    }
                    Node potentialStatement = primaryExpressionParent.jjtGetParent();
                    boolean assignmentToField = no.getImage().equals(location.getImage());
                    if (!assignmentToField || !this.isInAssignment(potentialStatement)) {
                        violation = false;
                        break;
                    }
                    if (usages.size() > ix + 1) {
                        SimpleNode secondUsageLocation = usages.get(ix + 1).getLocation();
                        List<ASTStatementExpression> parentStatements = secondUsageLocation.getParentsOfType(ASTStatementExpression.class);
                        for (ASTStatementExpression statementExpression : parentStatements) {
                            if (statementExpression == null || !statementExpression.equals(potentialStatement)) continue;
                            violation = false;
                            break;
                        }
                    }
                }
                if (!checkInnerClasses && (clazz = location.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) != null && clazz.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class) != null) {
                    violation = false;
                    break;
                }
                if (primaryExpressionParent.jjtGetParent() instanceof ASTSynchronizedStatement) {
                    violation = false;
                    break;
                }
                SimpleNode method = location.getFirstParentOfType(ASTMethodDeclaration.class);
                if (method == null && (method = (SimpleNode)location.getFirstParentOfType(ASTConstructorDeclaration.class)) == null && (method = (SimpleNode)location.getFirstParentOfType(ASTInitializer.class)) == null) continue;
                if (decl == null) {
                    decl = method;
                    continue;
                }
                if (decl == method) continue;
                violation = false;
                break;
            }
            if (violation && !usages.isEmpty()) {
                this.addViolation(data, (Node)node, new Object[]{declaration.getImage()});
            }
        }
        return data;
    }

    private boolean isInAssignment(Node potentialStatement) {
        if (potentialStatement instanceof ASTStatementExpression) {
            ASTStatementExpression statement = (ASTStatementExpression)potentialStatement;
            ArrayList assignments = new ArrayList();
            statement.findChildrenOfType(ASTAssignmentOperator.class, assignments, false);
            return !assignments.isEmpty() && "=".equals(((ASTAssignmentOperator)assignments.get(0)).getImage());
        }
        return false;
    }
}

