/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strictexception;

import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionSignatureDeclaration
extends AbstractRule {
    private boolean junitImported;

    @Override
    public Object visit(ASTCompilationUnit node, Object o) {
        this.junitImported = false;
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object o) {
        if (node.getImportedName().indexOf("junit") != -1) {
            this.junitImported = true;
        }
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object o) {
        if ((methodDeclaration.getMethodName().equals("setUp") || methodDeclaration.getMethodName().equals("tearDown")) && this.junitImported) {
            return super.visit(methodDeclaration, o);
        }
        if (methodDeclaration.getMethodName().startsWith("test")) {
            return super.visit(methodDeclaration, o);
        }
        List<ASTName> exceptionList = methodDeclaration.findChildrenOfType(ASTName.class);
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
        return super.visit(methodDeclaration, o);
    }

    @Override
    public Object visit(ASTConstructorDeclaration constructorDeclaration, Object o) {
        List<ASTName> exceptionList = constructorDeclaration.findChildrenOfType(ASTName.class);
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
        return super.visit(constructorDeclaration, o);
    }

    private void evaluateExceptions(List<ASTName> exceptionList, Object context) {
        for (ASTName exception : exceptionList) {
            if (!this.hasDeclaredExceptionInSignature(exception)) continue;
            this.addViolation(context, exception);
        }
    }

    private boolean hasDeclaredExceptionInSignature(ASTName exception) {
        return exception.hasImageEqualTo("Exception") && this.isParentSignatureDeclaration(exception);
    }

    private boolean isParentSignatureDeclaration(ASTName exception) {
        Node parent = exception.jjtGetParent().jjtGetParent();
        return parent instanceof ASTMethodDeclaration || parent instanceof ASTConstructorDeclaration;
    }
}

