#                                                         -*- Perl -*-
# Copyright (c) 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ︡饹
#
package FreePWING::FPWUtils::KeyWord;

require 5.005;
use English;
use FreePWING::KeyWord;
use FreePWING::FPWUtils::FPWUtils;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(FreePWING::KeyWord);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    return $type->SUPER::new();
}

#
# :
#	open()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹ѤθФե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    
    return $self->SUPER::open($keyword_file_name);
}

#
# :
#	add_entry(word)
#           word
#		ñ
#           heading_position
#               Фΰ
#           text_position
#               ʸΰ
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեñɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;
    my ($word, $heading_position, $text_position) = @ARG;

    return $self->SUPER::add_entry($word,
				   $heading_position, $heading_file_name,
				   $text_position, $text_file_name);
}

1;
