'''OpenGL extension ARB.vertex_attrib_binding

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.vertex_attrib_binding to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL currently supports (at least) 16 vertex attributes and 16 vertex 
	buffer bindings, with a fixed mapping between vertex attributes and 
	vertex buffer bindings. This extension allows the application to change
	the mapping between attributes and bindings, which can make it more 
	efficient to update vertex buffer bindings for interleaved vertex formats
	where many attributes share the same buffer.
	
	This extension also separates the vertex binding update from the vertex
	attribute format update, which saves applications the effort of 
	redundantly specifying the same format state over and over.
	
	Conceptually, this extension splits the state for generic vertex attribute
	arrays into:
	
	- An array of vertex buffer binding points, each of which specifies:
	
	  - a bound buffer object,
	
	  - a starting offset for the vertex attribute data in that buffer object,
	
	  - a stride used by all attributes using that binding point, and
	
	  - a frequency divisor used by all attributes using that binding point.
	
	- An array of generic vertex attribute format information records, each of
	  which specifies:
	
	  - a reference to one of the new buffer binding points above,
	
	  - a component count and format, and a normalization flag for the
	    attribute data, and
	
	  - the offset of the attribute data relative to the base offset of each
	    vertex found at the associated binding point.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/vertex_attrib_binding.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.vertex_attrib_binding import *
from OpenGL.raw.GL.ARB.vertex_attrib_binding import _EXTENSION_NAME

def glInitVertexAttribBindingARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION