/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_ATIR128_H
#define GATOS_ATIR128_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_ATIR128_C
#define WHERE
#else
#define WHERE	extern
#endif

#include <stdio.h>

#ifdef XY
#undef XY
#endif
#ifdef XYZ
#undef XYZ
#endif

#define XY(Y,X)		\
	( ( (0xFFFF&((u32)(X))) << 16 ) | (0xFFFF&((u32)(Y))) )
#define XYZ(X,Y,Z)	\
	( ( (0xFF&((u32)(X))) << 16 ) | ( (0xFF&((u32)(Y))) << 8 ) | (0xFF&((u32)(Z))) )

/* OV0_SCALE_CNTL values */
#define DISABLE_R128_VIDEO	0x00FF8B03L
#define ENABLE_R128_VIDEO	\
	(0x71FF8C01L|((gatos.gamma)?((4-gatos.gamma)<<5):0)|(gatos.cold<<1))

/* CAP0_CONFIG values */
#define ENABLE_R128_CAPTURE	0x1C0000B5L

/* ATI Rage128 function declarations */

int	r128_init(void) ;
int	r128_inita(void) ;
int	r128_initb(void) ;

int	r128_setcolorkey(void) ;
void	r128_enable_video(int) ;
void	r128_enable_capture(int) ;
void	r128_buffer_mode(void) ;
int	r128_setcaptsize(void) ;
int	r128_pollscreen(int) ;
void	r128_setgeometry(void) ;
int	r128_setgamma(void) ;
int	r128_setcold(void) ;

void	r128_rgbcapture(unsigned char*) ;
void	r128_capture(FILE*, int) ;
void	r128_playback(FILE*, int) ;

void	r128_dumpregs(void) ;

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
