/* { dg-require-effective-target vect_int } */
/* { dg-require-effective-target vect_shift } */
/* { dg-additional-options { "-fdump-tree-ifcvt-all" } } */

#include <stdarg.h>
#include "tree-vect.h"

extern void abort(void);

struct s { int i : 31; };

#define ELT0 {0}
#define ELT1 {1}
#define ELT2 {2}
#define ELT3 {3}
#define ELT4 {4}
#define N 32
#define RES 25
struct s A[N]
  = { ELT0, ELT1, ELT2, ELT3, ELT0, ELT1, ELT2, ELT3,
      ELT0, ELT1, ELT2, ELT3, ELT0, ELT1, ELT2, ELT3,
      ELT0, ELT1, ELT4, ELT3, ELT0, ELT1, ELT2, ELT3,
      ELT0, ELT1, ELT2, ELT3, ELT0, ELT1, ELT2, ELT3};

int __attribute__ ((noipa))
f(struct s *ptr, unsigned n) {
    int res = 0;
    for (int i = 0; i < n; ++i)
      {
	if (ptr[i].i == 4)
	  return res;
	res += ptr[i].i;
      }

    return res;
}

int main (void)
{
  check_vect ();

  if (f(&A[0], N) != RES)
    abort ();

  return 0;
}

/* { dg-final { scan-tree-dump "Bitfield OK to lower." "ifcvt" } } */

