*
* $Id: cmlabe.F,v 1.1.1.1 1995/10/24 10:21:55 cernlib Exp $
*
* $Log: cmlabe.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:55  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.48  by  S.Giani
*-- Author :
      SUBROUTINE CMLABE(D,LD,AWR,KZ,ID,FM,Q,IFLG)
C       THIS ROUTINE CONVERTS THE EXIT NEUTRON SCATTERING ANGLE
C       FROM THE CENTER OF MASS COORDINATE SYSTEM TO THE LABORATORY
C       COORDINATE SYSTEM FOR AN ELASTIC SCATTERING REACTION. IT
C       ALSO CALCULATES THE EXIT ENERGIES AND DIRECTIONAL COSINES
C       FOR THE NEUTRON AND RECOIL NUCLEUS AS WELL AS SETTING ALL
C       EXIT PARAMETERS FOR THE RECOIL NUCLEUS.
#include "geant321/minput.inc"
#include "geant321/mconst.inc"
#include "geant321/mnutrn.inc"
#include "geant321/mrecoi.inc"
#include "geant321/mapoll.inc"
#include "geant321/mmass.inc"
#include "geant321/mupsca.inc"
#include "geant321/mpstor.inc"
      DIMENSION D(*),LD(*)
      SAVE
      MT=0
      IF(ID.EQ.2)MT=2
C       IFLG EQUAL TO ONE IMPLIES LABORATORY COORDINATE SYSTEM
      IF(IFLG.EQ.1)GO TO 10
      IF(IFLG.EQ.2)GO TO 50
      ALPHA=((AWR-1.0)/(AWR+1.0))**2
C       E EQUALS THE EXIT ENERGY IN THE LAB SYSTEM
      E=0.5*EOLD*((1.0-ALPHA)*FM+1.0+ALPHA)
C       CALCULATE COSINE OF SCATTERING ANGLE (FM) IN LAB SYSTEM
      FM=(1.0+AWR*FM)/SQRT(1.0+AWR**2+2.0*AWR*FM)
C       CALCULATE THE NEUTRON EXIT DIRECTIONAL COSINES
   10 SINPSI=SQRT(1.0-FM**2)
      CALL AZIRN(SINETA,COSETA)
      STHETA=1.0-UOLD**2
      IF(STHETA)30,30,20
   20 STHETA=SQRT(STHETA)
      COSPHI=VOLD/STHETA
      SINPHI=WOLD/STHETA
      GO TO 40
   30 COSPHI=1.0
      SINPHI=0.0
      STHETA=0.0
   40 U=UOLD*FM-COSETA*SINPSI*STHETA
      V=VOLD*FM+UOLD*COSPHI*COSETA*SINPSI-SINPHI*SINPSI*SINETA
      W=WOLD*FM+UOLD*SINPHI*COSETA*SINPSI+COSPHI*SINPSI*SINETA
      S=1.0/SQRT(U**2+V**2+W**2)
      U=U*S
      V=V*S
      W=W*S
C       CALCULATE AND SET THE RECOIL NUCLEUS EXIT PARAMETERS
   50 ER=EOLD-E
C       PERFORM ENERGY BALANCE CONSIDERING TARGET NUCLEUS ENERGY
      IF(IFLG.EQ.2)ER=ERFGM+EOLD-E
      XR=X
      YR=Y
      ZR=Z
      WATER=WTBC
      NZR=KZ
      AGER=AGE
      NCOLR=NCOL
      MTNR=MT
      AR=AWR*AN
      ENIR=EOLD
      UNIR=UOLD
      VNIR=VOLD
      WNIR=WOLD
      ENOR=E
      UNOR=U
      VNOR=V
      WNOR=W
      WTNR=WATE
      QR=Q
C       CALCULATE THE NEUTRON MOMENTUM BEFORE AND AFTER COLLISION
C       NEUTRON MOMENTUM BEFORE COLLISION (PI) EQUALS TOTAL MOMENTUM
      PI=SQRT(2.0*ZN*EOLD)
      PO=SQRT(2.0*ZN*E)
C       CALCULATE THE DIRECTIONAL MOMENTUM OF THE RECOIL NUCLEUS
      PRX=PI*UOLD-PO*U
      PRY=PI*VOLD-PO*V
      PRZ=PI*WOLD-PO*W
C       CALCULATE THE TOTAL MOMENTUM OF THE RECOIL NUCLEUS
      PR=SQRT(PRX**2+PRY**2+PRZ**2)
C       CALCULATE THE RECOIL NUCLEUS DIRECTIONAL COSINES
      IF(PR.GT.0.0) THEN
         UR=PRX/PR
         VR=PRY/PR
         WR=PRZ/PR
      ELSE
         UR=0.0
         VR=0.0
         WR=0.0
      ENDIF
C       STORE THE  RECOIL HEAVY ION IN THE RECOIL BANK
      EP = ER
      UP = UR
      VP = VR
      WP = WR
      AGEP = AGE
      MTP = MT
      AMP = AR
      ZMP = FLOAT(NZR)
      CALL STOPAR(IDHEVY,NHEVY)
      RETURN
      END
