.\" @(#)$RCSfile: gfal_get_results_python.man,v $ $Revision: 1.9 $ $Date: 2009/09/08 13:54:58 $ CERN Remi Mollon
.\" Copyright (C) 2007 by CERN
.\" All rights reserved
.\"
.TH GFAL_GET_RESULTS 3 "$Date: 2009/09/08 13:54:58 $" GFAL "Library Functions"
.SH NAME
gfal_get_results \- Extracts the results from the 'gfal_internal' object
.SH SYNOPSIS
\fBimport gfal\fR
.sp
.BI "(int " returncode ,
.BI "gfal_internal " gfal ,
.BI "listOfDict " filestatuses
.BI ") gfal_get_results (gfal_internal " gfal
.B );

.SH DESCRIPTION
.B gfal_get_results
Extracts the results of the last called GFAL function from the 
.B gfal_internal
object.

.TP
.I gfal
.B gfal_internal
object generated from user parameters.
.TP
.I filestatuses
List of dictionary. See the next section to know the field you can get from it.

.SH RESULT DICTIONARY FIELDS
Keep in mind that all fields are not fulfilled by all functions!
.TP
.B string surl
The SURLs concerned. Fulfilled by all functions.
.TP
.B string turl
The TURL associated to the SURL in 
.BR surl .
Fulfilled by 
.IR gfal_turlsfromsurls_python(3) ,
.IR gfal_getstatuses_python(3) .
.TP
.B int status
For almost all function it corresponds to 
.I errno
values ('0' means that all is ok). But for asynchronous functions, possible values are -1, 0 and 1,
what correspond respectively to error, pending and done. Fulfilled by all functions.
.TP
.B string explanation
Error message associated with 
.BR status .
Can be fulfilled by all functions, but only when SRMv2 interface is used.
.TP
.B int pinlifetime
Remaining pin life time for 
.BR surl .
Fulfilled by 
.IR gfal_turlsfromsurls_python(3) ,
.IR gfal_getstatus_python(3) ,
.IR gfal_bringonline_python(3) ,
.I gfal_prestagestatus_python(3)
when SRMv2 interface is used.
.TP
.B string locality
File locality. Possible values are:
.IR ONLINE ,
.IR NEARLINE ,
.IR ONLINE_AND_NEARLINE ,
.IR LOST ,
.IR NONE ,
.IR UNAVAILABLE ,
.IR UNKNOWN .
.TP
.B list stat
Stat information about the 
.BR surl .
Each field of the list corresponds to the same thing than in a system python stat.
So the field are respectively st_mode, st_ino, st_dev, st_nlink, st_uid, st_gid, st_size, st_atime, st_mtime, st_ctime.
It is 
.B ONLY
fulfilled by 
.IR gfal_ls_python(3) .
.TP
.B listOfDict subpaths
Information about files in the directory (if there are ones)
.BR surl .
It is 
.B ONLY
fulfilled by 
.I gfal_ls_python(3)
when you define 
.B srmv2_lslevels
to '1' in the 
.B gfal_request
object.
.TP
.B string checksumtype
Name of the checksum algorithm (for example
.B ADLER32, MD5
). It is 
.B ONLY
filled by 
.I gfal_ls_python(3).
.TP
.B string checksum
The checksum value. It is 
.B ONLY
filled by 
.I gfal_ls_python(3).
.TP
.B listOfString spacetokens
The list of space tokens. Filled by  
.I gfal_prestage_python(3) 
when SRMv2 interface is used.

.SH RETURN VALUE
This routine returns 0 on a success, or -1 in case of error. In the latter case,
.B results
is defined to NULL.

.SH SEE ALSO
.BR gfal_python (3) ,
.BR gfal_init_python (3) ,
.BR gfal_internal_free_python (3) ,
.BR gfal_deletesurls_python (3) ,
.BR gfal_removedir_python (3) ,
.BR gfal_get_python (3) ,
.BR gfal_getstatus_python (3) ,
.BR gfal_ls_python (3) ,
.BR gfal_pin_python (3) ,
.BR gfal_prestage_python (3) ,
.BR gfal_prestagestatus_python (3) ,
.BR gfal_release_python (3) ,
.BR gfal_abortrequest_python (3) ,
.BR gfal_abortfiles_python (3) ,
.BR gfal_set_xfer_done_python (3) ,
.BR gfal_set_xfer_running_python (3) ,
.BR gfal_turlsfromsurls_python (3) ,
.BR gfal_get_ids_python (3) ,
.BR gfal_set_ids_python (3) ,
.BR gfal_get_results_python (3) ,
.BR gfal_access_python (3) ,
.BR gfal_chmod_python (3) ,
.BR gfal_close_python (3) ,
.BR gfal_closedir_python (3) ,
.BR gfal_creat_python (3) ,
.BR gfal_get_timeout_connect_python (3) ,
.BR gfal_get_timeout_sendreceive_python (3) ,
.BR gfal_get_timeout_bdii_python (3) ,
.BR gfal_get_timeout_srm_python (3) ,
.BR gfal_set_timeout_connect_python (3) ,
.BR gfal_set_timeout_sendreceive_python (3) ,
.BR gfal_set_timeout_bdii_python (3) ,
.BR gfal_set_timeout_srm_python (3) ,
.BR gfal_lseek_python (3) ,
.BR gfal_mkdir_python (3) ,
.BR gfal_open_python (3) ,
.BR gfal_opendir_python (3) ,
.BR gfal_read_python (3) ,
.BR gfal_rename_python (3) ,
.BR gfal_rmdir_python (3) ,
.BR gfal_stat_python (3) ,
.BR gfal_unlink_python (3) ,
.BR gfal_write_python (3) ,
.BR gfal_set_verbose_python (3) ,
.BR gfal_get_errno_python (3) ,
