/**
 * QtAwesome - use font-awesome (or other font icons) in your c++ / Qt Application
 *
 * MIT Licensed
 *
 * Copyright 2013-2015 - Reliable Bits Software by Blommers IT. All Rights Reserved.
 * Author Rick Blommers
 */

#ifndef QTAWESOME_H
#define QTAWESOME_H

#include "QtAwesomeAnim.h"

#include <QIcon>
#include <QIconEngine>
#include <QPainter>
#include <QRect>
#include <QVariantMap>


/// A list of all style-names
namespace style {
    enum styles {
        /// solid icons
        stfas,
        /// regular icons
        stfar,
#ifdef FONT_AWESOME_PRO
        /// light icons
        stfal,
        /// duotone icons
        stfad,
#endif
        /// brands icons
        stfab
    };
}

/// A list of all icon-names with the codepoint (unicode-value) on the right
/// You can use the names on the page  http://fortawesome.github.io/Font-Awesome/design.html

namespace fa {
  enum common {
      ad                               = 0xf641,
      addressbook                      = 0xf2b9,
      addresscard                      = 0xf2bb,
      adjust                           = 0xf042,
      airfreshener                     = 0xf5d0,
      aligncenter                      = 0xf037,
      alignjustify                     = 0xf039,
      alignleft                        = 0xf036,
      alignright                       = 0xf038,
      allergies                        = 0xf461,
      ambulance                        = 0xf0f9,
      americansignlanguageinterpreting = 0xf2a3,
      anchor                           = 0xf13d,
      angledoubledown                  = 0xf103,
      angledoubleleft                  = 0xf100,
      angledoubleright                 = 0xf101,
      angledoubleup                    = 0xf102,
      angledown                        = 0xf107,
      angleleft                        = 0xf104,
      angleright                       = 0xf105,
      angleup                          = 0xf106,
      angry                            = 0xf556,
      ankh                             = 0xf644,
      applealt                         = 0xf5d1,
      archive                          = 0xf187,
      archway                          = 0xf557,
      arrowaltcircledown               = 0xf358,
      arrowaltcircleleft               = 0xf359,
      arrowaltcircleright              = 0xf35a,
      arrowaltcircleup                 = 0xf35b,
      arrowcircledown                  = 0xf0ab,
      arrowcircleleft                  = 0xf0a8,
      arrowcircleright                 = 0xf0a9,
      arrowcircleup                    = 0xf0aa,
      arrowdown                        = 0xf063,
      arrowleft                        = 0xf060,
      arrowright                       = 0xf061,
      arrowsalt                        = 0xf0b2,
      arrowsalth                       = 0xf337,
      arrowsaltv                       = 0xf338,
      arrowup                          = 0xf062,
      assistivelisteningsystems        = 0xf2a2,
      asterisk                         = 0xf069,
      at                               = 0xf1fa,
      atlas                            = 0xf558,
      atom                             = 0xf5d2,
      audiodescription                 = 0xf29e,
      award                            = 0xf559,
      baby                             = 0xf77c,
      babycarriage                     = 0xf77d,
      backspace                        = 0xf55a,
      backward                         = 0xf04a,
      bacon                            = 0xf7e5,
      balancescale                     = 0xf24e,
      balancescaleleft                 = 0xf515,
      balancescaleright                = 0xf516,
      ban                              = 0xf05e,
      bandaid                          = 0xf462,
      barcode                          = 0xf02a,
      bars                             = 0xf0c9,
      baseballball                     = 0xf433,
      basketballball                   = 0xf434,
      bath                             = 0xf2cd,
      batteryempty                     = 0xf244,
      batteryfull                      = 0xf240,
      batteryhalf                      = 0xf242,
      batteryquarter                   = 0xf243,
      batterythreequarters             = 0xf241,
      bed                              = 0xf236,
      beer                             = 0xf0fc,
      bell                             = 0xf0f3,
      bellslash                        = 0xf1f6,
      beziercurve                      = 0xf55b,
      bible                            = 0xf647,
      bicycle                          = 0xf206,
      biking                           = 0xf84a,
      binoculars                       = 0xf1e5,
      biohazard                        = 0xf780,
      birthdaycake                     = 0xf1fd,
      blender                          = 0xf517,
      blenderphone                     = 0xf6b6,
      blind                            = 0xf29d,
      blog                             = 0xf781,
      bold                             = 0xf032,
      bolt                             = 0xf0e7,
      bomb                             = 0xf1e2,
      bone                             = 0xf5d7,
      bong                             = 0xf55c,
      book                             = 0xf02d,
      bookdead                         = 0xf6b7,
      bookmark                         = 0xf02e,
      bookmedical                      = 0xf7e6,
      bookopen                         = 0xf518,
      bookreader                       = 0xf5da,
      borderall                        = 0xf84c,
      bordernone                       = 0xf850,
      borderstyle                      = 0xf853,
      bowlingball                      = 0xf436,
      box                              = 0xf466,
      boxes                            = 0xf468,
      boxopen                          = 0xf49e,
      braille                          = 0xf2a1,
      brain                            = 0xf5dc,
      breadslice                       = 0xf7ec,
      briefcase                        = 0xf0b1,
      briefcasemedical                 = 0xf469,
      broadcasttower                   = 0xf519,
      broom                            = 0xf51a,
      brush                            = 0xf55d,
      bug                              = 0xf188,
      building                         = 0xf1ad,
      bullhorn                         = 0xf0a1,
      bullseye                         = 0xf140,
      burn                             = 0xf46a,
      bus                              = 0xf207,
      busalt                           = 0xf55e,
      businesstime                     = 0xf64a,
      calculator                       = 0xf1ec,
      calendar                         = 0xf133,
      calendaralt                      = 0xf073,
      calendarcheck                    = 0xf274,
      calendarday                      = 0xf783,
      calendarminus                    = 0xf272,
      calendarplus                     = 0xf271,
      calendartimes                    = 0xf273,
      calendarweek                     = 0xf784,
      camera                           = 0xf030,
      cameraretro                      = 0xf083,
      campground                       = 0xf6bb,
      candycane                        = 0xf786,
      cannabis                         = 0xf55f,
      capsules                         = 0xf46b,
      car                              = 0xf1b9,
      caralt                           = 0xf5de,
      carbattery                       = 0xf5df,
      carcrash                         = 0xf5e1,
      caretdown                        = 0xf0d7,
      caretleft                        = 0xf0d9,
      caretright                       = 0xf0da,
      caretsquaredown                  = 0xf150,
      caretsquareleft                  = 0xf191,
      caretsquareright                 = 0xf152,
      caretsquareup                    = 0xf151,
      caretup                          = 0xf0d8,
      carrot                           = 0xf787,
      carside                          = 0xf5e4,
      cartarrowdown                    = 0xf218,
      cartplus                         = 0xf217,
      cashregister                     = 0xf788,
      cat                              = 0xf6be,
      certificate                      = 0xf0a3,
      chair                            = 0xf6c0,
      chalkboard                       = 0xf51b,
      chalkboardteacher                = 0xf51c,
      chargingstation                  = 0xf5e7,
      chartarea                        = 0xf1fe,
      chartbar                         = 0xf080,
      chartline                        = 0xf201,
      chartpie                         = 0xf200,
      check                            = 0xf00c,
      checkcircle                      = 0xf058,
      checkdouble                      = 0xf560,
      checksquare                      = 0xf14a,
      cheese                           = 0xf7ef,
      chess                            = 0xf439,
      chessbishop                      = 0xf43a,
      chessboard                       = 0xf43c,
      chessking                        = 0xf43f,
      chessknight                      = 0xf441,
      chesspawn                        = 0xf443,
      chessqueen                       = 0xf445,
      chessrook                        = 0xf447,
      chevroncircledown                = 0xf13a,
      chevroncircleleft                = 0xf137,
      chevroncircleright               = 0xf138,
      chevroncircleup                  = 0xf139,
      chevrondown                      = 0xf078,
      chevronleft                      = 0xf053,
      chevronright                     = 0xf054,
      chevronup                        = 0xf077,
      child                            = 0xf1ae,
      church                           = 0xf51d,
      circle                           = 0xf111,
      circlenotch                      = 0xf1ce,
      city                             = 0xf64f,
      clinicmedical                    = 0xf7f2,
      clipboard                        = 0xf328,
      clipboardcheck                   = 0xf46c,
      clipboardlist                    = 0xf46d,
      clock                            = 0xf017,
      clone                            = 0xf24d,
      closedcaptioning                 = 0xf20a,
      cloud                            = 0xf0c2,
      clouddownloadalt                 = 0xf381,
      cloudmeatball                    = 0xf73b,
      cloudmoon                        = 0xf6c3,
      cloudmoonrain                    = 0xf73c,
      cloudrain                        = 0xf73d,
      cloudshowersheavy                = 0xf740,
      cloudsun                         = 0xf6c4,
      cloudsunrain                     = 0xf743,
      clouduploadalt                   = 0xf382,
      cocktail                         = 0xf561,
      code                             = 0xf121,
      codebranch                       = 0xf126,
      coffee                           = 0xf0f4,
      cog                              = 0xf013,
      cogs                             = 0xf085,
      coins                            = 0xf51e,
      columns                          = 0xf0db,
      comment                          = 0xf075,
      commentalt                       = 0xf27a,
      commentdollar                    = 0xf651,
      commentdots                      = 0xf4ad,
      commentmedical                   = 0xf7f5,
      comments                         = 0xf086,
      commentsdollar                   = 0xf653,
      commentslash                     = 0xf4b3,
      compactdisc                      = 0xf51f,
      compass                          = 0xf14e,
      compress                         = 0xf066,
      compressarrowsalt                = 0xf78c,
      conciergebell                    = 0xf562,
      cookie                           = 0xf563,
      cookiebite                       = 0xf564,
      copy                             = 0xf0c5,
      copyright                        = 0xf1f9,
      couch                            = 0xf4b8,
      creditcard                       = 0xf09d,
      crop                             = 0xf125,
      cropalt                          = 0xf565,
      cross                            = 0xf654,
      crosshairs                       = 0xf05b,
      crow                             = 0xf520,
      crown                            = 0xf521,
      crutch                           = 0xf7f7,
      cube                             = 0xf1b2,
      cubes                            = 0xf1b3,
      cut                              = 0xf0c4,
      database                         = 0xf1c0,
      deaf                             = 0xf2a4,
      democrat                         = 0xf747,
      desktop                          = 0xf108,
      dharmachakra                     = 0xf655,
      diagnoses                        = 0xf470,
      dice                             = 0xf522,
      diced20                          = 0xf6cf,
      diced6                           = 0xf6d1,
      dicefive                         = 0xf523,
      dicefour                         = 0xf524,
      diceone                          = 0xf525,
      dicesix                          = 0xf526,
      dicethree                        = 0xf527,
      dicetwo                          = 0xf528,
      digitaltachograph                = 0xf566,
      directions                       = 0xf5eb,
      divide                           = 0xf529,
      dizzy                            = 0xf567,
      dna                              = 0xf471,
      dog                              = 0xf6d3,
      dollarsign                       = 0xf155,
      dolly                            = 0xf472,
      dollyflatbed                     = 0xf474,
      donate                           = 0xf4b9,
      doorclosed                       = 0xf52a,
      dooropen                         = 0xf52b,
      dotcircle                        = 0xf192,
      dove                             = 0xf4ba,
      download                         = 0xf019,
      draftingcompass                  = 0xf568,
      dragon                           = 0xf6d5,
      drawpolygon                      = 0xf5ee,
      drum                             = 0xf569,
      drumsteelpan                     = 0xf56a,
      drumstickbite                    = 0xf6d7,
      dumbbell                         = 0xf44b,
      dumpster                         = 0xf793,
      dumpsterfire                     = 0xf794,
      dungeon                          = 0xf6d9,
      edit                             = 0xf044,
      egg                              = 0xf7fb,
      eject                            = 0xf052,
      ellipsish                        = 0xf141,
      ellipsisv                        = 0xf142,
      envelope                         = 0xf0e0,
      envelopeopen                     = 0xf2b6,
      envelopeopentext                 = 0xf658,
      envelopesquare                   = 0xf199,
      equals                           = 0xf52c,
      eraser                           = 0xf12d,
      ethernet                         = 0xf796,
      eurosign                         = 0xf153,
      exchangealt                      = 0xf362,
      exclamation                      = 0xf12a,
      exclamationcircle                = 0xf06a,
      exclamationtriangle              = 0xf071,
      expand                           = 0xf065,
      expandarrowsalt                  = 0xf31e,
      externallinkalt                  = 0xf35d,
      externallinksquarealt            = 0xf360,
      eye                              = 0xf06e,
      eyedropper                       = 0xf1fb,
      eyeslash                         = 0xf070,
      fan                              = 0xf863,
      fastbackward                     = 0xf049,
      fastforward                      = 0xf050,
      fax                              = 0xf1ac,
      feather                          = 0xf52d,
      featheralt                       = 0xf56b,
      female                           = 0xf182,
      fighterjet                       = 0xf0fb,
      file                             = 0xf15b,
      filealt                          = 0xf15c,
      filearchive                      = 0xf1c6,
      fileaudio                        = 0xf1c7,
      filecode                         = 0xf1c9,
      filecontract                     = 0xf56c,
      filecsv                          = 0xf6dd,
      filedownload                     = 0xf56d,
      fileexcel                        = 0xf1c3,
      fileexport                       = 0xf56e,
      fileimage                        = 0xf1c5,
      fileimport                       = 0xf56f,
      fileinvoice                      = 0xf570,
      fileinvoicedollar                = 0xf571,
      filemedical                      = 0xf477,
      filemedicalalt                   = 0xf478,
      filepdf                          = 0xf1c1,
      filepowerpoint                   = 0xf1c4,
      fileprescription                 = 0xf572,
      filesignature                    = 0xf573,
      fileupload                       = 0xf574,
      filevideo                        = 0xf1c8,
      fileword                         = 0xf1c2,
      fill                             = 0xf575,
      filldrip                         = 0xf576,
      film                             = 0xf008,
      filter                           = 0xf0b0,
      fingerprint                      = 0xf577,
      fire                             = 0xf06d,
      firealt                          = 0xf7e4,
      fireextinguisher                 = 0xf134,
      firstaid                         = 0xf479,
      fish                             = 0xf578,
      fistraised                       = 0xf6de,
      flag                             = 0xf024,
      flagcheckered                    = 0xf11e,
      flagusa                          = 0xf74d,
      flask                            = 0xf0c3,
      flushed                          = 0xf579,
      folder                           = 0xf07b,
      folderminus                      = 0xf65d,
      folderopen                       = 0xf07c,
      folderplus                       = 0xf65e,
      font                             = 0xf031,
      footballball                     = 0xf44e,
      forward                          = 0xf04e,
      frog                             = 0xf52e,
      frown                            = 0xf119,
      frownopen                        = 0xf57a,
      funneldollar                     = 0xf662,
      futbol                           = 0xf1e3,
      gamepad                          = 0xf11b,
      gaspump                          = 0xf52f,
      gavel                            = 0xf0e3,
      gem                              = 0xf3a5,
      genderless                       = 0xf22d,
      ghost                            = 0xf6e2,
      gift                             = 0xf06b,
      gifts                            = 0xf79c,
      glasscheers                      = 0xf79f,
      glasses                          = 0xf530,
      glassmartini                     = 0xf000,
      glassmartinialt                  = 0xf57b,
      glasswhiskey                     = 0xf7a0,
      globe                            = 0xf0ac,
      globeafrica                      = 0xf57c,
      globeamericas                    = 0xf57d,
      globeasia                        = 0xf57e,
      globeeurope                      = 0xf7a2,
      golfball                         = 0xf450,
      gopuram                          = 0xf664,
      graduationcap                    = 0xf19d,
      greaterthan                      = 0xf531,
      greaterthanequal                 = 0xf532,
      grimace                          = 0xf57f,
      grin                             = 0xf580,
      grinalt                          = 0xf581,
      grinbeam                         = 0xf582,
      grinbeamsweat                    = 0xf583,
      grinhearts                       = 0xf584,
      grinsquint                       = 0xf585,
      grinsquinttears                  = 0xf586,
      grinstars                        = 0xf587,
      grintears                        = 0xf588,
      grintongue                       = 0xf589,
      grintonguesquint                 = 0xf58a,
      grintonguewink                   = 0xf58b,
      grinwink                         = 0xf58c,
      griphorizontal                   = 0xf58d,
      griplines                        = 0xf7a4,
      griplinesvertical                = 0xf7a5,
      gripvertical                     = 0xf58e,
      guitar                           = 0xf7a6,
      hamburger                        = 0xf805,
      hammer                           = 0xf6e3,
      hamsa                            = 0xf665,
      handholding                      = 0xf4bd,
      handholdingheart                 = 0xf4be,
      handholdingusd                   = 0xf4c0,
      handlizard                       = 0xf258,
      handmiddlefinger                 = 0xf806,
      handpaper                        = 0xf256,
      handpeace                        = 0xf25b,
      handpointdown                    = 0xf0a7,
      handpointer                      = 0xf25a,
      handpointleft                    = 0xf0a5,
      handpointright                   = 0xf0a4,
      handpointup                      = 0xf0a6,
      handrock                         = 0xf255,
      hands                            = 0xf4c2,
      handscissors                     = 0xf257,
      handshake                        = 0xf2b5,
      handshelping                     = 0xf4c4,
      handspock                        = 0xf259,
      hanukiah                         = 0xf6e6,
      hardhat                          = 0xf807,
      hashtag                          = 0xf292,
      hatwizard                        = 0xf6e8,
      haykal                           = 0xf666,
      hdd                              = 0xf0a0,
      heading                          = 0xf1dc,
      headphones                       = 0xf025,
      headphonesalt                    = 0xf58f,
      headset                          = 0xf590,
      heart                            = 0xf004,
      heartbeat                        = 0xf21e,
      heartbroken                      = 0xf7a9,
      helicopter                       = 0xf533,
      highlighter                      = 0xf591,
      hiking                           = 0xf6ec,
      hippo                            = 0xf6ed,
      history                          = 0xf1da,
      hockeypuck                       = 0xf453,
      hollyberry                       = 0xf7aa,
      home                             = 0xf015,
      horse                            = 0xf6f0,
      horsehead                        = 0xf7ab,
      hospital                         = 0xf0f8,
      hospitalalt                      = 0xf47d,
      hospitalsymbol                   = 0xf47e,
      hotdog                           = 0xf80f,
      hotel                            = 0xf594,
      hottub                           = 0xf593,
      hourglass                        = 0xf254,
      hourglassend                     = 0xf253,
      hourglasshalf                    = 0xf252,
      hourglassstart                   = 0xf251,
      housedamage                      = 0xf6f1,
      hryvnia                          = 0xf6f2,
      hsquare                          = 0xf0fd,
      icecream                         = 0xf810,
      icicles                          = 0xf7ad,
      icons                            = 0xf86d,
      icursor                          = 0xf246,
      idbadge                          = 0xf2c1,
      idcard                           = 0xf2c2,
      idcardalt                        = 0xf47f,
      igloo                            = 0xf7ae,
      image                            = 0xf03e,
      images                           = 0xf302,
      inbox                            = 0xf01c,
      indent                           = 0xf03c,
      industry                         = 0xf275,
      infinity                         = 0xf534,
      info                             = 0xf129,
      infocircle                       = 0xf05a,
      italic                           = 0xf033,
      jedi                             = 0xf669,
      joint                            = 0xf595,
      journalwhills                    = 0xf66a,
      kaaba                            = 0xf66b,
      key                              = 0xf084,
      keyboard                         = 0xf11c,
      khanda                           = 0xf66d,
      kiss                             = 0xf596,
      kissbeam                         = 0xf597,
      kisswinkheart                    = 0xf598,
      kiwibird                         = 0xf535,
      landmark                         = 0xf66f,
      language                         = 0xf1ab,
      laptop                           = 0xf109,
      laptopcode                       = 0xf5fc,
      laptopmedical                    = 0xf812,
      laugh                            = 0xf599,
      laughbeam                        = 0xf59a,
      laughsquint                      = 0xf59b,
      laughwink                        = 0xf59c,
      layergroup                       = 0xf5fd,
      leaf                             = 0xf06c,
      lemon                            = 0xf094,
      lessthan                         = 0xf536,
      lessthanequal                    = 0xf537,
      leveldownalt                     = 0xf3be,
      levelupalt                       = 0xf3bf,
      lifering                         = 0xf1cd,
      lightbulb                        = 0xf0eb,
      link                             = 0xf0c1,
      lirasign                         = 0xf195,
      list                             = 0xf03a,
      listalt                          = 0xf022,
      listol                           = 0xf0cb,
      listul                           = 0xf0ca,
      locationarrow                    = 0xf124,
      lock                             = 0xf023,
      lockopen                         = 0xf3c1,
      longarrowaltdown                 = 0xf309,
      longarrowaltleft                 = 0xf30a,
      longarrowaltright                = 0xf30b,
      longarrowaltup                   = 0xf30c,
      lowvision                        = 0xf2a8,
      luggagecart                      = 0xf59d,
      magic                            = 0xf0d0,
      magnet                           = 0xf076,
      mailbulk                         = 0xf674,
      male                             = 0xf183,
      map                              = 0xf279,
      mapmarked                        = 0xf59f,
      mapmarkedalt                     = 0xf5a0,
      mapmarker                        = 0xf041,
      mapmarkeralt                     = 0xf3c5,
      mappin                           = 0xf276,
      mapsigns                         = 0xf277,
      marker                           = 0xf5a1,
      mars                             = 0xf222,
      marsdouble                       = 0xf227,
      marsstroke                       = 0xf229,
      marsstrokeh                      = 0xf22b,
      marsstrokev                      = 0xf22a,
      mask                             = 0xf6fa,
      medal                            = 0xf5a2,
      medkit                           = 0xf0fa,
      meh                              = 0xf11a,
      mehblank                         = 0xf5a4,
      mehrollingeyes                   = 0xf5a5,
      memory                           = 0xf538,
      menorah                          = 0xf676,
      mercury                          = 0xf223,
      meteor                           = 0xf753,
      microchip                        = 0xf2db,
      microphone                       = 0xf130,
      microphonealt                    = 0xf3c9,
      microphonealtslash               = 0xf539,
      microphoneslash                  = 0xf131,
      microscope                       = 0xf610,
      minus                            = 0xf068,
      minuscircle                      = 0xf056,
      minussquare                      = 0xf146,
      mitten                           = 0xf7b5,
      mobile                           = 0xf10b,
      mobilealt                        = 0xf3cd,
      moneybill                        = 0xf0d6,
      moneybillalt                     = 0xf3d1,
      moneybillwave                    = 0xf53a,
      moneybillwavealt                 = 0xf53b,
      moneycheck                       = 0xf53c,
      moneycheckalt                    = 0xf53d,
      monument                         = 0xf5a6,
      moon                             = 0xf186,
      mortarpestle                     = 0xf5a7,
      mosque                           = 0xf678,
      motorcycle                       = 0xf21c,
      mountain                         = 0xf6fc,
      mousepointer                     = 0xf245,
      mughot                           = 0xf7b6,
      music                            = 0xf001,
      networkwired                     = 0xf6ff,
      neuter                           = 0xf22c,
      newspaper                        = 0xf1ea,
      notequal                         = 0xf53e,
      notesmedical                     = 0xf481,
      objectgroup                      = 0xf247,
      objectungroup                    = 0xf248,
      oilcan                           = 0xf613,
      om                               = 0xf679,
      otter                            = 0xf700,
      outdent                          = 0xf03b,
      pager                            = 0xf815,
      paintbrush                       = 0xf1fc,
      paintroller                      = 0xf5aa,
      palette                          = 0xf53f,
      pallet                           = 0xf482,
      paperclip                        = 0xf0c6,
      paperplane                       = 0xf1d8,
      parachutebox                     = 0xf4cd,
      paragraph                        = 0xf1dd,
      parking                          = 0xf540,
      passport                         = 0xf5ab,
      pastafarianism                   = 0xf67b,
      paste                            = 0xf0ea,
      pause                            = 0xf04c,
      pausecircle                      = 0xf28b,
      paw                              = 0xf1b0,
      peace                            = 0xf67c,
      pen                              = 0xf304,
      penalt                           = 0xf305,
      pencilalt                        = 0xf303,
      pencilruler                      = 0xf5ae,
      penfancy                         = 0xf5ac,
      pennib                           = 0xf5ad,
      pensquare                        = 0xf14b,
      peoplecarry                      = 0xf4ce,
      pepperhot                        = 0xf816,
      percent                          = 0xf295,
      percentage                       = 0xf541,
      personbooth                      = 0xf756,
      phone                            = 0xf095,
      phonealt                         = 0xf879,
      phoneslash                       = 0xf3dd,
      phonesquare                      = 0xf098,
      phonesquarealt                   = 0xf87b,
      phonevolume                      = 0xf2a0,
      photovideo                       = 0xf87c,
      piggybank                        = 0xf4d3,
      pills                            = 0xf484,
      pizzaslice                       = 0xf818,
      placeofworship                   = 0xf67f,
      plane                            = 0xf072,
      planearrival                     = 0xf5af,
      planedeparture                   = 0xf5b0,
      play                             = 0xf04b,
      playcircle                       = 0xf144,
      plug                             = 0xf1e6,
      plus                             = 0xf067,
      pluscircle                       = 0xf055,
      plussquare                       = 0xf0fe,
      podcast                          = 0xf2ce,
      poll                             = 0xf681,
      pollh                            = 0xf682,
      poo                              = 0xf2fe,
      poop                             = 0xf619,
      poostorm                         = 0xf75a,
      portrait                         = 0xf3e0,
      poundsign                        = 0xf154,
      poweroff                         = 0xf011,
      pray                             = 0xf683,
      prayinghands                     = 0xf684,
      prescription                     = 0xf5b1,
      prescriptionbottle               = 0xf485,
      prescriptionbottlealt            = 0xf486,
      print                            = 0xf02f,
      procedures                       = 0xf487,
      projectdiagram                   = 0xf542,
      puzzlepiece                      = 0xf12e,
      qrcode                           = 0xf029,
      question                         = 0xf128,
      questioncircle                   = 0xf059,
      quidditch                        = 0xf458,
      quoteleft                        = 0xf10d,
      quoteright                       = 0xf10e,
      quran                            = 0xf687,
      radiation                        = 0xf7b9,
      radiationalt                     = 0xf7ba,
      rainbow                          = 0xf75b,
      random                           = 0xf074,
      receipt                          = 0xf543,
      recycle                          = 0xf1b8,
      redo                             = 0xf01e,
      redoalt                          = 0xf2f9,
      registered                       = 0xf25d,
      removeformat                     = 0xf87d,
      reply                            = 0xf3e5,
      replyall                         = 0xf122,
      republican                       = 0xf75e,
      restroom                         = 0xf7bd,
      retweet                          = 0xf079,
      ribbon                           = 0xf4d6,
      ring                             = 0xf70b,
      road                             = 0xf018,
      robot                            = 0xf544,
      rocket                           = 0xf135,
      route                            = 0xf4d7,
      rss                              = 0xf09e,
      rsssquare                        = 0xf143,
      rublesign                        = 0xf158,
      ruler                            = 0xf545,
      rulercombined                    = 0xf546,
      rulerhorizontal                  = 0xf547,
      rulervertical                    = 0xf548,
      running                          = 0xf70c,
      rupeesign                        = 0xf156,
      sadcry                           = 0xf5b3,
      sadtear                          = 0xf5b4,
      satellite                        = 0xf7bf,
      satellitedish                    = 0xf7c0,
      save                             = 0xf0c7,
      school                           = 0xf549,
      screwdriver                      = 0xf54a,
      scroll                           = 0xf70e,
      sdcard                           = 0xf7c2,
      search                           = 0xf002,
      searchdollar                     = 0xf688,
      searchlocation                   = 0xf689,
      searchminus                      = 0xf010,
      searchplus                       = 0xf00e,
      seedling                         = 0xf4d8,
      server                           = 0xf233,
      shapes                           = 0xf61f,
      share                            = 0xf064,
      sharealt                         = 0xf1e0,
      sharealtsquare                   = 0xf1e1,
      sharesquare                      = 0xf14d,
      shekelsign                       = 0xf20b,
      shieldalt                        = 0xf3ed,
      ship                             = 0xf21a,
      shippingfast                     = 0xf48b,
      shoeprints                       = 0xf54b,
      shoppingbag                      = 0xf290,
      shoppingbasket                   = 0xf291,
      shoppingcart                     = 0xf07a,
      shower                           = 0xf2cc,
      shuttlevan                       = 0xf5b6,
      sign                             = 0xf4d9,
      signal                           = 0xf012,
      signature                        = 0xf5b7,
      signinalt                        = 0xf2f6,
      signlanguage                     = 0xf2a7,
      signoutalt                       = 0xf2f5,
      simcard                          = 0xf7c4,
      sitemap                          = 0xf0e8,
      skating                          = 0xf7c5,
      skiing                           = 0xf7c9,
      skiingnordic                     = 0xf7ca,
      skull                            = 0xf54c,
      skullcrossbones                  = 0xf714,
      slash                            = 0xf715,
      sleigh                           = 0xf7cc,
      slidersh                         = 0xf1de,
      smile                            = 0xf118,
      smilebeam                        = 0xf5b8,
      smilewink                        = 0xf4da,
      smog                             = 0xf75f,
      smoking                          = 0xf48d,
      smokingban                       = 0xf54d,
      sms                              = 0xf7cd,
      snowboarding                     = 0xf7ce,
      snowflake                        = 0xf2dc,
      snowman                          = 0xf7d0,
      snowplow                         = 0xf7d2,
      socks                            = 0xf696,
      solarpanel                       = 0xf5ba,
      sort                             = 0xf0dc,
      sortalphadown                    = 0xf15d,
      sortalphadownalt                 = 0xf881,
      sortalphaup                      = 0xf15e,
      sortalphaupalt                   = 0xf882,
      sortamountdown                   = 0xf160,
      sortamountdownalt                = 0xf884,
      sortamountup                     = 0xf161,
      sortamountupalt                  = 0xf885,
      sortdown                         = 0xf0dd,
      sortnumericdown                  = 0xf162,
      sortnumericdownalt               = 0xf886,
      sortnumericup                    = 0xf163,
      sortnumericupalt                 = 0xf887,
      sortup                           = 0xf0de,
      spa                              = 0xf5bb,
      spaceshuttle                     = 0xf197,
      spellcheck                       = 0xf891,
      spider                           = 0xf717,
      spinner                          = 0xf110,
      splotch                          = 0xf5bc,
      spraycan                         = 0xf5bd,
      square                           = 0xf0c8,
      squarefull                       = 0xf45c,
      squarerootalt                    = 0xf698,
      stamp                            = 0xf5bf,
      star                             = 0xf005,
      starandcrescent                  = 0xf699,
      starhalf                         = 0xf089,
      starhalfalt                      = 0xf5c0,
      starofdavid                      = 0xf69a,
      staroflife                       = 0xf621,
      stepbackward                     = 0xf048,
      stepforward                      = 0xf051,
      stethoscope                      = 0xf0f1,
      stickynote                       = 0xf249,
      stop                             = 0xf04d,
      stopcircle                       = 0xf28d,
      stopwatch                        = 0xf2f2,
      store                            = 0xf54e,
      storealt                         = 0xf54f,
      stream                           = 0xf550,
      streetview                       = 0xf21d,
      strikethrough                    = 0xf0cc,
      stroopwafel                      = 0xf551,
      subscript                        = 0xf12c,
      subway                           = 0xf239,
      suitcase                         = 0xf0f2,
      suitcaserolling                  = 0xf5c1,
      sun                              = 0xf185,
      superscript                      = 0xf12b,
      surprise                         = 0xf5c2,
      swatchbook                       = 0xf5c3,
      swimmer                          = 0xf5c4,
      swimmingpool                     = 0xf5c5,
      synagogue                        = 0xf69b,
      sync                             = 0xf021,
      syncalt                          = 0xf2f1,
      syringe                          = 0xf48e,
      table                            = 0xf0ce,
      tablet                           = 0xf10a,
      tabletalt                        = 0xf3fa,
      tabletennis                      = 0xf45d,
      tablets                          = 0xf490,
      tachometeralt                    = 0xf3fd,
      tag                              = 0xf02b,
      tags                             = 0xf02c,
      tape                             = 0xf4db,
      tasks                            = 0xf0ae,
      taxi                             = 0xf1ba,
      teeth                            = 0xf62e,
      teethopen                        = 0xf62f,
      temperaturehigh                  = 0xf769,
      temperaturelow                   = 0xf76b,
      tenge                            = 0xf7d7,
      terminal                         = 0xf120,
      textheight                       = 0xf034,
      textwidth                        = 0xf035,
      th                               = 0xf00a,
      theatermasks                     = 0xf630,
      thermometer                      = 0xf491,
      thermometerempty                 = 0xf2cb,
      thermometerfull                  = 0xf2c7,
      thermometerhalf                  = 0xf2c9,
      thermometerquarter               = 0xf2ca,
      thermometerthreequarters         = 0xf2c8,
      thlarge                          = 0xf009,
      thlist                           = 0xf00b,
      thumbsdown                       = 0xf165,
      thumbsup                         = 0xf164,
      thumbtack                        = 0xf08d,
      ticketalt                        = 0xf3ff,
      times                            = 0xf00d,
      timescircle                      = 0xf057,
      tint                             = 0xf043,
      tintslash                        = 0xf5c7,
      tired                            = 0xf5c8,
      toggleoff                        = 0xf204,
      toggleon                         = 0xf205,
      toilet                           = 0xf7d8,
      toiletpaper                      = 0xf71e,
      toolbox                          = 0xf552,
      tools                            = 0xf7d9,
      tooth                            = 0xf5c9,
      torah                            = 0xf6a0,
      toriigate                        = 0xf6a1,
      tractor                          = 0xf722,
      trademark                        = 0xf25c,
      trafficlight                     = 0xf637,
      train                            = 0xf238,
      tram                             = 0xf7da,
      transgender                      = 0xf224,
      transgenderalt                   = 0xf225,
      trash                            = 0xf1f8,
      trashalt                         = 0xf2ed,
      trashrestore                     = 0xf829,
      trashrestorealt                  = 0xf82a,
      tree                             = 0xf1bb,
      trophy                           = 0xf091,
      truck                            = 0xf0d1,
      truckloading                     = 0xf4de,
      truckmonster                     = 0xf63b,
      truckmoving                      = 0xf4df,
      truckpickup                      = 0xf63c,
      tshirt                           = 0xf553,
      tty                              = 0xf1e4,
      tv                               = 0xf26c,
      umbrella                         = 0xf0e9,
      umbrellabeach                    = 0xf5ca,
      underline                        = 0xf0cd,
      undo                             = 0xf0e2,
      undoalt                          = 0xf2ea,
      universalaccess                  = 0xf29a,
      university                       = 0xf19c,
      unlink                           = 0xf127,
      unlock                           = 0xf09c,
      unlockalt                        = 0xf13e,
      upload                           = 0xf093,
      user                             = 0xf007,
      useralt                          = 0xf406,
      useraltslash                     = 0xf4fa,
      userastronaut                    = 0xf4fb,
      usercheck                        = 0xf4fc,
      usercircle                       = 0xf2bd,
      userclock                        = 0xf4fd,
      usercog                          = 0xf4fe,
      useredit                         = 0xf4ff,
      userfriends                      = 0xf500,
      usergraduate                     = 0xf501,
      userinjured                      = 0xf728,
      userlock                         = 0xf502,
      usermd                           = 0xf0f0,
      userminus                        = 0xf503,
      userninja                        = 0xf504,
      usernurse                        = 0xf82f,
      userplus                         = 0xf234,
      users                            = 0xf0c0,
      userscog                         = 0xf509,
      usersecret                       = 0xf21b,
      usershield                       = 0xf505,
      userslash                        = 0xf506,
      usertag                          = 0xf507,
      usertie                          = 0xf508,
      usertimes                        = 0xf235,
      utensils                         = 0xf2e7,
      utensilspoon                     = 0xf2e5,
      vectorsquare                     = 0xf5cb,
      venus                            = 0xf221,
      venusdouble                      = 0xf226,
      venusmars                        = 0xf228,
      vial                             = 0xf492,
      vials                            = 0xf493,
      video                            = 0xf03d,
      videoslash                       = 0xf4e2,
      vihara                           = 0xf6a7,
      voicemail                        = 0xf897,
      volleyballball                   = 0xf45f,
      volumedown                       = 0xf027,
      volumemute                       = 0xf6a9,
      volumeoff                        = 0xf026,
      volumeup                         = 0xf028,
      voteyea                          = 0xf772,
      vrcardboard                      = 0xf729,
      walking                          = 0xf554,
      wallet                           = 0xf555,
      warehouse                        = 0xf494,
      water                            = 0xf773,
      wavesquare                       = 0xf83e,
      weight                           = 0xf496,
      weighthanging                    = 0xf5cd,
      wheelchair                       = 0xf193,
      wifi                             = 0xf1eb,
      wind                             = 0xf72e,
      windowclose                      = 0xf410,
      windowmaximize                   = 0xf2d0,
      windowminimize                   = 0xf2d1,
      windowrestore                    = 0xf2d2,
      winebottle                       = 0xf72f,
      wineglass                        = 0xf4e3,
      wineglassalt                     = 0xf5ce,
      wonsign                          = 0xf159,
      wrench                           = 0xf0ad,
      xray                             = 0xf497,
      yensign                          = 0xf157,
      yinyang                          = 0xf6ad
  };

#ifdef FONT_AWESOME_PRO
  enum pro {
      abacus                           = 0xf640,
      acorn                            = 0xf6ae,
      alarmclock                       = 0xf34e,
      alarmexclamation                 = 0xf843,
      alarmplus                        = 0xf844,
      alarmsnooze                      = 0xf845,
      alicorn                          = 0xf6b0,
      alignslash                       = 0xf846,
      analytics                        = 0xf643,
      angel                            = 0xf779,
      applecrate                       = 0xf6b1,
      arrowaltdown                     = 0xf354,
      arrowaltfrombottom               = 0xf346,
      arrowaltfromleft                 = 0xf347,
      arrowaltfromright                = 0xf348,
      arrowaltfromtop                  = 0xf349,
      arrowaltleft                     = 0xf355,
      arrowaltright                    = 0xf356,
      arrowaltsquaredown               = 0xf350,
      arrowaltsquareleft               = 0xf351,
      arrowaltsquareright              = 0xf352,
      arrowaltsquareup                 = 0xf353,
      arrowalttobottom                 = 0xf34a,
      arrowalttoleft                   = 0xf34b,
      arrowalttoright                  = 0xf34c,
      arrowalttotop                    = 0xf34d,
      arrowaltup                       = 0xf357,
      arrowfrombottom                  = 0xf342,
      arrowfromleft                    = 0xf343,
      arrowfromright                   = 0xf344,
      arrowfromtop                     = 0xf345,
      arrows                           = 0xf047,
      arrowsh                          = 0xf07e,
      arrowsquaredown                  = 0xf339,
      arrowsquareleft                  = 0xf33a,
      arrowsquareright                 = 0xf33b,
      arrowsquareup                    = 0xf33c,
      arrowsv                          = 0xf07d,
      arrowtobottom                    = 0xf33d,
      arrowtoleft                      = 0xf33e,
      arrowtoright                     = 0xf340,
      arrowtotop                       = 0xf341,
      atomalt                          = 0xf5d3,
      axe                              = 0xf6b2,
      axebattle                        = 0xf6b3,
      backpack                         = 0xf5d4,
      badge                            = 0xf335,
      badgecheck                       = 0xf336,
      badgedollar                      = 0xf645,
      badgepercent                     = 0xf646,
      badgerhoney                      = 0xf6b4,
      bagsshopping                     = 0xf847,
      ballot                           = 0xf732,
      ballotcheck                      = 0xf733,
      ballpile                         = 0xf77e,
      barcodealt                       = 0xf463,
      barcoderead                      = 0xf464,
      barcodescan                      = 0xf465,
      baseball                         = 0xf432,
      basketballhoop                   = 0xf435,
      bat                              = 0xf6b5,
      batterybolt                      = 0xf376,
      batteryslash                     = 0xf377,
      bellexclamation                  = 0xf848,
      bellplus                         = 0xf849,
      bells                            = 0xf77f,
      bellschool                       = 0xf5d5,
      bellschoolslash                  = 0xf5d6,
      bikingmountain                   = 0xf84b,
      blanket                          = 0xf498,
      bonebreak                        = 0xf5d8,
      bookalt                          = 0xf5d9,
      bookheart                        = 0xf499,
      books                            = 0xf5db,
      booksmedical                     = 0xf7e8,
      bookspells                       = 0xf6b8,
      bookuser                         = 0xf7e7,
      boot                             = 0xf782,
      boothcurtain                     = 0xf734,
      borderbottom                     = 0xf84d,
      bordercenterh                    = 0xf89c,
      bordercenterv                    = 0xf89d,
      borderinner                      = 0xf84e,
      borderleft                       = 0xf84f,
      borderouter                      = 0xf851,
      borderright                      = 0xf852,
      borderstylealt                   = 0xf854,
      bordertop                        = 0xf855,
      bowarrow                         = 0xf6b9,
      bowlingpins                      = 0xf437,
      boxalt                           = 0xf49a,
      boxballot                        = 0xf735,
      boxcheck                         = 0xf467,
      boxesalt                         = 0xf4a1,
      boxfragile                       = 0xf49b,
      boxfull                          = 0xf49c,
      boxheart                         = 0xf49d,
      boxingglove                      = 0xf438,
      boxup                            = 0xf49f,
      boxusd                           = 0xf4a0,
      brackets                         = 0xf7e9,
      bracketscurly                    = 0xf7ea,
      breadloaf                        = 0xf7eb,
      bringforward                     = 0xf856,
      bringfront                       = 0xf857,
      browser                          = 0xf37e,
      bullseyearrow                    = 0xf648,
      bullseyepointer                  = 0xf649,
      burgersoda                       = 0xf858,
      burrito                          = 0xf7ed,
      busschool                        = 0xf5dd,
      cabinetfiling                    = 0xf64b,
      calculatoralt                    = 0xf64c,
      calendaredit                     = 0xf333,
      calendarexclamation              = 0xf334,
      calendarstar                     = 0xf736,
      cameraalt                        = 0xf332,
      campfire                         = 0xf6ba,
      candleholder                     = 0xf6bc,
      candycorn                        = 0xf6bd,
      carbuilding                      = 0xf859,
      carbump                          = 0xf5e0,
      carbus                           = 0xf85a,
      caretcircledown                  = 0xf32d,
      caretcircleleft                  = 0xf32e,
      caretcircleright                 = 0xf330,
      caretcircleup                    = 0xf331,
      cargarage                        = 0xf5e2,
      carmechanic                      = 0xf5e3,
      cars                             = 0xf85b,
      cartilt                          = 0xf5e5,
      carwash                          = 0xf5e6,
      cauldron                         = 0xf6bf,
      chairoffice                      = 0xf6c1,
      chartlinedown                    = 0xf64d,
      chartnetwork                     = 0xf78a,
      chartpiealt                      = 0xf64e,
      chartscatter                     = 0xf7ee,
      cheeseburger                     = 0xf7f1,
      cheeseswiss                      = 0xf7f0,
      chessbishopalt                   = 0xf43b,
      chessclock                       = 0xf43d,
      chessclockalt                    = 0xf43e,
      chesskingalt                     = 0xf440,
      chessknightalt                   = 0xf442,
      chesspawnalt                     = 0xf444,
      chessqueenalt                    = 0xf446,
      chessrookalt                     = 0xf448,
      chevrondoubledown                = 0xf322,
      chevrondoubleleft                = 0xf323,
      chevrondoubleright               = 0xf324,
      chevrondoubleup                  = 0xf325,
      chevronsquaredown                = 0xf329,
      chevronsquareleft                = 0xf32a,
      chevronsquareright               = 0xf32b,
      chevronsquareup                  = 0xf32c,
      chimney                          = 0xf78b,
      clawmarks                        = 0xf6c2,
      clipboardlistcheck               = 0xf737,
      clipboardprescription            = 0xf5e8,
      clipboarduser                    = 0xf7f3,
      clouddownload                    = 0xf0ed,
      clouddrizzle                     = 0xf738,
      cloudhail                        = 0xf739,
      cloudhailmixed                   = 0xf73a,
      cloudrainbow                     = 0xf73e,
      clouds                           = 0xf744,
      cloudshowers                     = 0xf73f,
      cloudsleet                       = 0xf741,
      cloudsmoon                       = 0xf745,
      cloudsnow                        = 0xf742,
      cloudssun                        = 0xf746,
      cloudupload                      = 0xf0ee,
      club                             = 0xf327,
      codecommit                       = 0xf386,
      codemerge                        = 0xf387,
      coffeetogo                       = 0xf6c5,
      coffin                           = 0xf6c6,
      coin                             = 0xf85c,
      commentaltcheck                  = 0xf4a2,
      commentaltdollar                 = 0xf650,
      commentaltdots                   = 0xf4a3,
      commentaltedit                   = 0xf4a4,
      commentaltexclamation            = 0xf4a5,
      commentaltlines                  = 0xf4a6,
      commentaltmedical                = 0xf7f4,
      commentaltminus                  = 0xf4a7,
      commentaltplus                   = 0xf4a8,
      commentaltslash                  = 0xf4a9,
      commentaltsmile                  = 0xf4aa,
      commentalttimes                  = 0xf4ab,
      commentcheck                     = 0xf4ac,
      commentedit                      = 0xf4ae,
      commentexclamation               = 0xf4af,
      commentlines                     = 0xf4b0,
      commentminus                     = 0xf4b1,
      commentplus                      = 0xf4b2,
      commentsalt                      = 0xf4b6,
      commentsaltdollar                = 0xf652,
      commentsmile                     = 0xf4b4,
      commenttimes                     = 0xf4b5,
      compassslash                     = 0xf5e9,
      compressalt                      = 0xf422,
      compresswide                     = 0xf326,
      construction                     = 0xf85d,
      containerstorage                 = 0xf4b7,
      conveyorbelt                     = 0xf46e,
      conveyorbeltalt                  = 0xf46f,
      corn                             = 0xf6c7,
      cow                              = 0xf6c8,
      creditcardblank                  = 0xf389,
      creditcardfront                  = 0xf38a,
      cricket                          = 0xf449,
      croissant                        = 0xf7f6,
      crutches                         = 0xf7f8,
      curling                          = 0xf44a,
      dagger                           = 0xf6cb,
      debug                            = 0xf7f9,
      deer                             = 0xf78e,
      deerrudolph                      = 0xf78f,
      desktopalt                       = 0xf390,
      dewpoint                         = 0xf748,
      diamond                          = 0xf219,
      diced10                          = 0xf6cd,
      diced12                          = 0xf6ce,
      diced4                           = 0xf6d0,
      diced8                           = 0xf6d2,
      digging                          = 0xf85e,
      diploma                          = 0xf5ea,
      disease                          = 0xf7fa,
      dogleashed                       = 0xf6d4,
      dollyempty                       = 0xf473,
      dollyflatbedalt                  = 0xf475,
      dollyflatbedempty                = 0xf476,
      donotenter                       = 0xf5ec,
      drawcircle                       = 0xf5ed,
      drawsquare                       = 0xf5ef,
      dreidel                          = 0xf792,
      drone                            = 0xf85f,
      dronealt                         = 0xf860,
      drumstick                        = 0xf6d6,
      dryer                            = 0xf861,
      dryeralt                         = 0xf862,
      duck                             = 0xf6d8,
      ear                              = 0xf5f0,
      earmuffs                         = 0xf795,
      eclipse                          = 0xf749,
      eclipsealt                       = 0xf74a,
      eggfried                         = 0xf7fc,
      elephant                         = 0xf6da,
      ellipsishalt                     = 0xf39b,
      ellipsisvalt                     = 0xf39c,
      emptyset                         = 0xf656,
      enginewarning                    = 0xf5f2,
      envelopeopendollar               = 0xf657,
      exchange                         = 0xf0ec,
      exclamationsquare                = 0xf321,
      expandalt                        = 0xf424,
      expandarrows                     = 0xf31d,
      expandwide                       = 0xf320,
      externallink                     = 0xf08e,
      externallinksquare               = 0xf14c,
      eyeevil                          = 0xf6db,
      farm                             = 0xf864,
      fieldhockey                      = 0xf44c,
      filecertificate                  = 0xf5f3,
      filechartline                    = 0xf659,
      filechartpie                     = 0xf65a,
      filecheck                        = 0xf316,
      fileedit                         = 0xf31c,
      fileexclamation                  = 0xf31a,
      fileminus                        = 0xf318,
      fileplus                         = 0xf319,
      filesearch                       = 0xf865,
      filesmedical                     = 0xf7fd,
      filespreadsheet                  = 0xf65b,
      filetimes                        = 0xf317,
      fileuser                         = 0xf65c,
      filmalt                          = 0xf3a0,
      fireplace                        = 0xf79a,
      firesmoke                        = 0xf74b,
      fishcooked                       = 0xf7fe,
      flagalt                          = 0xf74c,
      flame                            = 0xf6df,
      flaskpoison                      = 0xf6e0,
      flaskpotion                      = 0xf6e1,
      flower                           = 0xf7ff,
      flowerdaffodil                   = 0xf800,
      flowertulip                      = 0xf801,
      fog                              = 0xf74e,
      folders                          = 0xf660,
      foldertimes                      = 0xf65f,
      foldertree                       = 0xf802,
      fontcase                         = 0xf866,
      footballhelmet                   = 0xf44f,
      forklift                         = 0xf47a,
      fragile                          = 0xf4bb,
      frenchfries                      = 0xf803,
      frostyhead                       = 0xf79b,
      function                         = 0xf661,
      gameboard                        = 0xf867,
      gameboardalt                     = 0xf868,
      gaspumpslash                     = 0xf5f4,
      giftcard                         = 0xf663,
      gingerbreadman                   = 0xf79d,
      glass                            = 0xf804,
      glasschampagne                   = 0xf79e,
      glasscitrus                      = 0xf869,
      glassesalt                       = 0xf5f5,
      glasswhiskeyrocks                = 0xf7a1,
      globesnow                        = 0xf7a3,
      globestand                       = 0xf5f6,
      golfclub                         = 0xf451,
      h1                               = 0xf313,
      h2                               = 0xf314,
      h3                               = 0xf315,
      h4                               = 0xf86a,
      hammerwar                        = 0xf6e4,
      handheart                        = 0xf4bc,
      handholdingbox                   = 0xf47b,
      handholdingmagic                 = 0xf6e5,
      handholdingseedling              = 0xf4bf,
      handholdingwater                 = 0xf4c1,
      handreceiving                    = 0xf47c,
      handshakealt                     = 0xf4c6,
      handsheart                       = 0xf4c3,
      handsusd                         = 0xf4c5,
      hatchef                          = 0xf86b,
      hatsanta                         = 0xf7a7,
      hatwinter                        = 0xf7a8,
      hatwitch                         = 0xf6e7,
      headside                         = 0xf6e9,
      headsidebrain                    = 0xf808,
      headsidemedical                  = 0xf809,
      headvr                           = 0xf6ea,
      heartcircle                      = 0xf4c7,
      heartrate                        = 0xf5f8,
      heartsquare                      = 0xf4c8,
      helmetbattle                     = 0xf6eb,
      hexagon                          = 0xf312,
      hockeymask                       = 0xf6ee,
      hockeysticks                     = 0xf454,
      homealt                          = 0xf80a,
      homeheart                        = 0xf4c9,
      homelg                           = 0xf80b,
      homelgalt                        = 0xf80c,
      hoodcloak                        = 0xf6ef,
      horizontalrule                   = 0xf86c,
      hospitals                        = 0xf80e,
      hospitaluser                     = 0xf80d,
      houseflood                       = 0xf74f,
      humidity                         = 0xf750,
      hurricane                        = 0xf751,
      iceskate                         = 0xf7ac,
      iconsalt                         = 0xf86e,
      inboxin                          = 0xf310,
      inboxout                         = 0xf311,
      industryalt                      = 0xf3b3,
      infosquare                       = 0xf30f,
      inhaler                          = 0xf5f9,
      integral                         = 0xf667,
      intersection                     = 0xf668,
      inventory                        = 0xf480,
      islandtropical                   = 0xf811,
      jackolantern                     = 0xf30e,
      kerning                          = 0xf86f,
      keynote                          = 0xf66c,
      keyskeleton                      = 0xf6f3,
      kidneys                          = 0xf5fb,
      kite                             = 0xf6f4,
      knifekitchen                     = 0xf6f5,
      lambda                           = 0xf66e,
      lamp                             = 0xf4ca,
      landmarkalt                      = 0xf752,
      layerminus                       = 0xf5fe,
      layerplus                        = 0xf5ff,
      leafheart                        = 0xf4cb,
      leafmaple                        = 0xf6f6,
      leafoak                          = 0xf6f7,
      leveldown                        = 0xf149,
      levelup                          = 0xf148,
      lightbulbdollar                  = 0xf670,
      lightbulbexclamation             = 0xf671,
      lightbulbon                      = 0xf672,
      lightbulbslash                   = 0xf673,
      lightsholiday                    = 0xf7b2,
      linecolumns                      = 0xf870,
      lineheight                       = 0xf871,
      lips                             = 0xf600,
      location                         = 0xf601,
      locationcircle                   = 0xf602,
      locationslash                    = 0xf603,
      lockalt                          = 0xf30d,
      lockopenalt                      = 0xf3c2,
      longarrowdown                    = 0xf175,
      longarrowleft                    = 0xf177,
      longarrowright                   = 0xf178,
      longarrowup                      = 0xf176,
      loveseat                         = 0xf4cc,
      luchador                         = 0xf455,
      lungs                            = 0xf604,
      mace                             = 0xf6f8,
      mailbox                          = 0xf813,
      mandolin                         = 0xf6f9,
      mapmarkeraltslash                = 0xf605,
      mapmarkercheck                   = 0xf606,
      mapmarkeredit                    = 0xf607,
      mapmarkerexclamation             = 0xf608,
      mapmarkerminus                   = 0xf609,
      mapmarkerplus                    = 0xf60a,
      mapmarkerquestion                = 0xf60b,
      mapmarkerslash                   = 0xf60c,
      mapmarkersmile                   = 0xf60d,
      mapmarkertimes                   = 0xf60e,
      meat                             = 0xf814,
      megaphone                        = 0xf675,
      mindshare                        = 0xf677,
      minushexagon                     = 0xf307,
      minusoctagon                     = 0xf308,
      mistletoe                        = 0xf7b4,
      mobileandroid                    = 0xf3ce,
      mobileandroidalt                 = 0xf3cf,
      moneycheckedit                   = 0xf872,
      moneycheckeditalt                = 0xf873,
      monitorheartrate                 = 0xf611,
      monkey                           = 0xf6fb,
      mooncloud                        = 0xf754,
      moonstars                        = 0xf755,
      mountains                        = 0xf6fd,
      mug                              = 0xf874,
      mugmarshmallows                  = 0xf7b7,
      mugtea                           = 0xf875,
      narwhal                          = 0xf6fe,
      octagon                          = 0xf306,
      oiltemp                          = 0xf614,
      omega                            = 0xf67a,
      ornament                         = 0xf7b8,
      overline                         = 0xf876,
      pagebreak                        = 0xf877,
      paintbrushalt                    = 0xf5a9,
      palletalt                        = 0xf483,
      paragraphrtl                     = 0xf878,
      parkingcircle                    = 0xf615,
      parkingcircleslash               = 0xf616,
      parkingslash                     = 0xf617,
      pawalt                           = 0xf701,
      pawclaws                         = 0xf702,
      pegasus                          = 0xf703,
      pencil                           = 0xf040,
      pencilpaintbrush                 = 0xf618,
      pennant                          = 0xf456,
      personcarry                      = 0xf4cf,
      persondolly                      = 0xf4d0,
      persondollyempty                 = 0xf4d1,
      personsign                       = 0xf757,
      phonelaptop                      = 0xf87a,
      phoneoffice                      = 0xf67d,
      phoneplus                        = 0xf4d2,
      pi                               = 0xf67e,
      pie                              = 0xf705,
      pig                              = 0xf706,
      pizza                            = 0xf817,
      planealt                         = 0xf3de,
      plushexagon                      = 0xf300,
      plusoctagon                      = 0xf301,
      podium                           = 0xf680,
      podiumstar                       = 0xf758,
      pollpeople                       = 0xf759,
      popcorn                          = 0xf819,
      presentation                     = 0xf685,
      printsearch                      = 0xf81a,
      printslash                       = 0xf686,
      pumpkin                          = 0xf707,
      questionsquare                   = 0xf2fd,
      rabbit                           = 0xf708,
      rabbitfast                       = 0xf709,
      racquet                          = 0xf45a,
      raindrops                        = 0xf75c,
      ram                              = 0xf70a,
      ramploading                      = 0xf4d4,
      rectanglelandscape               = 0xf2fa,
      rectangleportrait                = 0xf2fb,
      rectanglewide                    = 0xf2fc,
      repeat                           = 0xf363,
      repeat1                          = 0xf365,
      repeat1alt                       = 0xf366,
      repeatalt                        = 0xf364,
      retweetalt                       = 0xf361,
      ringswedding                     = 0xf81b,
      routehighway                     = 0xf61a,
      routeinterstate                  = 0xf61b,
      rulertriangle                    = 0xf61c,
      rv                               = 0xf7be,
      sack                             = 0xf81c,
      sackdollar                       = 0xf81d,
      salad                            = 0xf81e,
      sandwich                         = 0xf81f,
      sausage                          = 0xf820,
      scalpel                          = 0xf61d,
      scalpelpath                      = 0xf61e,
      scanner                          = 0xf488,
      scannerkeyboard                  = 0xf489,
      scannertouchscreen               = 0xf48a,
      scarecrow                        = 0xf70d,
      scarf                            = 0xf7c1,
      scrollold                        = 0xf70f,
      scrubber                         = 0xf2f8,
      scythe                           = 0xf710,
      sendback                         = 0xf87e,
      sendbackward                     = 0xf87f,
      shareall                         = 0xf367,
      sheep                            = 0xf711,
      shield                           = 0xf132,
      shieldcheck                      = 0xf2f7,
      shieldcross                      = 0xf712,
      shippingtimed                    = 0xf48c,
      shishkebab                       = 0xf821,
      shovel                           = 0xf713,
      shovelsnow                       = 0xf7c3,
      shredder                         = 0xf68a,
      shuttlecock                      = 0xf45b,
      sickle                           = 0xf822,
      sigma                            = 0xf68b,
      signal1                          = 0xf68c,
      signal2                          = 0xf68d,
      signal3                          = 0xf68e,
      signal4                          = 0xf68f,
      signalalt                        = 0xf690,
      signalalt1                       = 0xf691,
      signalalt2                       = 0xf692,
      signalalt3                       = 0xf693,
      signalaltslash                   = 0xf694,
      signalslash                      = 0xf695,
      signin                           = 0xf090,
      signout                          = 0xf08b,
      skeleton                         = 0xf620,
      skijump                          = 0xf7c7,
      skilift                          = 0xf7c8,
      sledding                         = 0xf7cb,
      slidershsquare                   = 0xf3f0,
      slidersv                         = 0xf3f1,
      slidersvsquare                   = 0xf3f2,
      smileplus                        = 0xf5b9,
      smoke                            = 0xf760,
      snake                            = 0xf716,
      snooze                           = 0xf880,
      snowblowing                      = 0xf761,
      snowflakes                       = 0xf7cf,
      snowmobile                       = 0xf7d1,
      sortalt                          = 0xf883,
      sortshapesdown                   = 0xf888,
      sortshapesdownalt                = 0xf889,
      sortshapesup                     = 0xf88a,
      sortshapesupalt                  = 0xf88b,
      sortsizedown                     = 0xf88c,
      sortsizedownalt                  = 0xf88d,
      sortsizeup                       = 0xf88e,
      sortsizeupalt                    = 0xf88f,
      soup                             = 0xf823,
      spade                            = 0xf2f4,
      sparkles                         = 0xf890,
      spiderblackwidow                 = 0xf718,
      spiderweb                        = 0xf719,
      spinnerthird                     = 0xf3f4,
      squareroot                       = 0xf697,
      squirrel                         = 0xf71a,
      staff                            = 0xf71b,
      starchristmas                    = 0xf7d4,
      starexclamation                  = 0xf2f3,
      stars                            = 0xf762,
      steak                            = 0xf824,
      steeringwheel                    = 0xf622,
      stocking                         = 0xf7d5,
      stomach                          = 0xf623,
      stretcher                        = 0xf825,
      suncloud                         = 0xf763,
      sundust                          = 0xf764,
      sunglasses                       = 0xf892,
      sunhaze                          = 0xf765,
      sunrise                          = 0xf766,
      sunset                           = 0xf767,
      sword                            = 0xf71c,
      swords                           = 0xf71d,
      tabletandroid                    = 0xf3fb,
      tabletandroidalt                 = 0xf3fc,
      tabletrugged                     = 0xf48f,
      tachometer                       = 0xf0e4,
      tachometeraltaverage             = 0xf624,
      tachometeraltfast                = 0xf625,
      tachometeraltfastest             = 0xf626,
      tachometeraltslow                = 0xf627,
      tachometeraltslowest             = 0xf628,
      tachometeraverage                = 0xf629,
      tachometerfast                   = 0xf62a,
      tachometerfastest                = 0xf62b,
      tachometerslow                   = 0xf62c,
      tachometerslowest                = 0xf62d,
      taco                             = 0xf826,
      tally                            = 0xf69c,
      tanakh                           = 0xf827,
      tasksalt                         = 0xf828,
      temperaturefrigid                = 0xf768,
      temperaturehot                   = 0xf76a,
      tennisball                       = 0xf45e,
      text                             = 0xf893,
      textsize                         = 0xf894,
      theta                            = 0xf69e,
      thunderstorm                     = 0xf76c,
      thunderstormmoon                 = 0xf76d,
      thunderstormsun                  = 0xf76e,
      ticket                           = 0xf145,
      tilde                            = 0xf69f,
      timeshexagon                     = 0xf2ee,
      timesoctagon                     = 0xf2f0,
      timessquare                      = 0xf2d3,
      tire                             = 0xf631,
      tireflat                         = 0xf632,
      tirepressurewarning              = 0xf633,
      tirerugged                       = 0xf634,
      toiletpaperalt                   = 0xf71f,
      tombstone                        = 0xf720,
      tombstonealt                     = 0xf721,
      toothbrush                       = 0xf635,
      tornado                          = 0xf76f,
      trafficcone                      = 0xf636,
      trafficlightgo                   = 0xf638,
      trafficlightslow                 = 0xf639,
      trafficlightstop                 = 0xf63a,
      trashundo                        = 0xf895,
      trashundoalt                     = 0xf896,
      treasurechest                    = 0xf723,
      treealt                          = 0xf400,
      treechristmas                    = 0xf7db,
      treedecorated                    = 0xf7dc,
      treelarge                        = 0xf7dd,
      treepalm                         = 0xf82b,
      trees                            = 0xf724,
      triangle                         = 0xf2ec,
      trophyalt                        = 0xf2eb,
      truckcontainer                   = 0xf4dc,
      truckcouch                       = 0xf4dd,
      truckplow                        = 0xf7de,
      truckramp                        = 0xf4e0,
      turkey                           = 0xf725,
      turtle                           = 0xf726,
      tvretro                          = 0xf401,
      unicorn                          = 0xf727,
      unionp                           = 0xf6a2,
      usdcircle                        = 0xf2e8,
      usdsquare                        = 0xf2e9,
      userchart                        = 0xf6a3,
      usercrown                        = 0xf6a4,
      userhardhat                      = 0xf82c,
      userheadset                      = 0xf82d,
      usermdchat                       = 0xf82e,
      usersclass                       = 0xf63d,
      userscrown                       = 0xf6a5,
      usersmedical                     = 0xf830,
      utensilfork                      = 0xf2e3,
      utensilknife                     = 0xf2e4,
      utensilsalt                      = 0xf2e6,
      valueabsolute                    = 0xf6a6,
      videoplus                        = 0xf4e1,
      volcano                          = 0xf770,
      volume                           = 0xf6a8,
      volumeslash                      = 0xf2e2,
      votenay                          = 0xf771,
      walker                           = 0xf831,
      wand                             = 0xf72a,
      wandmagic                        = 0xf72b,
      warehousealt                     = 0xf495,
      washer                           = 0xf898,
      watch                            = 0xf2e1,
      watchfitness                     = 0xf63e,
      waterlower                       = 0xf774,
      waterrise                        = 0xf775,
      wavesine                         = 0xf899,
      wavetriangle                     = 0xf89a,
      webcam                           = 0xf832,
      webcamslash                      = 0xf833,
      whale                            = 0xf72c,
      wheat                            = 0xf72d,
      whistle                          = 0xf460,
      wifi1                            = 0xf6aa,
      wifi2                            = 0xf6ab,
      wifislash                        = 0xf6ac,
      window                           = 0xf40e,
      windowalt                        = 0xf40f,
      windsock                         = 0xf777,
      windturbine                      = 0xf89b,
      windwarning                      = 0xf776,
      wreath                           = 0xf7e2
  };
#endif

  enum brands {
      fa_500px                    = 0xf26e,
      accessibleicon              = 0xf368,
      accusoft                    = 0xf369,
      acquisitionsincorporated    = 0xf6af,
      adn                         = 0xf170,
      adobe                       = 0xf778,
      adversal                    = 0xf36a,
      affiliatetheme              = 0xf36b,
      airbnb                      = 0xf834,
      algolia                     = 0xf36c,
      alipay                      = 0xf642,
      amazon                      = 0xf270,
      amazonpay                   = 0xf42c,
      amilia                      = 0xf36d,
      android                     = 0xf17b,
      angellist                   = 0xf209,
      angrycreative               = 0xf36e,
      angular                     = 0xf420,
      appstore                    = 0xf36f,
      appstoreios                 = 0xf370,
      apper                       = 0xf371,
      apple                       = 0xf179,
      applepay                    = 0xf415,
      artstation                  = 0xf77a,
      asymmetrik                  = 0xf372,
      atlassian                   = 0xf77b,
      audible                     = 0xf373,
      autoprefixer                = 0xf41c,
      avianex                     = 0xf374,
      aviato                      = 0xf421,
      aws                         = 0xf375,
      bandcamp                    = 0xf2d5,
      battlenet                   = 0xf835,
      behance                     = 0xf1b4,
      behancesquare               = 0xf1b5,
      bimobject                   = 0xf378,
      bitbucket                   = 0xf171,
      bitcoin                     = 0xf379,
      bity                        = 0xf37a,
      blacktie                    = 0xf27e,
      blackberry                  = 0xf37b,
      blogger                     = 0xf37c,
      bloggerb                    = 0xf37d,
      bluetooth                   = 0xf293,
      bluetoothb                  = 0xf294,
      bootstrap                   = 0xf836,
      btc                         = 0xf15a,
      buffer                      = 0xf837,
      buromobelexperte            = 0xf37f,
      buysellads                  = 0xf20d,
      canadianmapleleaf           = 0xf785,
      ccamazonpay                 = 0xf42d,
      ccamex                      = 0xf1f3,
      ccapplepay                  = 0xf416,
      ccdinersclub                = 0xf24c,
      ccdiscover                  = 0xf1f2,
      ccjcb                       = 0xf24b,
      ccmastercard                = 0xf1f1,
      ccpaypal                    = 0xf1f4,
      ccstripe                    = 0xf1f5,
      ccvisa                      = 0xf1f0,
      centercode                  = 0xf380,
      centos                      = 0xf789,
      chrome                      = 0xf268,
      chromecast                  = 0xf838,
      cloudscale                  = 0xf383,
      cloudsmith                  = 0xf384,
      cloudversify                = 0xf385,
      codepen                     = 0xf1cb,
      codiepie                    = 0xf284,
      confluence                  = 0xf78d,
      connectdevelop              = 0xf20e,
      contao                      = 0xf26d,
      cottonbureau                = 0xf89e,
      cpanel                      = 0xf388,
      creativecommons             = 0xf25e,
      creativecommonsby           = 0xf4e7,
      creativecommonsnc           = 0xf4e8,
      creativecommonsnceu         = 0xf4e9,
      creativecommonsncjp         = 0xf4ea,
      creativecommonsnd           = 0xf4eb,
      creativecommonspd           = 0xf4ec,
      creativecommonspdalt        = 0xf4ed,
      creativecommonsremix        = 0xf4ee,
      creativecommonssa           = 0xf4ef,
      creativecommonssampling     = 0xf4f0,
      creativecommonssamplingplus = 0xf4f1,
      creativecommonsshare        = 0xf4f2,
      creativecommonszero         = 0xf4f3,
      criticalrole                = 0xf6c9,
      css3                        = 0xf13c,
      css3alt                     = 0xf38b,
      cuttlefish                  = 0xf38c,
      dandd                       = 0xf38d,
      danddbeyond                 = 0xf6ca,
      dashcube                    = 0xf210,
      delicious                   = 0xf1a5,
      deploydog                   = 0xf38e,
      deskpro                     = 0xf38f,
      dev                         = 0xf6cc,
      deviantart                  = 0xf1bd,
      dhl                         = 0xf790,
      diaspora                    = 0xf791,
      digg                        = 0xf1a6,
      digitalocean                = 0xf391,
      discord                     = 0xf392,
      discourse                   = 0xf393,
      dochub                      = 0xf394,
      docker                      = 0xf395,
      draft2digital               = 0xf396,
      dribbble                    = 0xf17d,
      dribbblesquare              = 0xf397,
      dropbox                     = 0xf16b,
      drupal                      = 0xf1a9,
      dyalog                      = 0xf399,
      earlybirds                  = 0xf39a,
      ebay                        = 0xf4f4,
      edge                        = 0xf282,
      elementor                   = 0xf430,
      ello                        = 0xf5f1,
      ember                       = 0xf423,
      empire                      = 0xf1d1,
      envira                      = 0xf299,
      erlang                      = 0xf39d,
      ethereum                    = 0xf42e,
      etsy                        = 0xf2d7,
      evernote                    = 0xf839,
      expeditedssl                = 0xf23e,
      facebook                    = 0xf09a,
      facebookf                   = 0xf39e,
      facebookmessenger           = 0xf39f,
      facebooksquare              = 0xf082,
      fantasyflightgames          = 0xf6dc,
      fedex                       = 0xf797,
      fedora                      = 0xf798,
      figma                       = 0xf799,
      firefox                     = 0xf269,
      firstorder                  = 0xf2b0,
      firstorderalt               = 0xf50a,
      firstdraft                  = 0xf3a1,
      flickr                      = 0xf16e,
      flipboard                   = 0xf44d,
      fly                         = 0xf417,
      fontawesome                 = 0xf2b4,
      fontawesomealt              = 0xf35c,
      fontawesomeflag             = 0xf425,
      fonticons                   = 0xf280,
      fonticonsfi                 = 0xf3a2,
      fortawesome                 = 0xf286,
      fortawesomealt              = 0xf3a3,
      forumbee                    = 0xf211,
      foursquare                  = 0xf180,
      freecodecamp                = 0xf2c5,
      freebsd                     = 0xf3a4,
      fulcrum                     = 0xf50b,
      galacticrepublic            = 0xf50c,
      galacticsenate              = 0xf50d,
      getpocket                   = 0xf265,
      gg                          = 0xf260,
      ggcircle                    = 0xf261,
      git                         = 0xf1d3,
      gitalt                      = 0xf841,
      gitsquare                   = 0xf1d2,
      github                      = 0xf09b,
      githubalt                   = 0xf113,
      githubsquare                = 0xf092,
      gitkraken                   = 0xf3a6,
      gitlab                      = 0xf296,
      gitter                      = 0xf426,
      glide                       = 0xf2a5,
      glideg                      = 0xf2a6,
      gofore                      = 0xf3a7,
      goodreads                   = 0xf3a8,
      goodreadsg                  = 0xf3a9,
      google                      = 0xf1a0,
      googledrive                 = 0xf3aa,
      googleplay                  = 0xf3ab,
      googleplus                  = 0xf2b3,
      googleplusg                 = 0xf0d5,
      googleplussquare            = 0xf0d4,
      googlewallet                = 0xf1ee,
      gratipay                    = 0xf184,
      grav                        = 0xf2d6,
      gripfire                    = 0xf3ac,
      grunt                       = 0xf3ad,
      gulp                        = 0xf3ae,
      hackernews                  = 0xf1d4,
      hackernewssquare            = 0xf3af,
      hackerrank                  = 0xf5f7,
      hips                        = 0xf452,
      hireahelper                 = 0xf3b0,
      hooli                       = 0xf427,
      hornbill                    = 0xf592,
      hotjar                      = 0xf3b1,
      houzz                       = 0xf27c,
      html5                       = 0xf13b,
      hubspot                     = 0xf3b2,
      imdb                        = 0xf2d8,
      instagram                   = 0xf16d,
      intercom                    = 0xf7af,
      internetexplorer            = 0xf26b,
      invision                    = 0xf7b0,
      ioxhost                     = 0xf208,
      itchio                      = 0xf83a,
      itunes                      = 0xf3b4,
      itunesnote                  = 0xf3b5,
      java                        = 0xf4e4,
      jediorder                   = 0xf50e,
      jenkins                     = 0xf3b6,
      jira                        = 0xf7b1,
      joget                       = 0xf3b7,
      joomla                      = 0xf1aa,
      js                          = 0xf3b8,
      jssquare                    = 0xf3b9,
      jsfiddle                    = 0xf1cc,
      kaggle                      = 0xf5fa,
      keybase                     = 0xf4f5,
      keycdn                      = 0xf3ba,
      kickstarter                 = 0xf3bb,
      kickstarterk                = 0xf3bc,
      korvue                      = 0xf42f,
      laravel                     = 0xf3bd,
      lastfm                      = 0xf202,
      lastfmsquare                = 0xf203,
      leanpub                     = 0xf212,
      less                        = 0xf41d,
      line                        = 0xf3c0,
      linkedin                    = 0xf08c,
      linkedinin                  = 0xf0e1,
      linode                      = 0xf2b8,
      fa_linux                    = 0xf17c,
      lyft                        = 0xf3c3,
      magento                     = 0xf3c4,
      mailchimp                   = 0xf59e,
      mandalorian                 = 0xf50f,
      markdown                    = 0xf60f,
      mastodon                    = 0xf4f6,
      maxcdn                      = 0xf136,
      medapps                     = 0xf3c6,
      medium                      = 0xf23a,
      mediumm                     = 0xf3c7,
      medrt                       = 0xf3c8,
      meetup                      = 0xf2e0,
      megaport                    = 0xf5a3,
      mendeley                    = 0xf7b3,
      microsoft                   = 0xf3ca,
      mix                         = 0xf3cb,
      mixcloud                    = 0xf289,
      mizuni                      = 0xf3cc,
      modx                        = 0xf285,
      monero                      = 0xf3d0,
      napster                     = 0xf3d2,
      neos                        = 0xf612,
      nimblr                      = 0xf5a8,
      node                        = 0xf419,
      nodejs                      = 0xf3d3,
      npm                         = 0xf3d4,
      ns8                         = 0xf3d5,
      nutritionix                 = 0xf3d6,
      odnoklassniki               = 0xf263,
      odnoklassnikisquare         = 0xf264,
      oldrepublic                 = 0xf510,
      opencart                    = 0xf23d,
      openid                      = 0xf19b,
      opera                       = 0xf26a,
      optinmonster                = 0xf23c,
      osi                         = 0xf41a,
      page4                       = 0xf3d7,
      pagelines                   = 0xf18c,
      palfed                      = 0xf3d8,
      patreon                     = 0xf3d9,
      paypal                      = 0xf1ed,
      pennyarcade                 = 0xf704,
      periscope                   = 0xf3da,
      phabricator                 = 0xf3db,
      phoenixframework            = 0xf3dc,
      phoenixsquadron             = 0xf511,
      php                         = 0xf457,
      piedpiper                   = 0xf2ae,
      piedpiperalt                = 0xf1a8,
      piedpiperhat                = 0xf4e5,
      piedpiperpp                 = 0xf1a7,
      pinterest                   = 0xf0d2,
      pinterestp                  = 0xf231,
      pinterestsquare             = 0xf0d3,
      playstation                 = 0xf3df,
      producthunt                 = 0xf288,
      pushed                      = 0xf3e1,
      python                      = 0xf3e2,
      qq                          = 0xf1d6,
      quinscape                   = 0xf459,
      quora                       = 0xf2c4,
      rproject                    = 0xf4f7,
      raspberrypi                 = 0xf7bb,
      ravelry                     = 0xf2d9,
      react                       = 0xf41b,
      reacteurope                 = 0xf75d,
      readme                      = 0xf4d5,
      rebel                       = 0xf1d0,
      redriver                    = 0xf3e3,
      reddit                      = 0xf1a1,
      redditalien                 = 0xf281,
      redditsquare                = 0xf1a2,
      redhat                      = 0xf7bc,
      renren                      = 0xf18b,
      replyd                      = 0xf3e6,
      researchgate                = 0xf4f8,
      resolving                   = 0xf3e7,
      rev                         = 0xf5b2,
      rocketchat                  = 0xf3e8,
      rockrms                     = 0xf3e9,
      safari                      = 0xf267,
      salesforce                  = 0xf83b,
      sass                        = 0xf41e,
      schlix                      = 0xf3ea,
      scribd                      = 0xf28a,
      searchengin                 = 0xf3eb,
      sellcast                    = 0xf2da,
      sellsy                      = 0xf213,
      servicestack                = 0xf3ec,
      shirtsinbulk                = 0xf214,
      shopware                    = 0xf5b5,
      simplybuilt                 = 0xf215,
      sistrix                     = 0xf3ee,
      sith                        = 0xf512,
      sketch                      = 0xf7c6,
      skyatlas                    = 0xf216,
      skype                       = 0xf17e,
      slack                       = 0xf198,
      slackhash                   = 0xf3ef,
      slideshare                  = 0xf1e7,
      snapchat                    = 0xf2ab,
      snapchatghost               = 0xf2ac,
      snapchatsquare              = 0xf2ad,
      soundcloud                  = 0xf1be,
      sourcetree                  = 0xf7d3,
      speakap                     = 0xf3f3,
      speakerdeck                 = 0xf83c,
      spotify                     = 0xf1bc,
      squarespace                 = 0xf5be,
      stackexchange               = 0xf18d,
      stackoverflow               = 0xf16c,
      stackpath                   = 0xf842,
      staylinked                  = 0xf3f5,
      steam                       = 0xf1b6,
      steamsquare                 = 0xf1b7,
      steamsymbol                 = 0xf3f6,
      stickermule                 = 0xf3f7,
      strava                      = 0xf428,
      stripe                      = 0xf429,
      stripes                     = 0xf42a,
      studiovinari                = 0xf3f8,
      stumbleupon                 = 0xf1a4,
      stumbleuponcircle           = 0xf1a3,
      superpowers                 = 0xf2dd,
      supple                      = 0xf3f9,
      suse                        = 0xf7d6,
      symfony                     = 0xf83d,
      teamspeak                   = 0xf4f9,
      telegram                    = 0xf2c6,
      telegramplane               = 0xf3fe,
      tencentweibo                = 0xf1d5,
      theredyeti                  = 0xf69d,
      themeco                     = 0xf5c6,
      themeisle                   = 0xf2b2,
      thinkpeaks                  = 0xf731,
      tradefederation             = 0xf513,
      trello                      = 0xf181,
      tripadvisor                 = 0xf262,
      tumblr                      = 0xf173,
      tumblrsquare                = 0xf174,
      twitch                      = 0xf1e8,
      twitter                     = 0xf099,
      twittersquare               = 0xf081,
      typo3                       = 0xf42b,
      uber                        = 0xf402,
      ubuntu                      = 0xf7df,
      uikit                       = 0xf403,
      uniregistry                 = 0xf404,
      untappd                     = 0xf405,
      ups                         = 0xf7e0,
      usb                         = 0xf287,
      usps                        = 0xf7e1,
      ussunnah                    = 0xf407,
      vaadin                      = 0xf408,
      viacoin                     = 0xf237,
      viadeo                      = 0xf2a9,
      viadeosquare                = 0xf2aa,
      viber                       = 0xf409,
      vimeo                       = 0xf40a,
      vimeosquare                 = 0xf194,
      vimeov                      = 0xf27d,
      vine                        = 0xf1ca,
      vk                          = 0xf189,
      vnv                         = 0xf40b,
      vuejs                       = 0xf41f,
      waze                        = 0xf83f,
      weebly                      = 0xf5cc,
      weibo                       = 0xf18a,
      weixin                      = 0xf1d7,
      whatsapp                    = 0xf232,
      whatsappsquare              = 0xf40c,
      whmcs                       = 0xf40d,
      wikipediaw                  = 0xf266,
      windows                     = 0xf17a,
      wix                         = 0xf5cf,
      wizardsofthecoast           = 0xf730,
      wolfpackbattalion           = 0xf514,
      wordpress                   = 0xf19a,
      wordpresssimple             = 0xf411,
      wpbeginner                  = 0xf297,
      wpexplorer                  = 0xf2de,
      wpforms                     = 0xf298,
      wpressr                     = 0xf3e4,
      xbox                        = 0xf412,
      xing                        = 0xf168,
      xingsquare                  = 0xf169,
      ycombinator                 = 0xf23b,
      yahoo                       = 0xf19e,
      yammer                      = 0xf840,
      yandex                      = 0xf413,
      yandexinternational         = 0xf414,
      yarn                        = 0xf7e3,
      yelp                        = 0xf1e9,
      yoast                       = 0xf2b1,
      youtube                     = 0xf167,
      youtubesquare               = 0xf431,
      zhihu                       = 0xf63f
  };
}



//---------------------------------------------------------------------------------------

class QtAwesomeIconPainter;

/// The main class for managing icons
/// This class requires a 2-phase construction. You must first create the class and then initialize it via an init* method
class QtAwesome : public QObject
{
    Q_OBJECT
public:
    static const QString FAB_FONT_FILENAME;
    static const QString FAR_FONT_FILENAME;
    static const QString FAS_FONT_FILENAME;
    static const int FAB_FONT_WEIGHT = QFont::Normal;
    static const int FAR_FONT_WEIGHT = QFont::Normal;
    static const int FAS_FONT_WEIGHT = QFont::Black;
#ifdef FONT_AWESOME_PRO
    static const QString FAL_FONT_FILENAME;
    static const QString FAD_FONT_FILENAME;
    static const int DUOTONE_HEX_ICON_VALUE = 0x100000;
    static const int FAL_FONT_WEIGHT = QFont::Light;
    static const int FAD_FONT_WEIGHT = QFont::Black;
#else
    static const int FREE_REGULAR_ICON_SIZE = 151;
#endif

public:

    explicit QtAwesome(QObject *parent = nullptr);
    virtual ~QtAwesome();

    bool initFontAwesome();

    const QHash<QString, int> namedCodePoints(style::styles st) const;

    void setDefaultOption( const QString& name, const QVariant& value );
    QVariant defaultOption( const QString& name );

    QIcon icon(int st, int character, const QVariantMap& options = QVariantMap() );
    QIcon icon(const QString& name, const QVariantMap& options = QVariantMap() );
    QIcon icon(QtAwesomeIconPainter* painter, const QVariantMap& optionMap = QVariantMap() );

    void give( const QString& name, QtAwesomeIconPainter* painter );

    QFont font(style::styles st, int size ) const;

    /// Returns the font-name that is used as icon-map
    QString fontName(style::styles st) const;

private:
    int stringToStyleEnum(const QString st) const;
    const QString styleEnumToString(int st) const;

private:
    class FontData{
    private:
        QString _fontFamily;
        QString _fontFilename;
        int _fontId;
        int _fontWeight;

    public:
        FontData() : FontData(QString()){

        }
        FontData(const QString &fontFileName, int fontWeight = QFont::Normal){
            _fontFilename = fontFileName;
            _fontFamily = QString();
            _fontId = -1;
            _fontWeight = fontWeight;
        }
        const QString& fontFamily() const { return _fontFamily; }
        void setFontFamily(const QString &family) { _fontFamily = family; }
        const QString& fontFilename() const { return _fontFilename; }
        int fontId() const { return _fontId; }
        void setFontId(int id) { _fontId = id; }
        int fontWeight() const { return _fontWeight; }
        ///
        /// \brief setFontWeight set the font weight as QFont::weight
        /// \param weight the weight value according to QFont::weight enum
        /// This enum contains the predefined font weights:
        /// \value Thin       0         #same as weight 100
        /// \value ExtraLight 12        #same as weight 200
        /// \value Light      25        #same as weight 300
        /// \value Normal     50        #same as weight 400
        /// \value Medium     57        #same as weight 500
        /// \value DemiBold   63        #same as weight 600
        /// \value Bold       75        #same as weight 700
        /// \value ExtraBold  81        #same as weight 800
        /// \value Black      87        #same as weight 900
        void setFontWeight(int weight) { _fontWeight = weight; }
    };

    QHash<int, FontData> _fontDetails;                      ///< The fonts name used for each style
    QHash<int, QHash<QString, int>*> _namedCodepoints;      ///< A map with names mapped to code-points for each style

    QHash<QString, QtAwesomeIconPainter*> _painterMap;     ///< A map of custom painters
    QVariantMap _defaultOptions;                           ///< The default icon options
    QtAwesomeIconPainter* _fontIconPainter;                ///< A special painter fo painting codepoints
};


//---------------------------------------------------------------------------------------


/// The QtAwesomeIconPainter is a specialized painter for painting icons
/// your can implement an iconpainter to create custom font-icon code
class QtAwesomeIconPainter
{
public:
    virtual ~QtAwesomeIconPainter();
    virtual void paint( QtAwesome* awesome, QPainter* painter, const QRect& rect, QIcon::Mode mode, QIcon::State state, const QVariantMap& options ) = 0;
};

Q_DECLARE_METATYPE(QtAwesomeAnimation*)

#endif // QTAWESOME_H
