
/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIExport.C  -  Export MIDI file Song Functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modifies by Josep Andreu

*/


#include "GMorgan.h"

long
GMO::calculadelta(int value)
{

unsigned long buffer;
unsigned long value1;

value1 = (long) value;

        buffer = value1 & 0x7f;
        while ( (value1 >>= 7) )
              {
               buffer <<= 8;
               buffer |= ((value1 & 0x7F) | 0x80);
              }        

return(buffer);



};




void
GMO::saveMidiFile(char *filename)
{

  FILE *fs;
   char temp[128];
   int i=0;
   bplay = 1;
   generatracks();
   bplay = 0;
   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "w")) != NULL)
   {

   sprintf(temp,"MThd%c%c%c%c%c%c%c%c%c%c",0,0,0,6,0,1,0,8,0,128);

   for (i=0; i<14; i++) fputc(temp[i],fs);

   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cdrums / 256,cdrums % 256);
  
   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cdrums; i++) fputc(drums[i],fs);  

   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cbass / 256,cbass % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cbass; i++) fputc(bass[i],fs);
  
   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cacc1 / 256,cacc1 % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cacc1; i++) fputc(acc1[i],fs);

   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cacc2 / 256,cacc2 % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cacc2; i++) fputc(acc2[i],fs);

   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cacc3 / 256,cacc3 % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cacc3; i++) fputc(acc3[i],fs);


   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cacc4 / 256,cacc4 % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cacc4; i++) fputc(acc4[i],fs);

   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,cacc5 / 256,cacc5 % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<cacc5; i++) fputc(acc5[i],fs);


   bzero(temp,sizeof(temp));

   sprintf(temp,"MTrk%c%c%c%c",0,0,ccontr / 256,ccontr % 256);

   for (i=0; i<8; i++) fputc(temp[i],fs);

   for (i=0; i<ccontr; i++) fputc(contr[i],fs);




   fclose(fs);
   
  }



};


void
GMO::generatracks()
{
 int i;
 int neg,sem;
 char temp[512];
 int compas = 0;
 int tcompas = 0;
 long longtempo;
 Pendientes = 0;
 deltad= 0;
 deltab= 0;
 deltacc1= 0;
 deltacc2= 0;
 deltacc3= 0;
 deltacc4= 0;
 deltacc5= 0;
 deltacon= 0;
 delta = 0;
 int lt1;
 int lt2;
 int lt3;

 
 bzero (PO,sizeof(PO));
 bzero(drums, sizeof(drums));
 bzero(bass, sizeof(bass));
 bzero(acc1, sizeof(acc1));
 bzero(acc2, sizeof(acc2));
 bzero(acc3, sizeof(acc3));
 bzero(acc4, sizeof(acc4));
 bzero(acc5, sizeof(acc5));
 bzero(contr, sizeof(contr));

 stdrums = 0;
 stbass = 0;
 stacc1 = 0;
 stacc2 = 0;
 stacc3 = 0;
 stacc4 = 0;
 stacc5 = 0;
 stcontr = 0;
 cdrums = 0;
 cbass = 0;
 cacc1 = 0;
 cacc2 = 0;
 cacc3 = 0;
 cacc4 = 0;
 cacc5 = 0;
 ccontr = 0;

longtempo = 60000000 / (2 * TempoSong);


lt1 = longtempo / 65536;
lt2 = (longtempo % 65536) / 256;
lt3 = (longtempo % 65536) % 256;




bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cDrums%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,255,3,5,0,255,81,3,lt1,lt2,lt3,0,255,88,4,SNomi,2,16,8);
for (i=0; i<24; i++) drums[i] = temp[i];
cdrums += 24;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cBass",0,255,3,4);
for (i=0; i<8; i++) bass[i] = temp[i];
cbass += 8;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cAcc1",0,255,3,4);
for (i=0; i<8; i++) acc1[i] = temp[i];
cacc1 += 8;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cAcc2",0,255,3,4);
for (i=0; i<8; i++) acc2[i] = temp[i];
cacc2 += 8;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cAcc3",0,255,3,4);
for (i=0; i<8; i++) acc3[i] = temp[i];
cacc3 += 8;


bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cAcc4",0,255,3,4);
for (i=0; i<8; i++) acc4[i] = temp[i];
cacc4 += 8;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cAcc5",0,255,3,4);
for (i=0; i<8; i++) acc5[i] = temp[i];
cacc5 += 8;


bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%cCtrl",0,255,3,4);
for (i=0; i<8; i++) contr[i] = temp[i];
ccontr += 8;



 BuscaRepes();
 while ( compas<=128)

{
  	compas++;
        tcompas++;
        nb = compas;
        if (S[compas].fin == 1) break;        
        compas = mirasaltos(compas);
        nb = compas;
        if (S[compas].pattern != 0)
              {
               sp = S[compas].pattern;
               cambiopat();
               sposi = 0;
              }
        for (neg=1; neg<=SNomi; neg++)
        {    
               count = neg;
               if (MTempo)MiraCambioTempoM(tcompas,neg);
	       GeneraChord();
               for (sem=1; sem<=4; sem++)
                     { 
                     if ((S[nb].ar8 == 1) && (count == SNomi) && (sem == 3))
                     {
                     anticipa =1;
                     GeneraChord();
                     }
                     if ((S[nb].ar16 == 1) && (count == SNomi) && (sem == 4))
                     {
                     anticipa =1;
                     GeneraChord();
                     }
                     for(i=0; i<64; i++)
                     {
                     parsetracks();
                     delta++;

                     }
                     }
        } 
}


PonNotesOff();

bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cdrums; i<cdrums+4; i++) drums[i]=temp[i-cdrums];
cdrums +=4;

bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cbass; i<cbass+4; i++) bass[i]=temp[i-cbass];
cbass +=4;

bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cacc1; i<cacc1+4; i++) acc1[i]=temp[i-cacc1];
cacc1 +=4;

bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cacc2; i<cacc2+4; i++) acc2[i]=temp[i-cacc2];
cacc2 +=4;

bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cacc3; i<cacc3+4; i++) acc3[i]=temp[i-cacc3];
cacc3 +=4;


bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cacc4; i<cacc4+4; i++) acc4[i]=temp[i-cacc4];
cacc4 +=4;

bzero(temp,sizeof(temp)); 
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=cacc5; i<cacc5+4; i++) acc5[i]=temp[i-cacc5];
cacc5 +=4;


bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c",0,255,47,0);
for (i=ccontr; i<ccontr+4; i++) contr[i]=temp[i-ccontr];
ccontr +=4;





};

void

GMO::ActuPen()

{

 int i;

bzero(POAC, sizeof(POAC));
Pendientes = 0;
for (i=0; i<=78; i++)

{
  if (PO[i].estado == 1)
  {
  
  POAC[Pendientes]=PO[i];
  Pendientes++;
  }
}

bzero(PO,sizeof(PO));
for (i=0; i<Pendientes; i++) PO[i]=POAC[i];

};


void

GMO::parsetracks()
{

  char temp[32];
  int i,j,k,l,altinoti;
  int veces,kpen;
  int nveces = 0;
  int stactual = 0;
  int cnumero[10];
  int cvalor[10];
  int note;
  int maxposi;
  int la1;
  int la3;
  int la5;
  int la7;
  int laresta = 0;
  int ac = 0;
  int conh=0;
  int lavelo = 0;
  int ponnotas = 0;
  unsigned long tempdelta;


 if ( (delta % 64 ) == 0)

{
 sposi++;
 ponnotas = 1;

}

if ((Rt[sp].swing != 0) && ((sposi+1) % 4 == 0))
{
ponnotas =0;

if ((delta %  64) == Rt[sp].swing) ponnotas = 1;

}


  maxposi = Rt[sp].bars*Rt[sp].blackn*4;
  if (sposi>maxposi) sposi = 1;
   

  for (i=1; i<=7; i++)
  { 

    switch(i)
        {
          case 1:
             stactual = 180;
             break;
          case 2:
             stactual = 181;
             break;
          case 3:
             stactual = 183;
             break;
          case 4:
             stactual = 184;
             break;
          case 5:
             stactual = 186;
             break;
          case 6:
             stactual = 182;
             break;
          case 7:
             stactual = 185;
             break;
        } 




  for (k=1; k<=30; k++)
  {

kpen = k+200;

switch(kpen)
      {
  case 201:
      nveces = 1;
      cvalor[1] = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[1]= 10;
      break;
    case 202:
      nveces = 1;
      cvalor[1] = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[1] = 7;
      break;
    case 203:
      nveces = 1;
      cvalor[1] = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[1] = 91;
      break;
    case 204:
      nveces = 1;
      cvalor[1] = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[1] = 93;
      break;
    case 205:
      nveces = 4;
      cvalor[1]=0;
      cnumero[1]=101;    
      cvalor[2]=1;
      cvalor[2]=100;
      qcontrol = calculaval(Ectrl[i][k][sposi],-8192,8191);
      cnumero[3] = 6;
      cvalor[3] = DataMSB; 
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
     case 206:
      nveces =1;
      cvalor[1] = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[1] = 5;
      break;
     case 207:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 22;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB; 
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 208:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 0;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5900);
      cnumero[3] = 6;
      cvalor[3] = DataMSB; 
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 209:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 1;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 210:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 2;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5900);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 211:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 3;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 212:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 4;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5900);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 213:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 5;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5940);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 214:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 6;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,8191);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 215:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 7;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5940);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 216:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 8;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 217:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 9;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5940);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 218:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 10;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5900);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 219:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 11;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5940);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 220:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 12;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,8191);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 221:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 13;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5940);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 222:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 14;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 223:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 15;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,5940);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 224:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 17;
      qcontrol = calculaval(Ectrl[i][k][sposi],-127,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 225:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 18;
      qcontrol = calculaval(Ectrl[i][k][sposi],-127,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 226:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 19;
      qcontrol = calculaval(Ectrl[i][k][sposi],-127,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 227:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 20;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 228:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 21;
      qcontrol = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 229:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 23;
      qcontrol = calculaval(Ectrl[i][k][sposi],-64,63);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 230:
      nveces = 4;
      cnumero[1] = 99;
      cvalor[1]=127;
      cnumero[2] = 98;
      cvalor[2] = 24;
      qcontrol = calculaval(Ectrl[i][k][sposi],-127,127);
      cnumero[3] = 6;
      cvalor[3] = DataMSB;
      cnumero[4] = 38;
      cvalor[4] = DataLSB;
      break;
      case 231:
      nveces = 1;
      cvalor[1] = calculaval(Ectrl[i][k][sposi],0,127);
      cnumero[1]= 1;
      break;


      }


    if ((Ectrl[i][k][sposi] != 0) && (ponnotas == 1)) 
         {


             tempdelta= calculadelta(deltacon);
              deltacon = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=ccontr; j<ccontr+1;j++)contr[j]=temp[j-ccontr];
                                   ccontr++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
              
          if (stcontr != stactual)
              {
               stcontr = stactual;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stcontr);
               for(j=ccontr; j<ccontr+1; j++) contr[j]=temp[j-ccontr];
               ccontr++;
              }
          
         for (veces=1; veces<=nveces; veces++)
         {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",cnumero[veces],cvalor[veces]);
         for(j=ccontr; j<ccontr+2; j++) contr[j]=temp[j-ccontr];
         ccontr += 2;
         if (veces<nveces)
         {
           bzero(temp,sizeof(temp));
           sprintf(temp,"%c",0);
           for(j=ccontr; j<ccontr+1; j++) contr[j]=temp[j-ccontr];
           ccontr++;
          }        

         }
         }
   }
  }
  
deltacon++;


         for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 9) && (PO[i].delta == delta) && (PO[i].estado == 1))

            {
                   ac = 1;
                        tempdelta= calculadelta(deltad);
                        deltad = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cdrums; j<cdrums+1; j++) drums[j]=temp[j-cdrums];
                                   cdrums++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    

                           
                   if (stdrums != 153 )
                     {
                        stdrums = 153;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stdrums);
                        for(j=cdrums; j<cdrums+1; j++) drums[j]=temp[j-cdrums];
                        cdrums++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cdrums; j<cdrums+2; j++) drums[j]=temp[j-cdrums];
              cdrums += 2;
            }    
         }
         if (ac) ActuPen();         

  for (i=1; i<=61; i++)
  { 
    
    if ((Edr[i][sposi] != 0) && (ponnotas == 1)) 
         {
          lavelo = Edr[i][sposi] + veloplus[i];
          if (lavelo > 127) lavelo = 127; 
          if (lavelo < 0 ) lavelo = 0;
         


              tempdelta= calculadelta(deltad);
              deltad = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cdrums; j<cdrums+1; j++)drums[j]=temp[j-cdrums];
                                   cdrums++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stdrums != 153 )
              {
               stdrums = 153;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stdrums);
               for(j=cdrums; j<cdrums+1; j++) drums[j]=temp[j-cdrums];
               cdrums++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",i+26,lavelo);
         for(j=cdrums; j<cdrums+2; j++) drums[j]=temp[j-cdrums];
         cdrums += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = i+26;         
         PO[Pendientes].canal = 9;
         PO[Pendientes].delta = delta+128;
         Pendientes++;
         }
   }

  
deltad++;

     
          for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 4) && (PO[i].delta == delta) && (PO[i].estado == 1))
            {      ac = 1;
                        tempdelta= calculadelta(deltacc1);
                        deltacc1 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cacc1; j<cacc1+1; j++) acc1[j]=temp[j-cacc1];
                                   cacc1++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    
                   if (stacc1 != 148 )
                     {
                        stacc1 = 148;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stacc1);
                        for(j=cacc1; j<cacc1+1; j++) acc1[j]=temp[j-cacc1];
                        cacc1++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cacc1; j<cacc1+2; j++) acc1[j]=temp[j-cacc1];
              cacc1 += 2;
            }    
         }
         if (ac) ActuPen();         
  


    if ((Rt[sp].acc1n[1][sposi] != 0) && (ponnotas == 1))
   
    { 
      if (Rt[sp].acc1n[0][sposi] != 0 ) duracion = (int) (TICKS4+Rt[sp].acc1stlt)/Rt[sp].acc1n[0][sposi];
      for (i=0; i<POLY; i++)
      {
       if ((note_active[i]) || (gate[i])) 
         { note =rnote[i]+12; 
           note += (12 * Rt[sp].acc1octa);
                            
              bzero(temp,sizeof(temp));
              tempdelta= calculadelta(deltacc1);
              deltacc1 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cacc1; j<cacc1+1; j++)acc1[j]=temp[j-cacc1];
                                   cacc1++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stacc1 != 148 )
              {
               stacc1 = 148;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stacc1);
               for(j=cacc1; j<cacc1+1; j++) acc1[j]=temp[j-cacc1];
               cacc1++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",note+transpose,Rt[sp].acc1n[1][sposi]);
         for(j=cacc1; j<cacc1+2; j++) acc1[j]=temp[j-cacc1];
         cacc1 += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = note+transpose;         
         PO[Pendientes].canal = 4;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++;

            }
         }

    }

deltacc1++;


          for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 5) && (PO[i].delta == delta) && (PO[i].estado == 1))
            {      ac = 1;
                        tempdelta= calculadelta(deltacc2);
                        deltacc2 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cacc2; j<cacc2+1; j++) acc2[j]=temp[j-cacc2];
                                   cacc2++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    
                   if (stacc2 != 149 )
                     {
                        stacc2 = 149;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stacc2);
                        for(j=cacc2; j<cacc2+1; j++) acc2[j]=temp[j-cacc2];
                        cacc2++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cacc2; j<cacc2+2; j++) acc2[j]=temp[j-cacc2];
              cacc2 += 2;
            }    
         }
         if (ac) ActuPen();         
  




       if ((Rt[sp].acc2n[0][sposi] != 0) && (ponnotas == 1))
       {
        switch(Rt[sp].acc2mode)
        {
         case 0:
         miranota(2);
         break;
         case 1:
         miranotam2(2);
         break;
         case 2:
         miranotam3(2);
         break;
        }
        if (Rt[sp].acc2n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc2stlt)/Rt[sp].acc2n[2][sposi];
        notabajo += (12 * Rt[sp].acc2octa);

              tempdelta= calculadelta(deltacc2);
              deltacc2 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cacc2; j<cacc2+1; j++)acc2[j]=temp[j-cacc2];
                                   cacc2++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stacc2 != 149 )
              {
               stacc2 = 149;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stacc2);
               for(j=cacc2; j<cacc2+1; j++) acc2[j]=temp[j-cacc2];
               cacc2++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",notabajo+48+transpose,Rt[sp].acc2n[1][sposi]);
         for(j=cacc2; j<cacc2+2; j++) acc2[j]=temp[j-cacc2];
         cacc2 += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+48+transpose;         
         PO[Pendientes].canal = 5;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++;
         if (Rt[sp].octavate) 
         {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c%c",0,notabajo+36+transpose,Rt[sp].acc2n[1][sposi]);
         for(j=cacc2; j<cacc2+3; j++) acc2[j]=temp[j-cacc2];
         cacc2 += 3;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+36+transpose;         
         PO[Pendientes].canal = 5;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++; 
         }

        if ((Rt[sp].terceras) || (Rt[sp].sextas))
         {

         if (Rt[sp].terceras) laresta = -3;
         if (Rt[sp].sextas) laresta = -7;

         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;

      for (i = notabajo+laresta+48+transpose; i>=notabajo+36+transpose; i--)
        {
          if ((i % 12 == la1 ) || (i % 12 == la3) || (i % 12 == la5) || ( i % 12 == la7 ))
                   {
                    bzero(temp,sizeof(temp));
                    sprintf(temp,"%c%c%c",0,i,Rt[sp].acc2n[1][sposi]);
                    for(j=cacc2; j<cacc2+3; j++) acc2[j]=temp[j-cacc2];
                    cacc2 += 3;
                    PO[Pendientes].estado = 1;
                    PO[Pendientes].nota = i;         
                    PO[Pendientes].canal = 5;
                    PO[Pendientes].delta = delta+duracion;
                    Pendientes++;
                    break;
                   }
         }

         }

       }

deltacc2++;



          for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 6) && (PO[i].delta == delta) && (PO[i].estado == 1))

            {
                   ac = 1;
                        tempdelta= calculadelta(deltab);
                        deltab = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cbass; j<cbass+1; j++) bass[j]=temp[j-cbass];
                                   cbass++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    

                           
                   if (stbass != 150 )
                     {
                        stbass = 150;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stbass);
                        for(j=cbass; j<cbass+1; j++) bass[j]=temp[j-cbass];
                        cbass++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cbass; j<cbass+2; j++) bass[j]=temp[j-cbass];
              cbass += 2;
            }    
         }
         if (ac) ActuPen();         
 

     if ((Rt[sp].basn[0][sposi] != 0) && (ponnotas ==1))
       {
        miranota(1);
        notabajo += (12 * Rt[sp].bassocta);
        if (Rt[sp].basn[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].bassstlt)/Rt[sp].basn[2][sposi];
      
        
          bzero(temp,sizeof(temp));
              tempdelta= calculadelta(deltab);
              deltab = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cbass; j<cbass+1; j++)bass[j]=temp[j-cbass];
                                   cbass++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stbass != 150 )
              {
               stbass = 150;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stbass);
               for(j=cbass; j<cbass+1; j++) bass[j]=temp[j-cbass];
               cbass++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",notabajo+transpose,Rt[sp].basn[1][sposi]);
         for(j=cbass; j<cbass+2; j++) bass[j]=temp[j-cbass];
         cbass += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+transpose;         
         PO[Pendientes].canal = 6;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++;  
       }

     deltab++;


          for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 7) && (PO[i].delta == delta) && (PO[i].estado == 1))
            {      ac = 1;
                        tempdelta= calculadelta(deltacc3);
                        deltacc3 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cacc3; j<cacc3+1; j++)acc3[j]=temp[j-cacc3];
                                   cacc3++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    
                   if (stacc3 != 151 )
                     {
                        stacc3 = 151;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stacc3);
                        for(j=cacc3; j<cacc3+1; j++) acc3[j]=temp[j-cacc3];
                        cacc3++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cacc3; j<cacc3+2; j++) acc3[j]=temp[j-cacc3];
              cacc3 += 2;
            }    
         }
         if (ac) ActuPen();         
  

      if ((Rt[sp].acc3n[0][sposi] != 0) && (ponnotas == 1))
       {
        switch(Rt[sp].acc3mode)
        {
         case 0:
         miranota(3);
         break;
         case 1:
         miranotam2(3);
         break;
         case 2:
         miranotam3(3);
         break;
        }
        if (Rt[sp].acc3n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc3stlt)/Rt[sp].acc3n[2][sposi];
        notabajo += (12 * Rt[sp].acc3octa);


              bzero(temp,sizeof(temp));
              tempdelta= calculadelta(deltacc3);
              deltacc3 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cacc3; j<cacc3+1; j++)acc3[j]=temp[j-cacc3];
                                   cacc3++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stacc3 != 151 )
              {
               stacc3 = 151;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stacc3);
               for(j=cacc3; j<cacc3+1; j++) acc3[j]=temp[j-cacc3];
               cacc3++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",notabajo+36+transpose,Rt[sp].acc3n[1][sposi]);
         for(j=cacc3; j<cacc3+2; j++) acc3[j]=temp[j-cacc3];
         cacc3 += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+36+transpose;         
         PO[Pendientes].canal = 7;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++;

         la1 = fundi + 12;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;          

      for (i = notabajo-2+36+transpose; i>=notabajo -14+36+transpose; i--)
        {
           
         for (j=4; j>=1; j--)
              { 
                 k = j*12;
                 if ((la3 + k == i) || (la7 + k == i) || (la5 + k == i) || (la1 + k == i))
                   {
                    conh++;
                    if (i>=40) altinoti = i; else altinoti = i+12;
                    bzero(temp,sizeof(temp));
                    sprintf(temp,"%c%c%c",0,altinoti,Rt[sp].acc3n[1][sposi]);
                    for(l=cacc3; l<cacc3+3; l++) acc3[l]=temp[l-cacc3];
                    cacc3 += 3;
                    PO[Pendientes].estado = 1;
                    PO[Pendientes].nota = altinoti;         
                    PO[Pendientes].canal = 7;
                    PO[Pendientes].delta = delta+duracion;
                    Pendientes++;                     
                    
                    if (conh == 3) break; 
                   }
               } 
         if (conh == 3) break;
        }

   }    

deltacc3++;

          for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 8) && (PO[i].delta == delta) && (PO[i].estado == 1))
            {      ac = 1;
                        tempdelta= calculadelta(deltacc4);
                        deltacc4 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cacc4; j<cacc4+1; j++) acc4[j]=temp[j-cacc4];
                                   cacc4++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    
                   if (stacc4 != 152 )
                     {
                        stacc4 = 152;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stacc4);
                        for(j=cacc4; j<cacc4+1; j++) acc4[j]=temp[j-cacc4];
                        cacc4++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cacc4; j<cacc4+2; j++) acc4[j]=temp[j-cacc4];
              cacc4 += 2;
            }    
         }
         if (ac) ActuPen();         
  




       if ((Rt[sp].acc4n[0][sposi] != 0) && (ponnotas == 1))
       {
        switch(Rt[sp].acc4mode)
        {
         case 0:
         miranota(4);
         break;
         case 1:
         miranotam2(4);
         break;
         case 2:
         miranotam3(4);
         break;
        }
        if (Rt[sp].acc4n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc4stlt)/Rt[sp].acc4n[2][sposi];
        notabajo += (12 * Rt[sp].acc4octa);

              bzero(temp,sizeof(temp));
              tempdelta= calculadelta(deltacc4);
              deltacc4 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cacc4; j<cacc4+1; j++)acc4[j]=temp[j-cacc4];
                                   cacc4++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stacc4 != 152 )
              {
               stacc4 = 152;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stacc4);
               for(j=cacc4; j<cacc4+1; j++) acc4[j]=temp[j-cacc4];
               cacc4++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",notabajo+48+transpose,Rt[sp].acc4n[1][sposi]);
         for(j=cacc4; j<cacc4+2; j++) acc4[j]=temp[j-cacc4];
         cacc4 += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+48+transpose;         
         PO[Pendientes].canal = 8;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++;
         if (Rt[sp].octavate4) 
         {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c%c",0,notabajo+36+transpose,Rt[sp].acc4n[1][sposi]);
         for(j=cacc4; j<cacc4+3; j++) acc4[j]=temp[j-cacc4];
         cacc4 += 3;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+36+transpose;         
         PO[Pendientes].canal = 8;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++; 
         }

        if ((Rt[sp].terceras4) || (Rt[sp].sextas4))
         {

         if (Rt[sp].terceras4) laresta = -3;
         if (Rt[sp].sextas4) laresta = -7;

         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;

      for (i = notabajo+laresta+48+transpose; i>=notabajo+36+transpose; i--)
        {
          if ((i % 12 == la1 ) || (i % 12 == la3) || (i % 12 == la5) || ( i % 12 == la7 ))
                   {
                    bzero(temp,sizeof(temp));
                    sprintf(temp,"%c%c%c",0,i,Rt[sp].acc4n[1][sposi]);
                    for(j=cacc4; j<cacc4+3; j++) acc4[j]=temp[j-cacc4];
                    cacc4 += 3;
                    PO[Pendientes].estado = 1;
                    PO[Pendientes].nota = i;         
                    PO[Pendientes].canal = 8;
                    PO[Pendientes].delta = delta+duracion;
                    Pendientes++;
                    break;
                   }
         }

         }

       }

deltacc4++;


          for(i=0; i<Pendientes; i++)
         {
           if (( PO[i].canal == 10) && (PO[i].delta == delta) && (PO[i].estado == 1))
            {      ac = 1;
                        tempdelta= calculadelta(deltacc5);
                        deltacc5 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int) tempdelta);
                                   for(j=cacc5; j<cacc5+1;j++)acc5[j]=temp[j-cacc5];
                                   cacc5++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }                    
                   if (stacc5 != 154 )
                     {
                        stacc5 = 154;
                        bzero(temp,sizeof(temp));
                        sprintf(temp,"%c",stacc5);
                        for(j=cacc5; j<cacc5+1; j++) acc5[j]=temp[j-cacc5];
                        cacc5++;
                      }


              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%c%c",PO[i].nota,0);
              for(j=cacc5; j<cacc5+2; j++) acc5[j]=temp[j-cacc5];
              cacc5 += 2;
            }    
         }
         if (ac) ActuPen();         
  

      if ((Rt[sp].acc5n[0][sposi] != 0) && (ponnotas == 1))
       {
        switch(Rt[sp].acc5mode)
        {
         case 0:
         miranota(5);
         break;
         case 1:
         miranotam2(5);
         break;
         case 2:
         miranotam3(5);
         break;
        }
        if (Rt[sp].acc5n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc5stlt)/Rt[sp].acc5n[2][sposi];
        notabajo += (12 * Rt[sp].acc5octa);


              tempdelta= calculadelta(deltacc5);
              deltacc5 = 0;
                        while (1) {
                                   bzero(temp,sizeof(temp));
                                   sprintf(temp,"%c",(int)tempdelta);
                                   for(j=cacc5; j<cacc5+1;j++)acc5[j]=temp[j-cacc5];
                                   cacc5++;
                                   if (tempdelta & 0x80) tempdelta >>= 8;
                                   else break;
                                   }

              
          if (stacc5 != 154 )
              {
               stacc5 = 154;
               bzero(temp,sizeof(temp));
               sprintf(temp,"%c",stacc5);
               for(j=cacc5; j<cacc5+1; j++) acc5[j]=temp[j-cacc5];
               cacc5++;
              }

         bzero(temp,sizeof(temp));
         sprintf(temp,"%c%c",notabajo+36+transpose,Rt[sp].acc5n[1][sposi]);
         for(j=cacc5; j<cacc5+2; j++) acc5[j]=temp[j-cacc5];
         cacc5 += 2;
         PO[Pendientes].estado = 1;
         PO[Pendientes].nota = notabajo+36+transpose;         
         PO[Pendientes].canal = 10;
         PO[Pendientes].delta = delta+duracion;
         Pendientes++;

         la1 = fundi + 12;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;          

      for (i = notabajo-2+36+transpose; i>=notabajo -14+36+transpose; i--)
        {
           
         for (j=4; j>=1; j--)
              { 
                 k = j*12;
                 if ((la3 + k == i) || (la7 + k == i) || (la5 + k == i) || (la1 + k == i))
                   {
                    conh++;
                    if (i>=40) altinoti = i; else altinoti = i+12;
                    bzero(temp,sizeof(temp));
                    sprintf(temp,"%c%c%c",0,altinoti,Rt[sp].acc5n[1][sposi]);
                    for(l=cacc5; l<cacc5+3; l++) acc5[l]=temp[l-cacc5];
                    cacc5 += 3;
                    PO[Pendientes].estado = 1;
                    PO[Pendientes].nota = altinoti;         
                    PO[Pendientes].canal = 10;
                    PO[Pendientes].delta = delta+duracion;
                    Pendientes++;                     
                    
                    if (conh == 3) break; 
                   }
               } 
         if (conh == 3) break;
        }

   }    

deltacc5++;






};


void
GMO::cambiopat()
{

char temp[128];
int i;

PonDrumTemp(sp);

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,185,0,Rt[sp].drBankM,0,201,Rt[sp].drpc,0,185,7,Rt[sp].drvol,0,10,Rt[sp].drpan,0,91,Rt[sp].drrev,0,93,Rt[sp].drcho);
for(i=cdrums;i<cdrums+20; i++) drums[i]=temp[i-cdrums];
cdrums +=20;
stdrums=185;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,182,0,Rt[sp].bassBankM,0,198,Rt[sp].basspc,0,182,7,Rt[sp].bassvol,0,10,Rt[sp].basspan,0,91,Rt[sp].bassrev,0,93,Rt[sp].basscho);
for(i=cbass;i<cbass+20; i++) bass[i]=temp[i-cbass];
cbass +=20;
stbass=182;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,180,0,Rt[sp].acc1BankM,0,196,Rt[sp].acc1pc,0,180,7,Rt[sp].acc1vol,0,10,Rt[sp].acc1pan,0,91,Rt[sp].acc1rev,0,93,Rt[sp].acc1cho);
for(i=cacc1;i<cacc1+20; i++) acc1[i]=temp[i-cacc1];
cacc1 +=20;
stacc1=180;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,181,0,Rt[sp].acc2BankM,0,197,Rt[sp].acc2pc,0,181,7,Rt[sp].acc2vol,0,10,Rt[sp].acc2pan,0,91,Rt[sp].acc2rev,0,93,Rt[sp].acc2cho);
for(i=cacc2;i<cacc2+20; i++) acc2[i]=temp[i-cacc2];
cacc2 +=20;
stacc2=181;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,183,0,Rt[sp].acc3BankM,0,199,Rt[sp].acc3pc,0,183,7,Rt[sp].acc3vol,0,10,Rt[sp].acc3pan,0,91,Rt[sp].acc3rev,0,93,Rt[sp].acc3cho);
for(i=cacc3;i<cacc3+20; i++) acc3[i]=temp[i-cacc3];
cacc3 +=20;
stacc3=183;


bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,184,0,Rt[sp].acc4BankM,0,200,Rt[sp].acc4pc,0,184,7,Rt[sp].acc4vol,0,10,Rt[sp].acc4pan,0,91,Rt[sp].acc4rev,0,93,Rt[sp].acc4cho);
for(i=cacc4;i<cacc4+20; i++) acc4[i]=temp[i-cacc4];
cacc4 +=20;
stacc4=184;

bzero(temp,sizeof(temp));
sprintf(temp,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",0,186,0,Rt[sp].acc5BankM,0,202,Rt[sp].acc5pc,0,186,7,Rt[sp].acc5vol,0,10,Rt[sp].acc5pan,0,91,Rt[sp].acc5rev,0,93,Rt[sp].acc5cho);
for(i=cacc5;i<cacc5+20; i++) acc5[i]=temp[i-cacc5];
cacc5 +=20;
stacc5=186;

PonControles(sp);



};


void

GMO::PonNotesOff()
{
int i,j;
char temp[64];


          for(i=0; i<Pendientes; i++)
         {
         
              PO[i].estado = 0;
              bzero(temp,sizeof(temp));
              switch(PO[i].canal)
                   {
                   case 9:            
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cdrums; j<cdrums+3; j++) drums[j]=temp[j-cdrums];
              cdrums +=3;
              break;
                   case 6: 
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cbass; j<cbass+3; j++) bass[j]=temp[j-cbass];
              cbass +=3;
              break;
                    case 4:
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cacc1; j<cacc1+3; j++) acc1[j]=temp[j-cacc1];
              cacc1 +=3;
              break;
                    case 5:
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cacc2; j<cacc2+3; j++) acc2[j]=temp[j-cacc2];
              cacc2 +=3;
              break;
                    case 7:
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cacc3; j<cacc3+3; j++) acc3[j]=temp[j-cacc3];
              cacc3 += 3;
              break;
                    case 8:
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cacc4; j<cacc4+3; j++) acc4[j]=temp[j-cacc4];
              cacc4 +=3;
              break;
                    case 10:
              sprintf(temp,"%c%c%c",0,PO[i].nota,0);
              for(j=cacc5; j<cacc5+3; j++) acc5[j]=temp[j-cacc5];
              cacc5 += 3;
              break;
          



                 }    
         }
         ActuPen();         

};

void 
GMO::MiraCambioTempoM(int tcompas,int neg)
{

char temp[32];
long longtempo;
int i,j;
int lt1;
int lt2;
int lt3;


for (i=1; i<200; i++)
{ 
  if (TemT[i].bar == 0) break;
  if ((TemT[i].bar == tcompas) && (TemT[i].black == neg))
      
       {       

            longtempo = 60000000 / (2 * TemT[i].tempo);
            stdrums = 255;

            lt1 = longtempo / 65536;
            lt2 = (longtempo % 65536) / 256;
            lt3 = (longtempo % 65536) % 256;
            bzero(temp,sizeof(temp));
            sprintf(temp,"%c%c%c%c%c%c%c",0,255,81,3,lt1,lt2,lt3);
            for (j=cdrums; j<cdrums+7; j++) drums[j] = temp[j-cdrums];
            cdrums += 7;
            break;
        }
}
};

