/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */


#ifndef _GNOME_SCAN_PREVIEW_AREA_H_
#define _GNOME_SCAN_PREVIEW_AREA_H_

#include <gtk/gtk.h>
#include <cairo.h>
#include "gnome-scan-utils.h"
#include "gnome-scan-preview-plugin.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_PREVIEW_AREA             (gnome_scan_preview_area_get_type ())
#define GNOME_SCAN_PREVIEW_AREA(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PREVIEW_AREA, GnomeScanPreviewArea))
#define GNOME_SCAN_PREVIEW_AREA_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PREVIEW_AREA, GnomeScanPreviewAreaClass))
#define GNOME_IS_SCAN_PREVIEW_AREA(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PREVIEW_AREA))
#define GNOME_IS_SCAN_PREVIEW_AREA_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PREVIEW_AREA))
#define GNOME_SCAN_PREVIEW_AREA_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PREVIEW_AREA, GnomeScanPreviewAreaClass))

typedef struct _GnomeScanPreviewAreaClass GnomeScanPreviewAreaClass;
typedef struct _GnomeScanPreviewArea GnomeScanPreviewArea;

struct _GnomeScanPreviewAreaClass
{
  GtkDrawingAreaClass parent_class;

  /* Signals */
/*   void	(*draw_buffer)	        (GnomeScanPreviewArea *gspa, cairo_t*cr, gpointer data); */
  void	(*preview_received)	(GnomeScanPreviewArea *gspa, GdkPixbuf *pixbuf, gpointer data);
};

struct _GnomeScanPreviewArea
{
  GtkDrawingArea parent_instance;
};

GType		gnome_scan_preview_area_get_type			(void) G_GNUC_CONST;
GtkWidget*	gnome_scan_preview_area_new				(void);
void		gnome_scan_preview_area_set_pixbuf			(GnomeScanPreviewArea *preview_area,
									 GdkPixbuf *pixbuf,
									 gdouble resolution);
gdouble		gnome_scan_preview_area_get_resolution		        (GnomeScanPreviewArea *preview_area);
void		gnome_scan_preview_area_get_size			(GnomeScanPreviewArea *preview_area,
									 gint *width, gint*height);
void		gnome_scan_preview_area_update				(GnomeScanPreviewArea *preview_area,
									 GdkRectangle *invalid_rect);

void		gnome_scan_preview_area_select_plugin			(GnomeScanPreviewArea *pa,
									 GnomeScanPreviewPlugin *plugin);

G_END_DECLS

#endif /* _GNOME_SCAN_PREVIEW_AREA_H_ */
