// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// If the interval for this service level objective is a calendar interval, this
// structure contains the interval specifications.
type CalendarInterval struct {

	// Specifies the duration of each calendar interval. For example, if Duration is 1
	// and DurationUnit is MONTH , each interval is one month, aligned with the
	// calendar.
	//
	// This member is required.
	Duration *int32

	// Specifies the calendar interval unit.
	//
	// This member is required.
	DurationUnit DurationUnit

	// The date and time when you want the first interval to start. Be sure to choose
	// a time that configures the intervals the way that you want. For example, if you
	// want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start
	// time that is a Monday at 6 a.m.
	//
	// When used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// As soon as one calendar interval ends, another automatically begins.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// A dimension is a name/value pair that is part of the identity of a metric.
// Because dimensions are part of the unique identifier for a metric, whenever you
// add a unique name/value pair to one of your metrics, you are creating a new
// variation of that metric. For example, many Amazon EC2 metrics publish
// InstanceId as a dimension name, and the actual instance ID as the value for that
// dimension.
//
// You can assign up to 30 dimensions to a metric.
type Dimension struct {

	// The name of the dimension. Dimension names must contain only ASCII characters,
	// must include at least one non-whitespace character, and cannot start with a
	// colon ( : ). ASCII control characters are not supported as part of dimension
	// names.
	//
	// This member is required.
	Name *string

	// The value of the dimension. Dimension values must contain only ASCII characters
	// and must include at least one non-whitespace character. ASCII control characters
	// are not supported as part of dimension values.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// This structure contains the attributes that determine the goal of an SLO. This
// includes the time period for evaluation and the attainment threshold.
type Goal struct {

	// The threshold that determines if the goal is being met. An attainment goal is
	// the ratio of good periods that meet the threshold requirements to the total
	// periods within the interval. For example, an attainment goal of 99.9% means that
	// within your interval, you are targeting 99.9% of the periods to be in healthy
	// state.
	//
	// If you omit this parameter, 99 is used to represent 99% as the attainment goal.
	AttainmentGoal *float64

	// The time period used to evaluate the SLO. It can be either a calendar interval
	// or rolling interval.
	//
	// If you omit this parameter, a rolling interval of 7 days is used.
	Interval Interval

	// The percentage of remaining budget over total budget that you want to get
	// warnings for. If you omit this parameter, the default of 50.0 is used.
	WarningThreshold *float64

	noSmithyDocumentSerde
}

// The time period used to evaluate the SLO. It can be either a calendar interval
// or rolling interval.
//
// The following types satisfy this interface:
//
//	IntervalMemberCalendarInterval
//	IntervalMemberRollingInterval
type Interval interface {
	isInterval()
}

// If the interval is a calendar interval, this structure contains the interval
// specifications.
type IntervalMemberCalendarInterval struct {
	Value CalendarInterval

	noSmithyDocumentSerde
}

func (*IntervalMemberCalendarInterval) isInterval() {}

// If the interval is a rolling interval, this structure contains the interval
// specifications.
type IntervalMemberRollingInterval struct {
	Value RollingInterval

	noSmithyDocumentSerde
}

func (*IntervalMemberRollingInterval) isInterval() {}

// This structure defines the metric used for a service level indicator, including
// the metric name, namespace, and dimensions
type Metric struct {

	// An array of one or more dimensions to use to define the metric that you want to
	// use. For more information, see [Dimensions].
	//
	// [Dimensions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension
	Dimensions []Dimension

	// The name of the metric to use.
	MetricName *string

	// The namespace of the metric. For more information, see [Namespaces].
	//
	// [Namespaces]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace
	Namespace *string

	noSmithyDocumentSerde
}

// Use this structure to define a metric or metric math expression that you want
// to use as for a service level objective.
//
// Each MetricDataQuery in the MetricDataQueries array specifies either a metric
// to retrieve, or a metric math expression to be performed on retrieved metrics. A
// single MetricDataQueries array can include as many as 20 MetricDataQuery
// structures in the array. The 20 structures can include as many as 10 structures
// that contain a MetricStat parameter to retrieve a metric, and as many as 10
// structures that contain the Expression parameter to perform a math expression.
// Of those Expression structures, exactly one must have true as the value for
// ReturnData . The result of this expression used for the SLO.
//
// For more information about metric math expressions, see [CloudWatchUse metric math].
//
// Within each MetricDataQuery object, you must specify either Expression or
// MetricStat but not both.
//
// [CloudWatchUse metric math]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html
type MetricDataQuery struct {

	// A short name used to tie this object to the results in the response. This Id
	// must be unique within a MetricDataQueries array. If you are performing math
	// expressions on this set of data, this name represents that data and can serve as
	// a variable in the metric math expression. The valid characters are letters,
	// numbers, and underscore. The first character must be a lowercase letter.
	//
	// This member is required.
	Id *string

	// The ID of the account where this metric is located. If you are performing this
	// operatiion in a monitoring account, use this to specify which source account to
	// retrieve this metric from.
	AccountId *string

	// This field can contain a metric math expression to be performed on the other
	// metrics that you are retrieving within this MetricDataQueries structure.
	//
	// A math expression can use the Id of the other metrics or queries to refer to
	// those metrics, and can also use the Id of other expressions to use the result
	// of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions]
	// in the Amazon CloudWatch User Guide.
	//
	// Within each MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	//
	// [Metric Math Syntax and Functions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax
	Expression *string

	// A human-readable label for this metric or expression. This is especially useful
	// if this is an expression, so that you know what the value represents. If the
	// metric or expression is shown in a CloudWatch dashboard widget, the label is
	// shown. If Label is omitted, CloudWatch generates a default.
	//
	// You can put dynamic expressions into a label, so that it is more descriptive.
	// For more information, see [Using Dynamic Labels].
	//
	// [Using Dynamic Labels]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html
	Label *string

	// A metric to be used directly for the SLO, or to be used in the math expression
	// that will be used for the SLO.
	//
	// Within one MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	MetricStat *MetricStat

	// The granularity, in seconds, of the returned data points for this metric. For
	// metrics with regular resolution, a period can be as short as one minute (60
	// seconds) and must be a multiple of 60. For high-resolution metrics that are
	// collected at intervals of less than one minute, the period can be 1, 5, 10, 30,
	// 60, or any multiple of 60. High-resolution metrics are those metrics stored by a
	// PutMetricData call that includes a StorageResolution of 1 second.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 3 hours
	// ago, you must specify the period as follows or no data points in that time range
	// is returned:
	//
	//   - Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds
	//   (1 minute).
	//
	//   - Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5
	//   minutes).
	//
	//   - Start time greater than 63 days ago - Use a multiple of 3600 seconds (1
	//   hour).
	Period *int32

	// Use this only if you are using a metric math expression for the SLO. Specify
	// true for ReturnData for only the one expression result to use as the alarm. For
	// all other metrics and expressions in the same CreateServiceLevelObjective
	// operation, specify ReturnData as false .
	ReturnData *bool

	noSmithyDocumentSerde
}

// This structure contains information about one CloudWatch metric associated with
// this entity discovered by Application Signals.
type MetricReference struct {

	// The name of the metric.
	//
	// This member is required.
	MetricName *string

	// Used to display the appropriate statistics in the CloudWatch console.
	//
	// This member is required.
	MetricType *string

	// The namespace of the metric. For more information, see [CloudWatchNamespaces].
	//
	// [CloudWatchNamespaces]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace
	//
	// This member is required.
	Namespace *string

	// An array of one or more dimensions that further define the metric. For more
	// information, see [CloudWatchDimensions].
	//
	// [CloudWatchDimensions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension
	Dimensions []Dimension

	noSmithyDocumentSerde
}

// This structure defines the metric to be used as the service level indicator,
// along with the statistics, period, and unit.
type MetricStat struct {

	// The metric to use as the service level indicator, including the metric name,
	// namespace, and dimensions.
	//
	// This member is required.
	Metric *Metric

	// The granularity, in seconds, to be used for the metric. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and must
	// be a multiple of 60. For high-resolution metrics that are collected at intervals
	// of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of
	// 60. High-resolution metrics are those metrics stored by a PutMetricData call
	// that includes a StorageResolution of 1 second.
	//
	// This member is required.
	Period *int32

	// The statistic to use for comparison to the threshold. It can be any CloudWatch
	// statistic or extended statistic. For more information about statistics, see [CloudWatch statistics definitions].
	//
	// [CloudWatch statistics definitions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html
	//
	// This member is required.
	Stat *string

	// If you omit Unit then all data that was collected with any unit is returned,
	// along with the corresponding units that were specified when the data was
	// reported to CloudWatch. If you specify a unit, the operation returns only data
	// that was collected with that unit specified. If you specify a unit that does not
	// match the data collected, the results of the operation are null. CloudWatch does
	// not perform unit conversions.
	Unit StandardUnit

	noSmithyDocumentSerde
}

// If the interval for this SLO is a rolling interval, this structure contains the
// interval specifications.
type RollingInterval struct {

	// Specifies the duration of each rolling interval. For example, if Duration is 7
	// and DurationUnit is DAY , each rolling interval is seven days.
	//
	// This member is required.
	Duration *int32

	// Specifies the rolling interval unit.
	//
	// This member is required.
	DurationUnit DurationUnit

	noSmithyDocumentSerde
}

// This structure contains information about one of your services that was
// discovered by Application Signals.
type Service struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	KeyAttributes map[string]string

	// An array of structures that each contain information about one metric
	// associated with this service.
	//
	// This member is required.
	MetricReferences []MetricReference

	// This structure contains one or more string-to-string maps that help identify
	// this service. It can include platform attributes, application attributes, and
	// telemetry attributes.
	//
	// Platform attributes contain information the service's platform.
	//
	//   - PlatformType defines the hosted-in platform.
	//
	//   - EKS.Cluster is the name of the Amazon EKS cluster.
	//
	//   - K8s.Cluster is the name of the self-hosted Kubernetes cluster.
	//
	//   - K8s.Namespace is the name of the Kubernetes namespace in either Amazon EKS
	//   or Kubernetes clusters.
	//
	//   - K8s.Workload is the name of the Kubernetes workload in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Node is the name of the Kubernetes node in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Pod is the name of the Kubernetes pod in either Amazon EKS or Kubernetes
	//   clusters.
	//
	//   - EC2.AutoScalingGroup is the name of the Amazon EC2 Auto Scaling group.
	//
	//   - EC2.InstanceId is the ID of the Amazon EC2 instance.
	//
	//   - Host is the name of the host, for all platform types.
	//
	// Applciation attributes contain information about the application.
	//
	//   - AWS.Application is the application's name in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	//   - AWS.Application.ARN is the application's ARN in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	// Telemetry attributes contain telemetry information.
	//
	//   - Telemetry.SDK is the fingerprint of the OpenTelemetry SDK version for
	//   instrumented services.
	//
	//   - Telemetry.Agent is the fingerprint of the agent used to collect and send
	//   telemetry data.
	//
	//   - Telemetry.Source Specifies the point of application where the telemetry was
	//   collected or specifies what was used for the source of telemetry data.
	AttributeMaps []map[string]string

	noSmithyDocumentSerde
}

// This structure contains information about one dependency of this service.
type ServiceDependency struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	DependencyKeyAttributes map[string]string

	// The name of the called operation in the dependency.
	//
	// This member is required.
	DependencyOperationName *string

	// An array of structures that each contain information about one metric
	// associated with this service dependency that was discovered by Application
	// Signals.
	//
	// This member is required.
	MetricReferences []MetricReference

	// The name of the operation in this service that calls the dependency.
	//
	// This member is required.
	OperationName *string

	noSmithyDocumentSerde
}

// This structure contains information about a service dependent that was
// discovered by Application Signals. A dependent is an entity that invoked the
// specified service during the provided time range. Dependents include other
// services, CloudWatch Synthetics canaries, and clients that are instrumented with
// CloudWatch RUM app monitors.
type ServiceDependent struct {

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	DependentKeyAttributes map[string]string

	// An array of structures that each contain information about one metric
	// associated with this service dependent that was discovered by Application
	// Signals.
	//
	// This member is required.
	MetricReferences []MetricReference

	// If the dependent invoker was a service that invoked it from an operation, the
	// name of that dependent operation is displayed here.
	DependentOperationName *string

	// If the invoked entity is an operation on an entity, the name of that dependent
	// operation is displayed here.
	OperationName *string

	noSmithyDocumentSerde
}

// This structure contains information about the performance metric that an SLO
// monitors.
type ServiceLevelIndicator struct {

	// The arithmetic operation used when comparing the specified metric to the
	// threshold.
	//
	// This member is required.
	ComparisonOperator ServiceLevelIndicatorComparisonOperator

	// The value that the SLI metric is compared to.
	//
	// This member is required.
	MetricThreshold *float64

	// A structure that contains information about the metric that the SLO monitors.
	//
	// This member is required.
	SliMetric *ServiceLevelIndicatorMetric

	noSmithyDocumentSerde
}

// This structure specifies the information about the service and the performance
// metric that an SLO is to monitor.
type ServiceLevelIndicatorConfig struct {

	// The arithmetic operation to use when comparing the specified metric to the
	// threshold.
	//
	// This member is required.
	ComparisonOperator ServiceLevelIndicatorComparisonOperator

	// The value that the SLI metric is compared to.
	//
	// This member is required.
	MetricThreshold *float64

	// Use this structure to specify the metric to be used for the SLO.
	//
	// This member is required.
	SliMetricConfig *ServiceLevelIndicatorMetricConfig

	noSmithyDocumentSerde
}

// This structure contains the information about the metric that is used for the
// SLO.
type ServiceLevelIndicatorMetric struct {

	// If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric
	// math expression, this structure includes the information about that metric or
	// expression.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	// This is a string-to-string map that contains information about the type of
	// object that this SLO is related to. It can include the following fields.
	//
	//   - Type designates the type of object that this SLO is related to.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If the SLO monitors either the LATENCY or AVAILABILITY metric that Application
	// Signals collects, this field displays which of those metrics is used.
	MetricType ServiceLevelIndicatorMetricType

	// If the SLO monitors a specific operation of the service, this field displays
	// that operation name.
	OperationName *string

	noSmithyDocumentSerde
}

// Use this structure to specify the information for the metric that the SLO will
// monitor.
type ServiceLevelIndicatorMetricConfig struct {

	// If this SLO is related to a metric collected by Application Signals, you must
	// use this field to specify which service the SLO metric is related to. To do so,
	// you must specify at least the Type , Name , and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric
	// math expression, use this structure to specify that metric or expression.
	MetricDataQueries []MetricDataQuery

	// If the SLO is to monitor either the LATENCY or AVAILABILITY metric that
	// Application Signals collects, use this field to specify which of those metrics
	// is used.
	MetricType ServiceLevelIndicatorMetricType

	// If the SLO is to monitor a specific operation of the service, use this field to
	// specify the name of that operation.
	OperationName *string

	// The number of seconds to use as the period for SLO evaluation. Your
	// application's performance is compared to the SLI during each period. For each
	// period, the application is determined to have either achieved or not achieved
	// the necessary performance.
	PeriodSeconds *int32

	// The statistic to use for comparison to the threshold. It can be any CloudWatch
	// statistic or extended statistic. For more information about statistics, see [CloudWatch statistics definitions].
	//
	// [CloudWatch statistics definitions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html
	Statistic *string

	noSmithyDocumentSerde
}

// A structure containing information about one service level objective (SLO) that
// has been created in Application Signals. Creating SLOs can help you ensure your
// services are performing to the level that you expect. SLOs help you set and
// track a specific target level for the reliability and availability of your
// applications and services. Each SLO uses a service level indicator (SLI), which
// is a key performance metric, to calculate how much underperformance can be
// tolerated before the goal that you set for the SLO is not achieved.
type ServiceLevelObjective struct {

	// The ARN of this SLO.
	//
	// This member is required.
	Arn *string

	// The date and time that this SLO was created. When used in a raw HTTP Query API,
	// it is formatted as yyyy-MM-dd'T'HH:mm:ss . For example, 2019-07-01T23:59:59 .
	//
	// This member is required.
	CreatedTime *time.Time

	// This structure contains the attributes that determine the goal of an SLO. This
	// includes the time period for evaluation and the attainment threshold.
	//
	// This member is required.
	Goal *Goal

	// The time that this SLO was most recently updated. When used in a raw HTTP Query
	// API, it is formatted as yyyy-MM-dd'T'HH:mm:ss . For example, 2019-07-01T23:59:59
	// .
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of this SLO.
	//
	// This member is required.
	Name *string

	// A structure containing information about the performance metric that this SLO
	// monitors.
	//
	// This member is required.
	Sli *ServiceLevelIndicator

	// The description that you created for this SLO.
	Description *string

	noSmithyDocumentSerde
}

// A structure containing an SLO budget report that you have requested.
type ServiceLevelObjectiveBudgetReport struct {

	// The ARN of the SLO that this report is for.
	//
	// This member is required.
	Arn *string

	// The status of this SLO, as it relates to the error budget for the entire time
	// interval.
	//
	//   - OK means that the SLO had remaining budget above the warning threshold, as
	//   of the time that you specified in TimeStamp .
	//
	//   - WARNING means that the SLO's remaining budget was below the warning
	//   threshold, as of the time that you specified in TimeStamp .
	//
	//   - BREACHED means that the SLO's budget was exhausted, as of the time that you
	//   specified in TimeStamp .
	//
	//   - INSUFFICIENT_DATA means that the specifed start and end times were before
	//   the SLO was created, or that attainment data is missing.
	//
	// This member is required.
	BudgetStatus ServiceLevelObjectiveBudgetStatus

	// The name of the SLO that this report is for.
	//
	// This member is required.
	Name *string

	// A number between 0 and 100 that represents the percentage of time periods that
	// the service has attained the SLO's attainment goal, as of the time of the
	// request.
	Attainment *float64

	// The budget amount remaining before the SLO status becomes BREACHING , at the
	// time specified in the Timestemp parameter of the request. If this value is
	// negative, then the SLO is already in BREACHING status.
	BudgetSecondsRemaining *int32

	// This structure contains the attributes that determine the goal of an SLO. This
	// includes the time period for evaluation and the attainment threshold.
	Goal *Goal

	// A structure that contains information about the performance metric that this
	// SLO monitors.
	Sli *ServiceLevelIndicator

	// The total number of seconds in the error budget for the interval.
	TotalBudgetSeconds *int32

	noSmithyDocumentSerde
}

// A structure containing information about one error that occurred during a [BatchGetServiceLevelObjectiveBudgetReport]
// operation.
//
// [BatchGetServiceLevelObjectiveBudgetReport]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_BatchGetServiceLevelObjectiveBudgetReport.html
type ServiceLevelObjectiveBudgetReportError struct {

	// The ARN of the SLO that this error is related to.
	//
	// This member is required.
	Arn *string

	// The error code for this error.
	//
	// This member is required.
	ErrorCode *string

	// The message for this error.
	//
	// This member is required.
	ErrorMessage *string

	// The name of the SLO that this error is related to.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A structure that contains information about one service level objective (SLO)
// created in Application Signals.
type ServiceLevelObjectiveSummary struct {

	// The ARN of this service level objective.
	//
	// This member is required.
	Arn *string

	// The name of the service level objective.
	//
	// This member is required.
	Name *string

	// The date and time that this service level objective was created. It is
	// expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
	CreatedTime *time.Time

	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this service level objective is for.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// If this service level objective is specific to a single operation, this field
	// displays the name of that operation.
	OperationName *string

	noSmithyDocumentSerde
}

// This structure contains information about an operation discovered by
// Application Signals. An operation is a specific function performed by a service
// that was discovered by Application Signals, and is often an API that is called
// by an upstream dependent.
type ServiceOperation struct {

	// An array of structures that each contain information about one metric
	// associated with this service operation that was discovered by Application
	// Signals.
	//
	// This member is required.
	MetricReferences []MetricReference

	// The name of the operation, discovered by Application Signals.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// This structure contains information about one of your services that was
// discoverd by Application Signals
type ServiceSummary struct {

	// This is a string-to-string map that help identify the objects discovered by
	// Application Signals. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	// This member is required.
	KeyAttributes map[string]string

	// An array of structures that each contain information about one metric
	// associated with this service.
	//
	// This member is required.
	MetricReferences []MetricReference

	// This structure contains one or more string-to-string maps that help identify
	// this service. It can include platform attributes, application attributes, and
	// telemetry attributes.
	//
	// Platform attributes contain information the service's platform.
	//
	//   - PlatformType defines the hosted-in platform.
	//
	//   - EKS.Cluster is the name of the Amazon EKS cluster.
	//
	//   - K8s.Cluster is the name of the self-hosted Kubernetes cluster.
	//
	//   - K8s.Namespace is the name of the Kubernetes namespace in either Amazon EKS
	//   or Kubernetes clusters.
	//
	//   - K8s.Workload is the name of the Kubernetes workload in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Node is the name of the Kubernetes node in either Amazon EKS or
	//   Kubernetes clusters.
	//
	//   - K8s.Pod is the name of the Kubernetes pod in either Amazon EKS or Kubernetes
	//   clusters.
	//
	//   - EC2.AutoScalingGroup is the name of the Amazon EC2 Auto Scaling group.
	//
	//   - EC2.InstanceId is the ID of the Amazon EC2 instance.
	//
	//   - Host is the name of the host, for all platform types.
	//
	// Applciation attributes contain information about the application.
	//
	//   - AWS.Application is the application's name in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	//   - AWS.Application.ARN is the application's ARN in Amazon Web Services Service
	//   Catalog AppRegistry.
	//
	// Telemetry attributes contain telemetry information.
	//
	//   - Telemetry.SDK is the fingerprint of the OpenTelemetry SDK version for
	//   instrumented services.
	//
	//   - Telemetry.Agent is the fingerprint of the agent used to collect and send
	//   telemetry data.
	//
	//   - Telemetry.Source Specifies the point of application where the telemetry was
	//   collected or specifies what was used for the source of telemetry data.
	AttributeMaps []map[string]string

	noSmithyDocumentSerde
}

// A key-value pair associated with a resource. Tags can help you organize and
// categorize your resources.
type Tag struct {

	// A string that you can use to assign a value. The combination of tag keys and
	// values can help you organize and categorize your resources.
	//
	// This member is required.
	Key *string

	// The value for the specified tag key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isInterval() {}
