// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// You do not have required permissions to access the requested resource.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	ErrorCode_ AccessDeniedErrorCode
	CanRetry   *bool

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You started an assessment run, but one of the instances is already
// participating in another assessment run.
type AgentsAlreadyRunningAssessmentException struct {
	Message *string

	ErrorCodeOverride *string

	Agents          []AgentAlreadyRunningAssessment
	AgentsTruncated *bool
	CanRetry        *bool

	noSmithyDocumentSerde
}

func (e *AgentsAlreadyRunningAssessmentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AgentsAlreadyRunningAssessmentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AgentsAlreadyRunningAssessmentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AgentsAlreadyRunningAssessmentException"
	}
	return *e.ErrorCodeOverride
}
func (e *AgentsAlreadyRunningAssessmentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You cannot perform a specified action if an assessment run is currently in
// progress.
type AssessmentRunInProgressException struct {
	Message *string

	ErrorCodeOverride *string

	AssessmentRunArns          []string
	AssessmentRunArnsTruncated *bool
	CanRetry                   *bool

	noSmithyDocumentSerde
}

func (e *AssessmentRunInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssessmentRunInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssessmentRunInProgressException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssessmentRunInProgressException"
	}
	return *e.ErrorCodeOverride
}
func (e *AssessmentRunInProgressException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Internal server error.
type InternalException struct {
	Message *string

	ErrorCodeOverride *string

	CanRetry *bool

	noSmithyDocumentSerde
}

func (e *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Amazon Inspector cannot assume the cross-account role that it needs to list
// your EC2 instances during the assessment run.
type InvalidCrossAccountRoleException struct {
	Message *string

	ErrorCodeOverride *string

	ErrorCode_ InvalidCrossAccountRoleErrorCode
	CanRetry   *bool

	noSmithyDocumentSerde
}

func (e *InvalidCrossAccountRoleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCrossAccountRoleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCrossAccountRoleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCrossAccountRoleException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCrossAccountRoleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because an invalid or out-of-range value was supplied
// for an input parameter.
type InvalidInputException struct {
	Message *string

	ErrorCodeOverride *string

	ErrorCode_ InvalidInputErrorCode
	CanRetry   *bool

	noSmithyDocumentSerde
}

func (e *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInputException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInputException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInputException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInputException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it attempted to create resources beyond the
// current AWS account limits. The error code describes the limit exceeded.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	ErrorCode_ LimitExceededErrorCode
	CanRetry   *bool

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it referenced an entity that does not exist.
// The error code describes the entity.
type NoSuchEntityException struct {
	Message *string

	ErrorCodeOverride *string

	ErrorCode_ NoSuchEntityErrorCode
	CanRetry   *bool

	noSmithyDocumentSerde
}

func (e *NoSuchEntityException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchEntityException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchEntityException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchEntityException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchEntityException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request is rejected. The specified assessment template is currently
// generating an exclusions preview.
type PreviewGenerationInProgressException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PreviewGenerationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PreviewGenerationInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PreviewGenerationInProgressException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PreviewGenerationInProgressException"
	}
	return *e.ErrorCodeOverride
}
func (e *PreviewGenerationInProgressException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The serice is temporary unavailable.
type ServiceTemporarilyUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	CanRetry *bool

	noSmithyDocumentSerde
}

func (e *ServiceTemporarilyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceTemporarilyUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceTemporarilyUnavailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceTemporarilyUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceTemporarilyUnavailableException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultServer
}

// Used by the GetAssessmentReport API. The request was rejected because you tried to generate a
// report for an assessment run that existed before reporting was supported in
// Amazon Inspector. You can only generate reports for assessment runs that took
// place or will take place after generating reports in Amazon Inspector became
// available.
type UnsupportedFeatureException struct {
	Message *string

	ErrorCodeOverride *string

	CanRetry *bool

	noSmithyDocumentSerde
}

func (e *UnsupportedFeatureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedFeatureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedFeatureException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedFeatureException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedFeatureException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
