// Code generated by smithy-go-codegen DO NOT EDIT.

package ram

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ram/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the lists of resources and principals that associated for resource
// shares that you own.
func (c *Client) GetResourceShareAssociations(ctx context.Context, params *GetResourceShareAssociationsInput, optFns ...func(*Options)) (*GetResourceShareAssociationsOutput, error) {
	if params == nil {
		params = &GetResourceShareAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceShareAssociations", params, optFns, c.addOperationGetResourceShareAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceShareAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceShareAssociationsInput struct {

	// Specifies whether you want to retrieve the associations that involve a
	// specified resource or principal.
	//
	//   - PRINCIPAL – list the principals whose associations you want to see.
	//
	//   - RESOURCE – list the resources whose associations you want to see.
	//
	// This member is required.
	AssociationType types.ResourceShareAssociationType

	// Specifies that you want to retrieve only associations that have this status.
	AssociationStatus types.ResourceShareAssociationStatus

	// Specifies the total number of results that you want included on each page of
	// the response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the number you
	// specify, the NextToken response element is returned with a value (not null).
	// Include the specified value as the NextToken request parameter in the next call
	// to the operation to get the next part of the results. Note that the service
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that you
	// receive all of the results.
	MaxResults *int32

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a NextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's NextToken response to request the next page of results.
	NextToken *string

	// Specifies the ID of the principal whose resource shares you want to retrieve.
	// This can be an Amazon Web Services account ID, an organization ID, an
	// organizational unit ID, or the [Amazon Resource Name (ARN)]of an individual IAM role or user.
	//
	// You cannot specify this parameter if the association type is RESOURCE .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	Principal *string

	// Specifies the [Amazon Resource Name (ARN)] of a resource whose resource shares you want to retrieve.
	//
	// You cannot specify this parameter if the association type is PRINCIPAL .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceArn *string

	// Specifies a list of [Amazon Resource Names (ARNs)] of the resource share whose associations you want to
	// retrieve.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceShareArns []string

	noSmithyDocumentSerde
}

type GetResourceShareAssociationsOutput struct {

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null . This
	// indicates that this is the last page of results.
	NextToken *string

	// An array of objects that contain the details about the associations.
	ResourceShareAssociations []types.ResourceShareAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceShareAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetResourceShareAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetResourceShareAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetResourceShareAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetResourceShareAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceShareAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetResourceShareAssociationsPaginatorOptions is the paginator options for
// GetResourceShareAssociations
type GetResourceShareAssociationsPaginatorOptions struct {
	// Specifies the total number of results that you want included on each page of
	// the response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the number you
	// specify, the NextToken response element is returned with a value (not null).
	// Include the specified value as the NextToken request parameter in the next call
	// to the operation to get the next part of the results. Note that the service
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that you
	// receive all of the results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetResourceShareAssociationsPaginator is a paginator for
// GetResourceShareAssociations
type GetResourceShareAssociationsPaginator struct {
	options   GetResourceShareAssociationsPaginatorOptions
	client    GetResourceShareAssociationsAPIClient
	params    *GetResourceShareAssociationsInput
	nextToken *string
	firstPage bool
}

// NewGetResourceShareAssociationsPaginator returns a new
// GetResourceShareAssociationsPaginator
func NewGetResourceShareAssociationsPaginator(client GetResourceShareAssociationsAPIClient, params *GetResourceShareAssociationsInput, optFns ...func(*GetResourceShareAssociationsPaginatorOptions)) *GetResourceShareAssociationsPaginator {
	if params == nil {
		params = &GetResourceShareAssociationsInput{}
	}

	options := GetResourceShareAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetResourceShareAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetResourceShareAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetResourceShareAssociations page.
func (p *GetResourceShareAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetResourceShareAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetResourceShareAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetResourceShareAssociationsAPIClient is a client that implements the
// GetResourceShareAssociations operation.
type GetResourceShareAssociationsAPIClient interface {
	GetResourceShareAssociations(context.Context, *GetResourceShareAssociationsInput, ...func(*Options)) (*GetResourceShareAssociationsOutput, error)
}

var _ GetResourceShareAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetResourceShareAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetResourceShareAssociations",
	}
}
