// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package smsiface provides an interface to enable mocking the AWS Server Migration Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package smsiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sms"
)

// SMSAPI provides an interface to enable mocking the
// sms.SMS service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Server Migration Service.
//    func myFunc(svc smsiface.SMSAPI) bool {
//        // Make svc.CreateReplicationJob request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := sms.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockSMSClient struct {
//        smsiface.SMSAPI
//    }
//    func (m *mockSMSClient) CreateReplicationJob(input *sms.CreateReplicationJobInput) (*sms.CreateReplicationJobOutput, error) {
//        // mock response/functionality
//    }
//
//    TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockSMSClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SMSAPI interface {
	CreateReplicationJobRequest(*sms.CreateReplicationJobInput) (*request.Request, *sms.CreateReplicationJobOutput)

	CreateReplicationJob(*sms.CreateReplicationJobInput) (*sms.CreateReplicationJobOutput, error)

	DeleteReplicationJobRequest(*sms.DeleteReplicationJobInput) (*request.Request, *sms.DeleteReplicationJobOutput)

	DeleteReplicationJob(*sms.DeleteReplicationJobInput) (*sms.DeleteReplicationJobOutput, error)

	DeleteServerCatalogRequest(*sms.DeleteServerCatalogInput) (*request.Request, *sms.DeleteServerCatalogOutput)

	DeleteServerCatalog(*sms.DeleteServerCatalogInput) (*sms.DeleteServerCatalogOutput, error)

	DisassociateConnectorRequest(*sms.DisassociateConnectorInput) (*request.Request, *sms.DisassociateConnectorOutput)

	DisassociateConnector(*sms.DisassociateConnectorInput) (*sms.DisassociateConnectorOutput, error)

	GetConnectorsRequest(*sms.GetConnectorsInput) (*request.Request, *sms.GetConnectorsOutput)

	GetConnectors(*sms.GetConnectorsInput) (*sms.GetConnectorsOutput, error)

	GetConnectorsPages(*sms.GetConnectorsInput, func(*sms.GetConnectorsOutput, bool) bool) error

	GetReplicationJobsRequest(*sms.GetReplicationJobsInput) (*request.Request, *sms.GetReplicationJobsOutput)

	GetReplicationJobs(*sms.GetReplicationJobsInput) (*sms.GetReplicationJobsOutput, error)

	GetReplicationJobsPages(*sms.GetReplicationJobsInput, func(*sms.GetReplicationJobsOutput, bool) bool) error

	GetReplicationRunsRequest(*sms.GetReplicationRunsInput) (*request.Request, *sms.GetReplicationRunsOutput)

	GetReplicationRuns(*sms.GetReplicationRunsInput) (*sms.GetReplicationRunsOutput, error)

	GetReplicationRunsPages(*sms.GetReplicationRunsInput, func(*sms.GetReplicationRunsOutput, bool) bool) error

	GetServersRequest(*sms.GetServersInput) (*request.Request, *sms.GetServersOutput)

	GetServers(*sms.GetServersInput) (*sms.GetServersOutput, error)

	GetServersPages(*sms.GetServersInput, func(*sms.GetServersOutput, bool) bool) error

	ImportServerCatalogRequest(*sms.ImportServerCatalogInput) (*request.Request, *sms.ImportServerCatalogOutput)

	ImportServerCatalog(*sms.ImportServerCatalogInput) (*sms.ImportServerCatalogOutput, error)

	StartOnDemandReplicationRunRequest(*sms.StartOnDemandReplicationRunInput) (*request.Request, *sms.StartOnDemandReplicationRunOutput)

	StartOnDemandReplicationRun(*sms.StartOnDemandReplicationRunInput) (*sms.StartOnDemandReplicationRunOutput, error)

	UpdateReplicationJobRequest(*sms.UpdateReplicationJobInput) (*request.Request, *sms.UpdateReplicationJobOutput)

	UpdateReplicationJob(*sms.UpdateReplicationJobInput) (*sms.UpdateReplicationJobOutput, error)
}

var _ SMSAPI = (*sms.SMS)(nil)
