// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opApplyArchiveRule = "ApplyArchiveRule"

// ApplyArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the ApplyArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyArchiveRule for more information on using the ApplyArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyArchiveRuleRequest method.
//    req, resp := client.ApplyArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ApplyArchiveRule
func (c *AccessAnalyzer) ApplyArchiveRuleRequest(input *ApplyArchiveRuleInput) (req *request.Request, output *ApplyArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opApplyArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/archive-rule",
	}

	if input == nil {
		input = &ApplyArchiveRuleInput{}
	}

	output = &ApplyArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ApplyArchiveRule API operation for Access Analyzer.
//
// Retroactively applies the archive rule to existing findings that meet the
// archive rule criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ApplyArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ApplyArchiveRule
func (c *AccessAnalyzer) ApplyArchiveRule(input *ApplyArchiveRuleInput) (*ApplyArchiveRuleOutput, error) {
	req, out := c.ApplyArchiveRuleRequest(input)
	return out, req.Send()
}

// ApplyArchiveRuleWithContext is the same as ApplyArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ApplyArchiveRuleWithContext(ctx aws.Context, input *ApplyArchiveRuleInput, opts ...request.Option) (*ApplyArchiveRuleOutput, error) {
	req, out := c.ApplyArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelPolicyGeneration = "CancelPolicyGeneration"

// CancelPolicyGenerationRequest generates a "aws/request.Request" representing the
// client's request for the CancelPolicyGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelPolicyGeneration for more information on using the CancelPolicyGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelPolicyGenerationRequest method.
//    req, resp := client.CancelPolicyGenerationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CancelPolicyGeneration
func (c *AccessAnalyzer) CancelPolicyGenerationRequest(input *CancelPolicyGenerationInput) (req *request.Request, output *CancelPolicyGenerationOutput) {
	op := &request.Operation{
		Name:       opCancelPolicyGeneration,
		HTTPMethod: "PUT",
		HTTPPath:   "/policy/generation/{jobId}",
	}

	if input == nil {
		input = &CancelPolicyGenerationInput{}
	}

	output = &CancelPolicyGenerationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelPolicyGeneration API operation for Access Analyzer.
//
// Cancels the requested policy generation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation CancelPolicyGeneration for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CancelPolicyGeneration
func (c *AccessAnalyzer) CancelPolicyGeneration(input *CancelPolicyGenerationInput) (*CancelPolicyGenerationOutput, error) {
	req, out := c.CancelPolicyGenerationRequest(input)
	return out, req.Send()
}

// CancelPolicyGenerationWithContext is the same as CancelPolicyGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See CancelPolicyGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) CancelPolicyGenerationWithContext(ctx aws.Context, input *CancelPolicyGenerationInput, opts ...request.Option) (*CancelPolicyGenerationOutput, error) {
	req, out := c.CancelPolicyGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessPreview = "CreateAccessPreview"

// CreateAccessPreviewRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPreview for more information on using the CreateAccessPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccessPreviewRequest method.
//    req, resp := client.CreateAccessPreviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAccessPreview
func (c *AccessAnalyzer) CreateAccessPreviewRequest(input *CreateAccessPreviewInput) (req *request.Request, output *CreateAccessPreviewOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPreview,
		HTTPMethod: "PUT",
		HTTPPath:   "/access-preview",
	}

	if input == nil {
		input = &CreateAccessPreviewInput{}
	}

	output = &CreateAccessPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccessPreview API operation for Access Analyzer.
//
// Creates an access preview that allows you to preview IAM Access Analyzer
// findings for your resource before deploying resource permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation CreateAccessPreview for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ServiceQuotaExceededException
//   Service quote met error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAccessPreview
func (c *AccessAnalyzer) CreateAccessPreview(input *CreateAccessPreviewInput) (*CreateAccessPreviewOutput, error) {
	req, out := c.CreateAccessPreviewRequest(input)
	return out, req.Send()
}

// CreateAccessPreviewWithContext is the same as CreateAccessPreview with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) CreateAccessPreviewWithContext(ctx aws.Context, input *CreateAccessPreviewInput, opts ...request.Option) (*CreateAccessPreviewOutput, error) {
	req, out := c.CreateAccessPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnalyzer = "CreateAnalyzer"

// CreateAnalyzerRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnalyzer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnalyzer for more information on using the CreateAnalyzer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAnalyzerRequest method.
//    req, resp := client.CreateAnalyzerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAnalyzer
func (c *AccessAnalyzer) CreateAnalyzerRequest(input *CreateAnalyzerInput) (req *request.Request, output *CreateAnalyzerOutput) {
	op := &request.Operation{
		Name:       opCreateAnalyzer,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer",
	}

	if input == nil {
		input = &CreateAnalyzerInput{}
	}

	output = &CreateAnalyzerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnalyzer API operation for Access Analyzer.
//
// Creates an analyzer for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation CreateAnalyzer for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ServiceQuotaExceededException
//   Service quote met error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAnalyzer
func (c *AccessAnalyzer) CreateAnalyzer(input *CreateAnalyzerInput) (*CreateAnalyzerOutput, error) {
	req, out := c.CreateAnalyzerRequest(input)
	return out, req.Send()
}

// CreateAnalyzerWithContext is the same as CreateAnalyzer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnalyzer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) CreateAnalyzerWithContext(ctx aws.Context, input *CreateAnalyzerInput, opts ...request.Option) (*CreateAnalyzerOutput, error) {
	req, out := c.CreateAnalyzerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateArchiveRule = "CreateArchiveRule"

// CreateArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateArchiveRule for more information on using the CreateArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateArchiveRuleRequest method.
//    req, resp := client.CreateArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule
func (c *AccessAnalyzer) CreateArchiveRuleRequest(input *CreateArchiveRuleInput) (req *request.Request, output *CreateArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opCreateArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule",
	}

	if input == nil {
		input = &CreateArchiveRuleInput{}
	}

	output = &CreateArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateArchiveRule API operation for Access Analyzer.
//
// Creates an archive rule for the specified analyzer. Archive rules automatically
// archive new findings that meet the criteria you define when you create the
// rule.
//
// To learn about filter keys that you can use to create an archive rule, see
// IAM Access Analyzer filter keys (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation CreateArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ServiceQuotaExceededException
//   Service quote met error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule
func (c *AccessAnalyzer) CreateArchiveRule(input *CreateArchiveRuleInput) (*CreateArchiveRuleOutput, error) {
	req, out := c.CreateArchiveRuleRequest(input)
	return out, req.Send()
}

// CreateArchiveRuleWithContext is the same as CreateArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) CreateArchiveRuleWithContext(ctx aws.Context, input *CreateArchiveRuleInput, opts ...request.Option) (*CreateArchiveRuleOutput, error) {
	req, out := c.CreateArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnalyzer = "DeleteAnalyzer"

// DeleteAnalyzerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalyzer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnalyzer for more information on using the DeleteAnalyzer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAnalyzerRequest method.
//    req, resp := client.DeleteAnalyzerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer
func (c *AccessAnalyzer) DeleteAnalyzerRequest(input *DeleteAnalyzerInput) (req *request.Request, output *DeleteAnalyzerOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalyzer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/analyzer/{analyzerName}",
	}

	if input == nil {
		input = &DeleteAnalyzerInput{}
	}

	output = &DeleteAnalyzerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnalyzer API operation for Access Analyzer.
//
// Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer
// is disabled for the account or organization in the current or specific Region.
// All findings that were generated by the analyzer are deleted. You cannot
// undo this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation DeleteAnalyzer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer
func (c *AccessAnalyzer) DeleteAnalyzer(input *DeleteAnalyzerInput) (*DeleteAnalyzerOutput, error) {
	req, out := c.DeleteAnalyzerRequest(input)
	return out, req.Send()
}

// DeleteAnalyzerWithContext is the same as DeleteAnalyzer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnalyzer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) DeleteAnalyzerWithContext(ctx aws.Context, input *DeleteAnalyzerInput, opts ...request.Option) (*DeleteAnalyzerOutput, error) {
	req, out := c.DeleteAnalyzerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteArchiveRule = "DeleteArchiveRule"

// DeleteArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteArchiveRule for more information on using the DeleteArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteArchiveRuleRequest method.
//    req, resp := client.DeleteArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteArchiveRule
func (c *AccessAnalyzer) DeleteArchiveRuleRequest(input *DeleteArchiveRuleInput) (req *request.Request, output *DeleteArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteArchiveRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &DeleteArchiveRuleInput{}
	}

	output = &DeleteArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteArchiveRule API operation for Access Analyzer.
//
// Deletes the specified archive rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation DeleteArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteArchiveRule
func (c *AccessAnalyzer) DeleteArchiveRule(input *DeleteArchiveRuleInput) (*DeleteArchiveRuleOutput, error) {
	req, out := c.DeleteArchiveRuleRequest(input)
	return out, req.Send()
}

// DeleteArchiveRuleWithContext is the same as DeleteArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) DeleteArchiveRuleWithContext(ctx aws.Context, input *DeleteArchiveRuleInput, opts ...request.Option) (*DeleteArchiveRuleOutput, error) {
	req, out := c.DeleteArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPreview = "GetAccessPreview"

// GetAccessPreviewRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPreview for more information on using the GetAccessPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPreviewRequest method.
//    req, resp := client.GetAccessPreviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAccessPreview
func (c *AccessAnalyzer) GetAccessPreviewRequest(input *GetAccessPreviewInput) (req *request.Request, output *GetAccessPreviewOutput) {
	op := &request.Operation{
		Name:       opGetAccessPreview,
		HTTPMethod: "GET",
		HTTPPath:   "/access-preview/{accessPreviewId}",
	}

	if input == nil {
		input = &GetAccessPreviewInput{}
	}

	output = &GetAccessPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccessPreview API operation for Access Analyzer.
//
// Retrieves information about an access preview for the specified analyzer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetAccessPreview for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAccessPreview
func (c *AccessAnalyzer) GetAccessPreview(input *GetAccessPreviewInput) (*GetAccessPreviewOutput, error) {
	req, out := c.GetAccessPreviewRequest(input)
	return out, req.Send()
}

// GetAccessPreviewWithContext is the same as GetAccessPreview with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetAccessPreviewWithContext(ctx aws.Context, input *GetAccessPreviewInput, opts ...request.Option) (*GetAccessPreviewOutput, error) {
	req, out := c.GetAccessPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnalyzedResource = "GetAnalyzedResource"

// GetAnalyzedResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetAnalyzedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnalyzedResource for more information on using the GetAnalyzedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnalyzedResourceRequest method.
//    req, resp := client.GetAnalyzedResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource
func (c *AccessAnalyzer) GetAnalyzedResourceRequest(input *GetAnalyzedResourceInput) (req *request.Request, output *GetAnalyzedResourceOutput) {
	op := &request.Operation{
		Name:       opGetAnalyzedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzed-resource",
	}

	if input == nil {
		input = &GetAnalyzedResourceInput{}
	}

	output = &GetAnalyzedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnalyzedResource API operation for Access Analyzer.
//
// Retrieves information about a resource that was analyzed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetAnalyzedResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource
func (c *AccessAnalyzer) GetAnalyzedResource(input *GetAnalyzedResourceInput) (*GetAnalyzedResourceOutput, error) {
	req, out := c.GetAnalyzedResourceRequest(input)
	return out, req.Send()
}

// GetAnalyzedResourceWithContext is the same as GetAnalyzedResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnalyzedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetAnalyzedResourceWithContext(ctx aws.Context, input *GetAnalyzedResourceInput, opts ...request.Option) (*GetAnalyzedResourceOutput, error) {
	req, out := c.GetAnalyzedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnalyzer = "GetAnalyzer"

// GetAnalyzerRequest generates a "aws/request.Request" representing the
// client's request for the GetAnalyzer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnalyzer for more information on using the GetAnalyzer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnalyzerRequest method.
//    req, resp := client.GetAnalyzerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer
func (c *AccessAnalyzer) GetAnalyzerRequest(input *GetAnalyzerInput) (req *request.Request, output *GetAnalyzerOutput) {
	op := &request.Operation{
		Name:       opGetAnalyzer,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}",
	}

	if input == nil {
		input = &GetAnalyzerInput{}
	}

	output = &GetAnalyzerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnalyzer API operation for Access Analyzer.
//
// Retrieves information about the specified analyzer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetAnalyzer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer
func (c *AccessAnalyzer) GetAnalyzer(input *GetAnalyzerInput) (*GetAnalyzerOutput, error) {
	req, out := c.GetAnalyzerRequest(input)
	return out, req.Send()
}

// GetAnalyzerWithContext is the same as GetAnalyzer with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnalyzer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetAnalyzerWithContext(ctx aws.Context, input *GetAnalyzerInput, opts ...request.Option) (*GetAnalyzerOutput, error) {
	req, out := c.GetAnalyzerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveRule = "GetArchiveRule"

// GetArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveRule for more information on using the GetArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetArchiveRuleRequest method.
//    req, resp := client.GetArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule
func (c *AccessAnalyzer) GetArchiveRuleRequest(input *GetArchiveRuleInput) (req *request.Request, output *GetArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opGetArchiveRule,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &GetArchiveRuleInput{}
	}

	output = &GetArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveRule API operation for Access Analyzer.
//
// Retrieves information about an archive rule.
//
// To learn about filter keys that you can use to create an archive rule, see
// IAM Access Analyzer filter keys (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule
func (c *AccessAnalyzer) GetArchiveRule(input *GetArchiveRuleInput) (*GetArchiveRuleOutput, error) {
	req, out := c.GetArchiveRuleRequest(input)
	return out, req.Send()
}

// GetArchiveRuleWithContext is the same as GetArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetArchiveRuleWithContext(ctx aws.Context, input *GetArchiveRuleInput, opts ...request.Option) (*GetArchiveRuleOutput, error) {
	req, out := c.GetArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFinding = "GetFinding"

// GetFindingRequest generates a "aws/request.Request" representing the
// client's request for the GetFinding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFinding for more information on using the GetFinding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingRequest method.
//    req, resp := client.GetFindingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding
func (c *AccessAnalyzer) GetFindingRequest(input *GetFindingInput) (req *request.Request, output *GetFindingOutput) {
	op := &request.Operation{
		Name:       opGetFinding,
		HTTPMethod: "GET",
		HTTPPath:   "/finding/{id}",
	}

	if input == nil {
		input = &GetFindingInput{}
	}

	output = &GetFindingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFinding API operation for Access Analyzer.
//
// Retrieves information about the specified finding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetFinding for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding
func (c *AccessAnalyzer) GetFinding(input *GetFindingInput) (*GetFindingOutput, error) {
	req, out := c.GetFindingRequest(input)
	return out, req.Send()
}

// GetFindingWithContext is the same as GetFinding with the addition of
// the ability to pass a context and additional request options.
//
// See GetFinding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetFindingWithContext(ctx aws.Context, input *GetFindingInput, opts ...request.Option) (*GetFindingOutput, error) {
	req, out := c.GetFindingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGeneratedPolicy = "GetGeneratedPolicy"

// GetGeneratedPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetGeneratedPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeneratedPolicy for more information on using the GetGeneratedPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGeneratedPolicyRequest method.
//    req, resp := client.GetGeneratedPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetGeneratedPolicy
func (c *AccessAnalyzer) GetGeneratedPolicyRequest(input *GetGeneratedPolicyInput) (req *request.Request, output *GetGeneratedPolicyOutput) {
	op := &request.Operation{
		Name:       opGetGeneratedPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policy/generation/{jobId}",
	}

	if input == nil {
		input = &GetGeneratedPolicyInput{}
	}

	output = &GetGeneratedPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGeneratedPolicy API operation for Access Analyzer.
//
// Retrieves the policy that was generated using StartPolicyGeneration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetGeneratedPolicy for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetGeneratedPolicy
func (c *AccessAnalyzer) GetGeneratedPolicy(input *GetGeneratedPolicyInput) (*GetGeneratedPolicyOutput, error) {
	req, out := c.GetGeneratedPolicyRequest(input)
	return out, req.Send()
}

// GetGeneratedPolicyWithContext is the same as GetGeneratedPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeneratedPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetGeneratedPolicyWithContext(ctx aws.Context, input *GetGeneratedPolicyInput, opts ...request.Option) (*GetGeneratedPolicyOutput, error) {
	req, out := c.GetGeneratedPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessPreviewFindings = "ListAccessPreviewFindings"

// ListAccessPreviewFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPreviewFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPreviewFindings for more information on using the ListAccessPreviewFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessPreviewFindingsRequest method.
//    req, resp := client.ListAccessPreviewFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviewFindings
func (c *AccessAnalyzer) ListAccessPreviewFindingsRequest(input *ListAccessPreviewFindingsInput) (req *request.Request, output *ListAccessPreviewFindingsOutput) {
	op := &request.Operation{
		Name:       opListAccessPreviewFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/access-preview/{accessPreviewId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPreviewFindingsInput{}
	}

	output = &ListAccessPreviewFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessPreviewFindings API operation for Access Analyzer.
//
// Retrieves a list of access preview findings generated by the specified access
// preview.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListAccessPreviewFindings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviewFindings
func (c *AccessAnalyzer) ListAccessPreviewFindings(input *ListAccessPreviewFindingsInput) (*ListAccessPreviewFindingsOutput, error) {
	req, out := c.ListAccessPreviewFindingsRequest(input)
	return out, req.Send()
}

// ListAccessPreviewFindingsWithContext is the same as ListAccessPreviewFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPreviewFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAccessPreviewFindingsWithContext(ctx aws.Context, input *ListAccessPreviewFindingsInput, opts ...request.Option) (*ListAccessPreviewFindingsOutput, error) {
	req, out := c.ListAccessPreviewFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPreviewFindingsPages iterates over the pages of a ListAccessPreviewFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPreviewFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessPreviewFindings operation.
//    pageNum := 0
//    err := client.ListAccessPreviewFindingsPages(params,
//        func(page *accessanalyzer.ListAccessPreviewFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListAccessPreviewFindingsPages(input *ListAccessPreviewFindingsInput, fn func(*ListAccessPreviewFindingsOutput, bool) bool) error {
	return c.ListAccessPreviewFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPreviewFindingsPagesWithContext same as ListAccessPreviewFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAccessPreviewFindingsPagesWithContext(ctx aws.Context, input *ListAccessPreviewFindingsInput, fn func(*ListAccessPreviewFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPreviewFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPreviewFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPreviewFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessPreviews = "ListAccessPreviews"

// ListAccessPreviewsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPreviews operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPreviews for more information on using the ListAccessPreviews
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessPreviewsRequest method.
//    req, resp := client.ListAccessPreviewsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviews
func (c *AccessAnalyzer) ListAccessPreviewsRequest(input *ListAccessPreviewsInput) (req *request.Request, output *ListAccessPreviewsOutput) {
	op := &request.Operation{
		Name:       opListAccessPreviews,
		HTTPMethod: "GET",
		HTTPPath:   "/access-preview",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPreviewsInput{}
	}

	output = &ListAccessPreviewsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessPreviews API operation for Access Analyzer.
//
// Retrieves a list of access previews for the specified analyzer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListAccessPreviews for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviews
func (c *AccessAnalyzer) ListAccessPreviews(input *ListAccessPreviewsInput) (*ListAccessPreviewsOutput, error) {
	req, out := c.ListAccessPreviewsRequest(input)
	return out, req.Send()
}

// ListAccessPreviewsWithContext is the same as ListAccessPreviews with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPreviews for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAccessPreviewsWithContext(ctx aws.Context, input *ListAccessPreviewsInput, opts ...request.Option) (*ListAccessPreviewsOutput, error) {
	req, out := c.ListAccessPreviewsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPreviewsPages iterates over the pages of a ListAccessPreviews operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPreviews method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessPreviews operation.
//    pageNum := 0
//    err := client.ListAccessPreviewsPages(params,
//        func(page *accessanalyzer.ListAccessPreviewsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListAccessPreviewsPages(input *ListAccessPreviewsInput, fn func(*ListAccessPreviewsOutput, bool) bool) error {
	return c.ListAccessPreviewsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPreviewsPagesWithContext same as ListAccessPreviewsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAccessPreviewsPagesWithContext(ctx aws.Context, input *ListAccessPreviewsInput, fn func(*ListAccessPreviewsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPreviewsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPreviewsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPreviewsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnalyzedResources = "ListAnalyzedResources"

// ListAnalyzedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyzedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyzedResources for more information on using the ListAnalyzedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnalyzedResourcesRequest method.
//    req, resp := client.ListAnalyzedResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources
func (c *AccessAnalyzer) ListAnalyzedResourcesRequest(input *ListAnalyzedResourcesInput) (req *request.Request, output *ListAnalyzedResourcesOutput) {
	op := &request.Operation{
		Name:       opListAnalyzedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/analyzed-resource",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalyzedResourcesInput{}
	}

	output = &ListAnalyzedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyzedResources API operation for Access Analyzer.
//
// Retrieves a list of resources of the specified type that have been analyzed
// by the specified analyzer..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListAnalyzedResources for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources
func (c *AccessAnalyzer) ListAnalyzedResources(input *ListAnalyzedResourcesInput) (*ListAnalyzedResourcesOutput, error) {
	req, out := c.ListAnalyzedResourcesRequest(input)
	return out, req.Send()
}

// ListAnalyzedResourcesWithContext is the same as ListAnalyzedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyzedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzedResourcesWithContext(ctx aws.Context, input *ListAnalyzedResourcesInput, opts ...request.Option) (*ListAnalyzedResourcesOutput, error) {
	req, out := c.ListAnalyzedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalyzedResourcesPages iterates over the pages of a ListAnalyzedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyzedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnalyzedResources operation.
//    pageNum := 0
//    err := client.ListAnalyzedResourcesPages(params,
//        func(page *accessanalyzer.ListAnalyzedResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListAnalyzedResourcesPages(input *ListAnalyzedResourcesInput, fn func(*ListAnalyzedResourcesOutput, bool) bool) error {
	return c.ListAnalyzedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalyzedResourcesPagesWithContext same as ListAnalyzedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzedResourcesPagesWithContext(ctx aws.Context, input *ListAnalyzedResourcesInput, fn func(*ListAnalyzedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalyzedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalyzedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalyzedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnalyzers = "ListAnalyzers"

// ListAnalyzersRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyzers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyzers for more information on using the ListAnalyzers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnalyzersRequest method.
//    req, resp := client.ListAnalyzersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers
func (c *AccessAnalyzer) ListAnalyzersRequest(input *ListAnalyzersInput) (req *request.Request, output *ListAnalyzersOutput) {
	op := &request.Operation{
		Name:       opListAnalyzers,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalyzersInput{}
	}

	output = &ListAnalyzersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyzers API operation for Access Analyzer.
//
// Retrieves a list of analyzers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListAnalyzers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers
func (c *AccessAnalyzer) ListAnalyzers(input *ListAnalyzersInput) (*ListAnalyzersOutput, error) {
	req, out := c.ListAnalyzersRequest(input)
	return out, req.Send()
}

// ListAnalyzersWithContext is the same as ListAnalyzers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyzers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzersWithContext(ctx aws.Context, input *ListAnalyzersInput, opts ...request.Option) (*ListAnalyzersOutput, error) {
	req, out := c.ListAnalyzersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalyzersPages iterates over the pages of a ListAnalyzers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyzers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnalyzers operation.
//    pageNum := 0
//    err := client.ListAnalyzersPages(params,
//        func(page *accessanalyzer.ListAnalyzersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListAnalyzersPages(input *ListAnalyzersInput, fn func(*ListAnalyzersOutput, bool) bool) error {
	return c.ListAnalyzersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalyzersPagesWithContext same as ListAnalyzersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzersPagesWithContext(ctx aws.Context, input *ListAnalyzersInput, fn func(*ListAnalyzersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalyzersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalyzersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalyzersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListArchiveRules = "ListArchiveRules"

// ListArchiveRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListArchiveRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArchiveRules for more information on using the ListArchiveRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListArchiveRulesRequest method.
//    req, resp := client.ListArchiveRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules
func (c *AccessAnalyzer) ListArchiveRulesRequest(input *ListArchiveRulesInput) (req *request.Request, output *ListArchiveRulesOutput) {
	op := &request.Operation{
		Name:       opListArchiveRules,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArchiveRulesInput{}
	}

	output = &ListArchiveRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArchiveRules API operation for Access Analyzer.
//
// Retrieves a list of archive rules created for the specified analyzer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListArchiveRules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules
func (c *AccessAnalyzer) ListArchiveRules(input *ListArchiveRulesInput) (*ListArchiveRulesOutput, error) {
	req, out := c.ListArchiveRulesRequest(input)
	return out, req.Send()
}

// ListArchiveRulesWithContext is the same as ListArchiveRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListArchiveRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListArchiveRulesWithContext(ctx aws.Context, input *ListArchiveRulesInput, opts ...request.Option) (*ListArchiveRulesOutput, error) {
	req, out := c.ListArchiveRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArchiveRulesPages iterates over the pages of a ListArchiveRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArchiveRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListArchiveRules operation.
//    pageNum := 0
//    err := client.ListArchiveRulesPages(params,
//        func(page *accessanalyzer.ListArchiveRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListArchiveRulesPages(input *ListArchiveRulesInput, fn func(*ListArchiveRulesOutput, bool) bool) error {
	return c.ListArchiveRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArchiveRulesPagesWithContext same as ListArchiveRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListArchiveRulesPagesWithContext(ctx aws.Context, input *ListArchiveRulesInput, fn func(*ListArchiveRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArchiveRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArchiveRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArchiveRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsRequest method.
//    req, resp := client.ListFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings
func (c *AccessAnalyzer) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/finding",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Access Analyzer.
//
// Retrieves a list of findings generated by the specified analyzer.
//
// To learn about filter keys that you can use to retrieve a list of findings,
// see IAM Access Analyzer filter keys (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListFindings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings
func (c *AccessAnalyzer) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindings operation.
//    pageNum := 0
//    err := client.ListFindingsPages(params,
//        func(page *accessanalyzer.ListFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicyGenerations = "ListPolicyGenerations"

// ListPolicyGenerationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyGenerations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyGenerations for more information on using the ListPolicyGenerations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPolicyGenerationsRequest method.
//    req, resp := client.ListPolicyGenerationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListPolicyGenerations
func (c *AccessAnalyzer) ListPolicyGenerationsRequest(input *ListPolicyGenerationsInput) (req *request.Request, output *ListPolicyGenerationsOutput) {
	op := &request.Operation{
		Name:       opListPolicyGenerations,
		HTTPMethod: "GET",
		HTTPPath:   "/policy/generation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPolicyGenerationsInput{}
	}

	output = &ListPolicyGenerationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyGenerations API operation for Access Analyzer.
//
// Lists all of the policy generations requested in the last seven days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListPolicyGenerations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListPolicyGenerations
func (c *AccessAnalyzer) ListPolicyGenerations(input *ListPolicyGenerationsInput) (*ListPolicyGenerationsOutput, error) {
	req, out := c.ListPolicyGenerationsRequest(input)
	return out, req.Send()
}

// ListPolicyGenerationsWithContext is the same as ListPolicyGenerations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyGenerations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListPolicyGenerationsWithContext(ctx aws.Context, input *ListPolicyGenerationsInput, opts ...request.Option) (*ListPolicyGenerationsOutput, error) {
	req, out := c.ListPolicyGenerationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPolicyGenerationsPages iterates over the pages of a ListPolicyGenerations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicyGenerations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPolicyGenerations operation.
//    pageNum := 0
//    err := client.ListPolicyGenerationsPages(params,
//        func(page *accessanalyzer.ListPolicyGenerationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListPolicyGenerationsPages(input *ListPolicyGenerationsInput, fn func(*ListPolicyGenerationsOutput, bool) bool) error {
	return c.ListPolicyGenerationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPolicyGenerationsPagesWithContext same as ListPolicyGenerationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListPolicyGenerationsPagesWithContext(ctx aws.Context, input *ListPolicyGenerationsInput, fn func(*ListPolicyGenerationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPolicyGenerationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPolicyGenerationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPolicyGenerationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListTagsForResource
func (c *AccessAnalyzer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Access Analyzer.
//
// Retrieves a list of tags applied to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListTagsForResource
func (c *AccessAnalyzer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPolicyGeneration = "StartPolicyGeneration"

// StartPolicyGenerationRequest generates a "aws/request.Request" representing the
// client's request for the StartPolicyGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPolicyGeneration for more information on using the StartPolicyGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPolicyGenerationRequest method.
//    req, resp := client.StartPolicyGenerationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartPolicyGeneration
func (c *AccessAnalyzer) StartPolicyGenerationRequest(input *StartPolicyGenerationInput) (req *request.Request, output *StartPolicyGenerationOutput) {
	op := &request.Operation{
		Name:       opStartPolicyGeneration,
		HTTPMethod: "PUT",
		HTTPPath:   "/policy/generation",
	}

	if input == nil {
		input = &StartPolicyGenerationInput{}
	}

	output = &StartPolicyGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPolicyGeneration API operation for Access Analyzer.
//
// Starts the policy generation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation StartPolicyGeneration for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ServiceQuotaExceededException
//   Service quote met error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartPolicyGeneration
func (c *AccessAnalyzer) StartPolicyGeneration(input *StartPolicyGenerationInput) (*StartPolicyGenerationOutput, error) {
	req, out := c.StartPolicyGenerationRequest(input)
	return out, req.Send()
}

// StartPolicyGenerationWithContext is the same as StartPolicyGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See StartPolicyGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) StartPolicyGenerationWithContext(ctx aws.Context, input *StartPolicyGenerationInput, opts ...request.Option) (*StartPolicyGenerationOutput, error) {
	req, out := c.StartPolicyGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartResourceScan = "StartResourceScan"

// StartResourceScanRequest generates a "aws/request.Request" representing the
// client's request for the StartResourceScan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartResourceScan for more information on using the StartResourceScan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartResourceScanRequest method.
//    req, resp := client.StartResourceScanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartResourceScan
func (c *AccessAnalyzer) StartResourceScanRequest(input *StartResourceScanInput) (req *request.Request, output *StartResourceScanOutput) {
	op := &request.Operation{
		Name:       opStartResourceScan,
		HTTPMethod: "POST",
		HTTPPath:   "/resource/scan",
	}

	if input == nil {
		input = &StartResourceScanInput{}
	}

	output = &StartResourceScanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartResourceScan API operation for Access Analyzer.
//
// Immediately starts a scan of the policies applied to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation StartResourceScan for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartResourceScan
func (c *AccessAnalyzer) StartResourceScan(input *StartResourceScanInput) (*StartResourceScanOutput, error) {
	req, out := c.StartResourceScanRequest(input)
	return out, req.Send()
}

// StartResourceScanWithContext is the same as StartResourceScan with the addition of
// the ability to pass a context and additional request options.
//
// See StartResourceScan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) StartResourceScanWithContext(ctx aws.Context, input *StartResourceScanInput, opts ...request.Option) (*StartResourceScanOutput, error) {
	req, out := c.StartResourceScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/TagResource
func (c *AccessAnalyzer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Access Analyzer.
//
// Adds a tag to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/TagResource
func (c *AccessAnalyzer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UntagResource
func (c *AccessAnalyzer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Access Analyzer.
//
// Removes a tag from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UntagResource
func (c *AccessAnalyzer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateArchiveRule = "UpdateArchiveRule"

// UpdateArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateArchiveRule for more information on using the UpdateArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateArchiveRuleRequest method.
//    req, resp := client.UpdateArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule
func (c *AccessAnalyzer) UpdateArchiveRuleRequest(input *UpdateArchiveRuleInput) (req *request.Request, output *UpdateArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &UpdateArchiveRuleInput{}
	}

	output = &UpdateArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateArchiveRule API operation for Access Analyzer.
//
// Updates the criteria and values for the specified archive rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation UpdateArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule
func (c *AccessAnalyzer) UpdateArchiveRule(input *UpdateArchiveRuleInput) (*UpdateArchiveRuleOutput, error) {
	req, out := c.UpdateArchiveRuleRequest(input)
	return out, req.Send()
}

// UpdateArchiveRuleWithContext is the same as UpdateArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) UpdateArchiveRuleWithContext(ctx aws.Context, input *UpdateArchiveRuleInput, opts ...request.Option) (*UpdateArchiveRuleOutput, error) {
	req, out := c.UpdateArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsRequest method.
//    req, resp := client.UpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings
func (c *AccessAnalyzer) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PUT",
		HTTPPath:   "/finding",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for Access Analyzer.
//
// Updates the status for the specified findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings
func (c *AccessAnalyzer) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidatePolicy = "ValidatePolicy"

// ValidatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the ValidatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidatePolicy for more information on using the ValidatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidatePolicyRequest method.
//    req, resp := client.ValidatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ValidatePolicy
func (c *AccessAnalyzer) ValidatePolicyRequest(input *ValidatePolicyInput) (req *request.Request, output *ValidatePolicyOutput) {
	op := &request.Operation{
		Name:       opValidatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policy/validation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ValidatePolicyInput{}
	}

	output = &ValidatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidatePolicy API operation for Access Analyzer.
//
// Requests the validation of a policy and returns a list of findings. The findings
// help you identify issues and provide actionable recommendations to resolve
// the issue and enable you to author functional policies that meet security
// best practices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ValidatePolicy for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ValidatePolicy
func (c *AccessAnalyzer) ValidatePolicy(input *ValidatePolicyInput) (*ValidatePolicyOutput, error) {
	req, out := c.ValidatePolicyRequest(input)
	return out, req.Send()
}

// ValidatePolicyWithContext is the same as ValidatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ValidatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ValidatePolicyWithContext(ctx aws.Context, input *ValidatePolicyInput, opts ...request.Option) (*ValidatePolicyOutput, error) {
	req, out := c.ValidatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ValidatePolicyPages iterates over the pages of a ValidatePolicy operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ValidatePolicy method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ValidatePolicy operation.
//    pageNum := 0
//    err := client.ValidatePolicyPages(params,
//        func(page *accessanalyzer.ValidatePolicyOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ValidatePolicyPages(input *ValidatePolicyInput, fn func(*ValidatePolicyOutput, bool) bool) error {
	return c.ValidatePolicyPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ValidatePolicyPagesWithContext same as ValidatePolicyPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ValidatePolicyPagesWithContext(ctx aws.Context, input *ValidatePolicyInput, fn func(*ValidatePolicyOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ValidatePolicyInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ValidatePolicyRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ValidatePolicyOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an access preview.
type AccessPreview struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer used to generate the access preview.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A map of resource ARNs for the proposed resource configuration.
	//
	// Configurations is a required field
	Configurations map[string]*Configuration `locationName:"configurations" type:"map" required:"true"`

	// The time at which the access preview was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID for the access preview.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The status of the access preview.
	//
	//    * Creating - The access preview creation is in progress.
	//
	//    * Completed - The access preview is complete. You can preview findings
	//    for external access to the resource.
	//
	//    * Failed - The access preview creation has failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AccessPreviewStatus"`

	// Provides more details about the current status of the access preview.
	//
	// For example, if the creation of the access preview fails, a Failed status
	// is returned. This failure can be due to an internal issue with the analysis
	// or due to an invalid resource configuration.
	StatusReason *AccessPreviewStatusReason `locationName:"statusReason" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreview) GoString() string {
	return s.String()
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *AccessPreview) SetAnalyzerArn(v string) *AccessPreview {
	s.AnalyzerArn = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *AccessPreview) SetConfigurations(v map[string]*Configuration) *AccessPreview {
	s.Configurations = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessPreview) SetCreatedAt(v time.Time) *AccessPreview {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *AccessPreview) SetId(v string) *AccessPreview {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPreview) SetStatus(v string) *AccessPreview {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AccessPreview) SetStatusReason(v *AccessPreviewStatusReason) *AccessPreview {
	s.StatusReason = v
	return s
}

// An access preview finding generated by the access preview.
type AccessPreviewFinding struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to perform.
	Action []*string `locationName:"action" type:"list"`

	// Provides context on how the access preview finding compares to existing access
	// identified in IAM Access Analyzer.
	//
	//    * New - The finding is for newly-introduced access.
	//
	//    * Unchanged - The preview finding is an existing finding that would remain
	//    unchanged.
	//
	//    * Changed - The preview finding is an existing finding with a change in
	//    status.
	//
	// For example, a Changed finding with preview status Resolved and existing
	// status Active indicates the existing Active finding would become Resolved
	// as a result of the proposed permissions change.
	//
	// ChangeType is a required field
	ChangeType *string `locationName:"changeType" type:"string" required:"true" enum:"FindingChangeType"`

	// The condition in the analyzed policy statement that resulted in a finding.
	Condition map[string]*string `locationName:"condition" type:"map"`

	// The time at which the access preview finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error.
	Error *string `locationName:"error" type:"string"`

	// The existing ID of the finding in IAM Access Analyzer, provided only for
	// existing findings.
	ExistingFindingId *string `locationName:"existingFindingId" type:"string"`

	// The existing status of the finding, provided only for existing findings.
	ExistingFindingStatus *string `locationName:"existingFindingStatus" type:"string" enum:"FindingStatus"`

	// The ID of the access preview finding. This ID uniquely identifies the element
	// in the list of access preview findings and is not related to the finding
	// ID in Access Analyzer.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the policy that generated the finding allows public access
	// to the resource.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]*string `locationName:"principal" type:"map"`

	// The resource that an external principal has access to. This is the resource
	// associated with the access preview.
	Resource *string `locationName:"resource" type:"string"`

	// The Amazon Web Services account ID that owns the resource. For most Amazon
	// Web Services resources, the owning account is the account in which the resource
	// was created.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that can be accessed in the finding.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []*FindingSource `locationName:"sources" type:"list"`

	// The preview status of the finding. This is what the status of the finding
	// would be after permissions deployment. For example, a Changed finding with
	// preview status Resolved and existing status Active indicates the existing
	// Active finding would become Resolved as a result of the proposed permissions
	// change.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreviewFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreviewFinding) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AccessPreviewFinding) SetAction(v []*string) *AccessPreviewFinding {
	s.Action = v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *AccessPreviewFinding) SetChangeType(v string) *AccessPreviewFinding {
	s.ChangeType = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *AccessPreviewFinding) SetCondition(v map[string]*string) *AccessPreviewFinding {
	s.Condition = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessPreviewFinding) SetCreatedAt(v time.Time) *AccessPreviewFinding {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *AccessPreviewFinding) SetError(v string) *AccessPreviewFinding {
	s.Error = &v
	return s
}

// SetExistingFindingId sets the ExistingFindingId field's value.
func (s *AccessPreviewFinding) SetExistingFindingId(v string) *AccessPreviewFinding {
	s.ExistingFindingId = &v
	return s
}

// SetExistingFindingStatus sets the ExistingFindingStatus field's value.
func (s *AccessPreviewFinding) SetExistingFindingStatus(v string) *AccessPreviewFinding {
	s.ExistingFindingStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *AccessPreviewFinding) SetId(v string) *AccessPreviewFinding {
	s.Id = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *AccessPreviewFinding) SetIsPublic(v bool) *AccessPreviewFinding {
	s.IsPublic = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AccessPreviewFinding) SetPrincipal(v map[string]*string) *AccessPreviewFinding {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *AccessPreviewFinding) SetResource(v string) *AccessPreviewFinding {
	s.Resource = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *AccessPreviewFinding) SetResourceOwnerAccount(v string) *AccessPreviewFinding {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AccessPreviewFinding) SetResourceType(v string) *AccessPreviewFinding {
	s.ResourceType = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AccessPreviewFinding) SetSources(v []*FindingSource) *AccessPreviewFinding {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPreviewFinding) SetStatus(v string) *AccessPreviewFinding {
	s.Status = &v
	return s
}

// Provides more details about the current status of the access preview. For
// example, if the creation of the access preview fails, a Failed status is
// returned. This failure can be due to an internal issue with the analysis
// or due to an invalid proposed resource configuration.
type AccessPreviewStatusReason struct {
	_ struct{} `type:"structure"`

	// The reason code for the current status of the access preview.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"AccessPreviewStatusReasonCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreviewStatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreviewStatusReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AccessPreviewStatusReason) SetCode(v string) *AccessPreviewStatusReason {
	s.Code = &v
	return s
}

// Contains a summary of information about an access preview.
type AccessPreviewSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer used to generate the access preview.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// The time at which the access preview was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID for the access preview.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The status of the access preview.
	//
	//    * Creating - The access preview creation is in progress.
	//
	//    * Completed - The access preview is complete and previews the findings
	//    for external access to the resource.
	//
	//    * Failed - The access preview creation has failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AccessPreviewStatus"`

	// Provides more details about the current status of the access preview. For
	// example, if the creation of the access preview fails, a Failed status is
	// returned. This failure can be due to an internal issue with the analysis
	// or due to an invalid proposed resource configuration.
	StatusReason *AccessPreviewStatusReason `locationName:"statusReason" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPreviewSummary) GoString() string {
	return s.String()
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *AccessPreviewSummary) SetAnalyzerArn(v string) *AccessPreviewSummary {
	s.AnalyzerArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessPreviewSummary) SetCreatedAt(v time.Time) *AccessPreviewSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *AccessPreviewSummary) SetId(v string) *AccessPreviewSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPreviewSummary) SetStatus(v string) *AccessPreviewSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AccessPreviewSummary) SetStatusReason(v *AccessPreviewStatusReason) *AccessPreviewSummary {
	s.StatusReason = v
	return s
}

// You specify each grantee as a type-value pair using one of these types. You
// can specify only one type of grantee. For more information, see PutBucketAcl
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html).
type AclGrantee struct {
	_ struct{} `type:"structure"`

	// The value specified is the canonical user ID of an Amazon Web Services account.
	Id *string `locationName:"id" type:"string"`

	// Used for granting permissions to a predefined group.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AclGrantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AclGrantee) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AclGrantee) SetId(v string) *AclGrantee {
	s.Id = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *AclGrantee) SetUri(v string) *AclGrantee {
	s.Uri = &v
	return s
}

// Contains details about the analyzed resource.
type AnalyzedResource struct {
	_ struct{} `type:"structure"`

	// The actions that an external principal is granted permission to use by the
	// policy that generated the finding.
	Actions []*string `locationName:"actions" type:"list"`

	// The time at which the resource was analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time at which the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error message.
	Error *string `locationName:"error" type:"string"`

	// Indicates whether the policy that generated the finding grants public access
	// to the resource.
	//
	// IsPublic is a required field
	IsPublic *bool `locationName:"isPublic" type:"boolean" required:"true"`

	// The ARN of the resource that was analyzed.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The Amazon Web Services account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that was analyzed.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// Indicates how the access that generated the finding is granted. This is populated
	// for Amazon S3 bucket findings.
	SharedVia []*string `locationName:"sharedVia" type:"list"`

	// The current status of the finding generated from the analyzed resource.
	Status *string `locationName:"status" type:"string" enum:"FindingStatus"`

	// The time at which the finding was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzedResource) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *AnalyzedResource) SetActions(v []*string) *AnalyzedResource {
	s.Actions = v
	return s
}

// SetAnalyzedAt sets the AnalyzedAt field's value.
func (s *AnalyzedResource) SetAnalyzedAt(v time.Time) *AnalyzedResource {
	s.AnalyzedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AnalyzedResource) SetCreatedAt(v time.Time) *AnalyzedResource {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *AnalyzedResource) SetError(v string) *AnalyzedResource {
	s.Error = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *AnalyzedResource) SetIsPublic(v bool) *AnalyzedResource {
	s.IsPublic = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AnalyzedResource) SetResourceArn(v string) *AnalyzedResource {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *AnalyzedResource) SetResourceOwnerAccount(v string) *AnalyzedResource {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AnalyzedResource) SetResourceType(v string) *AnalyzedResource {
	s.ResourceType = &v
	return s
}

// SetSharedVia sets the SharedVia field's value.
func (s *AnalyzedResource) SetSharedVia(v []*string) *AnalyzedResource {
	s.SharedVia = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalyzedResource) SetStatus(v string) *AnalyzedResource {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AnalyzedResource) SetUpdatedAt(v time.Time) *AnalyzedResource {
	s.UpdatedAt = &v
	return s
}

// Contains the ARN of the analyzed resource.
type AnalyzedResourceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzed resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The Amazon Web Services account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of resource that was analyzed.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzedResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzedResourceSummary) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AnalyzedResourceSummary) SetResourceArn(v string) *AnalyzedResourceSummary {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *AnalyzedResourceSummary) SetResourceOwnerAccount(v string) *AnalyzedResourceSummary {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AnalyzedResourceSummary) SetResourceType(v string) *AnalyzedResourceSummary {
	s.ResourceType = &v
	return s
}

// Contains information about the analyzer.
type AnalyzerSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A timestamp for the time at which the analyzer was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The resource that was most recently analyzed by the analyzer.
	LastResourceAnalyzed *string `locationName:"lastResourceAnalyzed" type:"string"`

	// The time at which the most recently analyzed resource was analyzed.
	LastResourceAnalyzedAt *time.Time `locationName:"lastResourceAnalyzedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the analyzer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the analyzer. An Active analyzer successfully monitors supported
	// resources and generates new findings. The analyzer is Disabled when a user
	// action, such as removing trusted access for Identity and Access Management
	// Access Analyzer from Organizations, causes the analyzer to stop generating
	// new findings. The status is Creating when the analyzer creation is in progress
	// and Failed when the analyzer creation has failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AnalyzerStatus"`

	// The statusReason provides more details about the current status of the analyzer.
	// For example, if the creation for the analyzer fails, a Failed status is returned.
	// For an analyzer with organization as the type, this failure can be due to
	// an issue with creating the service-linked roles required in the member accounts
	// of the Amazon Web Services organization.
	StatusReason *StatusReason `locationName:"statusReason" type:"structure"`

	// The tags added to the analyzer.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of analyzer, which corresponds to the zone of trust chosen for the
	// analyzer.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzerSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AnalyzerSummary) SetArn(v string) *AnalyzerSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AnalyzerSummary) SetCreatedAt(v time.Time) *AnalyzerSummary {
	s.CreatedAt = &v
	return s
}

// SetLastResourceAnalyzed sets the LastResourceAnalyzed field's value.
func (s *AnalyzerSummary) SetLastResourceAnalyzed(v string) *AnalyzerSummary {
	s.LastResourceAnalyzed = &v
	return s
}

// SetLastResourceAnalyzedAt sets the LastResourceAnalyzedAt field's value.
func (s *AnalyzerSummary) SetLastResourceAnalyzedAt(v time.Time) *AnalyzerSummary {
	s.LastResourceAnalyzedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalyzerSummary) SetName(v string) *AnalyzerSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalyzerSummary) SetStatus(v string) *AnalyzerSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AnalyzerSummary) SetStatusReason(v *StatusReason) *AnalyzerSummary {
	s.StatusReason = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AnalyzerSummary) SetTags(v map[string]*string) *AnalyzerSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *AnalyzerSummary) SetType(v string) *AnalyzerSummary {
	s.Type = &v
	return s
}

// Retroactively applies an archive rule.
type ApplyArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the analyzer.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the rule to apply.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyArchiveRuleInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ApplyArchiveRuleInput) SetAnalyzerArn(v string) *ApplyArchiveRuleInput {
	s.AnalyzerArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ApplyArchiveRuleInput) SetClientToken(v string) *ApplyArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *ApplyArchiveRuleInput) SetRuleName(v string) *ApplyArchiveRuleInput {
	s.RuleName = &v
	return s
}

type ApplyArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyArchiveRuleOutput) GoString() string {
	return s.String()
}

// Contains information about an archive rule.
type ArchiveRuleSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the archive rule was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A filter used to define the archive rule.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the archive rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The time at which the archive rule was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveRuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveRuleSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ArchiveRuleSummary) SetCreatedAt(v time.Time) *ArchiveRuleSummary {
	s.CreatedAt = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ArchiveRuleSummary) SetFilter(v map[string]*Criterion) *ArchiveRuleSummary {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *ArchiveRuleSummary) SetRuleName(v string) *ArchiveRuleSummary {
	s.RuleName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ArchiveRuleSummary) SetUpdatedAt(v time.Time) *ArchiveRuleSummary {
	s.UpdatedAt = &v
	return s
}

type CancelPolicyGenerationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or
	// used with CancelPolicyGeneration to cancel the policy generation request.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelPolicyGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelPolicyGenerationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelPolicyGenerationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelPolicyGenerationInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelPolicyGenerationInput) SetJobId(v string) *CancelPolicyGenerationInput {
	s.JobId = &v
	return s
}

type CancelPolicyGenerationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelPolicyGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelPolicyGenerationOutput) GoString() string {
	return s.String()
}

// Contains information about CloudTrail access.
type CloudTrailDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the service role that IAM Access Analyzer uses to access your
	// CloudTrail trail and service last accessed information.
	//
	// AccessRole is a required field
	AccessRole *string `locationName:"accessRole" type:"string" required:"true"`

	// The end of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp after this time are not considered to generate
	// a policy. If this is not included in the request, the default value is the
	// current time.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// The start of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp before this time are not considered to generate
	// a policy.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A Trail object that contains settings for a trail.
	//
	// Trails is a required field
	Trails []*Trail `locationName:"trails" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudTrailDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudTrailDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudTrailDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudTrailDetails"}
	if s.AccessRole == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessRole"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Trails == nil {
		invalidParams.Add(request.NewErrParamRequired("Trails"))
	}
	if s.Trails != nil {
		for i, v := range s.Trails {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Trails", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessRole sets the AccessRole field's value.
func (s *CloudTrailDetails) SetAccessRole(v string) *CloudTrailDetails {
	s.AccessRole = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CloudTrailDetails) SetEndTime(v time.Time) *CloudTrailDetails {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CloudTrailDetails) SetStartTime(v time.Time) *CloudTrailDetails {
	s.StartTime = &v
	return s
}

// SetTrails sets the Trails field's value.
func (s *CloudTrailDetails) SetTrails(v []*Trail) *CloudTrailDetails {
	s.Trails = v
	return s
}

// Contains information about CloudTrail access.
type CloudTrailProperties struct {
	_ struct{} `type:"structure"`

	// The end of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp after this time are not considered to generate
	// a policy. If this is not included in the request, the default value is the
	// current time.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The start of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp before this time are not considered to generate
	// a policy.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A TrailProperties object that contains settings for trail properties.
	//
	// TrailProperties is a required field
	TrailProperties []*TrailProperties `locationName:"trailProperties" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudTrailProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudTrailProperties) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *CloudTrailProperties) SetEndTime(v time.Time) *CloudTrailProperties {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CloudTrailProperties) SetStartTime(v time.Time) *CloudTrailProperties {
	s.StartTime = &v
	return s
}

// SetTrailProperties sets the TrailProperties field's value.
func (s *CloudTrailProperties) SetTrailProperties(v []*TrailProperties) *CloudTrailProperties {
	s.TrailProperties = v
	return s
}

// Access control configuration structures for your resource. You specify the
// configuration as a type-value pair. You can specify only one type of access
// control configuration.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The access control configuration is for an IAM role.
	IamRole *IamRoleConfiguration `locationName:"iamRole" type:"structure"`

	// The access control configuration is for a KMS key.
	KmsKey *KmsKeyConfiguration `locationName:"kmsKey" type:"structure"`

	// The access control configuration is for an Amazon S3 Bucket.
	S3Bucket *S3BucketConfiguration `locationName:"s3Bucket" type:"structure"`

	// The access control configuration is for a Secrets Manager secret.
	SecretsManagerSecret *SecretsManagerSecretConfiguration `locationName:"secretsManagerSecret" type:"structure"`

	// The access control configuration is for an Amazon SQS queue.
	SqsQueue *SqsQueueConfiguration `locationName:"sqsQueue" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Configuration"}
	if s.KmsKey != nil {
		if err := s.KmsKey.Validate(); err != nil {
			invalidParams.AddNested("KmsKey", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Bucket != nil {
		if err := s.S3Bucket.Validate(); err != nil {
			invalidParams.AddNested("S3Bucket", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamRole sets the IamRole field's value.
func (s *Configuration) SetIamRole(v *IamRoleConfiguration) *Configuration {
	s.IamRole = v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *Configuration) SetKmsKey(v *KmsKeyConfiguration) *Configuration {
	s.KmsKey = v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *Configuration) SetS3Bucket(v *S3BucketConfiguration) *Configuration {
	s.S3Bucket = v
	return s
}

// SetSecretsManagerSecret sets the SecretsManagerSecret field's value.
func (s *Configuration) SetSecretsManagerSecret(v *SecretsManagerSecretConfiguration) *Configuration {
	s.SecretsManagerSecret = v
	return s
}

// SetSqsQueue sets the SqsQueue field's value.
func (s *Configuration) SetSqsQueue(v *SqsQueueConfiguration) *Configuration {
	s.SqsQueue = v
	return s
}

// A conflict exception error.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccessPreviewInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the account analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// used to generate the access preview. You can only create an access preview
	// for analyzers with an Account type and Active status.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Access control configuration for your resource that is used to generate the
	// access preview. The access preview includes findings for external access
	// allowed to the resource with the proposed access control configuration. The
	// configuration must contain exactly one element.
	//
	// Configurations is a required field
	Configurations map[string]*Configuration `locationName:"configurations" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPreviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPreviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPreviewInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Configurations == nil {
		invalidParams.Add(request.NewErrParamRequired("Configurations"))
	}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *CreateAccessPreviewInput) SetAnalyzerArn(v string) *CreateAccessPreviewInput {
	s.AnalyzerArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessPreviewInput) SetClientToken(v string) *CreateAccessPreviewInput {
	s.ClientToken = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *CreateAccessPreviewInput) SetConfigurations(v map[string]*Configuration) *CreateAccessPreviewInput {
	s.Configurations = v
	return s
}

type CreateAccessPreviewOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID for the access preview.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPreviewOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateAccessPreviewOutput) SetId(v string) *CreateAccessPreviewOutput {
	s.Id = &v
	return s
}

// Creates an analyzer.
type CreateAnalyzerInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to create.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// Specifies the archive rules to add for the analyzer. Archive rules automatically
	// archive findings that meet the criteria you define for the rule.
	ArchiveRules []*InlineArchiveRule `locationName:"archiveRules" type:"list"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The tags to apply to the analyzer.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are
	// supported. You can create only one analyzer per account per Region. You can
	// create up to 5 analyzers per organization per Region.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalyzerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnalyzerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnalyzerInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ArchiveRules != nil {
		for i, v := range s.ArchiveRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ArchiveRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *CreateAnalyzerInput) SetAnalyzerName(v string) *CreateAnalyzerInput {
	s.AnalyzerName = &v
	return s
}

// SetArchiveRules sets the ArchiveRules field's value.
func (s *CreateAnalyzerInput) SetArchiveRules(v []*InlineArchiveRule) *CreateAnalyzerInput {
	s.ArchiveRules = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAnalyzerInput) SetClientToken(v string) *CreateAnalyzerInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnalyzerInput) SetTags(v map[string]*string) *CreateAnalyzerInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAnalyzerInput) SetType(v string) *CreateAnalyzerInput {
	s.Type = &v
	return s
}

// The response to the request to create an analyzer.
type CreateAnalyzerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer that was created by the request.
	Arn *string `locationName:"arn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalyzerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateAnalyzerOutput) SetArn(v string) *CreateAnalyzerOutput {
	s.Arn = &v
	return s
}

// Creates an archive rule.
type CreateArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the created analyzer.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The criteria for the rule.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule to create.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *CreateArchiveRuleInput) SetAnalyzerName(v string) *CreateArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateArchiveRuleInput) SetClientToken(v string) *CreateArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *CreateArchiveRuleInput) SetFilter(v map[string]*Criterion) *CreateArchiveRuleInput {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *CreateArchiveRuleInput) SetRuleName(v string) *CreateArchiveRuleInput {
	s.RuleName = &v
	return s
}

type CreateArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveRuleOutput) GoString() string {
	return s.String()
}

// The criteria to use in the filter that defines the archive rule.
type Criterion struct {
	_ struct{} `type:"structure"`

	// A "contains" operator to match for the filter used to create the rule.
	Contains []*string `locationName:"contains" min:"1" type:"list"`

	// An "equals" operator to match for the filter used to create the rule.
	Eq []*string `locationName:"eq" min:"1" type:"list"`

	// An "exists" operator to match for the filter used to create the rule.
	Exists *bool `locationName:"exists" type:"boolean"`

	// A "not equals" operator to match for the filter used to create the rule.
	Neq []*string `locationName:"neq" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Criterion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Criterion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Criterion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Criterion"}
	if s.Contains != nil && len(s.Contains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Contains", 1))
	}
	if s.Eq != nil && len(s.Eq) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Eq", 1))
	}
	if s.Neq != nil && len(s.Neq) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Neq", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContains sets the Contains field's value.
func (s *Criterion) SetContains(v []*string) *Criterion {
	s.Contains = v
	return s
}

// SetEq sets the Eq field's value.
func (s *Criterion) SetEq(v []*string) *Criterion {
	s.Eq = v
	return s
}

// SetExists sets the Exists field's value.
func (s *Criterion) SetExists(v bool) *Criterion {
	s.Exists = &v
	return s
}

// SetNeq sets the Neq field's value.
func (s *Criterion) SetNeq(v []*string) *Criterion {
	s.Neq = v
	return s
}

// Deletes an analyzer.
type DeleteAnalyzerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the analyzer to delete.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalyzerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnalyzerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnalyzerInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *DeleteAnalyzerInput) SetAnalyzerName(v string) *DeleteAnalyzerInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAnalyzerInput) SetClientToken(v string) *DeleteAnalyzerInput {
	s.ClientToken = &v
	return s
}

type DeleteAnalyzerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalyzerOutput) GoString() string {
	return s.String()
}

// Deletes an archive rule.
type DeleteArchiveRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the analyzer that associated with the archive rule to delete.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the rule to delete.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *DeleteArchiveRuleInput) SetAnalyzerName(v string) *DeleteArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteArchiveRuleInput) SetClientToken(v string) *DeleteArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteArchiveRuleInput) SetRuleName(v string) *DeleteArchiveRuleInput {
	s.RuleName = &v
	return s
}

type DeleteArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveRuleOutput) GoString() string {
	return s.String()
}

// Contains information about a finding.
type Finding struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []*string `locationName:"action" type:"list"`

	// The time at which the resource was analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// Condition is a required field
	Condition map[string]*string `locationName:"condition" type:"map" required:"true"`

	// The time at which the finding was generated.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error.
	Error *string `locationName:"error" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the policy that generated the finding allows public access
	// to the resource.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that access to a resource within the zone of trust.
	Principal map[string]*string `locationName:"principal" type:"map"`

	// The resource that an external principal has access to.
	Resource *string `locationName:"resource" type:"string"`

	// The Amazon Web Services account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource identified in the finding.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []*FindingSource `locationName:"sources" type:"list"`

	// The current status of the finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatus"`

	// The time at which the finding was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Finding) SetAction(v []*string) *Finding {
	s.Action = v
	return s
}

// SetAnalyzedAt sets the AnalyzedAt field's value.
func (s *Finding) SetAnalyzedAt(v time.Time) *Finding {
	s.AnalyzedAt = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *Finding) SetCondition(v map[string]*string) *Finding {
	s.Condition = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v time.Time) *Finding {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *Finding) SetError(v string) *Finding {
	s.Error = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *Finding) SetIsPublic(v bool) *Finding {
	s.IsPublic = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *Finding) SetPrincipal(v map[string]*string) *Finding {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *Finding) SetResource(v string) *Finding {
	s.Resource = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *Finding) SetResourceOwnerAccount(v string) *Finding {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Finding) SetResourceType(v string) *Finding {
	s.ResourceType = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *Finding) SetSources(v []*FindingSource) *Finding {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Finding) SetStatus(v string) *Finding {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v time.Time) *Finding {
	s.UpdatedAt = &v
	return s
}

// The source of the finding. This indicates how the access that generated the
// finding is granted. It is populated for Amazon S3 bucket findings.
type FindingSource struct {
	_ struct{} `type:"structure"`

	// Includes details about how the access that generated the finding is granted.
	// This is populated for Amazon S3 bucket findings.
	Detail *FindingSourceDetail `locationName:"detail" type:"structure"`

	// Indicates the type of access that generated the finding.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FindingSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSource) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *FindingSource) SetDetail(v *FindingSourceDetail) *FindingSource {
	s.Detail = v
	return s
}

// SetType sets the Type field's value.
func (s *FindingSource) SetType(v string) *FindingSource {
	s.Type = &v
	return s
}

// Includes details about how the access that generated the finding is granted.
// This is populated for Amazon S3 bucket findings.
type FindingSourceDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point that generated the finding. The ARN format depends
	// on whether the ARN represents an access point or a multi-region access point.
	AccessPointArn *string `locationName:"accessPointArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSourceDetail) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *FindingSourceDetail) SetAccessPointArn(v string) *FindingSourceDetail {
	s.AccessPointArn = &v
	return s
}

// Contains information about a finding.
type FindingSummary struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []*string `locationName:"action" type:"list"`

	// The time at which the resource-based policy that generated the finding was
	// analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// Condition is a required field
	Condition map[string]*string `locationName:"condition" type:"map" required:"true"`

	// The time at which the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The error that resulted in an Error finding.
	Error *string `locationName:"error" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the finding reports a resource that has a policy that allows
	// public access.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]*string `locationName:"principal" type:"map"`

	// The resource that the external principal has access to.
	Resource *string `locationName:"resource" type:"string"`

	// The Amazon Web Services account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that the external principal has access to.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []*FindingSource `locationName:"sources" type:"list"`

	// The status of the finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatus"`

	// The time at which the finding was most recently updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSummary) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *FindingSummary) SetAction(v []*string) *FindingSummary {
	s.Action = v
	return s
}

// SetAnalyzedAt sets the AnalyzedAt field's value.
func (s *FindingSummary) SetAnalyzedAt(v time.Time) *FindingSummary {
	s.AnalyzedAt = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *FindingSummary) SetCondition(v map[string]*string) *FindingSummary {
	s.Condition = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FindingSummary) SetCreatedAt(v time.Time) *FindingSummary {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *FindingSummary) SetError(v string) *FindingSummary {
	s.Error = &v
	return s
}

// SetId sets the Id field's value.
func (s *FindingSummary) SetId(v string) *FindingSummary {
	s.Id = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *FindingSummary) SetIsPublic(v bool) *FindingSummary {
	s.IsPublic = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *FindingSummary) SetPrincipal(v map[string]*string) *FindingSummary {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *FindingSummary) SetResource(v string) *FindingSummary {
	s.Resource = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *FindingSummary) SetResourceOwnerAccount(v string) *FindingSummary {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *FindingSummary) SetResourceType(v string) *FindingSummary {
	s.ResourceType = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *FindingSummary) SetSources(v []*FindingSource) *FindingSummary {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FindingSummary) SetStatus(v string) *FindingSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FindingSummary) SetUpdatedAt(v time.Time) *FindingSummary {
	s.UpdatedAt = &v
	return s
}

// Contains the text for the generated policy.
type GeneratedPolicy struct {
	_ struct{} `type:"structure"`

	// The text to use as the content for the new policy. The policy is created
	// using the CreatePolicy (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html)
	// action.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedPolicy) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GeneratedPolicy) SetPolicy(v string) *GeneratedPolicy {
	s.Policy = &v
	return s
}

// Contains the generated policy details.
type GeneratedPolicyProperties struct {
	_ struct{} `type:"structure"`

	// Lists details about the Trail used to generated policy.
	CloudTrailProperties *CloudTrailProperties `locationName:"cloudTrailProperties" type:"structure"`

	// This value is set to true if the generated policy contains all possible actions
	// for a service that IAM Access Analyzer identified from the CloudTrail trail
	// that you specified, and false otherwise.
	IsComplete *bool `locationName:"isComplete" type:"boolean"`

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedPolicyProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedPolicyProperties) GoString() string {
	return s.String()
}

// SetCloudTrailProperties sets the CloudTrailProperties field's value.
func (s *GeneratedPolicyProperties) SetCloudTrailProperties(v *CloudTrailProperties) *GeneratedPolicyProperties {
	s.CloudTrailProperties = v
	return s
}

// SetIsComplete sets the IsComplete field's value.
func (s *GeneratedPolicyProperties) SetIsComplete(v bool) *GeneratedPolicyProperties {
	s.IsComplete = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *GeneratedPolicyProperties) SetPrincipalArn(v string) *GeneratedPolicyProperties {
	s.PrincipalArn = &v
	return s
}

// Contains the text for the generated policy and its details.
type GeneratedPolicyResult struct {
	_ struct{} `type:"structure"`

	// The text to use as the content for the new policy. The policy is created
	// using the CreatePolicy (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html)
	// action.
	GeneratedPolicies []*GeneratedPolicy `locationName:"generatedPolicies" type:"list"`

	// A GeneratedPolicyProperties object that contains properties of the generated
	// policy.
	//
	// Properties is a required field
	Properties *GeneratedPolicyProperties `locationName:"properties" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedPolicyResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedPolicyResult) GoString() string {
	return s.String()
}

// SetGeneratedPolicies sets the GeneratedPolicies field's value.
func (s *GeneratedPolicyResult) SetGeneratedPolicies(v []*GeneratedPolicy) *GeneratedPolicyResult {
	s.GeneratedPolicies = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *GeneratedPolicyResult) SetProperties(v *GeneratedPolicyProperties) *GeneratedPolicyResult {
	s.Properties = v
	return s
}

type GetAccessPreviewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the access preview.
	//
	// AccessPreviewId is a required field
	AccessPreviewId *string `location:"uri" locationName:"accessPreviewId" type:"string" required:"true"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// used to generate the access preview.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPreviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPreviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPreviewInput"}
	if s.AccessPreviewId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPreviewId"))
	}
	if s.AccessPreviewId != nil && len(*s.AccessPreviewId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPreviewId", 1))
	}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPreviewId sets the AccessPreviewId field's value.
func (s *GetAccessPreviewInput) SetAccessPreviewId(v string) *GetAccessPreviewInput {
	s.AccessPreviewId = &v
	return s
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *GetAccessPreviewInput) SetAnalyzerArn(v string) *GetAccessPreviewInput {
	s.AnalyzerArn = &v
	return s
}

type GetAccessPreviewOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the access preview.
	//
	// AccessPreview is a required field
	AccessPreview *AccessPreview `locationName:"accessPreview" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPreviewOutput) GoString() string {
	return s.String()
}

// SetAccessPreview sets the AccessPreview field's value.
func (s *GetAccessPreviewOutput) SetAccessPreview(v *AccessPreview) *GetAccessPreviewOutput {
	s.AccessPreview = v
	return s
}

// Retrieves an analyzed resource.
type GetAnalyzedResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// to retrieve information from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The ARN of the resource to retrieve information about.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalyzedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnalyzedResourceInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *GetAnalyzedResourceInput) SetAnalyzerArn(v string) *GetAnalyzedResourceInput {
	s.AnalyzerArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetAnalyzedResourceInput) SetResourceArn(v string) *GetAnalyzedResourceInput {
	s.ResourceArn = &v
	return s
}

// The response to the request.
type GetAnalyzedResourceOutput struct {
	_ struct{} `type:"structure"`

	// An AnalyzedResource object that contains information that IAM Access Analyzer
	// found when it analyzed the resource.
	Resource *AnalyzedResource `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzedResourceOutput) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *GetAnalyzedResourceOutput) SetResource(v *AnalyzedResource) *GetAnalyzedResourceOutput {
	s.Resource = v
	return s
}

// Retrieves an analyzer.
type GetAnalyzerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the analyzer retrieved.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalyzerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnalyzerInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *GetAnalyzerInput) SetAnalyzerName(v string) *GetAnalyzerInput {
	s.AnalyzerName = &v
	return s
}

// The response to the request.
type GetAnalyzerOutput struct {
	_ struct{} `type:"structure"`

	// An AnalyzerSummary object that contains information about the analyzer.
	//
	// Analyzer is a required field
	Analyzer *AnalyzerSummary `locationName:"analyzer" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalyzerOutput) GoString() string {
	return s.String()
}

// SetAnalyzer sets the Analyzer field's value.
func (s *GetAnalyzerOutput) SetAnalyzer(v *AnalyzerSummary) *GetAnalyzerOutput {
	s.Analyzer = v
	return s
}

// Retrieves an archive rule.
type GetArchiveRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the analyzer to retrieve rules from.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// The name of the rule to retrieve.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *GetArchiveRuleInput) SetAnalyzerName(v string) *GetArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *GetArchiveRuleInput) SetRuleName(v string) *GetArchiveRuleInput {
	s.RuleName = &v
	return s
}

// The response to the request.
type GetArchiveRuleOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an archive rule.
	//
	// ArchiveRule is a required field
	ArchiveRule *ArchiveRuleSummary `locationName:"archiveRule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveRuleOutput) GoString() string {
	return s.String()
}

// SetArchiveRule sets the ArchiveRule field's value.
func (s *GetArchiveRuleOutput) SetArchiveRule(v *ArchiveRuleSummary) *GetArchiveRuleOutput {
	s.ArchiveRule = v
	return s
}

// Retrieves a finding.
type GetFindingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// that generated the finding.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The ID of the finding to retrieve.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *GetFindingInput) SetAnalyzerArn(v string) *GetFindingInput {
	s.AnalyzerArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFindingInput) SetId(v string) *GetFindingInput {
	s.Id = &v
	return s
}

// The response to the request.
type GetFindingOutput struct {
	_ struct{} `type:"structure"`

	// A finding object that contains finding details.
	Finding *Finding `locationName:"finding" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingOutput) GoString() string {
	return s.String()
}

// SetFinding sets the Finding field's value.
func (s *GetFindingOutput) SetFinding(v *Finding) *GetFindingOutput {
	s.Finding = v
	return s
}

type GetGeneratedPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The level of detail that you want to generate. You can specify whether to
	// generate policies with placeholders for resource ARNs for actions that support
	// resource level granularity in policies.
	//
	// For example, in the resource section of a policy, you can receive a placeholder
	// such as "Resource":"arn:aws:s3:::${BucketName}" instead of "*".
	IncludeResourcePlaceholders *bool `location:"querystring" locationName:"includeResourcePlaceholders" type:"boolean"`

	// The level of detail that you want to generate. You can specify whether to
	// generate service-level policies.
	//
	// IAM Access Analyzer uses iam:servicelastaccessed to identify services that
	// have been used recently to create this service-level template.
	IncludeServiceLevelTemplate *bool `location:"querystring" locationName:"includeServiceLevelTemplate" type:"boolean"`

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or
	// used with CancelPolicyGeneration to cancel the policy generation request.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeneratedPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeneratedPolicyInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeResourcePlaceholders sets the IncludeResourcePlaceholders field's value.
func (s *GetGeneratedPolicyInput) SetIncludeResourcePlaceholders(v bool) *GetGeneratedPolicyInput {
	s.IncludeResourcePlaceholders = &v
	return s
}

// SetIncludeServiceLevelTemplate sets the IncludeServiceLevelTemplate field's value.
func (s *GetGeneratedPolicyInput) SetIncludeServiceLevelTemplate(v bool) *GetGeneratedPolicyInput {
	s.IncludeServiceLevelTemplate = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetGeneratedPolicyInput) SetJobId(v string) *GetGeneratedPolicyInput {
	s.JobId = &v
	return s
}

type GetGeneratedPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A GeneratedPolicyResult object that contains the generated policies and associated
	// details.
	//
	// GeneratedPolicyResult is a required field
	GeneratedPolicyResult *GeneratedPolicyResult `locationName:"generatedPolicyResult" type:"structure" required:"true"`

	// A GeneratedPolicyDetails object that contains details about the generated
	// policy.
	//
	// JobDetails is a required field
	JobDetails *JobDetails `locationName:"jobDetails" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedPolicyOutput) GoString() string {
	return s.String()
}

// SetGeneratedPolicyResult sets the GeneratedPolicyResult field's value.
func (s *GetGeneratedPolicyOutput) SetGeneratedPolicyResult(v *GeneratedPolicyResult) *GetGeneratedPolicyOutput {
	s.GeneratedPolicyResult = v
	return s
}

// SetJobDetails sets the JobDetails field's value.
func (s *GetGeneratedPolicyOutput) SetJobDetails(v *JobDetails) *GetGeneratedPolicyOutput {
	s.JobDetails = v
	return s
}

// The proposed access control configuration for an IAM role. You can propose
// a configuration for a new IAM role or an existing IAM role that you own by
// specifying the trust policy. If the configuration is for a new IAM role,
// you must specify the trust policy. If the configuration is for an existing
// IAM role that you own and you do not propose the trust policy, the access
// preview uses the existing trust policy for the role. The proposed trust policy
// cannot be an empty string. For more information about role trust policy limits,
// see IAM and STS quotas (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html).
type IamRoleConfiguration struct {
	_ struct{} `type:"structure"`

	// The proposed trust policy for the IAM role.
	TrustPolicy *string `locationName:"trustPolicy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IamRoleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IamRoleConfiguration) GoString() string {
	return s.String()
}

// SetTrustPolicy sets the TrustPolicy field's value.
func (s *IamRoleConfiguration) SetTrustPolicy(v string) *IamRoleConfiguration {
	s.TrustPolicy = &v
	return s
}

// An criterion statement in an archive rule. Each archive rule may have multiple
// criteria.
type InlineArchiveRule struct {
	_ struct{} `type:"structure"`

	// The condition and values for a criterion.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InlineArchiveRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InlineArchiveRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InlineArchiveRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InlineArchiveRule"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *InlineArchiveRule) SetFilter(v map[string]*Criterion) *InlineArchiveRule {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *InlineArchiveRule) SetRuleName(v string) *InlineArchiveRule {
	s.RuleName = &v
	return s
}

// Internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The seconds to wait to retry.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This configuration sets the network origin for the Amazon S3 access point
// or multi-region access point to Internet.
type InternetConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternetConfiguration) GoString() string {
	return s.String()
}

// Contains details about the policy generation request.
type JobDetails struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the job was completed.
	CompletedOn *time.Time `locationName:"completedOn" type:"timestamp" timestampFormat:"iso8601"`

	// The job error for the policy generation request.
	JobError *JobError `locationName:"jobError" type:"structure"`

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or
	// used with CancelPolicyGeneration to cancel the policy generation request.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A timestamp of when the job was started.
	//
	// StartedOn is a required field
	StartedOn *time.Time `locationName:"startedOn" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The status of the job request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetails) GoString() string {
	return s.String()
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *JobDetails) SetCompletedOn(v time.Time) *JobDetails {
	s.CompletedOn = &v
	return s
}

// SetJobError sets the JobError field's value.
func (s *JobDetails) SetJobError(v *JobError) *JobDetails {
	s.JobError = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDetails) SetJobId(v string) *JobDetails {
	s.JobId = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *JobDetails) SetStartedOn(v time.Time) *JobDetails {
	s.StartedOn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDetails) SetStatus(v string) *JobDetails {
	s.Status = &v
	return s
}

// Contains the details about the policy generation error.
type JobError struct {
	_ struct{} `type:"structure"`

	// The job error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"JobErrorCode"`

	// Specific information about the error. For example, which service quota was
	// exceeded or which resource was not found.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *JobError) SetCode(v string) *JobError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *JobError) SetMessage(v string) *JobError {
	s.Message = &v
	return s
}

// A proposed grant configuration for a KMS key. For more information, see CreateGrant
// (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html).
type KmsGrantConfiguration struct {
	_ struct{} `type:"structure"`

	// Use this structure to propose allowing cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// in the grant only when the operation request includes the specified encryption
	// context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
	Constraints *KmsGrantConstraints `locationName:"constraints" type:"structure"`

	// The principal that is given permission to perform the operations that the
	// grant permits.
	//
	// GranteePrincipal is a required field
	GranteePrincipal *string `locationName:"granteePrincipal" type:"string" required:"true"`

	// The Amazon Web Services account under which the grant was issued. The account
	// is used to propose KMS grants issued by accounts other than the owner of
	// the key.
	//
	// IssuingAccount is a required field
	IssuingAccount *string `locationName:"issuingAccount" type:"string" required:"true"`

	// A list of operations that the grant permits.
	//
	// Operations is a required field
	Operations []*string `locationName:"operations" type:"list" required:"true"`

	// The principal that is given permission to retire the grant by using RetireGrant
	// (https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html)
	// operation.
	RetiringPrincipal *string `locationName:"retiringPrincipal" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsGrantConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsGrantConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KmsGrantConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KmsGrantConfiguration"}
	if s.GranteePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteePrincipal"))
	}
	if s.IssuingAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("IssuingAccount"))
	}
	if s.Operations == nil {
		invalidParams.Add(request.NewErrParamRequired("Operations"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstraints sets the Constraints field's value.
func (s *KmsGrantConfiguration) SetConstraints(v *KmsGrantConstraints) *KmsGrantConfiguration {
	s.Constraints = v
	return s
}

// SetGranteePrincipal sets the GranteePrincipal field's value.
func (s *KmsGrantConfiguration) SetGranteePrincipal(v string) *KmsGrantConfiguration {
	s.GranteePrincipal = &v
	return s
}

// SetIssuingAccount sets the IssuingAccount field's value.
func (s *KmsGrantConfiguration) SetIssuingAccount(v string) *KmsGrantConfiguration {
	s.IssuingAccount = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *KmsGrantConfiguration) SetOperations(v []*string) *KmsGrantConfiguration {
	s.Operations = v
	return s
}

// SetRetiringPrincipal sets the RetiringPrincipal field's value.
func (s *KmsGrantConfiguration) SetRetiringPrincipal(v string) *KmsGrantConfiguration {
	s.RetiringPrincipal = &v
	return s
}

// Use this structure to propose allowing cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
// in the grant only when the operation request includes the specified encryption
// context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
// You can specify only one type of encryption context. An empty map is treated
// as not specified. For more information, see GrantConstraints (https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html).
type KmsGrantConstraints struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs that must match the encryption context in the cryptographic
	// operation (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// request. The grant allows the operation only when the encryption context
	// in the request is the same as the encryption context specified in this constraint.
	EncryptionContextEquals map[string]*string `locationName:"encryptionContextEquals" type:"map"`

	// A list of key-value pairs that must be included in the encryption context
	// of the cryptographic operation (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// request. The grant allows the cryptographic operation only when the encryption
	// context in the request includes the key-value pairs specified in this constraint,
	// although it can include additional key-value pairs.
	EncryptionContextSubset map[string]*string `locationName:"encryptionContextSubset" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsGrantConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsGrantConstraints) GoString() string {
	return s.String()
}

// SetEncryptionContextEquals sets the EncryptionContextEquals field's value.
func (s *KmsGrantConstraints) SetEncryptionContextEquals(v map[string]*string) *KmsGrantConstraints {
	s.EncryptionContextEquals = v
	return s
}

// SetEncryptionContextSubset sets the EncryptionContextSubset field's value.
func (s *KmsGrantConstraints) SetEncryptionContextSubset(v map[string]*string) *KmsGrantConstraints {
	s.EncryptionContextSubset = v
	return s
}

// Proposed access control configuration for a KMS key. You can propose a configuration
// for a new KMS key or an existing KMS key that you own by specifying the key
// policy and KMS grant configuration. If the configuration is for an existing
// key and you do not specify the key policy, the access preview uses the existing
// policy for the key. If the access preview is for a new resource and you do
// not specify the key policy, then the access preview uses the default key
// policy. The proposed key policy cannot be an empty string. For more information,
// see Default key policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
// For more information about key policy limits, see Resource quotas (https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html).
type KmsKeyConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of proposed grant configurations for the KMS key. If the proposed
	// grant configuration is for an existing key, the access preview uses the proposed
	// list of grant configurations in place of the existing grants. Otherwise,
	// the access preview uses the existing grants for the key.
	Grants []*KmsGrantConfiguration `locationName:"grants" type:"list"`

	// Resource policy configuration for the KMS key. The only valid value for the
	// name of the key policy is default. For more information, see Default key
	// policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
	KeyPolicies map[string]*string `locationName:"keyPolicies" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KmsKeyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KmsKeyConfiguration"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *KmsKeyConfiguration) SetGrants(v []*KmsGrantConfiguration) *KmsKeyConfiguration {
	s.Grants = v
	return s
}

// SetKeyPolicies sets the KeyPolicies field's value.
func (s *KmsKeyConfiguration) SetKeyPolicies(v map[string]*string) *KmsKeyConfiguration {
	s.KeyPolicies = v
	return s
}

type ListAccessPreviewFindingsInput struct {
	_ struct{} `type:"structure"`

	// The unique ID for the access preview.
	//
	// AccessPreviewId is a required field
	AccessPreviewId *string `location:"uri" locationName:"accessPreviewId" type:"string" required:"true"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// used to generate the access.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// Criteria to filter the returned findings.
	Filter map[string]*Criterion `locationName:"filter" type:"map"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPreviewFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPreviewFindingsInput"}
	if s.AccessPreviewId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPreviewId"))
	}
	if s.AccessPreviewId != nil && len(*s.AccessPreviewId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPreviewId", 1))
	}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPreviewId sets the AccessPreviewId field's value.
func (s *ListAccessPreviewFindingsInput) SetAccessPreviewId(v string) *ListAccessPreviewFindingsInput {
	s.AccessPreviewId = &v
	return s
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ListAccessPreviewFindingsInput) SetAnalyzerArn(v string) *ListAccessPreviewFindingsInput {
	s.AnalyzerArn = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListAccessPreviewFindingsInput) SetFilter(v map[string]*Criterion) *ListAccessPreviewFindingsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPreviewFindingsInput) SetMaxResults(v int64) *ListAccessPreviewFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPreviewFindingsInput) SetNextToken(v string) *ListAccessPreviewFindingsInput {
	s.NextToken = &v
	return s
}

type ListAccessPreviewFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of access preview findings that match the specified filter criteria.
	//
	// Findings is a required field
	Findings []*AccessPreviewFinding `locationName:"findings" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ListAccessPreviewFindingsOutput) SetFindings(v []*AccessPreviewFinding) *ListAccessPreviewFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPreviewFindingsOutput) SetNextToken(v string) *ListAccessPreviewFindingsOutput {
	s.NextToken = &v
	return s
}

type ListAccessPreviewsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// used to generate the access preview.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPreviewsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPreviewsInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ListAccessPreviewsInput) SetAnalyzerArn(v string) *ListAccessPreviewsInput {
	s.AnalyzerArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPreviewsInput) SetMaxResults(v int64) *ListAccessPreviewsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPreviewsInput) SetNextToken(v string) *ListAccessPreviewsInput {
	s.NextToken = &v
	return s
}

type ListAccessPreviewsOutput struct {
	_ struct{} `type:"structure"`

	// A list of access previews retrieved for the analyzer.
	//
	// AccessPreviews is a required field
	AccessPreviews []*AccessPreviewSummary `locationName:"accessPreviews" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPreviewsOutput) GoString() string {
	return s.String()
}

// SetAccessPreviews sets the AccessPreviews field's value.
func (s *ListAccessPreviewsOutput) SetAccessPreviews(v []*AccessPreviewSummary) *ListAccessPreviewsOutput {
	s.AccessPreviews = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPreviewsOutput) SetNextToken(v string) *ListAccessPreviewsOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of resources that have been analyzed.
type ListAnalyzedResourcesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// to retrieve a list of analyzed resources from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnalyzedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnalyzedResourcesInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ListAnalyzedResourcesInput) SetAnalyzerArn(v string) *ListAnalyzedResourcesInput {
	s.AnalyzerArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnalyzedResourcesInput) SetMaxResults(v int64) *ListAnalyzedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzedResourcesInput) SetNextToken(v string) *ListAnalyzedResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListAnalyzedResourcesInput) SetResourceType(v string) *ListAnalyzedResourcesInput {
	s.ResourceType = &v
	return s
}

// The response to the request.
type ListAnalyzedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of resources that were analyzed.
	//
	// AnalyzedResources is a required field
	AnalyzedResources []*AnalyzedResourceSummary `locationName:"analyzedResources" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzedResourcesOutput) GoString() string {
	return s.String()
}

// SetAnalyzedResources sets the AnalyzedResources field's value.
func (s *ListAnalyzedResourcesOutput) SetAnalyzedResources(v []*AnalyzedResourceSummary) *ListAnalyzedResourcesOutput {
	s.AnalyzedResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzedResourcesOutput) SetNextToken(v string) *ListAnalyzedResourcesOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of analyzers.
type ListAnalyzersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The type of analyzer.
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnalyzersInput) SetMaxResults(v int64) *ListAnalyzersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzersInput) SetNextToken(v string) *ListAnalyzersInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListAnalyzersInput) SetType(v string) *ListAnalyzersInput {
	s.Type = &v
	return s
}

// The response to the request.
type ListAnalyzersOutput struct {
	_ struct{} `type:"structure"`

	// The analyzers retrieved.
	//
	// Analyzers is a required field
	Analyzers []*AnalyzerSummary `locationName:"analyzers" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalyzersOutput) GoString() string {
	return s.String()
}

// SetAnalyzers sets the Analyzers field's value.
func (s *ListAnalyzersOutput) SetAnalyzers(v []*AnalyzerSummary) *ListAnalyzersOutput {
	s.Analyzers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzersOutput) SetNextToken(v string) *ListAnalyzersOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of archive rules created for the specified analyzer.
type ListArchiveRulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the analyzer to retrieve rules from.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchiveRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArchiveRulesInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *ListArchiveRulesInput) SetAnalyzerName(v string) *ListArchiveRulesInput {
	s.AnalyzerName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListArchiveRulesInput) SetMaxResults(v int64) *ListArchiveRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveRulesInput) SetNextToken(v string) *ListArchiveRulesInput {
	s.NextToken = &v
	return s
}

// The response to the request.
type ListArchiveRulesOutput struct {
	_ struct{} `type:"structure"`

	// A list of archive rules created for the specified analyzer.
	//
	// ArchiveRules is a required field
	ArchiveRules []*ArchiveRuleSummary `locationName:"archiveRules" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveRulesOutput) GoString() string {
	return s.String()
}

// SetArchiveRules sets the ArchiveRules field's value.
func (s *ListArchiveRulesOutput) SetArchiveRules(v []*ArchiveRuleSummary) *ListArchiveRulesOutput {
	s.ArchiveRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveRulesOutput) SetNextToken(v string) *ListArchiveRulesOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of findings generated by the specified analyzer.
type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// to retrieve findings from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A filter to match for the findings to return.
	Filter map[string]*Criterion `locationName:"filter" type:"map"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sort order for the findings returned.
	Sort *SortCriteria `locationName:"sort" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ListFindingsInput) SetAnalyzerArn(v string) *ListFindingsInput {
	s.AnalyzerArn = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListFindingsInput) SetFilter(v map[string]*Criterion) *ListFindingsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListFindingsInput) SetSort(v *SortCriteria) *ListFindingsInput {
	s.Sort = v
	return s
}

// The response to the request.
type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of findings retrieved from the analyzer that match the filter criteria
	// specified, if any.
	//
	// Findings is a required field
	Findings []*FindingSummary `locationName:"findings" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ListFindingsOutput) SetFindings(v []*FindingSummary) *ListFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

type ListPolicyGenerationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	// Use this with ListGeneratedPolicies to filter the results to only include
	// results for a specific principal.
	PrincipalArn *string `location:"querystring" locationName:"principalArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyGenerationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyGenerationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyGenerationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyGenerationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPolicyGenerationsInput) SetMaxResults(v int64) *ListPolicyGenerationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyGenerationsInput) SetNextToken(v string) *ListPolicyGenerationsInput {
	s.NextToken = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *ListPolicyGenerationsInput) SetPrincipalArn(v string) *ListPolicyGenerationsInput {
	s.PrincipalArn = &v
	return s
}

type ListPolicyGenerationsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A PolicyGeneration object that contains details about the generated policy.
	//
	// PolicyGenerations is a required field
	PolicyGenerations []*PolicyGeneration `locationName:"policyGenerations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyGenerationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyGenerationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyGenerationsOutput) SetNextToken(v string) *ListPolicyGenerationsOutput {
	s.NextToken = &v
	return s
}

// SetPolicyGenerations sets the PolicyGenerations field's value.
func (s *ListPolicyGenerationsOutput) SetPolicyGenerations(v []*PolicyGeneration) *ListPolicyGenerationsOutput {
	s.PolicyGenerations = v
	return s
}

// Retrieves a list of tags applied to the specified resource.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to retrieve tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// The response to the request.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are applied to the specified resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A location in a policy that is represented as a path through the JSON representation
// and a corresponding span.
type Location struct {
	_ struct{} `type:"structure"`

	// A path in a policy, represented as a sequence of path elements.
	//
	// Path is a required field
	Path []*PathElement `locationName:"path" type:"list" required:"true"`

	// A span in a policy.
	//
	// Span is a required field
	Span *Span `locationName:"span" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Location) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *Location) SetPath(v []*PathElement) *Location {
	s.Path = v
	return s
}

// SetSpan sets the Span field's value.
func (s *Location) SetSpan(v *Span) *Location {
	s.Span = v
	return s
}

// The proposed InternetConfiguration or VpcConfiguration to apply to the Amazon
// S3 access point. VpcConfiguration does not apply to multi-region access points.
// You can make the access point accessible from the internet, or you can specify
// that all requests made through that access point must originate from a specific
// virtual private cloud (VPC). You can specify only one type of network configuration.
// For more information, see Creating access points (https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html).
type NetworkOriginConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the Amazon S3 access point or multi-region access point
	// with an Internet origin.
	InternetConfiguration *InternetConfiguration `locationName:"internetConfiguration" type:"structure"`

	// The proposed virtual private cloud (VPC) configuration for the Amazon S3
	// access point. VPC configuration does not apply to multi-region access points.
	// For more information, see VpcConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html).
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkOriginConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkOriginConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkOriginConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkOriginConfiguration"}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInternetConfiguration sets the InternetConfiguration field's value.
func (s *NetworkOriginConfiguration) SetInternetConfiguration(v *InternetConfiguration) *NetworkOriginConfiguration {
	s.InternetConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *NetworkOriginConfiguration) SetVpcConfiguration(v *VpcConfiguration) *NetworkOriginConfiguration {
	s.VpcConfiguration = v
	return s
}

// A single element in a path through the JSON representation of a policy.
type PathElement struct {
	_ struct{} `type:"structure"`

	// Refers to an index in a JSON array.
	Index *int64 `locationName:"index" type:"integer"`

	// Refers to a key in a JSON object.
	Key *string `locationName:"key" type:"string"`

	// Refers to a substring of a literal string in a JSON object.
	Substring *Substring `locationName:"substring" type:"structure"`

	// Refers to the value associated with a given key in a JSON object.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathElement) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *PathElement) SetIndex(v int64) *PathElement {
	s.Index = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PathElement) SetKey(v string) *PathElement {
	s.Key = &v
	return s
}

// SetSubstring sets the Substring field's value.
func (s *PathElement) SetSubstring(v *Substring) *PathElement {
	s.Substring = v
	return s
}

// SetValue sets the Value field's value.
func (s *PathElement) SetValue(v string) *PathElement {
	s.Value = &v
	return s
}

// Contains details about the policy generation status and properties.
type PolicyGeneration struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the policy generation was completed.
	CompletedOn *time.Time `locationName:"completedOn" type:"timestamp" timestampFormat:"iso8601"`

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or
	// used with CancelPolicyGeneration to cancel the policy generation request.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`

	// A timestamp of when the policy generation started.
	//
	// StartedOn is a required field
	StartedOn *time.Time `locationName:"startedOn" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The status of the policy generation request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyGeneration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyGeneration) GoString() string {
	return s.String()
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *PolicyGeneration) SetCompletedOn(v time.Time) *PolicyGeneration {
	s.CompletedOn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PolicyGeneration) SetJobId(v string) *PolicyGeneration {
	s.JobId = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *PolicyGeneration) SetPrincipalArn(v string) *PolicyGeneration {
	s.PrincipalArn = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *PolicyGeneration) SetStartedOn(v time.Time) *PolicyGeneration {
	s.StartedOn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PolicyGeneration) SetStatus(v string) *PolicyGeneration {
	s.Status = &v
	return s
}

// Contains the ARN details about the IAM entity for which the policy is generated.
type PolicyGenerationDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyGenerationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyGenerationDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyGenerationDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyGenerationDetails"}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *PolicyGenerationDetails) SetPrincipalArn(v string) *PolicyGenerationDetails {
	s.PrincipalArn = &v
	return s
}

// A position in a policy.
type Position struct {
	_ struct{} `type:"structure"`

	// The column of the position, starting from 0.
	//
	// Column is a required field
	Column *int64 `locationName:"column" type:"integer" required:"true"`

	// The line of the position, starting from 1.
	//
	// Line is a required field
	Line *int64 `locationName:"line" type:"integer" required:"true"`

	// The offset within the policy that corresponds to the position, starting from
	// 0.
	//
	// Offset is a required field
	Offset *int64 `locationName:"offset" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Position) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Position) GoString() string {
	return s.String()
}

// SetColumn sets the Column field's value.
func (s *Position) SetColumn(v int64) *Position {
	s.Column = &v
	return s
}

// SetLine sets the Line field's value.
func (s *Position) SetLine(v int64) *Position {
	s.Line = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *Position) SetOffset(v int64) *Position {
	s.Offset = &v
	return s
}

// The specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for an Amazon S3 access point or multi-region access point
// for the bucket. You can propose up to 10 access points or multi-region access
// points per bucket. If the proposed Amazon S3 access point configuration is
// for an existing bucket, the access preview uses the proposed access point
// configuration in place of the existing access points. To propose an access
// point without a policy, you can provide an empty string as the access point
// policy. For more information, see Creating access points (https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html).
// For more information about access point policy limits, see Access points
// restrictions and limitations (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html).
type S3AccessPointConfiguration struct {
	_ struct{} `type:"structure"`

	// The access point or multi-region access point policy.
	AccessPointPolicy *string `locationName:"accessPointPolicy" type:"string"`

	// The proposed Internet and VpcConfiguration to apply to this Amazon S3 access
	// point. VpcConfiguration does not apply to multi-region access points. If
	// the access preview is for a new resource and neither is specified, the access
	// preview uses Internet for the network origin. If the access preview is for
	// an existing resource and neither is specified, the access preview uses the
	// exiting network origin.
	NetworkOrigin *NetworkOriginConfiguration `locationName:"networkOrigin" type:"structure"`

	// The proposed S3PublicAccessBlock configuration to apply to this Amazon S3
	// access point or multi-region access point.
	PublicAccessBlock *S3PublicAccessBlockConfiguration `locationName:"publicAccessBlock" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3AccessPointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3AccessPointConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessPointConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3AccessPointConfiguration"}
	if s.NetworkOrigin != nil {
		if err := s.NetworkOrigin.Validate(); err != nil {
			invalidParams.AddNested("NetworkOrigin", err.(request.ErrInvalidParams))
		}
	}
	if s.PublicAccessBlock != nil {
		if err := s.PublicAccessBlock.Validate(); err != nil {
			invalidParams.AddNested("PublicAccessBlock", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPointPolicy sets the AccessPointPolicy field's value.
func (s *S3AccessPointConfiguration) SetAccessPointPolicy(v string) *S3AccessPointConfiguration {
	s.AccessPointPolicy = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *S3AccessPointConfiguration) SetNetworkOrigin(v *NetworkOriginConfiguration) *S3AccessPointConfiguration {
	s.NetworkOrigin = v
	return s
}

// SetPublicAccessBlock sets the PublicAccessBlock field's value.
func (s *S3AccessPointConfiguration) SetPublicAccessBlock(v *S3PublicAccessBlockConfiguration) *S3AccessPointConfiguration {
	s.PublicAccessBlock = v
	return s
}

// A proposed access control list grant configuration for an Amazon S3 bucket.
// For more information, see How to Specify an ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls).
type S3BucketAclGrantConfiguration struct {
	_ struct{} `type:"structure"`

	// The grantee to whom you’re assigning access rights.
	//
	// Grantee is a required field
	Grantee *AclGrantee `locationName:"grantee" type:"structure" required:"true"`

	// The permissions being granted.
	//
	// Permission is a required field
	Permission *string `locationName:"permission" type:"string" required:"true" enum:"AclPermission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketAclGrantConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketAclGrantConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3BucketAclGrantConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3BucketAclGrantConfiguration"}
	if s.Grantee == nil {
		invalidParams.Add(request.NewErrParamRequired("Grantee"))
	}
	if s.Permission == nil {
		invalidParams.Add(request.NewErrParamRequired("Permission"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *S3BucketAclGrantConfiguration) SetGrantee(v *AclGrantee) *S3BucketAclGrantConfiguration {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *S3BucketAclGrantConfiguration) SetPermission(v string) *S3BucketAclGrantConfiguration {
	s.Permission = &v
	return s
}

// Proposed access control configuration for an Amazon S3 bucket. You can propose
// a configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket
// that you own by specifying the Amazon S3 bucket policy, bucket ACLs, bucket
// BPA settings, Amazon S3 access points, and multi-region access points attached
// to the bucket. If the configuration is for an existing Amazon S3 bucket and
// you do not specify the Amazon S3 bucket policy, the access preview uses the
// existing policy attached to the bucket. If the access preview is for a new
// resource and you do not specify the Amazon S3 bucket policy, the access preview
// assumes a bucket without a policy. To propose deletion of an existing bucket
// policy, you can specify an empty string. For more information about bucket
// policy limits, see Bucket Policy Examples (https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html).
type S3BucketConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of Amazon S3 access points or multi-region access points
	// for the bucket. You can propose up to 10 new access points per bucket.
	AccessPoints map[string]*S3AccessPointConfiguration `locationName:"accessPoints" type:"map"`

	// The proposed list of ACL grants for the Amazon S3 bucket. You can propose
	// up to 100 ACL grants per bucket. If the proposed grant configuration is for
	// an existing bucket, the access preview uses the proposed list of grant configurations
	// in place of the existing grants. Otherwise, the access preview uses the existing
	// grants for the bucket.
	BucketAclGrants []*S3BucketAclGrantConfiguration `locationName:"bucketAclGrants" type:"list"`

	// The proposed bucket policy for the Amazon S3 bucket.
	BucketPolicy *string `locationName:"bucketPolicy" type:"string"`

	// The proposed block public access configuration for the Amazon S3 bucket.
	BucketPublicAccessBlock *S3PublicAccessBlockConfiguration `locationName:"bucketPublicAccessBlock" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3BucketConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3BucketConfiguration"}
	if s.AccessPoints != nil {
		for i, v := range s.AccessPoints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessPoints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.BucketAclGrants != nil {
		for i, v := range s.BucketAclGrants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BucketAclGrants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.BucketPublicAccessBlock != nil {
		if err := s.BucketPublicAccessBlock.Validate(); err != nil {
			invalidParams.AddNested("BucketPublicAccessBlock", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPoints sets the AccessPoints field's value.
func (s *S3BucketConfiguration) SetAccessPoints(v map[string]*S3AccessPointConfiguration) *S3BucketConfiguration {
	s.AccessPoints = v
	return s
}

// SetBucketAclGrants sets the BucketAclGrants field's value.
func (s *S3BucketConfiguration) SetBucketAclGrants(v []*S3BucketAclGrantConfiguration) *S3BucketConfiguration {
	s.BucketAclGrants = v
	return s
}

// SetBucketPolicy sets the BucketPolicy field's value.
func (s *S3BucketConfiguration) SetBucketPolicy(v string) *S3BucketConfiguration {
	s.BucketPolicy = &v
	return s
}

// SetBucketPublicAccessBlock sets the BucketPublicAccessBlock field's value.
func (s *S3BucketConfiguration) SetBucketPublicAccessBlock(v *S3PublicAccessBlockConfiguration) *S3BucketConfiguration {
	s.BucketPublicAccessBlock = v
	return s
}

// The PublicAccessBlock configuration to apply to this Amazon S3 bucket. If
// the proposed configuration is for an existing Amazon S3 bucket and the configuration
// is not specified, the access preview uses the existing setting. If the proposed
// configuration is for a new bucket and the configuration is not specified,
// the access preview uses false. If the proposed configuration is for a new
// access point or multi-region access point and the access point BPA configuration
// is not specified, the access preview uses true. For more information, see
// PublicAccessBlockConfiguration (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html).
type S3PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should ignore public ACLs for this bucket and
	// objects in this bucket.
	//
	// IgnorePublicAcls is a required field
	IgnorePublicAcls *bool `locationName:"ignorePublicAcls" type:"boolean" required:"true"`

	// Specifies whether Amazon S3 should restrict public bucket policies for this
	// bucket.
	//
	// RestrictPublicBuckets is a required field
	RestrictPublicBuckets *bool `locationName:"restrictPublicBuckets" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3PublicAccessBlockConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3PublicAccessBlockConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3PublicAccessBlockConfiguration"}
	if s.IgnorePublicAcls == nil {
		invalidParams.Add(request.NewErrParamRequired("IgnorePublicAcls"))
	}
	if s.RestrictPublicBuckets == nil {
		invalidParams.Add(request.NewErrParamRequired("RestrictPublicBuckets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *S3PublicAccessBlockConfiguration) SetIgnorePublicAcls(v bool) *S3PublicAccessBlockConfiguration {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *S3PublicAccessBlockConfiguration) SetRestrictPublicBuckets(v bool) *S3PublicAccessBlockConfiguration {
	s.RestrictPublicBuckets = &v
	return s
}

// The configuration for a Secrets Manager secret. For more information, see
// CreateSecret (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html).
//
// You can propose a configuration for a new secret or an existing secret that
// you own by specifying the secret policy and optional KMS encryption key.
// If the configuration is for an existing secret and you do not specify the
// secret policy, the access preview uses the existing policy for the secret.
// If the access preview is for a new resource and you do not specify the policy,
// the access preview assumes a secret without a policy. To propose deletion
// of an existing policy, you can specify an empty string. If the proposed configuration
// is for a new secret and you do not specify the KMS key ID, the access preview
// uses the default CMK of the Amazon Web Services account. If you specify an
// empty string for the KMS key ID, the access preview uses the default CMK
// of the Amazon Web Services account. For more information about secret policy
// limits, see Quotas for Secrets Manager. (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html).
type SecretsManagerSecretConfiguration struct {
	_ struct{} `type:"structure"`

	// The proposed ARN, key ID, or alias of the KMS customer master key (CMK).
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The proposed resource policy defining who can access or manage the secret.
	SecretPolicy *string `locationName:"secretPolicy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretsManagerSecretConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretsManagerSecretConfiguration) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *SecretsManagerSecretConfiguration) SetKmsKeyId(v string) *SecretsManagerSecretConfiguration {
	s.KmsKeyId = &v
	return s
}

// SetSecretPolicy sets the SecretPolicy field's value.
func (s *SecretsManagerSecretConfiguration) SetSecretPolicy(v string) *SecretsManagerSecretConfiguration {
	s.SecretPolicy = &v
	return s
}

// Service quote met error.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The criteria used to sort.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to sort on.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The sort order, ascending or descending.
	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *SortCriteria) SetAttributeName(v string) *SortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *SortCriteria) SetOrderBy(v string) *SortCriteria {
	s.OrderBy = &v
	return s
}

// A span in a policy. The span consists of a start position (inclusive) and
// end position (exclusive).
type Span struct {
	_ struct{} `type:"structure"`

	// The end position of the span (exclusive).
	//
	// End is a required field
	End *Position `locationName:"end" type:"structure" required:"true"`

	// The start position of the span (inclusive).
	//
	// Start is a required field
	Start *Position `locationName:"start" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Span) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Span) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *Span) SetEnd(v *Position) *Span {
	s.End = v
	return s
}

// SetStart sets the Start field's value.
func (s *Span) SetStart(v *Position) *Span {
	s.Start = v
	return s
}

// The proposed access control configuration for an Amazon SQS queue. You can
// propose a configuration for a new Amazon SQS queue or an existing Amazon
// SQS queue that you own by specifying the Amazon SQS policy. If the configuration
// is for an existing Amazon SQS queue and you do not specify the Amazon SQS
// policy, the access preview uses the existing Amazon SQS policy for the queue.
// If the access preview is for a new resource and you do not specify the policy,
// the access preview assumes an Amazon SQS queue without a policy. To propose
// deletion of an existing Amazon SQS queue policy, you can specify an empty
// string for the Amazon SQS policy. For more information about Amazon SQS policy
// limits, see Quotas related to policies (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html).
type SqsQueueConfiguration struct {
	_ struct{} `type:"structure"`

	// The proposed resource policy for the Amazon SQS queue.
	QueuePolicy *string `locationName:"queuePolicy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsQueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsQueueConfiguration) GoString() string {
	return s.String()
}

// SetQueuePolicy sets the QueuePolicy field's value.
func (s *SqsQueueConfiguration) SetQueuePolicy(v string) *SqsQueueConfiguration {
	s.QueuePolicy = &v
	return s
}

type StartPolicyGenerationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// the subsequent retries with the same client token return the result from
	// the original successful request and they have no additional effect.
	//
	// If you do not specify a client token, one is automatically generated by the
	// Amazon Web Services SDK.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A CloudTrailDetails object that contains details about a Trail that you want
	// to analyze to generate policies.
	CloudTrailDetails *CloudTrailDetails `locationName:"cloudTrailDetails" type:"structure"`

	// Contains the ARN of the IAM entity (user or role) for which you are generating
	// a policy.
	//
	// PolicyGenerationDetails is a required field
	PolicyGenerationDetails *PolicyGenerationDetails `locationName:"policyGenerationDetails" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPolicyGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPolicyGenerationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPolicyGenerationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPolicyGenerationInput"}
	if s.PolicyGenerationDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyGenerationDetails"))
	}
	if s.CloudTrailDetails != nil {
		if err := s.CloudTrailDetails.Validate(); err != nil {
			invalidParams.AddNested("CloudTrailDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.PolicyGenerationDetails != nil {
		if err := s.PolicyGenerationDetails.Validate(); err != nil {
			invalidParams.AddNested("PolicyGenerationDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartPolicyGenerationInput) SetClientToken(v string) *StartPolicyGenerationInput {
	s.ClientToken = &v
	return s
}

// SetCloudTrailDetails sets the CloudTrailDetails field's value.
func (s *StartPolicyGenerationInput) SetCloudTrailDetails(v *CloudTrailDetails) *StartPolicyGenerationInput {
	s.CloudTrailDetails = v
	return s
}

// SetPolicyGenerationDetails sets the PolicyGenerationDetails field's value.
func (s *StartPolicyGenerationInput) SetPolicyGenerationDetails(v *PolicyGenerationDetails) *StartPolicyGenerationInput {
	s.PolicyGenerationDetails = v
	return s
}

type StartPolicyGenerationOutput struct {
	_ struct{} `type:"structure"`

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or
	// used with CancelPolicyGeneration to cancel the policy generation request.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPolicyGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPolicyGenerationOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartPolicyGenerationOutput) SetJobId(v string) *StartPolicyGenerationOutput {
	s.JobId = &v
	return s
}

// Starts a scan of the policies applied to the specified resource.
type StartResourceScanInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// to use to scan the policies applied to the specified resource.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// The ARN of the resource to scan.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartResourceScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartResourceScanInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *StartResourceScanInput) SetAnalyzerArn(v string) *StartResourceScanInput {
	s.AnalyzerArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *StartResourceScanInput) SetResourceArn(v string) *StartResourceScanInput {
	s.ResourceArn = &v
	return s
}

type StartResourceScanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanOutput) GoString() string {
	return s.String()
}

// Provides more details about the current status of the analyzer. For example,
// if the creation for the analyzer fails, a Failed status is returned. For
// an analyzer with organization as the type, this failure can be due to an
// issue with creating the service-linked roles required in the member accounts
// of the Amazon Web Services organization.
type StatusReason struct {
	_ struct{} `type:"structure"`

	// The reason code for the current status of the analyzer.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"ReasonCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatusReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *StatusReason) SetCode(v string) *StatusReason {
	s.Code = &v
	return s
}

// A reference to a substring of a literal string in a JSON document.
type Substring struct {
	_ struct{} `type:"structure"`

	// The length of the substring.
	//
	// Length is a required field
	Length *int64 `locationName:"length" type:"integer" required:"true"`

	// The start index of the substring, starting from 0.
	//
	// Start is a required field
	Start *int64 `locationName:"start" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Substring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Substring) GoString() string {
	return s.String()
}

// SetLength sets the Length field's value.
func (s *Substring) SetLength(v int64) *Substring {
	s.Length = &v
	return s
}

// SetStart sets the Start field's value.
func (s *Substring) SetStart(v int64) *Substring {
	s.Start = &v
	return s
}

// Adds a tag to the specified resource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to add the tag to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

// The response to the request.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Throttling limit exceeded error.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The seconds to wait to retry.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about the CloudTrail trail being analyzed to generate a
// policy.
type Trail struct {
	_ struct{} `type:"structure"`

	// Possible values are true or false. If set to true, IAM Access Analyzer retrieves
	// CloudTrail data from all regions to analyze and generate a policy.
	AllRegions *bool `locationName:"allRegions" type:"boolean"`

	// Specifies the ARN of the trail. The format of a trail ARN is arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail.
	//
	// CloudTrailArn is a required field
	CloudTrailArn *string `locationName:"cloudTrailArn" type:"string" required:"true"`

	// A list of regions to get CloudTrail data from and analyze to generate a policy.
	Regions []*string `locationName:"regions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Trail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Trail"}
	if s.CloudTrailArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudTrailArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllRegions sets the AllRegions field's value.
func (s *Trail) SetAllRegions(v bool) *Trail {
	s.AllRegions = &v
	return s
}

// SetCloudTrailArn sets the CloudTrailArn field's value.
func (s *Trail) SetCloudTrailArn(v string) *Trail {
	s.CloudTrailArn = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *Trail) SetRegions(v []*string) *Trail {
	s.Regions = v
	return s
}

// Contains details about the CloudTrail trail being analyzed to generate a
// policy.
type TrailProperties struct {
	_ struct{} `type:"structure"`

	// Possible values are true or false. If set to true, IAM Access Analyzer retrieves
	// CloudTrail data from all regions to analyze and generate a policy.
	AllRegions *bool `locationName:"allRegions" type:"boolean"`

	// Specifies the ARN of the trail. The format of a trail ARN is arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail.
	//
	// CloudTrailArn is a required field
	CloudTrailArn *string `locationName:"cloudTrailArn" type:"string" required:"true"`

	// A list of regions to get CloudTrail data from and analyze to generate a policy.
	Regions []*string `locationName:"regions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailProperties) GoString() string {
	return s.String()
}

// SetAllRegions sets the AllRegions field's value.
func (s *TrailProperties) SetAllRegions(v bool) *TrailProperties {
	s.AllRegions = &v
	return s
}

// SetCloudTrailArn sets the CloudTrailArn field's value.
func (s *TrailProperties) SetCloudTrailArn(v string) *TrailProperties {
	s.CloudTrailArn = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *TrailProperties) SetRegions(v []*string) *TrailProperties {
	s.Regions = v
	return s
}

// Removes a tag from the specified resource.
type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to remove the tag from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The key for the tag to add.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The response to the request.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Updates the specified archive rule.
type UpdateArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to update the archive rules for.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A filter to match for the rules to update. Only rules that match the filter
	// are updated.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule to update.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *UpdateArchiveRuleInput) SetAnalyzerName(v string) *UpdateArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateArchiveRuleInput) SetClientToken(v string) *UpdateArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *UpdateArchiveRuleInput) SetFilter(v map[string]*Criterion) *UpdateArchiveRuleInput {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *UpdateArchiveRuleInput) SetRuleName(v string) *UpdateArchiveRuleInput {
	s.RuleName = &v
	return s
}

type UpdateArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveRuleOutput) GoString() string {
	return s.String()
}

// Updates findings with the new values provided in the request.
type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
	// that generated the findings to update.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The IDs of the findings to update.
	Ids []*string `locationName:"ids" type:"list"`

	// The ARN of the resource identified in the finding.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The state represents the action to take to update the finding Status. Use
	// ARCHIVE to change an Active finding to an Archived finding. Use ACTIVE to
	// change an Archived finding to an Active finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatusUpdate"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *UpdateFindingsInput) SetAnalyzerArn(v string) *UpdateFindingsInput {
	s.AnalyzerArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateFindingsInput) SetClientToken(v string) *UpdateFindingsInput {
	s.ClientToken = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *UpdateFindingsInput) SetIds(v []*string) *UpdateFindingsInput {
	s.Ids = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateFindingsInput) SetResourceArn(v string) *UpdateFindingsInput {
	s.ResourceArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateFindingsInput) SetStatus(v string) *UpdateFindingsInput {
	s.Status = &v
	return s
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFindingsOutput) GoString() string {
	return s.String()
}

// A finding in a policy. Each finding is an actionable recommendation that
// can be used to improve the policy.
type ValidatePolicyFinding struct {
	_ struct{} `type:"structure"`

	// A localized message that explains the finding and provides guidance on how
	// to address it.
	//
	// FindingDetails is a required field
	FindingDetails *string `locationName:"findingDetails" type:"string" required:"true"`

	// The impact of the finding.
	//
	// Security warnings report when the policy allows access that we consider overly
	// permissive.
	//
	// Errors report when a part of the policy is not functional.
	//
	// Warnings report non-security issues when a policy does not conform to policy
	// writing best practices.
	//
	// Suggestions recommend stylistic improvements in the policy that do not impact
	// access.
	//
	// FindingType is a required field
	FindingType *string `locationName:"findingType" type:"string" required:"true" enum:"ValidatePolicyFindingType"`

	// The issue code provides an identifier of the issue associated with this finding.
	//
	// IssueCode is a required field
	IssueCode *string `locationName:"issueCode" type:"string" required:"true"`

	// A link to additional documentation about the type of finding.
	//
	// LearnMoreLink is a required field
	LearnMoreLink *string `locationName:"learnMoreLink" type:"string" required:"true"`

	// The list of locations in the policy document that are related to the finding.
	// The issue code provides a summary of an issue identified by the finding.
	//
	// Locations is a required field
	Locations []*Location `locationName:"locations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePolicyFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePolicyFinding) GoString() string {
	return s.String()
}

// SetFindingDetails sets the FindingDetails field's value.
func (s *ValidatePolicyFinding) SetFindingDetails(v string) *ValidatePolicyFinding {
	s.FindingDetails = &v
	return s
}

// SetFindingType sets the FindingType field's value.
func (s *ValidatePolicyFinding) SetFindingType(v string) *ValidatePolicyFinding {
	s.FindingType = &v
	return s
}

// SetIssueCode sets the IssueCode field's value.
func (s *ValidatePolicyFinding) SetIssueCode(v string) *ValidatePolicyFinding {
	s.IssueCode = &v
	return s
}

// SetLearnMoreLink sets the LearnMoreLink field's value.
func (s *ValidatePolicyFinding) SetLearnMoreLink(v string) *ValidatePolicyFinding {
	s.LearnMoreLink = &v
	return s
}

// SetLocations sets the Locations field's value.
func (s *ValidatePolicyFinding) SetLocations(v []*Location) *ValidatePolicyFinding {
	s.Locations = v
	return s
}

type ValidatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The locale to use for localizing the findings.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The JSON policy document to use as the content for the policy.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The type of policy to validate. Identity policies grant permissions to IAM
	// principals. Identity policies include managed and inline policies for IAM
	// roles, users, and groups. They also include service-control policies (SCPs)
	// that are attached to an Amazon Web Services organization, organizational
	// unit (OU), or an account.
	//
	// Resource policies grant permissions on Amazon Web Services resources. Resource
	// policies include trust policies for IAM roles and bucket policies for Amazon
	// S3 buckets. You can provide a generic input such as identity policy or resource
	// policy or a specific input such as managed policy or Amazon S3 bucket policy.
	//
	// PolicyType is a required field
	PolicyType *string `locationName:"policyType" type:"string" required:"true" enum:"PolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidatePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *ValidatePolicyInput) SetLocale(v string) *ValidatePolicyInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ValidatePolicyInput) SetMaxResults(v int64) *ValidatePolicyInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ValidatePolicyInput) SetNextToken(v string) *ValidatePolicyInput {
	s.NextToken = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *ValidatePolicyInput) SetPolicyDocument(v string) *ValidatePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ValidatePolicyInput) SetPolicyType(v string) *ValidatePolicyInput {
	s.PolicyType = &v
	return s
}

type ValidatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The list of findings in a policy returned by IAM Access Analyzer based on
	// its suite of policy checks.
	//
	// Findings is a required field
	Findings []*ValidatePolicyFinding `locationName:"findings" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePolicyOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ValidatePolicyOutput) SetFindings(v []*ValidatePolicyFinding) *ValidatePolicyOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ValidatePolicyOutput) SetNextToken(v string) *ValidatePolicyOutput {
	s.NextToken = &v
	return s
}

// Validation exception error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of fields that didn't validate.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The proposed virtual private cloud (VPC) configuration for the Amazon S3
// access point. VPC configuration does not apply to multi-region access points.
// For more information, see VpcConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html).
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// If this field is specified, this access point will only allow connections
	// from the specified VPC ID.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfiguration) SetVpcId(v string) *VpcConfiguration {
	s.VpcId = &v
	return s
}

const (
	// AccessPreviewStatusCompleted is a AccessPreviewStatus enum value
	AccessPreviewStatusCompleted = "COMPLETED"

	// AccessPreviewStatusCreating is a AccessPreviewStatus enum value
	AccessPreviewStatusCreating = "CREATING"

	// AccessPreviewStatusFailed is a AccessPreviewStatus enum value
	AccessPreviewStatusFailed = "FAILED"
)

// AccessPreviewStatus_Values returns all elements of the AccessPreviewStatus enum
func AccessPreviewStatus_Values() []string {
	return []string{
		AccessPreviewStatusCompleted,
		AccessPreviewStatusCreating,
		AccessPreviewStatusFailed,
	}
}

const (
	// AccessPreviewStatusReasonCodeInternalError is a AccessPreviewStatusReasonCode enum value
	AccessPreviewStatusReasonCodeInternalError = "INTERNAL_ERROR"

	// AccessPreviewStatusReasonCodeInvalidConfiguration is a AccessPreviewStatusReasonCode enum value
	AccessPreviewStatusReasonCodeInvalidConfiguration = "INVALID_CONFIGURATION"
)

// AccessPreviewStatusReasonCode_Values returns all elements of the AccessPreviewStatusReasonCode enum
func AccessPreviewStatusReasonCode_Values() []string {
	return []string{
		AccessPreviewStatusReasonCodeInternalError,
		AccessPreviewStatusReasonCodeInvalidConfiguration,
	}
}

const (
	// AclPermissionRead is a AclPermission enum value
	AclPermissionRead = "READ"

	// AclPermissionWrite is a AclPermission enum value
	AclPermissionWrite = "WRITE"

	// AclPermissionReadAcp is a AclPermission enum value
	AclPermissionReadAcp = "READ_ACP"

	// AclPermissionWriteAcp is a AclPermission enum value
	AclPermissionWriteAcp = "WRITE_ACP"

	// AclPermissionFullControl is a AclPermission enum value
	AclPermissionFullControl = "FULL_CONTROL"
)

// AclPermission_Values returns all elements of the AclPermission enum
func AclPermission_Values() []string {
	return []string{
		AclPermissionRead,
		AclPermissionWrite,
		AclPermissionReadAcp,
		AclPermissionWriteAcp,
		AclPermissionFullControl,
	}
}

const (
	// AnalyzerStatusActive is a AnalyzerStatus enum value
	AnalyzerStatusActive = "ACTIVE"

	// AnalyzerStatusCreating is a AnalyzerStatus enum value
	AnalyzerStatusCreating = "CREATING"

	// AnalyzerStatusDisabled is a AnalyzerStatus enum value
	AnalyzerStatusDisabled = "DISABLED"

	// AnalyzerStatusFailed is a AnalyzerStatus enum value
	AnalyzerStatusFailed = "FAILED"
)

// AnalyzerStatus_Values returns all elements of the AnalyzerStatus enum
func AnalyzerStatus_Values() []string {
	return []string{
		AnalyzerStatusActive,
		AnalyzerStatusCreating,
		AnalyzerStatusDisabled,
		AnalyzerStatusFailed,
	}
}

const (
	// FindingChangeTypeChanged is a FindingChangeType enum value
	FindingChangeTypeChanged = "CHANGED"

	// FindingChangeTypeNew is a FindingChangeType enum value
	FindingChangeTypeNew = "NEW"

	// FindingChangeTypeUnchanged is a FindingChangeType enum value
	FindingChangeTypeUnchanged = "UNCHANGED"
)

// FindingChangeType_Values returns all elements of the FindingChangeType enum
func FindingChangeType_Values() []string {
	return []string{
		FindingChangeTypeChanged,
		FindingChangeTypeNew,
		FindingChangeTypeUnchanged,
	}
}

const (
	// FindingSourceTypePolicy is a FindingSourceType enum value
	FindingSourceTypePolicy = "POLICY"

	// FindingSourceTypeBucketAcl is a FindingSourceType enum value
	FindingSourceTypeBucketAcl = "BUCKET_ACL"

	// FindingSourceTypeS3AccessPoint is a FindingSourceType enum value
	FindingSourceTypeS3AccessPoint = "S3_ACCESS_POINT"
)

// FindingSourceType_Values returns all elements of the FindingSourceType enum
func FindingSourceType_Values() []string {
	return []string{
		FindingSourceTypePolicy,
		FindingSourceTypeBucketAcl,
		FindingSourceTypeS3AccessPoint,
	}
}

const (
	// FindingStatusActive is a FindingStatus enum value
	FindingStatusActive = "ACTIVE"

	// FindingStatusArchived is a FindingStatus enum value
	FindingStatusArchived = "ARCHIVED"

	// FindingStatusResolved is a FindingStatus enum value
	FindingStatusResolved = "RESOLVED"
)

// FindingStatus_Values returns all elements of the FindingStatus enum
func FindingStatus_Values() []string {
	return []string{
		FindingStatusActive,
		FindingStatusArchived,
		FindingStatusResolved,
	}
}

const (
	// FindingStatusUpdateActive is a FindingStatusUpdate enum value
	FindingStatusUpdateActive = "ACTIVE"

	// FindingStatusUpdateArchived is a FindingStatusUpdate enum value
	FindingStatusUpdateArchived = "ARCHIVED"
)

// FindingStatusUpdate_Values returns all elements of the FindingStatusUpdate enum
func FindingStatusUpdate_Values() []string {
	return []string{
		FindingStatusUpdateActive,
		FindingStatusUpdateArchived,
	}
}

const (
	// JobErrorCodeAuthorizationError is a JobErrorCode enum value
	JobErrorCodeAuthorizationError = "AUTHORIZATION_ERROR"

	// JobErrorCodeResourceNotFoundError is a JobErrorCode enum value
	JobErrorCodeResourceNotFoundError = "RESOURCE_NOT_FOUND_ERROR"

	// JobErrorCodeServiceQuotaExceededError is a JobErrorCode enum value
	JobErrorCodeServiceQuotaExceededError = "SERVICE_QUOTA_EXCEEDED_ERROR"

	// JobErrorCodeServiceError is a JobErrorCode enum value
	JobErrorCodeServiceError = "SERVICE_ERROR"
)

// JobErrorCode_Values returns all elements of the JobErrorCode enum
func JobErrorCode_Values() []string {
	return []string{
		JobErrorCodeAuthorizationError,
		JobErrorCodeResourceNotFoundError,
		JobErrorCodeServiceQuotaExceededError,
		JobErrorCodeServiceError,
	}
}

const (
	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusCanceled is a JobStatus enum value
	JobStatusCanceled = "CANCELED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusInProgress,
		JobStatusSucceeded,
		JobStatusFailed,
		JobStatusCanceled,
	}
}

const (
	// KmsGrantOperationCreateGrant is a KmsGrantOperation enum value
	KmsGrantOperationCreateGrant = "CreateGrant"

	// KmsGrantOperationDecrypt is a KmsGrantOperation enum value
	KmsGrantOperationDecrypt = "Decrypt"

	// KmsGrantOperationDescribeKey is a KmsGrantOperation enum value
	KmsGrantOperationDescribeKey = "DescribeKey"

	// KmsGrantOperationEncrypt is a KmsGrantOperation enum value
	KmsGrantOperationEncrypt = "Encrypt"

	// KmsGrantOperationGenerateDataKey is a KmsGrantOperation enum value
	KmsGrantOperationGenerateDataKey = "GenerateDataKey"

	// KmsGrantOperationGenerateDataKeyPair is a KmsGrantOperation enum value
	KmsGrantOperationGenerateDataKeyPair = "GenerateDataKeyPair"

	// KmsGrantOperationGenerateDataKeyPairWithoutPlaintext is a KmsGrantOperation enum value
	KmsGrantOperationGenerateDataKeyPairWithoutPlaintext = "GenerateDataKeyPairWithoutPlaintext"

	// KmsGrantOperationGenerateDataKeyWithoutPlaintext is a KmsGrantOperation enum value
	KmsGrantOperationGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

	// KmsGrantOperationGetPublicKey is a KmsGrantOperation enum value
	KmsGrantOperationGetPublicKey = "GetPublicKey"

	// KmsGrantOperationReEncryptFrom is a KmsGrantOperation enum value
	KmsGrantOperationReEncryptFrom = "ReEncryptFrom"

	// KmsGrantOperationReEncryptTo is a KmsGrantOperation enum value
	KmsGrantOperationReEncryptTo = "ReEncryptTo"

	// KmsGrantOperationRetireGrant is a KmsGrantOperation enum value
	KmsGrantOperationRetireGrant = "RetireGrant"

	// KmsGrantOperationSign is a KmsGrantOperation enum value
	KmsGrantOperationSign = "Sign"

	// KmsGrantOperationVerify is a KmsGrantOperation enum value
	KmsGrantOperationVerify = "Verify"
)

// KmsGrantOperation_Values returns all elements of the KmsGrantOperation enum
func KmsGrantOperation_Values() []string {
	return []string{
		KmsGrantOperationCreateGrant,
		KmsGrantOperationDecrypt,
		KmsGrantOperationDescribeKey,
		KmsGrantOperationEncrypt,
		KmsGrantOperationGenerateDataKey,
		KmsGrantOperationGenerateDataKeyPair,
		KmsGrantOperationGenerateDataKeyPairWithoutPlaintext,
		KmsGrantOperationGenerateDataKeyWithoutPlaintext,
		KmsGrantOperationGetPublicKey,
		KmsGrantOperationReEncryptFrom,
		KmsGrantOperationReEncryptTo,
		KmsGrantOperationRetireGrant,
		KmsGrantOperationSign,
		KmsGrantOperationVerify,
	}
}

const (
	// LocaleDe is a Locale enum value
	LocaleDe = "DE"

	// LocaleEn is a Locale enum value
	LocaleEn = "EN"

	// LocaleEs is a Locale enum value
	LocaleEs = "ES"

	// LocaleFr is a Locale enum value
	LocaleFr = "FR"

	// LocaleIt is a Locale enum value
	LocaleIt = "IT"

	// LocaleJa is a Locale enum value
	LocaleJa = "JA"

	// LocaleKo is a Locale enum value
	LocaleKo = "KO"

	// LocalePtBr is a Locale enum value
	LocalePtBr = "PT_BR"

	// LocaleZhCn is a Locale enum value
	LocaleZhCn = "ZH_CN"

	// LocaleZhTw is a Locale enum value
	LocaleZhTw = "ZH_TW"
)

// Locale_Values returns all elements of the Locale enum
func Locale_Values() []string {
	return []string{
		LocaleDe,
		LocaleEn,
		LocaleEs,
		LocaleFr,
		LocaleIt,
		LocaleJa,
		LocaleKo,
		LocalePtBr,
		LocaleZhCn,
		LocaleZhTw,
	}
}

const (
	// OrderByAsc is a OrderBy enum value
	OrderByAsc = "ASC"

	// OrderByDesc is a OrderBy enum value
	OrderByDesc = "DESC"
)

// OrderBy_Values returns all elements of the OrderBy enum
func OrderBy_Values() []string {
	return []string{
		OrderByAsc,
		OrderByDesc,
	}
}

const (
	// PolicyTypeIdentityPolicy is a PolicyType enum value
	PolicyTypeIdentityPolicy = "IDENTITY_POLICY"

	// PolicyTypeResourcePolicy is a PolicyType enum value
	PolicyTypeResourcePolicy = "RESOURCE_POLICY"

	// PolicyTypeServiceControlPolicy is a PolicyType enum value
	PolicyTypeServiceControlPolicy = "SERVICE_CONTROL_POLICY"
)

// PolicyType_Values returns all elements of the PolicyType enum
func PolicyType_Values() []string {
	return []string{
		PolicyTypeIdentityPolicy,
		PolicyTypeResourcePolicy,
		PolicyTypeServiceControlPolicy,
	}
}

const (
	// ReasonCodeAwsServiceAccessDisabled is a ReasonCode enum value
	ReasonCodeAwsServiceAccessDisabled = "AWS_SERVICE_ACCESS_DISABLED"

	// ReasonCodeDelegatedAdministratorDeregistered is a ReasonCode enum value
	ReasonCodeDelegatedAdministratorDeregistered = "DELEGATED_ADMINISTRATOR_DEREGISTERED"

	// ReasonCodeOrganizationDeleted is a ReasonCode enum value
	ReasonCodeOrganizationDeleted = "ORGANIZATION_DELETED"

	// ReasonCodeServiceLinkedRoleCreationFailed is a ReasonCode enum value
	ReasonCodeServiceLinkedRoleCreationFailed = "SERVICE_LINKED_ROLE_CREATION_FAILED"
)

// ReasonCode_Values returns all elements of the ReasonCode enum
func ReasonCode_Values() []string {
	return []string{
		ReasonCodeAwsServiceAccessDisabled,
		ReasonCodeDelegatedAdministratorDeregistered,
		ReasonCodeOrganizationDeleted,
		ReasonCodeServiceLinkedRoleCreationFailed,
	}
}

const (
	// ResourceTypeAwsS3Bucket is a ResourceType enum value
	ResourceTypeAwsS3Bucket = "AWS::S3::Bucket"

	// ResourceTypeAwsIamRole is a ResourceType enum value
	ResourceTypeAwsIamRole = "AWS::IAM::Role"

	// ResourceTypeAwsSqsQueue is a ResourceType enum value
	ResourceTypeAwsSqsQueue = "AWS::SQS::Queue"

	// ResourceTypeAwsLambdaFunction is a ResourceType enum value
	ResourceTypeAwsLambdaFunction = "AWS::Lambda::Function"

	// ResourceTypeAwsLambdaLayerVersion is a ResourceType enum value
	ResourceTypeAwsLambdaLayerVersion = "AWS::Lambda::LayerVersion"

	// ResourceTypeAwsKmsKey is a ResourceType enum value
	ResourceTypeAwsKmsKey = "AWS::KMS::Key"

	// ResourceTypeAwsSecretsManagerSecret is a ResourceType enum value
	ResourceTypeAwsSecretsManagerSecret = "AWS::SecretsManager::Secret"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAwsS3Bucket,
		ResourceTypeAwsIamRole,
		ResourceTypeAwsSqsQueue,
		ResourceTypeAwsLambdaFunction,
		ResourceTypeAwsLambdaLayerVersion,
		ResourceTypeAwsKmsKey,
		ResourceTypeAwsSecretsManagerSecret,
	}
}

const (
	// TypeAccount is a Type enum value
	TypeAccount = "ACCOUNT"

	// TypeOrganization is a Type enum value
	TypeOrganization = "ORGANIZATION"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeAccount,
		TypeOrganization,
	}
}

const (
	// ValidatePolicyFindingTypeError is a ValidatePolicyFindingType enum value
	ValidatePolicyFindingTypeError = "ERROR"

	// ValidatePolicyFindingTypeSecurityWarning is a ValidatePolicyFindingType enum value
	ValidatePolicyFindingTypeSecurityWarning = "SECURITY_WARNING"

	// ValidatePolicyFindingTypeSuggestion is a ValidatePolicyFindingType enum value
	ValidatePolicyFindingTypeSuggestion = "SUGGESTION"

	// ValidatePolicyFindingTypeWarning is a ValidatePolicyFindingType enum value
	ValidatePolicyFindingTypeWarning = "WARNING"
)

// ValidatePolicyFindingType_Values returns all elements of the ValidatePolicyFindingType enum
func ValidatePolicyFindingType_Values() []string {
	return []string{
		ValidatePolicyFindingTypeError,
		ValidatePolicyFindingTypeSecurityWarning,
		ValidatePolicyFindingTypeSuggestion,
		ValidatePolicyFindingTypeWarning,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
