// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package kendraiface provides an interface to enable mocking the AWSKendraFrontendService service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package kendraiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/kendra"
)

// KendraAPI provides an interface to enable mocking the
// kendra.Kendra service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWSKendraFrontendService.
//    func myFunc(svc kendraiface.KendraAPI) bool {
//        // Make svc.BatchDeleteDocument request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := kendra.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockKendraClient struct {
//        kendraiface.KendraAPI
//    }
//    func (m *mockKendraClient) BatchDeleteDocument(input *kendra.BatchDeleteDocumentInput) (*kendra.BatchDeleteDocumentOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockKendraClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type KendraAPI interface {
	BatchDeleteDocument(*kendra.BatchDeleteDocumentInput) (*kendra.BatchDeleteDocumentOutput, error)
	BatchDeleteDocumentWithContext(aws.Context, *kendra.BatchDeleteDocumentInput, ...request.Option) (*kendra.BatchDeleteDocumentOutput, error)
	BatchDeleteDocumentRequest(*kendra.BatchDeleteDocumentInput) (*request.Request, *kendra.BatchDeleteDocumentOutput)

	BatchGetDocumentStatus(*kendra.BatchGetDocumentStatusInput) (*kendra.BatchGetDocumentStatusOutput, error)
	BatchGetDocumentStatusWithContext(aws.Context, *kendra.BatchGetDocumentStatusInput, ...request.Option) (*kendra.BatchGetDocumentStatusOutput, error)
	BatchGetDocumentStatusRequest(*kendra.BatchGetDocumentStatusInput) (*request.Request, *kendra.BatchGetDocumentStatusOutput)

	BatchPutDocument(*kendra.BatchPutDocumentInput) (*kendra.BatchPutDocumentOutput, error)
	BatchPutDocumentWithContext(aws.Context, *kendra.BatchPutDocumentInput, ...request.Option) (*kendra.BatchPutDocumentOutput, error)
	BatchPutDocumentRequest(*kendra.BatchPutDocumentInput) (*request.Request, *kendra.BatchPutDocumentOutput)

	ClearQuerySuggestions(*kendra.ClearQuerySuggestionsInput) (*kendra.ClearQuerySuggestionsOutput, error)
	ClearQuerySuggestionsWithContext(aws.Context, *kendra.ClearQuerySuggestionsInput, ...request.Option) (*kendra.ClearQuerySuggestionsOutput, error)
	ClearQuerySuggestionsRequest(*kendra.ClearQuerySuggestionsInput) (*request.Request, *kendra.ClearQuerySuggestionsOutput)

	CreateDataSource(*kendra.CreateDataSourceInput) (*kendra.CreateDataSourceOutput, error)
	CreateDataSourceWithContext(aws.Context, *kendra.CreateDataSourceInput, ...request.Option) (*kendra.CreateDataSourceOutput, error)
	CreateDataSourceRequest(*kendra.CreateDataSourceInput) (*request.Request, *kendra.CreateDataSourceOutput)

	CreateFaq(*kendra.CreateFaqInput) (*kendra.CreateFaqOutput, error)
	CreateFaqWithContext(aws.Context, *kendra.CreateFaqInput, ...request.Option) (*kendra.CreateFaqOutput, error)
	CreateFaqRequest(*kendra.CreateFaqInput) (*request.Request, *kendra.CreateFaqOutput)

	CreateIndex(*kendra.CreateIndexInput) (*kendra.CreateIndexOutput, error)
	CreateIndexWithContext(aws.Context, *kendra.CreateIndexInput, ...request.Option) (*kendra.CreateIndexOutput, error)
	CreateIndexRequest(*kendra.CreateIndexInput) (*request.Request, *kendra.CreateIndexOutput)

	CreateQuerySuggestionsBlockList(*kendra.CreateQuerySuggestionsBlockListInput) (*kendra.CreateQuerySuggestionsBlockListOutput, error)
	CreateQuerySuggestionsBlockListWithContext(aws.Context, *kendra.CreateQuerySuggestionsBlockListInput, ...request.Option) (*kendra.CreateQuerySuggestionsBlockListOutput, error)
	CreateQuerySuggestionsBlockListRequest(*kendra.CreateQuerySuggestionsBlockListInput) (*request.Request, *kendra.CreateQuerySuggestionsBlockListOutput)

	CreateThesaurus(*kendra.CreateThesaurusInput) (*kendra.CreateThesaurusOutput, error)
	CreateThesaurusWithContext(aws.Context, *kendra.CreateThesaurusInput, ...request.Option) (*kendra.CreateThesaurusOutput, error)
	CreateThesaurusRequest(*kendra.CreateThesaurusInput) (*request.Request, *kendra.CreateThesaurusOutput)

	DeleteDataSource(*kendra.DeleteDataSourceInput) (*kendra.DeleteDataSourceOutput, error)
	DeleteDataSourceWithContext(aws.Context, *kendra.DeleteDataSourceInput, ...request.Option) (*kendra.DeleteDataSourceOutput, error)
	DeleteDataSourceRequest(*kendra.DeleteDataSourceInput) (*request.Request, *kendra.DeleteDataSourceOutput)

	DeleteFaq(*kendra.DeleteFaqInput) (*kendra.DeleteFaqOutput, error)
	DeleteFaqWithContext(aws.Context, *kendra.DeleteFaqInput, ...request.Option) (*kendra.DeleteFaqOutput, error)
	DeleteFaqRequest(*kendra.DeleteFaqInput) (*request.Request, *kendra.DeleteFaqOutput)

	DeleteIndex(*kendra.DeleteIndexInput) (*kendra.DeleteIndexOutput, error)
	DeleteIndexWithContext(aws.Context, *kendra.DeleteIndexInput, ...request.Option) (*kendra.DeleteIndexOutput, error)
	DeleteIndexRequest(*kendra.DeleteIndexInput) (*request.Request, *kendra.DeleteIndexOutput)

	DeletePrincipalMapping(*kendra.DeletePrincipalMappingInput) (*kendra.DeletePrincipalMappingOutput, error)
	DeletePrincipalMappingWithContext(aws.Context, *kendra.DeletePrincipalMappingInput, ...request.Option) (*kendra.DeletePrincipalMappingOutput, error)
	DeletePrincipalMappingRequest(*kendra.DeletePrincipalMappingInput) (*request.Request, *kendra.DeletePrincipalMappingOutput)

	DeleteQuerySuggestionsBlockList(*kendra.DeleteQuerySuggestionsBlockListInput) (*kendra.DeleteQuerySuggestionsBlockListOutput, error)
	DeleteQuerySuggestionsBlockListWithContext(aws.Context, *kendra.DeleteQuerySuggestionsBlockListInput, ...request.Option) (*kendra.DeleteQuerySuggestionsBlockListOutput, error)
	DeleteQuerySuggestionsBlockListRequest(*kendra.DeleteQuerySuggestionsBlockListInput) (*request.Request, *kendra.DeleteQuerySuggestionsBlockListOutput)

	DeleteThesaurus(*kendra.DeleteThesaurusInput) (*kendra.DeleteThesaurusOutput, error)
	DeleteThesaurusWithContext(aws.Context, *kendra.DeleteThesaurusInput, ...request.Option) (*kendra.DeleteThesaurusOutput, error)
	DeleteThesaurusRequest(*kendra.DeleteThesaurusInput) (*request.Request, *kendra.DeleteThesaurusOutput)

	DescribeDataSource(*kendra.DescribeDataSourceInput) (*kendra.DescribeDataSourceOutput, error)
	DescribeDataSourceWithContext(aws.Context, *kendra.DescribeDataSourceInput, ...request.Option) (*kendra.DescribeDataSourceOutput, error)
	DescribeDataSourceRequest(*kendra.DescribeDataSourceInput) (*request.Request, *kendra.DescribeDataSourceOutput)

	DescribeFaq(*kendra.DescribeFaqInput) (*kendra.DescribeFaqOutput, error)
	DescribeFaqWithContext(aws.Context, *kendra.DescribeFaqInput, ...request.Option) (*kendra.DescribeFaqOutput, error)
	DescribeFaqRequest(*kendra.DescribeFaqInput) (*request.Request, *kendra.DescribeFaqOutput)

	DescribeIndex(*kendra.DescribeIndexInput) (*kendra.DescribeIndexOutput, error)
	DescribeIndexWithContext(aws.Context, *kendra.DescribeIndexInput, ...request.Option) (*kendra.DescribeIndexOutput, error)
	DescribeIndexRequest(*kendra.DescribeIndexInput) (*request.Request, *kendra.DescribeIndexOutput)

	DescribePrincipalMapping(*kendra.DescribePrincipalMappingInput) (*kendra.DescribePrincipalMappingOutput, error)
	DescribePrincipalMappingWithContext(aws.Context, *kendra.DescribePrincipalMappingInput, ...request.Option) (*kendra.DescribePrincipalMappingOutput, error)
	DescribePrincipalMappingRequest(*kendra.DescribePrincipalMappingInput) (*request.Request, *kendra.DescribePrincipalMappingOutput)

	DescribeQuerySuggestionsBlockList(*kendra.DescribeQuerySuggestionsBlockListInput) (*kendra.DescribeQuerySuggestionsBlockListOutput, error)
	DescribeQuerySuggestionsBlockListWithContext(aws.Context, *kendra.DescribeQuerySuggestionsBlockListInput, ...request.Option) (*kendra.DescribeQuerySuggestionsBlockListOutput, error)
	DescribeQuerySuggestionsBlockListRequest(*kendra.DescribeQuerySuggestionsBlockListInput) (*request.Request, *kendra.DescribeQuerySuggestionsBlockListOutput)

	DescribeQuerySuggestionsConfig(*kendra.DescribeQuerySuggestionsConfigInput) (*kendra.DescribeQuerySuggestionsConfigOutput, error)
	DescribeQuerySuggestionsConfigWithContext(aws.Context, *kendra.DescribeQuerySuggestionsConfigInput, ...request.Option) (*kendra.DescribeQuerySuggestionsConfigOutput, error)
	DescribeQuerySuggestionsConfigRequest(*kendra.DescribeQuerySuggestionsConfigInput) (*request.Request, *kendra.DescribeQuerySuggestionsConfigOutput)

	DescribeThesaurus(*kendra.DescribeThesaurusInput) (*kendra.DescribeThesaurusOutput, error)
	DescribeThesaurusWithContext(aws.Context, *kendra.DescribeThesaurusInput, ...request.Option) (*kendra.DescribeThesaurusOutput, error)
	DescribeThesaurusRequest(*kendra.DescribeThesaurusInput) (*request.Request, *kendra.DescribeThesaurusOutput)

	GetQuerySuggestions(*kendra.GetQuerySuggestionsInput) (*kendra.GetQuerySuggestionsOutput, error)
	GetQuerySuggestionsWithContext(aws.Context, *kendra.GetQuerySuggestionsInput, ...request.Option) (*kendra.GetQuerySuggestionsOutput, error)
	GetQuerySuggestionsRequest(*kendra.GetQuerySuggestionsInput) (*request.Request, *kendra.GetQuerySuggestionsOutput)

	ListDataSourceSyncJobs(*kendra.ListDataSourceSyncJobsInput) (*kendra.ListDataSourceSyncJobsOutput, error)
	ListDataSourceSyncJobsWithContext(aws.Context, *kendra.ListDataSourceSyncJobsInput, ...request.Option) (*kendra.ListDataSourceSyncJobsOutput, error)
	ListDataSourceSyncJobsRequest(*kendra.ListDataSourceSyncJobsInput) (*request.Request, *kendra.ListDataSourceSyncJobsOutput)

	ListDataSourceSyncJobsPages(*kendra.ListDataSourceSyncJobsInput, func(*kendra.ListDataSourceSyncJobsOutput, bool) bool) error
	ListDataSourceSyncJobsPagesWithContext(aws.Context, *kendra.ListDataSourceSyncJobsInput, func(*kendra.ListDataSourceSyncJobsOutput, bool) bool, ...request.Option) error

	ListDataSources(*kendra.ListDataSourcesInput) (*kendra.ListDataSourcesOutput, error)
	ListDataSourcesWithContext(aws.Context, *kendra.ListDataSourcesInput, ...request.Option) (*kendra.ListDataSourcesOutput, error)
	ListDataSourcesRequest(*kendra.ListDataSourcesInput) (*request.Request, *kendra.ListDataSourcesOutput)

	ListDataSourcesPages(*kendra.ListDataSourcesInput, func(*kendra.ListDataSourcesOutput, bool) bool) error
	ListDataSourcesPagesWithContext(aws.Context, *kendra.ListDataSourcesInput, func(*kendra.ListDataSourcesOutput, bool) bool, ...request.Option) error

	ListFaqs(*kendra.ListFaqsInput) (*kendra.ListFaqsOutput, error)
	ListFaqsWithContext(aws.Context, *kendra.ListFaqsInput, ...request.Option) (*kendra.ListFaqsOutput, error)
	ListFaqsRequest(*kendra.ListFaqsInput) (*request.Request, *kendra.ListFaqsOutput)

	ListGroupsOlderThanOrderingId(*kendra.ListGroupsOlderThanOrderingIdInput) (*kendra.ListGroupsOlderThanOrderingIdOutput, error)
	ListGroupsOlderThanOrderingIdWithContext(aws.Context, *kendra.ListGroupsOlderThanOrderingIdInput, ...request.Option) (*kendra.ListGroupsOlderThanOrderingIdOutput, error)
	ListGroupsOlderThanOrderingIdRequest(*kendra.ListGroupsOlderThanOrderingIdInput) (*request.Request, *kendra.ListGroupsOlderThanOrderingIdOutput)

	ListIndices(*kendra.ListIndicesInput) (*kendra.ListIndicesOutput, error)
	ListIndicesWithContext(aws.Context, *kendra.ListIndicesInput, ...request.Option) (*kendra.ListIndicesOutput, error)
	ListIndicesRequest(*kendra.ListIndicesInput) (*request.Request, *kendra.ListIndicesOutput)

	ListIndicesPages(*kendra.ListIndicesInput, func(*kendra.ListIndicesOutput, bool) bool) error
	ListIndicesPagesWithContext(aws.Context, *kendra.ListIndicesInput, func(*kendra.ListIndicesOutput, bool) bool, ...request.Option) error

	ListQuerySuggestionsBlockLists(*kendra.ListQuerySuggestionsBlockListsInput) (*kendra.ListQuerySuggestionsBlockListsOutput, error)
	ListQuerySuggestionsBlockListsWithContext(aws.Context, *kendra.ListQuerySuggestionsBlockListsInput, ...request.Option) (*kendra.ListQuerySuggestionsBlockListsOutput, error)
	ListQuerySuggestionsBlockListsRequest(*kendra.ListQuerySuggestionsBlockListsInput) (*request.Request, *kendra.ListQuerySuggestionsBlockListsOutput)

	ListTagsForResource(*kendra.ListTagsForResourceInput) (*kendra.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *kendra.ListTagsForResourceInput, ...request.Option) (*kendra.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*kendra.ListTagsForResourceInput) (*request.Request, *kendra.ListTagsForResourceOutput)

	ListThesauri(*kendra.ListThesauriInput) (*kendra.ListThesauriOutput, error)
	ListThesauriWithContext(aws.Context, *kendra.ListThesauriInput, ...request.Option) (*kendra.ListThesauriOutput, error)
	ListThesauriRequest(*kendra.ListThesauriInput) (*request.Request, *kendra.ListThesauriOutput)

	PutPrincipalMapping(*kendra.PutPrincipalMappingInput) (*kendra.PutPrincipalMappingOutput, error)
	PutPrincipalMappingWithContext(aws.Context, *kendra.PutPrincipalMappingInput, ...request.Option) (*kendra.PutPrincipalMappingOutput, error)
	PutPrincipalMappingRequest(*kendra.PutPrincipalMappingInput) (*request.Request, *kendra.PutPrincipalMappingOutput)

	Query(*kendra.QueryInput) (*kendra.QueryOutput, error)
	QueryWithContext(aws.Context, *kendra.QueryInput, ...request.Option) (*kendra.QueryOutput, error)
	QueryRequest(*kendra.QueryInput) (*request.Request, *kendra.QueryOutput)

	StartDataSourceSyncJob(*kendra.StartDataSourceSyncJobInput) (*kendra.StartDataSourceSyncJobOutput, error)
	StartDataSourceSyncJobWithContext(aws.Context, *kendra.StartDataSourceSyncJobInput, ...request.Option) (*kendra.StartDataSourceSyncJobOutput, error)
	StartDataSourceSyncJobRequest(*kendra.StartDataSourceSyncJobInput) (*request.Request, *kendra.StartDataSourceSyncJobOutput)

	StopDataSourceSyncJob(*kendra.StopDataSourceSyncJobInput) (*kendra.StopDataSourceSyncJobOutput, error)
	StopDataSourceSyncJobWithContext(aws.Context, *kendra.StopDataSourceSyncJobInput, ...request.Option) (*kendra.StopDataSourceSyncJobOutput, error)
	StopDataSourceSyncJobRequest(*kendra.StopDataSourceSyncJobInput) (*request.Request, *kendra.StopDataSourceSyncJobOutput)

	SubmitFeedback(*kendra.SubmitFeedbackInput) (*kendra.SubmitFeedbackOutput, error)
	SubmitFeedbackWithContext(aws.Context, *kendra.SubmitFeedbackInput, ...request.Option) (*kendra.SubmitFeedbackOutput, error)
	SubmitFeedbackRequest(*kendra.SubmitFeedbackInput) (*request.Request, *kendra.SubmitFeedbackOutput)

	TagResource(*kendra.TagResourceInput) (*kendra.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *kendra.TagResourceInput, ...request.Option) (*kendra.TagResourceOutput, error)
	TagResourceRequest(*kendra.TagResourceInput) (*request.Request, *kendra.TagResourceOutput)

	UntagResource(*kendra.UntagResourceInput) (*kendra.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *kendra.UntagResourceInput, ...request.Option) (*kendra.UntagResourceOutput, error)
	UntagResourceRequest(*kendra.UntagResourceInput) (*request.Request, *kendra.UntagResourceOutput)

	UpdateDataSource(*kendra.UpdateDataSourceInput) (*kendra.UpdateDataSourceOutput, error)
	UpdateDataSourceWithContext(aws.Context, *kendra.UpdateDataSourceInput, ...request.Option) (*kendra.UpdateDataSourceOutput, error)
	UpdateDataSourceRequest(*kendra.UpdateDataSourceInput) (*request.Request, *kendra.UpdateDataSourceOutput)

	UpdateIndex(*kendra.UpdateIndexInput) (*kendra.UpdateIndexOutput, error)
	UpdateIndexWithContext(aws.Context, *kendra.UpdateIndexInput, ...request.Option) (*kendra.UpdateIndexOutput, error)
	UpdateIndexRequest(*kendra.UpdateIndexInput) (*request.Request, *kendra.UpdateIndexOutput)

	UpdateQuerySuggestionsBlockList(*kendra.UpdateQuerySuggestionsBlockListInput) (*kendra.UpdateQuerySuggestionsBlockListOutput, error)
	UpdateQuerySuggestionsBlockListWithContext(aws.Context, *kendra.UpdateQuerySuggestionsBlockListInput, ...request.Option) (*kendra.UpdateQuerySuggestionsBlockListOutput, error)
	UpdateQuerySuggestionsBlockListRequest(*kendra.UpdateQuerySuggestionsBlockListInput) (*request.Request, *kendra.UpdateQuerySuggestionsBlockListOutput)

	UpdateQuerySuggestionsConfig(*kendra.UpdateQuerySuggestionsConfigInput) (*kendra.UpdateQuerySuggestionsConfigOutput, error)
	UpdateQuerySuggestionsConfigWithContext(aws.Context, *kendra.UpdateQuerySuggestionsConfigInput, ...request.Option) (*kendra.UpdateQuerySuggestionsConfigOutput, error)
	UpdateQuerySuggestionsConfigRequest(*kendra.UpdateQuerySuggestionsConfigInput) (*request.Request, *kendra.UpdateQuerySuggestionsConfigOutput)

	UpdateThesaurus(*kendra.UpdateThesaurusInput) (*kendra.UpdateThesaurusOutput, error)
	UpdateThesaurusWithContext(aws.Context, *kendra.UpdateThesaurusInput, ...request.Option) (*kendra.UpdateThesaurusOutput, error)
	UpdateThesaurusRequest(*kendra.UpdateThesaurusInput) (*request.Request, *kendra.UpdateThesaurusOutput)
}

var _ KendraAPI = (*kendra.Kendra)(nil)
