// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wellarchitected

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateLenses = "AssociateLenses"

// AssociateLensesRequest generates a "aws/request.Request" representing the
// client's request for the AssociateLenses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateLenses for more information on using the AssociateLenses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateLensesRequest method.
//    req, resp := client.AssociateLensesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses
func (c *WellArchitected) AssociateLensesRequest(input *AssociateLensesInput) (req *request.Request, output *AssociateLensesOutput) {
	op := &request.Operation{
		Name:       opAssociateLenses,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/associateLenses",
	}

	if input == nil {
		input = &AssociateLensesInput{}
	}

	output = &AssociateLensesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateLenses API operation for AWS Well-Architected Tool.
//
// Associate a lens to a workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation AssociateLenses for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses
func (c *WellArchitected) AssociateLenses(input *AssociateLensesInput) (*AssociateLensesOutput, error) {
	req, out := c.AssociateLensesRequest(input)
	return out, req.Send()
}

// AssociateLensesWithContext is the same as AssociateLenses with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateLenses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) AssociateLensesWithContext(ctx aws.Context, input *AssociateLensesInput, opts ...request.Option) (*AssociateLensesOutput, error) {
	req, out := c.AssociateLensesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMilestone = "CreateMilestone"

// CreateMilestoneRequest generates a "aws/request.Request" representing the
// client's request for the CreateMilestone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMilestone for more information on using the CreateMilestone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMilestoneRequest method.
//    req, resp := client.CreateMilestoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone
func (c *WellArchitected) CreateMilestoneRequest(input *CreateMilestoneInput) (req *request.Request, output *CreateMilestoneOutput) {
	op := &request.Operation{
		Name:       opCreateMilestone,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/milestones",
	}

	if input == nil {
		input = &CreateMilestoneInput{}
	}

	output = &CreateMilestoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMilestone API operation for AWS Well-Architected Tool.
//
// Create a milestone for an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateMilestone for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ServiceQuotaExceededException
//   The user has reached their resource quota.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone
func (c *WellArchitected) CreateMilestone(input *CreateMilestoneInput) (*CreateMilestoneOutput, error) {
	req, out := c.CreateMilestoneRequest(input)
	return out, req.Send()
}

// CreateMilestoneWithContext is the same as CreateMilestone with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMilestone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateMilestoneWithContext(ctx aws.Context, input *CreateMilestoneInput, opts ...request.Option) (*CreateMilestoneOutput, error) {
	req, out := c.CreateMilestoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkload = "CreateWorkload"

// CreateWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkload for more information on using the CreateWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkloadRequest method.
//    req, resp := client.CreateWorkloadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload
func (c *WellArchitected) CreateWorkloadRequest(input *CreateWorkloadInput) (req *request.Request, output *CreateWorkloadOutput) {
	op := &request.Operation{
		Name:       opCreateWorkload,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads",
	}

	if input == nil {
		input = &CreateWorkloadInput{}
	}

	output = &CreateWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkload API operation for AWS Well-Architected Tool.
//
// Create a new workload.
//
// The owner of a workload can share the workload with other AWS accounts and
// IAM users in the same AWS Region. Only the owner of a workload can delete
// it.
//
// For more information, see Defining a Workload (https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html)
// in the AWS Well-Architected Tool User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateWorkload for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ConflictException
//   The resource already exists.
//
//   * ServiceQuotaExceededException
//   The user has reached their resource quota.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload
func (c *WellArchitected) CreateWorkload(input *CreateWorkloadInput) (*CreateWorkloadOutput, error) {
	req, out := c.CreateWorkloadRequest(input)
	return out, req.Send()
}

// CreateWorkloadWithContext is the same as CreateWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateWorkloadWithContext(ctx aws.Context, input *CreateWorkloadInput, opts ...request.Option) (*CreateWorkloadOutput, error) {
	req, out := c.CreateWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkloadShare = "CreateWorkloadShare"

// CreateWorkloadShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkloadShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkloadShare for more information on using the CreateWorkloadShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkloadShareRequest method.
//    req, resp := client.CreateWorkloadShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare
func (c *WellArchitected) CreateWorkloadShareRequest(input *CreateWorkloadShareInput) (req *request.Request, output *CreateWorkloadShareOutput) {
	op := &request.Operation{
		Name:       opCreateWorkloadShare,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/shares",
	}

	if input == nil {
		input = &CreateWorkloadShareInput{}
	}

	output = &CreateWorkloadShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkloadShare API operation for AWS Well-Architected Tool.
//
// Create a workload share.
//
// The owner of a workload can share it with other AWS accounts and IAM users
// in the same AWS Region. Shared access to a workload is not removed until
// the workload invitation is deleted.
//
// For more information, see Sharing a Workload (https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html)
// in the AWS Well-Architected Tool User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateWorkloadShare for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ServiceQuotaExceededException
//   The user has reached their resource quota.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare
func (c *WellArchitected) CreateWorkloadShare(input *CreateWorkloadShareInput) (*CreateWorkloadShareOutput, error) {
	req, out := c.CreateWorkloadShareRequest(input)
	return out, req.Send()
}

// CreateWorkloadShareWithContext is the same as CreateWorkloadShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkloadShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateWorkloadShareWithContext(ctx aws.Context, input *CreateWorkloadShareInput, opts ...request.Option) (*CreateWorkloadShareOutput, error) {
	req, out := c.CreateWorkloadShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkload = "DeleteWorkload"

// DeleteWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkload for more information on using the DeleteWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkloadRequest method.
//    req, resp := client.DeleteWorkloadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload
func (c *WellArchitected) DeleteWorkloadRequest(input *DeleteWorkloadInput) (req *request.Request, output *DeleteWorkloadOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workloads/{WorkloadId}",
	}

	if input == nil {
		input = &DeleteWorkloadInput{}
	}

	output = &DeleteWorkloadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkload API operation for AWS Well-Architected Tool.
//
// Delete an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteWorkload for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload
func (c *WellArchitected) DeleteWorkload(input *DeleteWorkloadInput) (*DeleteWorkloadOutput, error) {
	req, out := c.DeleteWorkloadRequest(input)
	return out, req.Send()
}

// DeleteWorkloadWithContext is the same as DeleteWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteWorkloadWithContext(ctx aws.Context, input *DeleteWorkloadInput, opts ...request.Option) (*DeleteWorkloadOutput, error) {
	req, out := c.DeleteWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkloadShare = "DeleteWorkloadShare"

// DeleteWorkloadShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkloadShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkloadShare for more information on using the DeleteWorkloadShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkloadShareRequest method.
//    req, resp := client.DeleteWorkloadShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare
func (c *WellArchitected) DeleteWorkloadShareRequest(input *DeleteWorkloadShareInput) (req *request.Request, output *DeleteWorkloadShareOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkloadShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workloads/{WorkloadId}/shares/{ShareId}",
	}

	if input == nil {
		input = &DeleteWorkloadShareInput{}
	}

	output = &DeleteWorkloadShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkloadShare API operation for AWS Well-Architected Tool.
//
// Delete a workload share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteWorkloadShare for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare
func (c *WellArchitected) DeleteWorkloadShare(input *DeleteWorkloadShareInput) (*DeleteWorkloadShareOutput, error) {
	req, out := c.DeleteWorkloadShareRequest(input)
	return out, req.Send()
}

// DeleteWorkloadShareWithContext is the same as DeleteWorkloadShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkloadShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteWorkloadShareWithContext(ctx aws.Context, input *DeleteWorkloadShareInput, opts ...request.Option) (*DeleteWorkloadShareOutput, error) {
	req, out := c.DeleteWorkloadShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateLenses = "DisassociateLenses"

// DisassociateLensesRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateLenses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateLenses for more information on using the DisassociateLenses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateLensesRequest method.
//    req, resp := client.DisassociateLensesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses
func (c *WellArchitected) DisassociateLensesRequest(input *DisassociateLensesInput) (req *request.Request, output *DisassociateLensesOutput) {
	op := &request.Operation{
		Name:       opDisassociateLenses,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/disassociateLenses",
	}

	if input == nil {
		input = &DisassociateLensesInput{}
	}

	output = &DisassociateLensesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateLenses API operation for AWS Well-Architected Tool.
//
// Disassociate a lens from a workload.
//
// The AWS Well-Architected Framework lens (wellarchitected) cannot be removed
// from a workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DisassociateLenses for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses
func (c *WellArchitected) DisassociateLenses(input *DisassociateLensesInput) (*DisassociateLensesOutput, error) {
	req, out := c.DisassociateLensesRequest(input)
	return out, req.Send()
}

// DisassociateLensesWithContext is the same as DisassociateLenses with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateLenses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DisassociateLensesWithContext(ctx aws.Context, input *DisassociateLensesInput, opts ...request.Option) (*DisassociateLensesOutput, error) {
	req, out := c.DisassociateLensesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnswer = "GetAnswer"

// GetAnswerRequest generates a "aws/request.Request" representing the
// client's request for the GetAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnswer for more information on using the GetAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnswerRequest method.
//    req, resp := client.GetAnswerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer
func (c *WellArchitected) GetAnswerRequest(input *GetAnswerInput) (req *request.Request, output *GetAnswerOutput) {
	op := &request.Operation{
		Name:       opGetAnswer,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
	}

	if input == nil {
		input = &GetAnswerInput{}
	}

	output = &GetAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnswer API operation for AWS Well-Architected Tool.
//
// Get the answer to a specific question in a workload review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetAnswer for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer
func (c *WellArchitected) GetAnswer(input *GetAnswerInput) (*GetAnswerOutput, error) {
	req, out := c.GetAnswerRequest(input)
	return out, req.Send()
}

// GetAnswerWithContext is the same as GetAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetAnswerWithContext(ctx aws.Context, input *GetAnswerInput, opts ...request.Option) (*GetAnswerOutput, error) {
	req, out := c.GetAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLensReview = "GetLensReview"

// GetLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the GetLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLensReview for more information on using the GetLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLensReviewRequest method.
//    req, resp := client.GetLensReviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview
func (c *WellArchitected) GetLensReviewRequest(input *GetLensReviewInput) (req *request.Request, output *GetLensReviewOutput) {
	op := &request.Operation{
		Name:       opGetLensReview,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
	}

	if input == nil {
		input = &GetLensReviewInput{}
	}

	output = &GetLensReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLensReview API operation for AWS Well-Architected Tool.
//
// Get lens review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLensReview for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview
func (c *WellArchitected) GetLensReview(input *GetLensReviewInput) (*GetLensReviewOutput, error) {
	req, out := c.GetLensReviewRequest(input)
	return out, req.Send()
}

// GetLensReviewWithContext is the same as GetLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See GetLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensReviewWithContext(ctx aws.Context, input *GetLensReviewInput, opts ...request.Option) (*GetLensReviewOutput, error) {
	req, out := c.GetLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLensReviewReport = "GetLensReviewReport"

// GetLensReviewReportRequest generates a "aws/request.Request" representing the
// client's request for the GetLensReviewReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLensReviewReport for more information on using the GetLensReviewReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLensReviewReportRequest method.
//    req, resp := client.GetLensReviewReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport
func (c *WellArchitected) GetLensReviewReportRequest(input *GetLensReviewReportInput) (req *request.Request, output *GetLensReviewReportOutput) {
	op := &request.Operation{
		Name:       opGetLensReviewReport,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/report",
	}

	if input == nil {
		input = &GetLensReviewReportInput{}
	}

	output = &GetLensReviewReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLensReviewReport API operation for AWS Well-Architected Tool.
//
// Get lens review report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLensReviewReport for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport
func (c *WellArchitected) GetLensReviewReport(input *GetLensReviewReportInput) (*GetLensReviewReportOutput, error) {
	req, out := c.GetLensReviewReportRequest(input)
	return out, req.Send()
}

// GetLensReviewReportWithContext is the same as GetLensReviewReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetLensReviewReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensReviewReportWithContext(ctx aws.Context, input *GetLensReviewReportInput, opts ...request.Option) (*GetLensReviewReportOutput, error) {
	req, out := c.GetLensReviewReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLensVersionDifference = "GetLensVersionDifference"

// GetLensVersionDifferenceRequest generates a "aws/request.Request" representing the
// client's request for the GetLensVersionDifference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLensVersionDifference for more information on using the GetLensVersionDifference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLensVersionDifferenceRequest method.
//    req, resp := client.GetLensVersionDifferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference
func (c *WellArchitected) GetLensVersionDifferenceRequest(input *GetLensVersionDifferenceInput) (req *request.Request, output *GetLensVersionDifferenceOutput) {
	op := &request.Operation{
		Name:       opGetLensVersionDifference,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses/{LensAlias}/versionDifference",
	}

	if input == nil {
		input = &GetLensVersionDifferenceInput{}
	}

	output = &GetLensVersionDifferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLensVersionDifference API operation for AWS Well-Architected Tool.
//
// Get lens version differences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLensVersionDifference for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference
func (c *WellArchitected) GetLensVersionDifference(input *GetLensVersionDifferenceInput) (*GetLensVersionDifferenceOutput, error) {
	req, out := c.GetLensVersionDifferenceRequest(input)
	return out, req.Send()
}

// GetLensVersionDifferenceWithContext is the same as GetLensVersionDifference with the addition of
// the ability to pass a context and additional request options.
//
// See GetLensVersionDifference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensVersionDifferenceWithContext(ctx aws.Context, input *GetLensVersionDifferenceInput, opts ...request.Option) (*GetLensVersionDifferenceOutput, error) {
	req, out := c.GetLensVersionDifferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMilestone = "GetMilestone"

// GetMilestoneRequest generates a "aws/request.Request" representing the
// client's request for the GetMilestone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMilestone for more information on using the GetMilestone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMilestoneRequest method.
//    req, resp := client.GetMilestoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone
func (c *WellArchitected) GetMilestoneRequest(input *GetMilestoneInput) (req *request.Request, output *GetMilestoneOutput) {
	op := &request.Operation{
		Name:       opGetMilestone,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/milestones/{MilestoneNumber}",
	}

	if input == nil {
		input = &GetMilestoneInput{}
	}

	output = &GetMilestoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMilestone API operation for AWS Well-Architected Tool.
//
// Get a milestone for an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetMilestone for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone
func (c *WellArchitected) GetMilestone(input *GetMilestoneInput) (*GetMilestoneOutput, error) {
	req, out := c.GetMilestoneRequest(input)
	return out, req.Send()
}

// GetMilestoneWithContext is the same as GetMilestone with the addition of
// the ability to pass a context and additional request options.
//
// See GetMilestone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetMilestoneWithContext(ctx aws.Context, input *GetMilestoneInput, opts ...request.Option) (*GetMilestoneOutput, error) {
	req, out := c.GetMilestoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkload = "GetWorkload"

// GetWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkload for more information on using the GetWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkloadRequest method.
//    req, resp := client.GetWorkloadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload
func (c *WellArchitected) GetWorkloadRequest(input *GetWorkloadInput) (req *request.Request, output *GetWorkloadOutput) {
	op := &request.Operation{
		Name:       opGetWorkload,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}",
	}

	if input == nil {
		input = &GetWorkloadInput{}
	}

	output = &GetWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkload API operation for AWS Well-Architected Tool.
//
// Get an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetWorkload for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload
func (c *WellArchitected) GetWorkload(input *GetWorkloadInput) (*GetWorkloadOutput, error) {
	req, out := c.GetWorkloadRequest(input)
	return out, req.Send()
}

// GetWorkloadWithContext is the same as GetWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetWorkloadWithContext(ctx aws.Context, input *GetWorkloadInput, opts ...request.Option) (*GetWorkloadOutput, error) {
	req, out := c.GetWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnswers = "ListAnswers"

// ListAnswersRequest generates a "aws/request.Request" representing the
// client's request for the ListAnswers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnswers for more information on using the ListAnswers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnswersRequest method.
//    req, resp := client.ListAnswersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers
func (c *WellArchitected) ListAnswersRequest(input *ListAnswersInput) (req *request.Request, output *ListAnswersOutput) {
	op := &request.Operation{
		Name:       opListAnswers,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnswersInput{}
	}

	output = &ListAnswersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnswers API operation for AWS Well-Architected Tool.
//
// List of answers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListAnswers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers
func (c *WellArchitected) ListAnswers(input *ListAnswersInput) (*ListAnswersOutput, error) {
	req, out := c.ListAnswersRequest(input)
	return out, req.Send()
}

// ListAnswersWithContext is the same as ListAnswers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnswers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListAnswersWithContext(ctx aws.Context, input *ListAnswersInput, opts ...request.Option) (*ListAnswersOutput, error) {
	req, out := c.ListAnswersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnswersPages iterates over the pages of a ListAnswers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnswers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnswers operation.
//    pageNum := 0
//    err := client.ListAnswersPages(params,
//        func(page *wellarchitected.ListAnswersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListAnswersPages(input *ListAnswersInput, fn func(*ListAnswersOutput, bool) bool) error {
	return c.ListAnswersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnswersPagesWithContext same as ListAnswersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListAnswersPagesWithContext(ctx aws.Context, input *ListAnswersInput, fn func(*ListAnswersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnswersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnswersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnswersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLensReviewImprovements = "ListLensReviewImprovements"

// ListLensReviewImprovementsRequest generates a "aws/request.Request" representing the
// client's request for the ListLensReviewImprovements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLensReviewImprovements for more information on using the ListLensReviewImprovements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLensReviewImprovementsRequest method.
//    req, resp := client.ListLensReviewImprovementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements
func (c *WellArchitected) ListLensReviewImprovementsRequest(input *ListLensReviewImprovementsInput) (req *request.Request, output *ListLensReviewImprovementsOutput) {
	op := &request.Operation{
		Name:       opListLensReviewImprovements,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/improvements",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensReviewImprovementsInput{}
	}

	output = &ListLensReviewImprovementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLensReviewImprovements API operation for AWS Well-Architected Tool.
//
// List lens review improvements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLensReviewImprovements for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements
func (c *WellArchitected) ListLensReviewImprovements(input *ListLensReviewImprovementsInput) (*ListLensReviewImprovementsOutput, error) {
	req, out := c.ListLensReviewImprovementsRequest(input)
	return out, req.Send()
}

// ListLensReviewImprovementsWithContext is the same as ListLensReviewImprovements with the addition of
// the ability to pass a context and additional request options.
//
// See ListLensReviewImprovements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewImprovementsWithContext(ctx aws.Context, input *ListLensReviewImprovementsInput, opts ...request.Option) (*ListLensReviewImprovementsOutput, error) {
	req, out := c.ListLensReviewImprovementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensReviewImprovementsPages iterates over the pages of a ListLensReviewImprovements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLensReviewImprovements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLensReviewImprovements operation.
//    pageNum := 0
//    err := client.ListLensReviewImprovementsPages(params,
//        func(page *wellarchitected.ListLensReviewImprovementsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListLensReviewImprovementsPages(input *ListLensReviewImprovementsInput, fn func(*ListLensReviewImprovementsOutput, bool) bool) error {
	return c.ListLensReviewImprovementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensReviewImprovementsPagesWithContext same as ListLensReviewImprovementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewImprovementsPagesWithContext(ctx aws.Context, input *ListLensReviewImprovementsInput, fn func(*ListLensReviewImprovementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensReviewImprovementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensReviewImprovementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensReviewImprovementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLensReviews = "ListLensReviews"

// ListLensReviewsRequest generates a "aws/request.Request" representing the
// client's request for the ListLensReviews operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLensReviews for more information on using the ListLensReviews
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLensReviewsRequest method.
//    req, resp := client.ListLensReviewsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews
func (c *WellArchitected) ListLensReviewsRequest(input *ListLensReviewsInput) (req *request.Request, output *ListLensReviewsOutput) {
	op := &request.Operation{
		Name:       opListLensReviews,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensReviewsInput{}
	}

	output = &ListLensReviewsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLensReviews API operation for AWS Well-Architected Tool.
//
// List lens reviews.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLensReviews for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews
func (c *WellArchitected) ListLensReviews(input *ListLensReviewsInput) (*ListLensReviewsOutput, error) {
	req, out := c.ListLensReviewsRequest(input)
	return out, req.Send()
}

// ListLensReviewsWithContext is the same as ListLensReviews with the addition of
// the ability to pass a context and additional request options.
//
// See ListLensReviews for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewsWithContext(ctx aws.Context, input *ListLensReviewsInput, opts ...request.Option) (*ListLensReviewsOutput, error) {
	req, out := c.ListLensReviewsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensReviewsPages iterates over the pages of a ListLensReviews operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLensReviews method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLensReviews operation.
//    pageNum := 0
//    err := client.ListLensReviewsPages(params,
//        func(page *wellarchitected.ListLensReviewsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListLensReviewsPages(input *ListLensReviewsInput, fn func(*ListLensReviewsOutput, bool) bool) error {
	return c.ListLensReviewsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensReviewsPagesWithContext same as ListLensReviewsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewsPagesWithContext(ctx aws.Context, input *ListLensReviewsInput, fn func(*ListLensReviewsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensReviewsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensReviewsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensReviewsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLenses = "ListLenses"

// ListLensesRequest generates a "aws/request.Request" representing the
// client's request for the ListLenses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLenses for more information on using the ListLenses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLensesRequest method.
//    req, resp := client.ListLensesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses
func (c *WellArchitected) ListLensesRequest(input *ListLensesInput) (req *request.Request, output *ListLensesOutput) {
	op := &request.Operation{
		Name:       opListLenses,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensesInput{}
	}

	output = &ListLensesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLenses API operation for AWS Well-Architected Tool.
//
// List the available lenses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLenses for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses
func (c *WellArchitected) ListLenses(input *ListLensesInput) (*ListLensesOutput, error) {
	req, out := c.ListLensesRequest(input)
	return out, req.Send()
}

// ListLensesWithContext is the same as ListLenses with the addition of
// the ability to pass a context and additional request options.
//
// See ListLenses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensesWithContext(ctx aws.Context, input *ListLensesInput, opts ...request.Option) (*ListLensesOutput, error) {
	req, out := c.ListLensesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensesPages iterates over the pages of a ListLenses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLenses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLenses operation.
//    pageNum := 0
//    err := client.ListLensesPages(params,
//        func(page *wellarchitected.ListLensesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListLensesPages(input *ListLensesInput, fn func(*ListLensesOutput, bool) bool) error {
	return c.ListLensesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensesPagesWithContext same as ListLensesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensesPagesWithContext(ctx aws.Context, input *ListLensesInput, fn func(*ListLensesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMilestones = "ListMilestones"

// ListMilestonesRequest generates a "aws/request.Request" representing the
// client's request for the ListMilestones operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMilestones for more information on using the ListMilestones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMilestonesRequest method.
//    req, resp := client.ListMilestonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones
func (c *WellArchitected) ListMilestonesRequest(input *ListMilestonesInput) (req *request.Request, output *ListMilestonesOutput) {
	op := &request.Operation{
		Name:       opListMilestones,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/milestonesSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMilestonesInput{}
	}

	output = &ListMilestonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMilestones API operation for AWS Well-Architected Tool.
//
// List all milestones for an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListMilestones for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones
func (c *WellArchitected) ListMilestones(input *ListMilestonesInput) (*ListMilestonesOutput, error) {
	req, out := c.ListMilestonesRequest(input)
	return out, req.Send()
}

// ListMilestonesWithContext is the same as ListMilestones with the addition of
// the ability to pass a context and additional request options.
//
// See ListMilestones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListMilestonesWithContext(ctx aws.Context, input *ListMilestonesInput, opts ...request.Option) (*ListMilestonesOutput, error) {
	req, out := c.ListMilestonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMilestonesPages iterates over the pages of a ListMilestones operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMilestones method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMilestones operation.
//    pageNum := 0
//    err := client.ListMilestonesPages(params,
//        func(page *wellarchitected.ListMilestonesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListMilestonesPages(input *ListMilestonesInput, fn func(*ListMilestonesOutput, bool) bool) error {
	return c.ListMilestonesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMilestonesPagesWithContext same as ListMilestonesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListMilestonesPagesWithContext(ctx aws.Context, input *ListMilestonesInput, fn func(*ListMilestonesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMilestonesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMilestonesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMilestonesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotifications = "ListNotifications"

// ListNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotifications for more information on using the ListNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotificationsRequest method.
//    req, resp := client.ListNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications
func (c *WellArchitected) ListNotificationsRequest(input *ListNotificationsInput) (req *request.Request, output *ListNotificationsOutput) {
	op := &request.Operation{
		Name:       opListNotifications,
		HTTPMethod: "POST",
		HTTPPath:   "/notifications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationsInput{}
	}

	output = &ListNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotifications API operation for AWS Well-Architected Tool.
//
// List lens notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListNotifications for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications
func (c *WellArchitected) ListNotifications(input *ListNotificationsInput) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	return out, req.Send()
}

// ListNotificationsWithContext is the same as ListNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListNotificationsWithContext(ctx aws.Context, input *ListNotificationsInput, opts ...request.Option) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationsPages iterates over the pages of a ListNotifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotifications operation.
//    pageNum := 0
//    err := client.ListNotificationsPages(params,
//        func(page *wellarchitected.ListNotificationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListNotificationsPages(input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool) error {
	return c.ListNotificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationsPagesWithContext same as ListNotificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListNotificationsPagesWithContext(ctx aws.Context, input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListShareInvitations = "ListShareInvitations"

// ListShareInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListShareInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListShareInvitations for more information on using the ListShareInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListShareInvitationsRequest method.
//    req, resp := client.ListShareInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations
func (c *WellArchitected) ListShareInvitationsRequest(input *ListShareInvitationsInput) (req *request.Request, output *ListShareInvitationsOutput) {
	op := &request.Operation{
		Name:       opListShareInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/shareInvitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListShareInvitationsInput{}
	}

	output = &ListShareInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListShareInvitations API operation for AWS Well-Architected Tool.
//
// List the workload invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListShareInvitations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations
func (c *WellArchitected) ListShareInvitations(input *ListShareInvitationsInput) (*ListShareInvitationsOutput, error) {
	req, out := c.ListShareInvitationsRequest(input)
	return out, req.Send()
}

// ListShareInvitationsWithContext is the same as ListShareInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListShareInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListShareInvitationsWithContext(ctx aws.Context, input *ListShareInvitationsInput, opts ...request.Option) (*ListShareInvitationsOutput, error) {
	req, out := c.ListShareInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListShareInvitationsPages iterates over the pages of a ListShareInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListShareInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListShareInvitations operation.
//    pageNum := 0
//    err := client.ListShareInvitationsPages(params,
//        func(page *wellarchitected.ListShareInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListShareInvitationsPages(input *ListShareInvitationsInput, fn func(*ListShareInvitationsOutput, bool) bool) error {
	return c.ListShareInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListShareInvitationsPagesWithContext same as ListShareInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListShareInvitationsPagesWithContext(ctx aws.Context, input *ListShareInvitationsInput, fn func(*ListShareInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListShareInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListShareInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListShareInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource
func (c *WellArchitected) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{WorkloadArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Well-Architected Tool.
//
// List the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource
func (c *WellArchitected) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkloadShares = "ListWorkloadShares"

// ListWorkloadSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkloadShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkloadShares for more information on using the ListWorkloadShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkloadSharesRequest method.
//    req, resp := client.ListWorkloadSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares
func (c *WellArchitected) ListWorkloadSharesRequest(input *ListWorkloadSharesInput) (req *request.Request, output *ListWorkloadSharesOutput) {
	op := &request.Operation{
		Name:       opListWorkloadShares,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/shares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkloadSharesInput{}
	}

	output = &ListWorkloadSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkloadShares API operation for AWS Well-Architected Tool.
//
// List the workload shares associated with the workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListWorkloadShares for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares
func (c *WellArchitected) ListWorkloadShares(input *ListWorkloadSharesInput) (*ListWorkloadSharesOutput, error) {
	req, out := c.ListWorkloadSharesRequest(input)
	return out, req.Send()
}

// ListWorkloadSharesWithContext is the same as ListWorkloadShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkloadShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadSharesWithContext(ctx aws.Context, input *ListWorkloadSharesInput, opts ...request.Option) (*ListWorkloadSharesOutput, error) {
	req, out := c.ListWorkloadSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkloadSharesPages iterates over the pages of a ListWorkloadShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkloadShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkloadShares operation.
//    pageNum := 0
//    err := client.ListWorkloadSharesPages(params,
//        func(page *wellarchitected.ListWorkloadSharesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListWorkloadSharesPages(input *ListWorkloadSharesInput, fn func(*ListWorkloadSharesOutput, bool) bool) error {
	return c.ListWorkloadSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkloadSharesPagesWithContext same as ListWorkloadSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadSharesPagesWithContext(ctx aws.Context, input *ListWorkloadSharesInput, fn func(*ListWorkloadSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkloadSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkloadSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkloadSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkloads = "ListWorkloads"

// ListWorkloadsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkloads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkloads for more information on using the ListWorkloads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkloadsRequest method.
//    req, resp := client.ListWorkloadsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads
func (c *WellArchitected) ListWorkloadsRequest(input *ListWorkloadsInput) (req *request.Request, output *ListWorkloadsOutput) {
	op := &request.Operation{
		Name:       opListWorkloads,
		HTTPMethod: "POST",
		HTTPPath:   "/workloadsSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkloadsInput{}
	}

	output = &ListWorkloadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkloads API operation for AWS Well-Architected Tool.
//
// List workloads. Paginated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListWorkloads for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads
func (c *WellArchitected) ListWorkloads(input *ListWorkloadsInput) (*ListWorkloadsOutput, error) {
	req, out := c.ListWorkloadsRequest(input)
	return out, req.Send()
}

// ListWorkloadsWithContext is the same as ListWorkloads with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkloads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadsWithContext(ctx aws.Context, input *ListWorkloadsInput, opts ...request.Option) (*ListWorkloadsOutput, error) {
	req, out := c.ListWorkloadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkloadsPages iterates over the pages of a ListWorkloads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkloads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkloads operation.
//    pageNum := 0
//    err := client.ListWorkloadsPages(params,
//        func(page *wellarchitected.ListWorkloadsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WellArchitected) ListWorkloadsPages(input *ListWorkloadsInput, fn func(*ListWorkloadsOutput, bool) bool) error {
	return c.ListWorkloadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkloadsPagesWithContext same as ListWorkloadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadsPagesWithContext(ctx aws.Context, input *ListWorkloadsInput, fn func(*ListWorkloadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkloadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkloadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkloadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource
func (c *WellArchitected) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{WorkloadArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Well-Architected Tool.
//
// Adds one or more tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource
func (c *WellArchitected) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource
func (c *WellArchitected) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{WorkloadArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Well-Architected Tool.
//
// Deletes specified tags from a resource.
//
// To specify multiple tags, use separate tagKeys parameters, for example:
//
// DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource
func (c *WellArchitected) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnswer = "UpdateAnswer"

// UpdateAnswerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnswer for more information on using the UpdateAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAnswerRequest method.
//    req, resp := client.UpdateAnswerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer
func (c *WellArchitected) UpdateAnswerRequest(input *UpdateAnswerInput) (req *request.Request, output *UpdateAnswerOutput) {
	op := &request.Operation{
		Name:       opUpdateAnswer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
	}

	if input == nil {
		input = &UpdateAnswerInput{}
	}

	output = &UpdateAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnswer API operation for AWS Well-Architected Tool.
//
// Update the answer to a specific question in a workload review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateAnswer for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer
func (c *WellArchitected) UpdateAnswer(input *UpdateAnswerInput) (*UpdateAnswerOutput, error) {
	req, out := c.UpdateAnswerRequest(input)
	return out, req.Send()
}

// UpdateAnswerWithContext is the same as UpdateAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateAnswerWithContext(ctx aws.Context, input *UpdateAnswerInput, opts ...request.Option) (*UpdateAnswerOutput, error) {
	req, out := c.UpdateAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLensReview = "UpdateLensReview"

// UpdateLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLensReview for more information on using the UpdateLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLensReviewRequest method.
//    req, resp := client.UpdateLensReviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview
func (c *WellArchitected) UpdateLensReviewRequest(input *UpdateLensReviewInput) (req *request.Request, output *UpdateLensReviewOutput) {
	op := &request.Operation{
		Name:       opUpdateLensReview,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
	}

	if input == nil {
		input = &UpdateLensReviewInput{}
	}

	output = &UpdateLensReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLensReview API operation for AWS Well-Architected Tool.
//
// Update lens review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateLensReview for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview
func (c *WellArchitected) UpdateLensReview(input *UpdateLensReviewInput) (*UpdateLensReviewOutput, error) {
	req, out := c.UpdateLensReviewRequest(input)
	return out, req.Send()
}

// UpdateLensReviewWithContext is the same as UpdateLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateLensReviewWithContext(ctx aws.Context, input *UpdateLensReviewInput, opts ...request.Option) (*UpdateLensReviewOutput, error) {
	req, out := c.UpdateLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateShareInvitation = "UpdateShareInvitation"

// UpdateShareInvitationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateShareInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateShareInvitation for more information on using the UpdateShareInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateShareInvitationRequest method.
//    req, resp := client.UpdateShareInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation
func (c *WellArchitected) UpdateShareInvitationRequest(input *UpdateShareInvitationInput) (req *request.Request, output *UpdateShareInvitationOutput) {
	op := &request.Operation{
		Name:       opUpdateShareInvitation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/shareInvitations/{ShareInvitationId}",
	}

	if input == nil {
		input = &UpdateShareInvitationInput{}
	}

	output = &UpdateShareInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateShareInvitation API operation for AWS Well-Architected Tool.
//
// Update a workload invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateShareInvitation for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation
func (c *WellArchitected) UpdateShareInvitation(input *UpdateShareInvitationInput) (*UpdateShareInvitationOutput, error) {
	req, out := c.UpdateShareInvitationRequest(input)
	return out, req.Send()
}

// UpdateShareInvitationWithContext is the same as UpdateShareInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateShareInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateShareInvitationWithContext(ctx aws.Context, input *UpdateShareInvitationInput, opts ...request.Option) (*UpdateShareInvitationOutput, error) {
	req, out := c.UpdateShareInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkload = "UpdateWorkload"

// UpdateWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkload for more information on using the UpdateWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkloadRequest method.
//    req, resp := client.UpdateWorkloadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload
func (c *WellArchitected) UpdateWorkloadRequest(input *UpdateWorkloadInput) (req *request.Request, output *UpdateWorkloadOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkload,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}",
	}

	if input == nil {
		input = &UpdateWorkloadInput{}
	}

	output = &UpdateWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkload API operation for AWS Well-Architected Tool.
//
// Update an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateWorkload for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload
func (c *WellArchitected) UpdateWorkload(input *UpdateWorkloadInput) (*UpdateWorkloadOutput, error) {
	req, out := c.UpdateWorkloadRequest(input)
	return out, req.Send()
}

// UpdateWorkloadWithContext is the same as UpdateWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateWorkloadWithContext(ctx aws.Context, input *UpdateWorkloadInput, opts ...request.Option) (*UpdateWorkloadOutput, error) {
	req, out := c.UpdateWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkloadShare = "UpdateWorkloadShare"

// UpdateWorkloadShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkloadShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkloadShare for more information on using the UpdateWorkloadShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkloadShareRequest method.
//    req, resp := client.UpdateWorkloadShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare
func (c *WellArchitected) UpdateWorkloadShareRequest(input *UpdateWorkloadShareInput) (req *request.Request, output *UpdateWorkloadShareOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkloadShare,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/shares/{ShareId}",
	}

	if input == nil {
		input = &UpdateWorkloadShareInput{}
	}

	output = &UpdateWorkloadShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkloadShare API operation for AWS Well-Architected Tool.
//
// Update a workload share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateWorkloadShare for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare
func (c *WellArchitected) UpdateWorkloadShare(input *UpdateWorkloadShareInput) (*UpdateWorkloadShareOutput, error) {
	req, out := c.UpdateWorkloadShareRequest(input)
	return out, req.Send()
}

// UpdateWorkloadShareWithContext is the same as UpdateWorkloadShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkloadShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateWorkloadShareWithContext(ctx aws.Context, input *UpdateWorkloadShareInput, opts ...request.Option) (*UpdateWorkloadShareOutput, error) {
	req, out := c.UpdateWorkloadShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeLensReview = "UpgradeLensReview"

// UpgradeLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeLensReview for more information on using the UpgradeLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpgradeLensReviewRequest method.
//    req, resp := client.UpgradeLensReviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview
func (c *WellArchitected) UpgradeLensReviewRequest(input *UpgradeLensReviewInput) (req *request.Request, output *UpgradeLensReviewOutput) {
	op := &request.Operation{
		Name:       opUpgradeLensReview,
		HTTPMethod: "PUT",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/upgrade",
	}

	if input == nil {
		input = &UpgradeLensReviewInput{}
	}

	output = &UpgradeLensReviewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpgradeLensReview API operation for AWS Well-Architected Tool.
//
// Upgrade lens review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpgradeLensReview for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   The resource already exists.
//
//   * InternalServerException
//   There is a problem with the AWS Well-Architected Tool API service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview
func (c *WellArchitected) UpgradeLensReview(input *UpgradeLensReviewInput) (*UpgradeLensReviewOutput, error) {
	req, out := c.UpgradeLensReviewRequest(input)
	return out, req.Send()
}

// UpgradeLensReviewWithContext is the same as UpgradeLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpgradeLensReviewWithContext(ctx aws.Context, input *UpgradeLensReviewInput, opts ...request.Option) (*UpgradeLensReviewOutput, error) {
	req, out := c.UpgradeLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An answer of the question.
type Answer struct {
	_ struct{} `type:"structure"`

	// A list of selected choices to a question in your workload.
	ChoiceAnswers []*ChoiceAnswer `type:"list"`

	// List of choices available for a question.
	Choices []*Choice `type:"list"`

	// The helpful resource URL for a question.
	HelpfulResourceUrl *string `min:"1" type:"string"`

	// The improvement plan URL for a question.
	//
	// This value is only available if the question has been answered.
	ImprovementPlanUrl *string `min:"1" type:"string"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The description of the question.
	QuestionDescription *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The reason why the question is not applicable to your workload.
	Reason *string `type:"string" enum:"AnswerReason"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Answer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Answer) GoString() string {
	return s.String()
}

// SetChoiceAnswers sets the ChoiceAnswers field's value.
func (s *Answer) SetChoiceAnswers(v []*ChoiceAnswer) *Answer {
	s.ChoiceAnswers = v
	return s
}

// SetChoices sets the Choices field's value.
func (s *Answer) SetChoices(v []*Choice) *Answer {
	s.Choices = v
	return s
}

// SetHelpfulResourceUrl sets the HelpfulResourceUrl field's value.
func (s *Answer) SetHelpfulResourceUrl(v string) *Answer {
	s.HelpfulResourceUrl = &v
	return s
}

// SetImprovementPlanUrl sets the ImprovementPlanUrl field's value.
func (s *Answer) SetImprovementPlanUrl(v string) *Answer {
	s.ImprovementPlanUrl = &v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *Answer) SetIsApplicable(v bool) *Answer {
	s.IsApplicable = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *Answer) SetNotes(v string) *Answer {
	s.Notes = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *Answer) SetPillarId(v string) *Answer {
	s.PillarId = &v
	return s
}

// SetQuestionDescription sets the QuestionDescription field's value.
func (s *Answer) SetQuestionDescription(v string) *Answer {
	s.QuestionDescription = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *Answer) SetQuestionId(v string) *Answer {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *Answer) SetQuestionTitle(v string) *Answer {
	s.QuestionTitle = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Answer) SetReason(v string) *Answer {
	s.Reason = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *Answer) SetRisk(v string) *Answer {
	s.Risk = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *Answer) SetSelectedChoices(v []*string) *Answer {
	s.SelectedChoices = v
	return s
}

// An answer summary of a lens review in a workload.
type AnswerSummary struct {
	_ struct{} `type:"structure"`

	// A list of selected choices to a question in your workload.
	ChoiceAnswerSummaries []*ChoiceAnswerSummary `type:"list"`

	// List of choices available for a question.
	Choices []*Choice `type:"list"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"AnswerReason"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerSummary) GoString() string {
	return s.String()
}

// SetChoiceAnswerSummaries sets the ChoiceAnswerSummaries field's value.
func (s *AnswerSummary) SetChoiceAnswerSummaries(v []*ChoiceAnswerSummary) *AnswerSummary {
	s.ChoiceAnswerSummaries = v
	return s
}

// SetChoices sets the Choices field's value.
func (s *AnswerSummary) SetChoices(v []*Choice) *AnswerSummary {
	s.Choices = v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *AnswerSummary) SetIsApplicable(v bool) *AnswerSummary {
	s.IsApplicable = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *AnswerSummary) SetPillarId(v string) *AnswerSummary {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *AnswerSummary) SetQuestionId(v string) *AnswerSummary {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *AnswerSummary) SetQuestionTitle(v string) *AnswerSummary {
	s.QuestionTitle = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *AnswerSummary) SetReason(v string) *AnswerSummary {
	s.Reason = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *AnswerSummary) SetRisk(v string) *AnswerSummary {
	s.Risk = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *AnswerSummary) SetSelectedChoices(v []*string) *AnswerSummary {
	s.SelectedChoices = v
	return s
}

// Input to associate lens reviews.
type AssociateLensesInput struct {
	_ struct{} `type:"structure"`

	// List of lens aliases to associate or disassociate with a workload.
	//
	// Identify a lens using its LensSummary$LensAlias.
	//
	// LensAliases is a required field
	LensAliases []*string `min:"1" type:"list" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLensesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateLensesInput"}
	if s.LensAliases == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAliases"))
	}
	if s.LensAliases != nil && len(s.LensAliases) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAliases", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAliases sets the LensAliases field's value.
func (s *AssociateLensesInput) SetLensAliases(v []*string) *AssociateLensesInput {
	s.LensAliases = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *AssociateLensesInput) SetWorkloadId(v string) *AssociateLensesInput {
	s.WorkloadId = &v
	return s
}

type AssociateLensesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesOutput) GoString() string {
	return s.String()
}

// A choice available to answer question.
type Choice struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The description of a choice.
	Description *string `min:"1" type:"string"`

	// The title of a choice.
	Title *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Choice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Choice) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *Choice) SetChoiceId(v string) *Choice {
	s.ChoiceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Choice) SetDescription(v string) *Choice {
	s.Description = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Choice) SetTitle(v string) *Choice {
	s.Title = &v
	return s
}

// A choice that has been answered on a question in your workload.
type ChoiceAnswer struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The notes associated with a choice.
	Notes *string `type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"ChoiceReason"`

	// The status of a choice.
	Status *string `type:"string" enum:"ChoiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswer) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ChoiceAnswer) SetChoiceId(v string) *ChoiceAnswer {
	s.ChoiceId = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *ChoiceAnswer) SetNotes(v string) *ChoiceAnswer {
	s.Notes = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChoiceAnswer) SetReason(v string) *ChoiceAnswer {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChoiceAnswer) SetStatus(v string) *ChoiceAnswer {
	s.Status = &v
	return s
}

// A choice summary that has been answered on a question in your workload.
type ChoiceAnswerSummary struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"ChoiceReason"`

	// The status of a choice.
	Status *string `type:"string" enum:"ChoiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswerSummary) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ChoiceAnswerSummary) SetChoiceId(v string) *ChoiceAnswerSummary {
	s.ChoiceId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChoiceAnswerSummary) SetReason(v string) *ChoiceAnswerSummary {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChoiceAnswerSummary) SetStatus(v string) *ChoiceAnswerSummary {
	s.Status = &v
	return s
}

// A list of choices to be updated.
type ChoiceUpdate struct {
	_ struct{} `type:"structure"`

	// The notes associated with a choice.
	Notes *string `type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"ChoiceReason"`

	// The status of a choice.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ChoiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChoiceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChoiceUpdate"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotes sets the Notes field's value.
func (s *ChoiceUpdate) SetNotes(v string) *ChoiceUpdate {
	s.Notes = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChoiceUpdate) SetReason(v string) *ChoiceUpdate {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChoiceUpdate) SetStatus(v string) *ChoiceUpdate {
	s.Status = &v
	return s
}

// The resource already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Input for milestone creation.
type CreateMilestoneInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after it has completed
	// successfully, the result of the original request is returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// AWS SDKs automatically generate one for you. If you are not using the AWS
	// SDK or the AWS CLI, you must provide this token or the request will fail.
	ClientRequestToken *string `type:"string" idempotencyToken:"true"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	//
	// MilestoneName is a required field
	MilestoneName *string `min:"3" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMilestoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMilestoneInput"}
	if s.MilestoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("MilestoneName"))
	}
	if s.MilestoneName != nil && len(*s.MilestoneName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("MilestoneName", 3))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMilestoneInput) SetClientRequestToken(v string) *CreateMilestoneInput {
	s.ClientRequestToken = &v
	return s
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *CreateMilestoneInput) SetMilestoneName(v string) *CreateMilestoneInput {
	s.MilestoneName = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateMilestoneInput) SetWorkloadId(v string) *CreateMilestoneInput {
	s.WorkloadId = &v
	return s
}

// Output of a create milestone call.
type CreateMilestoneOutput struct {
	_ struct{} `type:"structure"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneOutput) GoString() string {
	return s.String()
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *CreateMilestoneOutput) SetMilestoneNumber(v int64) *CreateMilestoneOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateMilestoneOutput) SetWorkloadId(v string) *CreateMilestoneOutput {
	s.WorkloadId = &v
	return s
}

// Input for workload creation.
type CreateWorkloadInput struct {
	_ struct{} `type:"structure"`

	// The list of AWS account IDs associated with the workload.
	AccountIds []*string `type:"list"`

	// The URL of the architectural design for the workload.
	ArchitecturalDesign *string `type:"string"`

	// The list of AWS Regions associated with the workload, for example, us-east-2,
	// or ca-central-1.
	AwsRegions []*string `type:"list"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after it has completed
	// successfully, the result of the original request is returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// AWS SDKs automatically generate one for you. If you are not using the AWS
	// SDK or the AWS CLI, you must provide this token or the request will fail.
	ClientRequestToken *string `type:"string" idempotencyToken:"true"`

	// The description for the workload.
	//
	// Description is a required field
	Description *string `min:"3" type:"string" required:"true"`

	// The environment for the workload.
	//
	// Environment is a required field
	Environment *string `type:"string" required:"true" enum:"WorkloadEnvironment"`

	// The industry for the workload.
	Industry *string `type:"string"`

	// The industry type for the workload.
	//
	// If specified, must be one of the following:
	//
	//    * Agriculture
	//
	//    * Automobile
	//
	//    * Defense
	//
	//    * Design and Engineering
	//
	//    * Digital Advertising
	//
	//    * Education
	//
	//    * Environmental Protection
	//
	//    * Financial Services
	//
	//    * Gaming
	//
	//    * General Public Services
	//
	//    * Healthcare
	//
	//    * Hospitality
	//
	//    * InfoTech
	//
	//    * Justice and Public Safety
	//
	//    * Life Sciences
	//
	//    * Manufacturing
	//
	//    * Media & Entertainment
	//
	//    * Mining & Resources
	//
	//    * Oil & Gas
	//
	//    * Power & Utilities
	//
	//    * Professional Services
	//
	//    * Real Estate & Construction
	//
	//    * Retail & Wholesale
	//
	//    * Social Protection
	//
	//    * Telecommunications
	//
	//    * Travel, Transportation & Logistics
	//
	//    * Other
	IndustryType *string `type:"string"`

	// The list of lenses associated with the workload. Each lens is identified
	// by its LensSummary$LensAlias.
	//
	// Lenses is a required field
	Lenses []*string `type:"list" required:"true"`

	// The list of non-AWS Regions associated with the workload.
	NonAwsRegions []*string `type:"list"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// The priorities of the pillars, which are used to order items in the improvement
	// plan. Each pillar is represented by its PillarReviewSummary$PillarId.
	PillarPriorities []*string `type:"list"`

	// The review owner of the workload. The name, email address, or identifier
	// for the primary group or individual that owns the workload review process.
	//
	// ReviewOwner is a required field
	ReviewOwner *string `min:"3" type:"string" required:"true"`

	// The tags to be associated with the workload.
	Tags map[string]*string `min:"1" type:"map"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	//
	// WorkloadName is a required field
	WorkloadName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkloadInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 3))
	}
	if s.Environment == nil {
		invalidParams.Add(request.NewErrParamRequired("Environment"))
	}
	if s.Lenses == nil {
		invalidParams.Add(request.NewErrParamRequired("Lenses"))
	}
	if s.ReviewOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ReviewOwner"))
	}
	if s.ReviewOwner != nil && len(*s.ReviewOwner) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ReviewOwner", 3))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkloadName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadName"))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *CreateWorkloadInput) SetAccountIds(v []*string) *CreateWorkloadInput {
	s.AccountIds = v
	return s
}

// SetArchitecturalDesign sets the ArchitecturalDesign field's value.
func (s *CreateWorkloadInput) SetArchitecturalDesign(v string) *CreateWorkloadInput {
	s.ArchitecturalDesign = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *CreateWorkloadInput) SetAwsRegions(v []*string) *CreateWorkloadInput {
	s.AwsRegions = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorkloadInput) SetClientRequestToken(v string) *CreateWorkloadInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkloadInput) SetDescription(v string) *CreateWorkloadInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateWorkloadInput) SetEnvironment(v string) *CreateWorkloadInput {
	s.Environment = &v
	return s
}

// SetIndustry sets the Industry field's value.
func (s *CreateWorkloadInput) SetIndustry(v string) *CreateWorkloadInput {
	s.Industry = &v
	return s
}

// SetIndustryType sets the IndustryType field's value.
func (s *CreateWorkloadInput) SetIndustryType(v string) *CreateWorkloadInput {
	s.IndustryType = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *CreateWorkloadInput) SetLenses(v []*string) *CreateWorkloadInput {
	s.Lenses = v
	return s
}

// SetNonAwsRegions sets the NonAwsRegions field's value.
func (s *CreateWorkloadInput) SetNonAwsRegions(v []*string) *CreateWorkloadInput {
	s.NonAwsRegions = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *CreateWorkloadInput) SetNotes(v string) *CreateWorkloadInput {
	s.Notes = &v
	return s
}

// SetPillarPriorities sets the PillarPriorities field's value.
func (s *CreateWorkloadInput) SetPillarPriorities(v []*string) *CreateWorkloadInput {
	s.PillarPriorities = v
	return s
}

// SetReviewOwner sets the ReviewOwner field's value.
func (s *CreateWorkloadInput) SetReviewOwner(v string) *CreateWorkloadInput {
	s.ReviewOwner = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkloadInput) SetTags(v map[string]*string) *CreateWorkloadInput {
	s.Tags = v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *CreateWorkloadInput) SetWorkloadName(v string) *CreateWorkloadInput {
	s.WorkloadName = &v
	return s
}

// Output of a create workload call.
type CreateWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *CreateWorkloadOutput) SetWorkloadArn(v string) *CreateWorkloadOutput {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateWorkloadOutput) SetWorkloadId(v string) *CreateWorkloadOutput {
	s.WorkloadId = &v
	return s
}

// Input for Create Workload Share
type CreateWorkloadShareInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after it has completed
	// successfully, the result of the original request is returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// AWS SDKs automatically generate one for you. If you are not using the AWS
	// SDK or the AWS CLI, you must provide this token or the request will fail.
	ClientRequestToken *string `type:"string" idempotencyToken:"true"`

	// Permission granted on a workload share.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"PermissionType"`

	// The AWS account ID or IAM role with which the workload is shared.
	//
	// SharedWith is a required field
	SharedWith *string `min:"12" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkloadShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkloadShareInput"}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}
	if s.SharedWith == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedWith"))
	}
	if s.SharedWith != nil && len(*s.SharedWith) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SharedWith", 12))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorkloadShareInput) SetClientRequestToken(v string) *CreateWorkloadShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *CreateWorkloadShareInput) SetPermissionType(v string) *CreateWorkloadShareInput {
	s.PermissionType = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *CreateWorkloadShareInput) SetSharedWith(v string) *CreateWorkloadShareInput {
	s.SharedWith = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateWorkloadShareInput) SetWorkloadId(v string) *CreateWorkloadShareInput {
	s.WorkloadId = &v
	return s
}

// Input for Create Workload Share
type CreateWorkloadShareOutput struct {
	_ struct{} `type:"structure"`

	// The ID associated with the workload share.
	ShareId *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareOutput) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *CreateWorkloadShareOutput) SetShareId(v string) *CreateWorkloadShareOutput {
	s.ShareId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateWorkloadShareOutput) SetWorkloadId(v string) *CreateWorkloadShareOutput {
	s.WorkloadId = &v
	return s
}

// Input for workload deletion.
type DeleteWorkloadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after it has completed
	// successfully, the result of the original request is returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// AWS SDKs automatically generate one for you. If you are not using the AWS
	// SDK or the AWS CLI, you must provide this token or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" type:"string" idempotencyToken:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkloadInput"}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteWorkloadInput) SetClientRequestToken(v string) *DeleteWorkloadInput {
	s.ClientRequestToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DeleteWorkloadInput) SetWorkloadId(v string) *DeleteWorkloadInput {
	s.WorkloadId = &v
	return s
}

type DeleteWorkloadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadOutput) GoString() string {
	return s.String()
}

// Input for Delete Workload Share
type DeleteWorkloadShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after it has completed
	// successfully, the result of the original request is returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// AWS SDKs automatically generate one for you. If you are not using the AWS
	// SDK or the AWS CLI, you must provide this token or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" type:"string" idempotencyToken:"true"`

	// The ID associated with the workload share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkloadShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkloadShareInput"}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteWorkloadShareInput) SetClientRequestToken(v string) *DeleteWorkloadShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *DeleteWorkloadShareInput) SetShareId(v string) *DeleteWorkloadShareInput {
	s.ShareId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DeleteWorkloadShareInput) SetWorkloadId(v string) *DeleteWorkloadShareInput {
	s.WorkloadId = &v
	return s
}

type DeleteWorkloadShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareOutput) GoString() string {
	return s.String()
}

// Input to disassociate lens reviews.
type DisassociateLensesInput struct {
	_ struct{} `type:"structure"`

	// List of lens aliases to associate or disassociate with a workload.
	//
	// Identify a lens using its LensSummary$LensAlias.
	//
	// LensAliases is a required field
	LensAliases []*string `min:"1" type:"list" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateLensesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateLensesInput"}
	if s.LensAliases == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAliases"))
	}
	if s.LensAliases != nil && len(s.LensAliases) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAliases", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAliases sets the LensAliases field's value.
func (s *DisassociateLensesInput) SetLensAliases(v []*string) *DisassociateLensesInput {
	s.LensAliases = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DisassociateLensesInput) SetWorkloadId(v string) *DisassociateLensesInput {
	s.WorkloadId = &v
	return s
}

type DisassociateLensesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesOutput) GoString() string {
	return s.String()
}

// Input to get answer.
type GetAnswerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `location:"uri" locationName:"QuestionId" min:"1" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnswerInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetAnswerInput) SetLensAlias(v string) *GetAnswerInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetAnswerInput) SetMilestoneNumber(v int64) *GetAnswerInput {
	s.MilestoneNumber = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *GetAnswerInput) SetQuestionId(v string) *GetAnswerInput {
	s.QuestionId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetAnswerInput) SetWorkloadId(v string) *GetAnswerInput {
	s.WorkloadId = &v
	return s
}

// Output of a get answer call.
type GetAnswerOutput struct {
	_ struct{} `type:"structure"`

	// An answer of the question.
	Answer *Answer `type:"structure"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *GetAnswerOutput) SetAnswer(v *Answer) *GetAnswerOutput {
	s.Answer = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetAnswerOutput) SetLensAlias(v string) *GetAnswerOutput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetAnswerOutput) SetMilestoneNumber(v int64) *GetAnswerOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetAnswerOutput) SetWorkloadId(v string) *GetAnswerOutput {
	s.WorkloadId = &v
	return s
}

// Input to get lens review.
type GetLensReviewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensReviewInput) SetLensAlias(v string) *GetLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewInput) SetMilestoneNumber(v int64) *GetLensReviewInput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewInput) SetWorkloadId(v string) *GetLensReviewInput {
	s.WorkloadId = &v
	return s
}

// Output of a get lens review call.
type GetLensReviewOutput struct {
	_ struct{} `type:"structure"`

	// A lens review of a question.
	LensReview *LensReview `type:"structure"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewOutput) GoString() string {
	return s.String()
}

// SetLensReview sets the LensReview field's value.
func (s *GetLensReviewOutput) SetLensReview(v *LensReview) *GetLensReviewOutput {
	s.LensReview = v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewOutput) SetMilestoneNumber(v int64) *GetLensReviewOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewOutput) SetWorkloadId(v string) *GetLensReviewOutput {
	s.WorkloadId = &v
	return s
}

// Input to get lens review report.
type GetLensReviewReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensReviewReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensReviewReportInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensReviewReportInput) SetLensAlias(v string) *GetLensReviewReportInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewReportInput) SetMilestoneNumber(v int64) *GetLensReviewReportInput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewReportInput) SetWorkloadId(v string) *GetLensReviewReportInput {
	s.WorkloadId = &v
	return s
}

// Output of a get lens review report call.
type GetLensReviewReportOutput struct {
	_ struct{} `type:"structure"`

	// A report of a lens review.
	LensReviewReport *LensReviewReport `type:"structure"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportOutput) GoString() string {
	return s.String()
}

// SetLensReviewReport sets the LensReviewReport field's value.
func (s *GetLensReviewReportOutput) SetLensReviewReport(v *LensReviewReport) *GetLensReviewReportOutput {
	s.LensReviewReport = v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewReportOutput) SetMilestoneNumber(v int64) *GetLensReviewReportOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewReportOutput) SetWorkloadId(v string) *GetLensReviewReportOutput {
	s.WorkloadId = &v
	return s
}

type GetLensVersionDifferenceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The base version of the lens.
	//
	// BaseLensVersion is a required field
	BaseLensVersion *string `location:"querystring" locationName:"BaseLensVersion" min:"1" type:"string" required:"true"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensVersionDifferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensVersionDifferenceInput"}
	if s.BaseLensVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseLensVersion"))
	}
	if s.BaseLensVersion != nil && len(*s.BaseLensVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BaseLensVersion", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseLensVersion sets the BaseLensVersion field's value.
func (s *GetLensVersionDifferenceInput) SetBaseLensVersion(v string) *GetLensVersionDifferenceInput {
	s.BaseLensVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensVersionDifferenceInput) SetLensAlias(v string) *GetLensVersionDifferenceInput {
	s.LensAlias = &v
	return s
}

type GetLensVersionDifferenceOutput struct {
	_ struct{} `type:"structure"`

	// The base version of the lens.
	BaseLensVersion *string `min:"1" type:"string"`

	// The latest version of the lens.
	LatestLensVersion *string `min:"1" type:"string"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The differences between the base and latest versions of the lens.
	VersionDifferences *VersionDifferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceOutput) GoString() string {
	return s.String()
}

// SetBaseLensVersion sets the BaseLensVersion field's value.
func (s *GetLensVersionDifferenceOutput) SetBaseLensVersion(v string) *GetLensVersionDifferenceOutput {
	s.BaseLensVersion = &v
	return s
}

// SetLatestLensVersion sets the LatestLensVersion field's value.
func (s *GetLensVersionDifferenceOutput) SetLatestLensVersion(v string) *GetLensVersionDifferenceOutput {
	s.LatestLensVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensVersionDifferenceOutput) SetLensAlias(v string) *GetLensVersionDifferenceOutput {
	s.LensAlias = &v
	return s
}

// SetVersionDifferences sets the VersionDifferences field's value.
func (s *GetLensVersionDifferenceOutput) SetVersionDifferences(v *VersionDifferences) *GetLensVersionDifferenceOutput {
	s.VersionDifferences = v
	return s
}

// Input to get a milestone.
type GetMilestoneInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	//
	// MilestoneNumber is a required field
	MilestoneNumber *int64 `location:"uri" locationName:"MilestoneNumber" min:"1" type:"integer" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMilestoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMilestoneInput"}
	if s.MilestoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("MilestoneNumber"))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetMilestoneInput) SetMilestoneNumber(v int64) *GetMilestoneInput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetMilestoneInput) SetWorkloadId(v string) *GetMilestoneInput {
	s.WorkloadId = &v
	return s
}

// Output of a get milestone call.
type GetMilestoneOutput struct {
	_ struct{} `type:"structure"`

	// A milestone return object.
	Milestone *Milestone `type:"structure"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneOutput) GoString() string {
	return s.String()
}

// SetMilestone sets the Milestone field's value.
func (s *GetMilestoneOutput) SetMilestone(v *Milestone) *GetMilestoneOutput {
	s.Milestone = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetMilestoneOutput) SetWorkloadId(v string) *GetMilestoneOutput {
	s.WorkloadId = &v
	return s
}

// Input to get a workload.
type GetWorkloadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkloadInput"}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetWorkloadInput) SetWorkloadId(v string) *GetWorkloadInput {
	s.WorkloadId = &v
	return s
}

// Output of a get workload call.
type GetWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// A workload return object.
	Workload *Workload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkload sets the Workload field's value.
func (s *GetWorkloadOutput) SetWorkload(v *Workload) *GetWorkloadOutput {
	s.Workload = v
	return s
}

// An improvement summary of a lens review in a workload.
type ImprovementSummary struct {
	_ struct{} `type:"structure"`

	// The improvement plan URL for a question.
	//
	// This value is only available if the question has been answered.
	ImprovementPlanUrl *string `min:"1" type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImprovementSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImprovementSummary) GoString() string {
	return s.String()
}

// SetImprovementPlanUrl sets the ImprovementPlanUrl field's value.
func (s *ImprovementSummary) SetImprovementPlanUrl(v string) *ImprovementSummary {
	s.ImprovementPlanUrl = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ImprovementSummary) SetPillarId(v string) *ImprovementSummary {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ImprovementSummary) SetQuestionId(v string) *ImprovementSummary {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *ImprovementSummary) SetQuestionTitle(v string) *ImprovementSummary {
	s.QuestionTitle = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *ImprovementSummary) SetRisk(v string) *ImprovementSummary {
	s.Risk = &v
	return s
}

// There is a problem with the AWS Well-Architected Tool API service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A lens review of a question.
type LensReview struct {
	_ struct{} `type:"structure"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The status of the lens.
	LensStatus *string `type:"string" enum:"LensStatus"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// List of pillar review summaries of lens review in a workload.
	PillarReviewSummaries []*PillarReviewSummary `type:"list"`

	// A map from risk names to the count of how questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReview) GoString() string {
	return s.String()
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensReview) SetLensAlias(v string) *LensReview {
	s.LensAlias = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *LensReview) SetLensName(v string) *LensReview {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *LensReview) SetLensStatus(v string) *LensReview {
	s.LensStatus = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *LensReview) SetLensVersion(v string) *LensReview {
	s.LensVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LensReview) SetNextToken(v string) *LensReview {
	s.NextToken = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *LensReview) SetNotes(v string) *LensReview {
	s.Notes = &v
	return s
}

// SetPillarReviewSummaries sets the PillarReviewSummaries field's value.
func (s *LensReview) SetPillarReviewSummaries(v []*PillarReviewSummary) *LensReview {
	s.PillarReviewSummaries = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *LensReview) SetRiskCounts(v map[string]*int64) *LensReview {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LensReview) SetUpdatedAt(v time.Time) *LensReview {
	s.UpdatedAt = &v
	return s
}

// A report of a lens review.
type LensReviewReport struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded string representation of a lens review report.
	//
	// This data can be used to create a PDF file.
	Base64String *string `type:"string"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewReport) GoString() string {
	return s.String()
}

// SetBase64String sets the Base64String field's value.
func (s *LensReviewReport) SetBase64String(v string) *LensReviewReport {
	s.Base64String = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensReviewReport) SetLensAlias(v string) *LensReviewReport {
	s.LensAlias = &v
	return s
}

// A lens review summary of a workload.
type LensReviewSummary struct {
	_ struct{} `type:"structure"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The status of the lens.
	LensStatus *string `type:"string" enum:"LensStatus"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`

	// A map from risk names to the count of how questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewSummary) GoString() string {
	return s.String()
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensReviewSummary) SetLensAlias(v string) *LensReviewSummary {
	s.LensAlias = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *LensReviewSummary) SetLensName(v string) *LensReviewSummary {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *LensReviewSummary) SetLensStatus(v string) *LensReviewSummary {
	s.LensStatus = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *LensReviewSummary) SetLensVersion(v string) *LensReviewSummary {
	s.LensVersion = &v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *LensReviewSummary) SetRiskCounts(v map[string]*int64) *LensReviewSummary {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LensReviewSummary) SetUpdatedAt(v time.Time) *LensReviewSummary {
	s.UpdatedAt = &v
	return s
}

// A lens summary of a lens.
type LensSummary struct {
	_ struct{} `type:"structure"`

	// The description of the lens.
	Description *string `min:"1" type:"string"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *LensSummary) SetDescription(v string) *LensSummary {
	s.Description = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensSummary) SetLensAlias(v string) *LensSummary {
	s.LensAlias = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *LensSummary) SetLensName(v string) *LensSummary {
	s.LensName = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *LensSummary) SetLensVersion(v string) *LensSummary {
	s.LensVersion = &v
	return s
}

// Lens upgrade summary return object.
type LensUpgradeSummary struct {
	_ struct{} `type:"structure"`

	// The current version of the lens.
	CurrentLensVersion *string `min:"1" type:"string"`

	// The latest version of the lens.
	LatestLensVersion *string `min:"1" type:"string"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensUpgradeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensUpgradeSummary) GoString() string {
	return s.String()
}

// SetCurrentLensVersion sets the CurrentLensVersion field's value.
func (s *LensUpgradeSummary) SetCurrentLensVersion(v string) *LensUpgradeSummary {
	s.CurrentLensVersion = &v
	return s
}

// SetLatestLensVersion sets the LatestLensVersion field's value.
func (s *LensUpgradeSummary) SetLatestLensVersion(v string) *LensUpgradeSummary {
	s.LatestLensVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensUpgradeSummary) SetLensAlias(v string) *LensUpgradeSummary {
	s.LensAlias = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *LensUpgradeSummary) SetWorkloadId(v string) *LensUpgradeSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *LensUpgradeSummary) SetWorkloadName(v string) *LensUpgradeSummary {
	s.WorkloadName = &v
	return s
}

// Input to list answers.
type ListAnswersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `location:"querystring" locationName:"PillarId" min:"1" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnswersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnswersInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListAnswersInput) SetLensAlias(v string) *ListAnswersInput {
	s.LensAlias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnswersInput) SetMaxResults(v int64) *ListAnswersInput {
	s.MaxResults = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListAnswersInput) SetMilestoneNumber(v int64) *ListAnswersInput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnswersInput) SetNextToken(v string) *ListAnswersInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListAnswersInput) SetPillarId(v string) *ListAnswersInput {
	s.PillarId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListAnswersInput) SetWorkloadId(v string) *ListAnswersInput {
	s.WorkloadId = &v
	return s
}

// Output of a list answers call.
type ListAnswersOutput struct {
	_ struct{} `type:"structure"`

	// List of answer summaries of lens review in a workload.
	AnswerSummaries []*AnswerSummary `type:"list"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersOutput) GoString() string {
	return s.String()
}

// SetAnswerSummaries sets the AnswerSummaries field's value.
func (s *ListAnswersOutput) SetAnswerSummaries(v []*AnswerSummary) *ListAnswersOutput {
	s.AnswerSummaries = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListAnswersOutput) SetLensAlias(v string) *ListAnswersOutput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListAnswersOutput) SetMilestoneNumber(v int64) *ListAnswersOutput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnswersOutput) SetNextToken(v string) *ListAnswersOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListAnswersOutput) SetWorkloadId(v string) *ListAnswersOutput {
	s.WorkloadId = &v
	return s
}

// Input to list lens review improvements.
type ListLensReviewImprovementsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `location:"querystring" locationName:"PillarId" min:"1" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensReviewImprovementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensReviewImprovementsInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListLensReviewImprovementsInput) SetLensAlias(v string) *ListLensReviewImprovementsInput {
	s.LensAlias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensReviewImprovementsInput) SetMaxResults(v int64) *ListLensReviewImprovementsInput {
	s.MaxResults = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewImprovementsInput) SetMilestoneNumber(v int64) *ListLensReviewImprovementsInput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewImprovementsInput) SetNextToken(v string) *ListLensReviewImprovementsInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListLensReviewImprovementsInput) SetPillarId(v string) *ListLensReviewImprovementsInput {
	s.PillarId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewImprovementsInput) SetWorkloadId(v string) *ListLensReviewImprovementsInput {
	s.WorkloadId = &v
	return s
}

// Output of a list lens review improvements call.
type ListLensReviewImprovementsOutput struct {
	_ struct{} `type:"structure"`

	// List of improvement summaries of lens review in a workload.
	ImprovementSummaries []*ImprovementSummary `type:"list"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsOutput) GoString() string {
	return s.String()
}

// SetImprovementSummaries sets the ImprovementSummaries field's value.
func (s *ListLensReviewImprovementsOutput) SetImprovementSummaries(v []*ImprovementSummary) *ListLensReviewImprovementsOutput {
	s.ImprovementSummaries = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListLensReviewImprovementsOutput) SetLensAlias(v string) *ListLensReviewImprovementsOutput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewImprovementsOutput) SetMilestoneNumber(v int64) *ListLensReviewImprovementsOutput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewImprovementsOutput) SetNextToken(v string) *ListLensReviewImprovementsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewImprovementsOutput) SetWorkloadId(v string) *ListLensReviewImprovementsOutput {
	s.WorkloadId = &v
	return s
}

// Input to list lens reviews.
type ListLensReviewsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensReviewsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensReviewsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensReviewsInput) SetMaxResults(v int64) *ListLensReviewsInput {
	s.MaxResults = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewsInput) SetMilestoneNumber(v int64) *ListLensReviewsInput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewsInput) SetNextToken(v string) *ListLensReviewsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewsInput) SetWorkloadId(v string) *ListLensReviewsInput {
	s.WorkloadId = &v
	return s
}

// Output of a list lens reviews call.
type ListLensReviewsOutput struct {
	_ struct{} `type:"structure"`

	// List of lens summaries of lens reviews of a workload.
	LensReviewSummaries []*LensReviewSummary `type:"list"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsOutput) GoString() string {
	return s.String()
}

// SetLensReviewSummaries sets the LensReviewSummaries field's value.
func (s *ListLensReviewsOutput) SetLensReviewSummaries(v []*LensReviewSummary) *ListLensReviewsOutput {
	s.LensReviewSummaries = v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewsOutput) SetMilestoneNumber(v int64) *ListLensReviewsOutput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewsOutput) SetNextToken(v string) *ListLensReviewsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewsOutput) SetWorkloadId(v string) *ListLensReviewsOutput {
	s.WorkloadId = &v
	return s
}

// Input to list lenses.
type ListLensesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensesInput) SetMaxResults(v int64) *ListLensesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensesInput) SetNextToken(v string) *ListLensesInput {
	s.NextToken = &v
	return s
}

// Output of a list lenses call.
type ListLensesOutput struct {
	_ struct{} `type:"structure"`

	// List of lens summaries of available lenses.
	LensSummaries []*LensSummary `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesOutput) GoString() string {
	return s.String()
}

// SetLensSummaries sets the LensSummaries field's value.
func (s *ListLensesOutput) SetLensSummaries(v []*LensSummary) *ListLensesOutput {
	s.LensSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensesOutput) SetNextToken(v string) *ListLensesOutput {
	s.NextToken = &v
	return s
}

// Input to list all milestones for a workload.
type ListMilestonesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMilestonesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMilestonesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMilestonesInput) SetMaxResults(v int64) *ListMilestonesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMilestonesInput) SetNextToken(v string) *ListMilestonesInput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListMilestonesInput) SetWorkloadId(v string) *ListMilestonesInput {
	s.WorkloadId = &v
	return s
}

// Output of a list milestones call.
type ListMilestonesOutput struct {
	_ struct{} `type:"structure"`

	// A list of milestone summaries.
	MilestoneSummaries []*MilestoneSummary `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesOutput) GoString() string {
	return s.String()
}

// SetMilestoneSummaries sets the MilestoneSummaries field's value.
func (s *ListMilestonesOutput) SetMilestoneSummaries(v []*MilestoneSummary) *ListMilestonesOutput {
	s.MilestoneSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMilestonesOutput) SetNextToken(v string) *ListMilestonesOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListMilestonesOutput) SetWorkloadId(v string) *ListMilestonesOutput {
	s.WorkloadId = &v
	return s
}

type ListNotificationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNotificationsInput) SetMaxResults(v int64) *ListNotificationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationsInput) SetNextToken(v string) *ListNotificationsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListNotificationsInput) SetWorkloadId(v string) *ListNotificationsInput {
	s.WorkloadId = &v
	return s
}

type ListNotificationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// List of lens notification summaries in a workload.
	NotificationSummaries []*NotificationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationsOutput) SetNextToken(v string) *ListNotificationsOutput {
	s.NextToken = &v
	return s
}

// SetNotificationSummaries sets the NotificationSummaries field's value.
func (s *ListNotificationsOutput) SetNotificationSummaries(v []*NotificationSummary) *ListNotificationsOutput {
	s.NotificationSummaries = v
	return s
}

// Input for List Share Invitations
type ListShareInvitationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// An optional string added to the beginning of each workload name returned
	// in the results.
	WorkloadNamePrefix *string `location:"querystring" locationName:"WorkloadNamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListShareInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListShareInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListShareInvitationsInput) SetMaxResults(v int64) *ListShareInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListShareInvitationsInput) SetNextToken(v string) *ListShareInvitationsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadNamePrefix sets the WorkloadNamePrefix field's value.
func (s *ListShareInvitationsInput) SetWorkloadNamePrefix(v string) *ListShareInvitationsInput {
	s.WorkloadNamePrefix = &v
	return s
}

// Input for List Share Invitations
type ListShareInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// List of share invitation summaries in a workload.
	ShareInvitationSummaries []*ShareInvitationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListShareInvitationsOutput) SetNextToken(v string) *ListShareInvitationsOutput {
	s.NextToken = &v
	return s
}

// SetShareInvitationSummaries sets the ShareInvitationSummaries field's value.
func (s *ListShareInvitationsOutput) SetShareInvitationSummaries(v []*ShareInvitationSummary) *ListShareInvitationsOutput {
	s.ShareInvitationSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN for the workload.
	//
	// WorkloadArn is a required field
	WorkloadArn *string `location:"uri" locationName:"WorkloadArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.WorkloadArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadArn"))
	}
	if s.WorkloadArn != nil && len(*s.WorkloadArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *ListTagsForResourceInput) SetWorkloadArn(v string) *ListTagsForResourceInput {
	s.WorkloadArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Input for List Workload Share
type ListWorkloadSharesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The AWS account ID or IAM role with which the workload is shared.
	SharedWithPrefix *string `location:"querystring" locationName:"SharedWithPrefix" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkloadSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkloadSharesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkloadSharesInput) SetMaxResults(v int64) *ListWorkloadSharesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadSharesInput) SetNextToken(v string) *ListWorkloadSharesInput {
	s.NextToken = &v
	return s
}

// SetSharedWithPrefix sets the SharedWithPrefix field's value.
func (s *ListWorkloadSharesInput) SetSharedWithPrefix(v string) *ListWorkloadSharesInput {
	s.SharedWithPrefix = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListWorkloadSharesInput) SetWorkloadId(v string) *ListWorkloadSharesInput {
	s.WorkloadId = &v
	return s
}

// Input for List Workload Share
type ListWorkloadSharesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// A list of workload share summaries.
	WorkloadShareSummaries []*WorkloadShareSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadSharesOutput) SetNextToken(v string) *ListWorkloadSharesOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListWorkloadSharesOutput) SetWorkloadId(v string) *ListWorkloadSharesOutput {
	s.WorkloadId = &v
	return s
}

// SetWorkloadShareSummaries sets the WorkloadShareSummaries field's value.
func (s *ListWorkloadSharesOutput) SetWorkloadShareSummaries(v []*WorkloadShareSummary) *ListWorkloadSharesOutput {
	s.WorkloadShareSummaries = v
	return s
}

// Input to list all workloads.
type ListWorkloadsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// An optional string added to the beginning of each workload name returned
	// in the results.
	WorkloadNamePrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkloadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkloadsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkloadsInput) SetMaxResults(v int64) *ListWorkloadsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadsInput) SetNextToken(v string) *ListWorkloadsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadNamePrefix sets the WorkloadNamePrefix field's value.
func (s *ListWorkloadsInput) SetWorkloadNamePrefix(v string) *ListWorkloadsInput {
	s.WorkloadNamePrefix = &v
	return s
}

// Output of a list workloads call.
type ListWorkloadsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// A list of workload summaries.
	WorkloadSummaries []*WorkloadSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadsOutput) SetNextToken(v string) *ListWorkloadsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadSummaries sets the WorkloadSummaries field's value.
func (s *ListWorkloadsOutput) SetWorkloadSummaries(v []*WorkloadSummary) *ListWorkloadsOutput {
	s.WorkloadSummaries = v
	return s
}

// A milestone return object.
type Milestone struct {
	_ struct{} `type:"structure"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	MilestoneName *string `min:"3" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The date and time recorded.
	RecordedAt *time.Time `type:"timestamp"`

	// A workload return object.
	Workload *Workload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Milestone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Milestone) GoString() string {
	return s.String()
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *Milestone) SetMilestoneName(v string) *Milestone {
	s.MilestoneName = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *Milestone) SetMilestoneNumber(v int64) *Milestone {
	s.MilestoneNumber = &v
	return s
}

// SetRecordedAt sets the RecordedAt field's value.
func (s *Milestone) SetRecordedAt(v time.Time) *Milestone {
	s.RecordedAt = &v
	return s
}

// SetWorkload sets the Workload field's value.
func (s *Milestone) SetWorkload(v *Workload) *Milestone {
	s.Workload = v
	return s
}

// A milestone summary return object.
type MilestoneSummary struct {
	_ struct{} `type:"structure"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	MilestoneName *string `min:"3" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The date and time recorded.
	RecordedAt *time.Time `type:"timestamp"`

	// A workload summary return object.
	WorkloadSummary *WorkloadSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MilestoneSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MilestoneSummary) GoString() string {
	return s.String()
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *MilestoneSummary) SetMilestoneName(v string) *MilestoneSummary {
	s.MilestoneName = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *MilestoneSummary) SetMilestoneNumber(v int64) *MilestoneSummary {
	s.MilestoneNumber = &v
	return s
}

// SetRecordedAt sets the RecordedAt field's value.
func (s *MilestoneSummary) SetRecordedAt(v time.Time) *MilestoneSummary {
	s.RecordedAt = &v
	return s
}

// SetWorkloadSummary sets the WorkloadSummary field's value.
func (s *MilestoneSummary) SetWorkloadSummary(v *WorkloadSummary) *MilestoneSummary {
	s.WorkloadSummary = v
	return s
}

// A notification summary return object.
type NotificationSummary struct {
	_ struct{} `type:"structure"`

	// Summary of lens upgrade.
	LensUpgradeSummary *LensUpgradeSummary `type:"structure"`

	// The type of notification.
	Type *string `type:"string" enum:"NotificationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSummary) GoString() string {
	return s.String()
}

// SetLensUpgradeSummary sets the LensUpgradeSummary field's value.
func (s *NotificationSummary) SetLensUpgradeSummary(v *LensUpgradeSummary) *NotificationSummary {
	s.LensUpgradeSummary = v
	return s
}

// SetType sets the Type field's value.
func (s *NotificationSummary) SetType(v string) *NotificationSummary {
	s.Type = &v
	return s
}

// A pillar difference return object.
type PillarDifference struct {
	_ struct{} `type:"structure"`

	// Indicates the type of change to the pillar.
	DifferenceStatus *string `type:"string" enum:"DifferenceStatus"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// List of question differences.
	QuestionDifferences []*QuestionDifference `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarDifference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarDifference) GoString() string {
	return s.String()
}

// SetDifferenceStatus sets the DifferenceStatus field's value.
func (s *PillarDifference) SetDifferenceStatus(v string) *PillarDifference {
	s.DifferenceStatus = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *PillarDifference) SetPillarId(v string) *PillarDifference {
	s.PillarId = &v
	return s
}

// SetQuestionDifferences sets the QuestionDifferences field's value.
func (s *PillarDifference) SetQuestionDifferences(v []*QuestionDifference) *PillarDifference {
	s.QuestionDifferences = v
	return s
}

// A pillar review summary of a lens review.
type PillarReviewSummary struct {
	_ struct{} `type:"structure"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The name of the pillar.
	PillarName *string `min:"1" type:"string"`

	// A map from risk names to the count of how questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarReviewSummary) GoString() string {
	return s.String()
}

// SetNotes sets the Notes field's value.
func (s *PillarReviewSummary) SetNotes(v string) *PillarReviewSummary {
	s.Notes = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *PillarReviewSummary) SetPillarId(v string) *PillarReviewSummary {
	s.PillarId = &v
	return s
}

// SetPillarName sets the PillarName field's value.
func (s *PillarReviewSummary) SetPillarName(v string) *PillarReviewSummary {
	s.PillarName = &v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *PillarReviewSummary) SetRiskCounts(v map[string]*int64) *PillarReviewSummary {
	s.RiskCounts = v
	return s
}

// A question difference return object.
type QuestionDifference struct {
	_ struct{} `type:"structure"`

	// Indicates the type of change to the question.
	DifferenceStatus *string `type:"string" enum:"DifferenceStatus"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuestionDifference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuestionDifference) GoString() string {
	return s.String()
}

// SetDifferenceStatus sets the DifferenceStatus field's value.
func (s *QuestionDifference) SetDifferenceStatus(v string) *QuestionDifference {
	s.DifferenceStatus = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *QuestionDifference) SetQuestionId(v string) *QuestionDifference {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *QuestionDifference) SetQuestionTitle(v string) *QuestionDifference {
	s.QuestionTitle = &v
	return s
}

// The requested resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The user has reached their resource quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// Identifier of the resource affected.
	ResourceId *string `type:"string"`

	// Type of the resource affected.
	ResourceType *string `type:"string"`

	// Service Quotas requirement to identify originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The share invitation.
type ShareInvitation struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitation) GoString() string {
	return s.String()
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *ShareInvitation) SetShareInvitationId(v string) *ShareInvitation {
	s.ShareInvitationId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ShareInvitation) SetWorkloadId(v string) *ShareInvitation {
	s.WorkloadId = &v
	return s
}

// A share invitation summary return object.
type ShareInvitationSummary struct {
	_ struct{} `type:"structure"`

	// Permission granted on a workload share.
	PermissionType *string `type:"string" enum:"PermissionType"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// An AWS account ID.
	SharedBy *string `type:"string"`

	// The AWS account ID or IAM role with which the workload is shared.
	SharedWith *string `min:"12" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitationSummary) GoString() string {
	return s.String()
}

// SetPermissionType sets the PermissionType field's value.
func (s *ShareInvitationSummary) SetPermissionType(v string) *ShareInvitationSummary {
	s.PermissionType = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *ShareInvitationSummary) SetShareInvitationId(v string) *ShareInvitationSummary {
	s.ShareInvitationId = &v
	return s
}

// SetSharedBy sets the SharedBy field's value.
func (s *ShareInvitationSummary) SetSharedBy(v string) *ShareInvitationSummary {
	s.SharedBy = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *ShareInvitationSummary) SetSharedWith(v string) *ShareInvitationSummary {
	s.SharedWith = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ShareInvitationSummary) SetWorkloadId(v string) *ShareInvitationSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *ShareInvitationSummary) SetWorkloadName(v string) *ShareInvitationSummary {
	s.WorkloadName = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`

	// The ARN for the workload.
	//
	// WorkloadArn is a required field
	WorkloadArn *string `location:"uri" locationName:"WorkloadArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkloadArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadArn"))
	}
	if s.WorkloadArn != nil && len(*s.WorkloadArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *TagResourceInput) SetWorkloadArn(v string) *TagResourceInput {
	s.WorkloadArn = &v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	QuotaCode *string `type:"string"`

	// Service Quotas requirement to identify originating service.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A list of tag keys. Existing tags of the resource whose keys are members
	// of this list are removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`

	// The ARN for the workload.
	//
	// WorkloadArn is a required field
	WorkloadArn *string `location:"uri" locationName:"WorkloadArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}
	if s.WorkloadArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadArn"))
	}
	if s.WorkloadArn != nil && len(*s.WorkloadArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *UntagResourceInput) SetWorkloadArn(v string) *UntagResourceInput {
	s.WorkloadArn = &v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Input to update answer.
type UpdateAnswerInput struct {
	_ struct{} `type:"structure"`

	// A list of choices to update on a question in your workload. The String key
	// corresponds to the choice ID to be updated.
	ChoiceUpdates map[string]*ChoiceUpdate `type:"map"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `location:"uri" locationName:"QuestionId" min:"1" type:"string" required:"true"`

	// The reason why a question is not applicable to your workload.
	Reason *string `type:"string" enum:"AnswerReason"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnswerInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}
	if s.ChoiceUpdates != nil {
		for i, v := range s.ChoiceUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChoiceUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChoiceUpdates sets the ChoiceUpdates field's value.
func (s *UpdateAnswerInput) SetChoiceUpdates(v map[string]*ChoiceUpdate) *UpdateAnswerInput {
	s.ChoiceUpdates = v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *UpdateAnswerInput) SetIsApplicable(v bool) *UpdateAnswerInput {
	s.IsApplicable = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateAnswerInput) SetLensAlias(v string) *UpdateAnswerInput {
	s.LensAlias = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *UpdateAnswerInput) SetNotes(v string) *UpdateAnswerInput {
	s.Notes = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *UpdateAnswerInput) SetQuestionId(v string) *UpdateAnswerInput {
	s.QuestionId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UpdateAnswerInput) SetReason(v string) *UpdateAnswerInput {
	s.Reason = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *UpdateAnswerInput) SetSelectedChoices(v []*string) *UpdateAnswerInput {
	s.SelectedChoices = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateAnswerInput) SetWorkloadId(v string) *UpdateAnswerInput {
	s.WorkloadId = &v
	return s
}

// Output of a update answer call.
type UpdateAnswerOutput struct {
	_ struct{} `type:"structure"`

	// An answer of the question.
	Answer *Answer `type:"structure"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *UpdateAnswerOutput) SetAnswer(v *Answer) *UpdateAnswerOutput {
	s.Answer = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateAnswerOutput) SetLensAlias(v string) *UpdateAnswerOutput {
	s.LensAlias = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateAnswerOutput) SetWorkloadId(v string) *UpdateAnswerOutput {
	s.WorkloadId = &v
	return s
}

// Input for update lens review.
type UpdateLensReviewInput struct {
	_ struct{} `type:"structure"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The notes associated with the workload.
	LensNotes *string `type:"string"`

	// List of pillar notes of a lens review in a workload.
	PillarNotes map[string]*string `type:"map"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateLensReviewInput) SetLensAlias(v string) *UpdateLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetLensNotes sets the LensNotes field's value.
func (s *UpdateLensReviewInput) SetLensNotes(v string) *UpdateLensReviewInput {
	s.LensNotes = &v
	return s
}

// SetPillarNotes sets the PillarNotes field's value.
func (s *UpdateLensReviewInput) SetPillarNotes(v map[string]*string) *UpdateLensReviewInput {
	s.PillarNotes = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateLensReviewInput) SetWorkloadId(v string) *UpdateLensReviewInput {
	s.WorkloadId = &v
	return s
}

// Output of a update lens review call.
type UpdateLensReviewOutput struct {
	_ struct{} `type:"structure"`

	// A lens review of a question.
	LensReview *LensReview `type:"structure"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewOutput) GoString() string {
	return s.String()
}

// SetLensReview sets the LensReview field's value.
func (s *UpdateLensReviewOutput) SetLensReview(v *LensReview) *UpdateLensReviewOutput {
	s.LensReview = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateLensReviewOutput) SetWorkloadId(v string) *UpdateLensReviewOutput {
	s.WorkloadId = &v
	return s
}

// Input for Update Share Invitation
type UpdateShareInvitationInput struct {
	_ struct{} `type:"structure"`

	// Share invitation action taken by contributor.
	//
	// ShareInvitationAction is a required field
	ShareInvitationAction *string `type:"string" required:"true" enum:"ShareInvitationAction"`

	// The ID assigned to the share invitation.
	//
	// ShareInvitationId is a required field
	ShareInvitationId *string `location:"uri" locationName:"ShareInvitationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateShareInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateShareInvitationInput"}
	if s.ShareInvitationAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareInvitationAction"))
	}
	if s.ShareInvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareInvitationId"))
	}
	if s.ShareInvitationId != nil && len(*s.ShareInvitationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareInvitationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShareInvitationAction sets the ShareInvitationAction field's value.
func (s *UpdateShareInvitationInput) SetShareInvitationAction(v string) *UpdateShareInvitationInput {
	s.ShareInvitationAction = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *UpdateShareInvitationInput) SetShareInvitationId(v string) *UpdateShareInvitationInput {
	s.ShareInvitationId = &v
	return s
}

type UpdateShareInvitationOutput struct {
	_ struct{} `type:"structure"`

	// The updated workload share invitation.
	ShareInvitation *ShareInvitation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationOutput) GoString() string {
	return s.String()
}

// SetShareInvitation sets the ShareInvitation field's value.
func (s *UpdateShareInvitationOutput) SetShareInvitation(v *ShareInvitation) *UpdateShareInvitationOutput {
	s.ShareInvitation = v
	return s
}

// Input to update a workload.
type UpdateWorkloadInput struct {
	_ struct{} `type:"structure"`

	// The list of AWS account IDs associated with the workload.
	AccountIds []*string `type:"list"`

	// The URL of the architectural design for the workload.
	ArchitecturalDesign *string `type:"string"`

	// The list of AWS Regions associated with the workload, for example, us-east-2,
	// or ca-central-1.
	AwsRegions []*string `type:"list"`

	// The description for the workload.
	Description *string `min:"3" type:"string"`

	// The environment for the workload.
	Environment *string `type:"string" enum:"WorkloadEnvironment"`

	// The improvement status for a workload.
	ImprovementStatus *string `type:"string" enum:"WorkloadImprovementStatus"`

	// The industry for the workload.
	Industry *string `type:"string"`

	// The industry type for the workload.
	//
	// If specified, must be one of the following:
	//
	//    * Agriculture
	//
	//    * Automobile
	//
	//    * Defense
	//
	//    * Design and Engineering
	//
	//    * Digital Advertising
	//
	//    * Education
	//
	//    * Environmental Protection
	//
	//    * Financial Services
	//
	//    * Gaming
	//
	//    * General Public Services
	//
	//    * Healthcare
	//
	//    * Hospitality
	//
	//    * InfoTech
	//
	//    * Justice and Public Safety
	//
	//    * Life Sciences
	//
	//    * Manufacturing
	//
	//    * Media & Entertainment
	//
	//    * Mining & Resources
	//
	//    * Oil & Gas
	//
	//    * Power & Utilities
	//
	//    * Professional Services
	//
	//    * Real Estate & Construction
	//
	//    * Retail & Wholesale
	//
	//    * Social Protection
	//
	//    * Telecommunications
	//
	//    * Travel, Transportation & Logistics
	//
	//    * Other
	IndustryType *string `type:"string"`

	// Flag indicating whether the workload owner has acknowledged that the Review
	// owner field is required.
	//
	// If a Review owner is not added to the workload within 60 days of acknowledgement,
	// access to the workload is restricted until an owner is added.
	IsReviewOwnerUpdateAcknowledged *bool `type:"boolean"`

	// The list of non-AWS Regions associated with the workload.
	NonAwsRegions []*string `type:"list"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// The priorities of the pillars, which are used to order items in the improvement
	// plan. Each pillar is represented by its PillarReviewSummary$PillarId.
	PillarPriorities []*string `type:"list"`

	// The review owner of the workload. The name, email address, or identifier
	// for the primary group or individual that owns the workload review process.
	ReviewOwner *string `min:"3" type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkloadInput"}
	if s.Description != nil && len(*s.Description) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 3))
	}
	if s.ReviewOwner != nil && len(*s.ReviewOwner) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ReviewOwner", 3))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *UpdateWorkloadInput) SetAccountIds(v []*string) *UpdateWorkloadInput {
	s.AccountIds = v
	return s
}

// SetArchitecturalDesign sets the ArchitecturalDesign field's value.
func (s *UpdateWorkloadInput) SetArchitecturalDesign(v string) *UpdateWorkloadInput {
	s.ArchitecturalDesign = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *UpdateWorkloadInput) SetAwsRegions(v []*string) *UpdateWorkloadInput {
	s.AwsRegions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkloadInput) SetDescription(v string) *UpdateWorkloadInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateWorkloadInput) SetEnvironment(v string) *UpdateWorkloadInput {
	s.Environment = &v
	return s
}

// SetImprovementStatus sets the ImprovementStatus field's value.
func (s *UpdateWorkloadInput) SetImprovementStatus(v string) *UpdateWorkloadInput {
	s.ImprovementStatus = &v
	return s
}

// SetIndustry sets the Industry field's value.
func (s *UpdateWorkloadInput) SetIndustry(v string) *UpdateWorkloadInput {
	s.Industry = &v
	return s
}

// SetIndustryType sets the IndustryType field's value.
func (s *UpdateWorkloadInput) SetIndustryType(v string) *UpdateWorkloadInput {
	s.IndustryType = &v
	return s
}

// SetIsReviewOwnerUpdateAcknowledged sets the IsReviewOwnerUpdateAcknowledged field's value.
func (s *UpdateWorkloadInput) SetIsReviewOwnerUpdateAcknowledged(v bool) *UpdateWorkloadInput {
	s.IsReviewOwnerUpdateAcknowledged = &v
	return s
}

// SetNonAwsRegions sets the NonAwsRegions field's value.
func (s *UpdateWorkloadInput) SetNonAwsRegions(v []*string) *UpdateWorkloadInput {
	s.NonAwsRegions = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *UpdateWorkloadInput) SetNotes(v string) *UpdateWorkloadInput {
	s.Notes = &v
	return s
}

// SetPillarPriorities sets the PillarPriorities field's value.
func (s *UpdateWorkloadInput) SetPillarPriorities(v []*string) *UpdateWorkloadInput {
	s.PillarPriorities = v
	return s
}

// SetReviewOwner sets the ReviewOwner field's value.
func (s *UpdateWorkloadInput) SetReviewOwner(v string) *UpdateWorkloadInput {
	s.ReviewOwner = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateWorkloadInput) SetWorkloadId(v string) *UpdateWorkloadInput {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *UpdateWorkloadInput) SetWorkloadName(v string) *UpdateWorkloadInput {
	s.WorkloadName = &v
	return s
}

// Output of an update workload call.
type UpdateWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// A workload return object.
	Workload *Workload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkload sets the Workload field's value.
func (s *UpdateWorkloadOutput) SetWorkload(v *Workload) *UpdateWorkloadOutput {
	s.Workload = v
	return s
}

// Input for Update Workload Share
type UpdateWorkloadShareInput struct {
	_ struct{} `type:"structure"`

	// Permission granted on a workload share.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"PermissionType"`

	// The ID associated with the workload share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkloadShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkloadShareInput"}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissionType sets the PermissionType field's value.
func (s *UpdateWorkloadShareInput) SetPermissionType(v string) *UpdateWorkloadShareInput {
	s.PermissionType = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *UpdateWorkloadShareInput) SetShareId(v string) *UpdateWorkloadShareInput {
	s.ShareId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateWorkloadShareInput) SetWorkloadId(v string) *UpdateWorkloadShareInput {
	s.WorkloadId = &v
	return s
}

// Input for Update Workload Share
type UpdateWorkloadShareOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// A workload share return object.
	WorkloadShare *WorkloadShare `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareOutput) GoString() string {
	return s.String()
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateWorkloadShareOutput) SetWorkloadId(v string) *UpdateWorkloadShareOutput {
	s.WorkloadId = &v
	return s
}

// SetWorkloadShare sets the WorkloadShare field's value.
func (s *UpdateWorkloadShareOutput) SetWorkloadShare(v *WorkloadShare) *UpdateWorkloadShareOutput {
	s.WorkloadShare = v
	return s
}

type UpgradeLensReviewInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after it has completed
	// successfully, the result of the original request is returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// AWS SDKs automatically generate one for you. If you are not using the AWS
	// SDK or the AWS CLI, you must provide this token or the request will fail.
	ClientRequestToken *string `type:"string"`

	// The alias of the lens, for example, serverless.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	//
	// MilestoneName is a required field
	MilestoneName *string `min:"3" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("MilestoneName"))
	}
	if s.MilestoneName != nil && len(*s.MilestoneName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("MilestoneName", 3))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpgradeLensReviewInput) SetClientRequestToken(v string) *UpgradeLensReviewInput {
	s.ClientRequestToken = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpgradeLensReviewInput) SetLensAlias(v string) *UpgradeLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *UpgradeLensReviewInput) SetMilestoneName(v string) *UpgradeLensReviewInput {
	s.MilestoneName = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpgradeLensReviewInput) SetWorkloadId(v string) *UpgradeLensReviewInput {
	s.WorkloadId = &v
	return s
}

type UpgradeLensReviewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewOutput) GoString() string {
	return s.String()
}

// The user input is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error, if applicable.
	Fields []*ValidationExceptionField `type:"list"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// The reason why the request failed validation.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field passed inside a request that resulted in
// an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Description of the error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The field name for which validation failed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The differences between the base and latest versions of the lens.
type VersionDifferences struct {
	_ struct{} `type:"structure"`

	// The differences between the base and latest versions of the lens.
	PillarDifferences []*PillarDifference `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionDifferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionDifferences) GoString() string {
	return s.String()
}

// SetPillarDifferences sets the PillarDifferences field's value.
func (s *VersionDifferences) SetPillarDifferences(v []*PillarDifference) *VersionDifferences {
	s.PillarDifferences = v
	return s
}

// A workload return object.
type Workload struct {
	_ struct{} `type:"structure"`

	// The list of AWS account IDs associated with the workload.
	AccountIds []*string `type:"list"`

	// The URL of the architectural design for the workload.
	ArchitecturalDesign *string `type:"string"`

	// The list of AWS Regions associated with the workload, for example, us-east-2,
	// or ca-central-1.
	AwsRegions []*string `type:"list"`

	// The description for the workload.
	Description *string `min:"3" type:"string"`

	// The environment for the workload.
	Environment *string `type:"string" enum:"WorkloadEnvironment"`

	// The improvement status for a workload.
	ImprovementStatus *string `type:"string" enum:"WorkloadImprovementStatus"`

	// The industry for the workload.
	Industry *string `type:"string"`

	// The industry type for the workload.
	//
	// If specified, must be one of the following:
	//
	//    * Agriculture
	//
	//    * Automobile
	//
	//    * Defense
	//
	//    * Design and Engineering
	//
	//    * Digital Advertising
	//
	//    * Education
	//
	//    * Environmental Protection
	//
	//    * Financial Services
	//
	//    * Gaming
	//
	//    * General Public Services
	//
	//    * Healthcare
	//
	//    * Hospitality
	//
	//    * InfoTech
	//
	//    * Justice and Public Safety
	//
	//    * Life Sciences
	//
	//    * Manufacturing
	//
	//    * Media & Entertainment
	//
	//    * Mining & Resources
	//
	//    * Oil & Gas
	//
	//    * Power & Utilities
	//
	//    * Professional Services
	//
	//    * Real Estate & Construction
	//
	//    * Retail & Wholesale
	//
	//    * Social Protection
	//
	//    * Telecommunications
	//
	//    * Travel, Transportation & Logistics
	//
	//    * Other
	IndustryType *string `type:"string"`

	// Flag indicating whether the workload owner has acknowledged that the Review
	// owner field is required.
	//
	// If a Review owner is not added to the workload within 60 days of acknowledgement,
	// access to the workload is restricted until an owner is added.
	IsReviewOwnerUpdateAcknowledged *bool `type:"boolean"`

	// The list of lenses associated with the workload. Each lens is identified
	// by its LensSummary$LensAlias.
	Lenses []*string `type:"list"`

	// The list of non-AWS Regions associated with the workload.
	NonAwsRegions []*string `type:"list"`

	// The notes associated with the workload.
	Notes *string `type:"string"`

	// An AWS account ID.
	Owner *string `type:"string"`

	// The priorities of the pillars, which are used to order items in the improvement
	// plan. Each pillar is represented by its PillarReviewSummary$PillarId.
	PillarPriorities []*string `type:"list"`

	// The review owner of the workload. The name, email address, or identifier
	// for the primary group or individual that owns the workload review process.
	ReviewOwner *string `min:"3" type:"string"`

	// The date and time recorded.
	ReviewRestrictionDate *time.Time `type:"timestamp"`

	// A map from risk names to the count of how questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The tags associated with the workload.
	Tags map[string]*string `min:"1" type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workload) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *Workload) SetAccountIds(v []*string) *Workload {
	s.AccountIds = v
	return s
}

// SetArchitecturalDesign sets the ArchitecturalDesign field's value.
func (s *Workload) SetArchitecturalDesign(v string) *Workload {
	s.ArchitecturalDesign = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *Workload) SetAwsRegions(v []*string) *Workload {
	s.AwsRegions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Workload) SetDescription(v string) *Workload {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Workload) SetEnvironment(v string) *Workload {
	s.Environment = &v
	return s
}

// SetImprovementStatus sets the ImprovementStatus field's value.
func (s *Workload) SetImprovementStatus(v string) *Workload {
	s.ImprovementStatus = &v
	return s
}

// SetIndustry sets the Industry field's value.
func (s *Workload) SetIndustry(v string) *Workload {
	s.Industry = &v
	return s
}

// SetIndustryType sets the IndustryType field's value.
func (s *Workload) SetIndustryType(v string) *Workload {
	s.IndustryType = &v
	return s
}

// SetIsReviewOwnerUpdateAcknowledged sets the IsReviewOwnerUpdateAcknowledged field's value.
func (s *Workload) SetIsReviewOwnerUpdateAcknowledged(v bool) *Workload {
	s.IsReviewOwnerUpdateAcknowledged = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *Workload) SetLenses(v []*string) *Workload {
	s.Lenses = v
	return s
}

// SetNonAwsRegions sets the NonAwsRegions field's value.
func (s *Workload) SetNonAwsRegions(v []*string) *Workload {
	s.NonAwsRegions = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *Workload) SetNotes(v string) *Workload {
	s.Notes = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Workload) SetOwner(v string) *Workload {
	s.Owner = &v
	return s
}

// SetPillarPriorities sets the PillarPriorities field's value.
func (s *Workload) SetPillarPriorities(v []*string) *Workload {
	s.PillarPriorities = v
	return s
}

// SetReviewOwner sets the ReviewOwner field's value.
func (s *Workload) SetReviewOwner(v string) *Workload {
	s.ReviewOwner = &v
	return s
}

// SetReviewRestrictionDate sets the ReviewRestrictionDate field's value.
func (s *Workload) SetReviewRestrictionDate(v time.Time) *Workload {
	s.ReviewRestrictionDate = &v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *Workload) SetRiskCounts(v map[string]*int64) *Workload {
	s.RiskCounts = v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *Workload) SetShareInvitationId(v string) *Workload {
	s.ShareInvitationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Workload) SetTags(v map[string]*string) *Workload {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Workload) SetUpdatedAt(v time.Time) *Workload {
	s.UpdatedAt = &v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *Workload) SetWorkloadArn(v string) *Workload {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *Workload) SetWorkloadId(v string) *Workload {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *Workload) SetWorkloadName(v string) *Workload {
	s.WorkloadName = &v
	return s
}

// A workload share return object.
type WorkloadShare struct {
	_ struct{} `type:"structure"`

	// Permission granted on a workload share.
	PermissionType *string `type:"string" enum:"PermissionType"`

	// The ID associated with the workload share.
	ShareId *string `type:"string"`

	// An AWS account ID.
	SharedBy *string `type:"string"`

	// The AWS account ID or IAM role with which the workload is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of a workload share.
	Status *string `type:"string" enum:"ShareStatus"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShare) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShare) GoString() string {
	return s.String()
}

// SetPermissionType sets the PermissionType field's value.
func (s *WorkloadShare) SetPermissionType(v string) *WorkloadShare {
	s.PermissionType = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *WorkloadShare) SetShareId(v string) *WorkloadShare {
	s.ShareId = &v
	return s
}

// SetSharedBy sets the SharedBy field's value.
func (s *WorkloadShare) SetSharedBy(v string) *WorkloadShare {
	s.SharedBy = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *WorkloadShare) SetSharedWith(v string) *WorkloadShare {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkloadShare) SetStatus(v string) *WorkloadShare {
	s.Status = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *WorkloadShare) SetWorkloadId(v string) *WorkloadShare {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadShare) SetWorkloadName(v string) *WorkloadShare {
	s.WorkloadName = &v
	return s
}

// A workload share summary return object.
type WorkloadShareSummary struct {
	_ struct{} `type:"structure"`

	// Permission granted on a workload share.
	PermissionType *string `type:"string" enum:"PermissionType"`

	// The ID associated with the workload share.
	ShareId *string `type:"string"`

	// The AWS account ID or IAM role with which the workload is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of a workload share.
	Status *string `type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShareSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShareSummary) GoString() string {
	return s.String()
}

// SetPermissionType sets the PermissionType field's value.
func (s *WorkloadShareSummary) SetPermissionType(v string) *WorkloadShareSummary {
	s.PermissionType = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *WorkloadShareSummary) SetShareId(v string) *WorkloadShareSummary {
	s.ShareId = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *WorkloadShareSummary) SetSharedWith(v string) *WorkloadShareSummary {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkloadShareSummary) SetStatus(v string) *WorkloadShareSummary {
	s.Status = &v
	return s
}

// A workload summary return object.
type WorkloadSummary struct {
	_ struct{} `type:"structure"`

	// The improvement status for a workload.
	ImprovementStatus *string `type:"string" enum:"WorkloadImprovementStatus"`

	// The list of lenses associated with the workload. Each lens is identified
	// by its LensSummary$LensAlias.
	Lenses []*string `type:"list"`

	// An AWS account ID.
	Owner *string `type:"string"`

	// A map from risk names to the count of how questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an AWS Region.
	WorkloadId *string `type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within a Region. Spaces and capitalization
	// are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadSummary) GoString() string {
	return s.String()
}

// SetImprovementStatus sets the ImprovementStatus field's value.
func (s *WorkloadSummary) SetImprovementStatus(v string) *WorkloadSummary {
	s.ImprovementStatus = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *WorkloadSummary) SetLenses(v []*string) *WorkloadSummary {
	s.Lenses = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkloadSummary) SetOwner(v string) *WorkloadSummary {
	s.Owner = &v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *WorkloadSummary) SetRiskCounts(v map[string]*int64) *WorkloadSummary {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *WorkloadSummary) SetUpdatedAt(v time.Time) *WorkloadSummary {
	s.UpdatedAt = &v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *WorkloadSummary) SetWorkloadArn(v string) *WorkloadSummary {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *WorkloadSummary) SetWorkloadId(v string) *WorkloadSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadSummary) SetWorkloadName(v string) *WorkloadSummary {
	s.WorkloadName = &v
	return s
}

const (
	// AnswerReasonOutOfScope is a AnswerReason enum value
	AnswerReasonOutOfScope = "OUT_OF_SCOPE"

	// AnswerReasonBusinessPriorities is a AnswerReason enum value
	AnswerReasonBusinessPriorities = "BUSINESS_PRIORITIES"

	// AnswerReasonArchitectureConstraints is a AnswerReason enum value
	AnswerReasonArchitectureConstraints = "ARCHITECTURE_CONSTRAINTS"

	// AnswerReasonOther is a AnswerReason enum value
	AnswerReasonOther = "OTHER"

	// AnswerReasonNone is a AnswerReason enum value
	AnswerReasonNone = "NONE"
)

// AnswerReason_Values returns all elements of the AnswerReason enum
func AnswerReason_Values() []string {
	return []string{
		AnswerReasonOutOfScope,
		AnswerReasonBusinessPriorities,
		AnswerReasonArchitectureConstraints,
		AnswerReasonOther,
		AnswerReasonNone,
	}
}

const (
	// ChoiceReasonOutOfScope is a ChoiceReason enum value
	ChoiceReasonOutOfScope = "OUT_OF_SCOPE"

	// ChoiceReasonBusinessPriorities is a ChoiceReason enum value
	ChoiceReasonBusinessPriorities = "BUSINESS_PRIORITIES"

	// ChoiceReasonArchitectureConstraints is a ChoiceReason enum value
	ChoiceReasonArchitectureConstraints = "ARCHITECTURE_CONSTRAINTS"

	// ChoiceReasonOther is a ChoiceReason enum value
	ChoiceReasonOther = "OTHER"

	// ChoiceReasonNone is a ChoiceReason enum value
	ChoiceReasonNone = "NONE"
)

// ChoiceReason_Values returns all elements of the ChoiceReason enum
func ChoiceReason_Values() []string {
	return []string{
		ChoiceReasonOutOfScope,
		ChoiceReasonBusinessPriorities,
		ChoiceReasonArchitectureConstraints,
		ChoiceReasonOther,
		ChoiceReasonNone,
	}
}

const (
	// ChoiceStatusSelected is a ChoiceStatus enum value
	ChoiceStatusSelected = "SELECTED"

	// ChoiceStatusNotApplicable is a ChoiceStatus enum value
	ChoiceStatusNotApplicable = "NOT_APPLICABLE"

	// ChoiceStatusUnselected is a ChoiceStatus enum value
	ChoiceStatusUnselected = "UNSELECTED"
)

// ChoiceStatus_Values returns all elements of the ChoiceStatus enum
func ChoiceStatus_Values() []string {
	return []string{
		ChoiceStatusSelected,
		ChoiceStatusNotApplicable,
		ChoiceStatusUnselected,
	}
}

const (
	// DifferenceStatusUpdated is a DifferenceStatus enum value
	DifferenceStatusUpdated = "UPDATED"

	// DifferenceStatusNew is a DifferenceStatus enum value
	DifferenceStatusNew = "NEW"

	// DifferenceStatusDeleted is a DifferenceStatus enum value
	DifferenceStatusDeleted = "DELETED"
)

// DifferenceStatus_Values returns all elements of the DifferenceStatus enum
func DifferenceStatus_Values() []string {
	return []string{
		DifferenceStatusUpdated,
		DifferenceStatusNew,
		DifferenceStatusDeleted,
	}
}

const (
	// LensStatusCurrent is a LensStatus enum value
	LensStatusCurrent = "CURRENT"

	// LensStatusNotCurrent is a LensStatus enum value
	LensStatusNotCurrent = "NOT_CURRENT"

	// LensStatusDeprecated is a LensStatus enum value
	LensStatusDeprecated = "DEPRECATED"
)

// LensStatus_Values returns all elements of the LensStatus enum
func LensStatus_Values() []string {
	return []string{
		LensStatusCurrent,
		LensStatusNotCurrent,
		LensStatusDeprecated,
	}
}

const (
	// NotificationTypeLensVersionUpgraded is a NotificationType enum value
	NotificationTypeLensVersionUpgraded = "LENS_VERSION_UPGRADED"

	// NotificationTypeLensVersionDeprecated is a NotificationType enum value
	NotificationTypeLensVersionDeprecated = "LENS_VERSION_DEPRECATED"
)

// NotificationType_Values returns all elements of the NotificationType enum
func NotificationType_Values() []string {
	return []string{
		NotificationTypeLensVersionUpgraded,
		NotificationTypeLensVersionDeprecated,
	}
}

// Permission granted on a workload share.
const (
	// PermissionTypeReadonly is a PermissionType enum value
	PermissionTypeReadonly = "READONLY"

	// PermissionTypeContributor is a PermissionType enum value
	PermissionTypeContributor = "CONTRIBUTOR"
)

// PermissionType_Values returns all elements of the PermissionType enum
func PermissionType_Values() []string {
	return []string{
		PermissionTypeReadonly,
		PermissionTypeContributor,
	}
}

// The risk for a given workload, lens review, pillar, or question.
const (
	// RiskUnanswered is a Risk enum value
	RiskUnanswered = "UNANSWERED"

	// RiskHigh is a Risk enum value
	RiskHigh = "HIGH"

	// RiskMedium is a Risk enum value
	RiskMedium = "MEDIUM"

	// RiskNone is a Risk enum value
	RiskNone = "NONE"

	// RiskNotApplicable is a Risk enum value
	RiskNotApplicable = "NOT_APPLICABLE"
)

// Risk_Values returns all elements of the Risk enum
func Risk_Values() []string {
	return []string{
		RiskUnanswered,
		RiskHigh,
		RiskMedium,
		RiskNone,
		RiskNotApplicable,
	}
}

// Share invitation action taken by contributor.
const (
	// ShareInvitationActionAccept is a ShareInvitationAction enum value
	ShareInvitationActionAccept = "ACCEPT"

	// ShareInvitationActionReject is a ShareInvitationAction enum value
	ShareInvitationActionReject = "REJECT"
)

// ShareInvitationAction_Values returns all elements of the ShareInvitationAction enum
func ShareInvitationAction_Values() []string {
	return []string{
		ShareInvitationActionAccept,
		ShareInvitationActionReject,
	}
}

// The status of a workload share.
const (
	// ShareStatusAccepted is a ShareStatus enum value
	ShareStatusAccepted = "ACCEPTED"

	// ShareStatusRejected is a ShareStatus enum value
	ShareStatusRejected = "REJECTED"

	// ShareStatusPending is a ShareStatus enum value
	ShareStatusPending = "PENDING"

	// ShareStatusRevoked is a ShareStatus enum value
	ShareStatusRevoked = "REVOKED"

	// ShareStatusExpired is a ShareStatus enum value
	ShareStatusExpired = "EXPIRED"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusAccepted,
		ShareStatusRejected,
		ShareStatusPending,
		ShareStatusRevoked,
		ShareStatusExpired,
	}
}

// The reason why the request failed validation.
const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

// The environment for the workload.
const (
	// WorkloadEnvironmentProduction is a WorkloadEnvironment enum value
	WorkloadEnvironmentProduction = "PRODUCTION"

	// WorkloadEnvironmentPreproduction is a WorkloadEnvironment enum value
	WorkloadEnvironmentPreproduction = "PREPRODUCTION"
)

// WorkloadEnvironment_Values returns all elements of the WorkloadEnvironment enum
func WorkloadEnvironment_Values() []string {
	return []string{
		WorkloadEnvironmentProduction,
		WorkloadEnvironmentPreproduction,
	}
}

// The improvement status for a workload.
const (
	// WorkloadImprovementStatusNotApplicable is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusNotApplicable = "NOT_APPLICABLE"

	// WorkloadImprovementStatusNotStarted is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusNotStarted = "NOT_STARTED"

	// WorkloadImprovementStatusInProgress is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusInProgress = "IN_PROGRESS"

	// WorkloadImprovementStatusComplete is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusComplete = "COMPLETE"

	// WorkloadImprovementStatusRiskAcknowledged is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusRiskAcknowledged = "RISK_ACKNOWLEDGED"
)

// WorkloadImprovementStatus_Values returns all elements of the WorkloadImprovementStatus enum
func WorkloadImprovementStatus_Values() []string {
	return []string{
		WorkloadImprovementStatusNotApplicable,
		WorkloadImprovementStatusNotStarted,
		WorkloadImprovementStatusInProgress,
		WorkloadImprovementStatusComplete,
		WorkloadImprovementStatusRiskAcknowledged,
	}
}
