// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectcampaigns

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCampaignRequest method.
//	req, resp := client.CreateCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/CreateCampaign
func (c *ConnectCampaigns) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "PUT",
		HTTPPath:   "/campaigns",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for AmazonConnectCampaignService.
//
// Creates a campaign for the specified Amazon Connect account. This API is
// idempotent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/CreateCampaign
func (c *ConnectCampaigns) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCampaignRequest method.
//	req, resp := client.DeleteCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteCampaign
func (c *ConnectCampaigns) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "DELETE",
		HTTPPath:   "/campaigns/{id}",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCampaign API operation for AmazonConnectCampaignService.
//
// Deletes a campaign from the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteCampaign
func (c *ConnectCampaigns) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectInstanceConfig = "DeleteConnectInstanceConfig"

// DeleteConnectInstanceConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectInstanceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectInstanceConfig for more information on using the DeleteConnectInstanceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectInstanceConfigRequest method.
//	req, resp := client.DeleteConnectInstanceConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteConnectInstanceConfig
func (c *ConnectCampaigns) DeleteConnectInstanceConfigRequest(input *DeleteConnectInstanceConfigInput) (req *request.Request, output *DeleteConnectInstanceConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectInstanceConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/connect-instance/{connectInstanceId}/config",
	}

	if input == nil {
		input = &DeleteConnectInstanceConfigInput{}
	}

	output = &DeleteConnectInstanceConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectInstanceConfig API operation for AmazonConnectCampaignService.
//
// Deletes a connect instance config from the specified AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation DeleteConnectInstanceConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InvalidStateException
//     The request could not be processed because of conflict in the current state.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteConnectInstanceConfig
func (c *ConnectCampaigns) DeleteConnectInstanceConfig(input *DeleteConnectInstanceConfigInput) (*DeleteConnectInstanceConfigOutput, error) {
	req, out := c.DeleteConnectInstanceConfigRequest(input)
	return out, req.Send()
}

// DeleteConnectInstanceConfigWithContext is the same as DeleteConnectInstanceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectInstanceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) DeleteConnectInstanceConfigWithContext(ctx aws.Context, input *DeleteConnectInstanceConfigInput, opts ...request.Option) (*DeleteConnectInstanceConfigOutput, error) {
	req, out := c.DeleteConnectInstanceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceOnboardingJob = "DeleteInstanceOnboardingJob"

// DeleteInstanceOnboardingJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceOnboardingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceOnboardingJob for more information on using the DeleteInstanceOnboardingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceOnboardingJobRequest method.
//	req, resp := client.DeleteInstanceOnboardingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteInstanceOnboardingJob
func (c *ConnectCampaigns) DeleteInstanceOnboardingJobRequest(input *DeleteInstanceOnboardingJobInput) (req *request.Request, output *DeleteInstanceOnboardingJobOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceOnboardingJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/connect-instance/{connectInstanceId}/onboarding",
	}

	if input == nil {
		input = &DeleteInstanceOnboardingJobInput{}
	}

	output = &DeleteInstanceOnboardingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstanceOnboardingJob API operation for AmazonConnectCampaignService.
//
// Delete the Connect Campaigns onboarding job for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation DeleteInstanceOnboardingJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InvalidStateException
//     The request could not be processed because of conflict in the current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DeleteInstanceOnboardingJob
func (c *ConnectCampaigns) DeleteInstanceOnboardingJob(input *DeleteInstanceOnboardingJobInput) (*DeleteInstanceOnboardingJobOutput, error) {
	req, out := c.DeleteInstanceOnboardingJobRequest(input)
	return out, req.Send()
}

// DeleteInstanceOnboardingJobWithContext is the same as DeleteInstanceOnboardingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceOnboardingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) DeleteInstanceOnboardingJobWithContext(ctx aws.Context, input *DeleteInstanceOnboardingJobInput, opts ...request.Option) (*DeleteInstanceOnboardingJobOutput, error) {
	req, out := c.DeleteInstanceOnboardingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCampaign = "DescribeCampaign"

// DescribeCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCampaign for more information on using the DescribeCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCampaignRequest method.
//	req, resp := client.DescribeCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DescribeCampaign
func (c *ConnectCampaigns) DescribeCampaignRequest(input *DescribeCampaignInput) (req *request.Request, output *DescribeCampaignOutput) {
	op := &request.Operation{
		Name:       opDescribeCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/campaigns/{id}",
	}

	if input == nil {
		input = &DescribeCampaignInput{}
	}

	output = &DescribeCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCampaign API operation for AmazonConnectCampaignService.
//
// Describes the specific campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation DescribeCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DescribeCampaign
func (c *ConnectCampaigns) DescribeCampaign(input *DescribeCampaignInput) (*DescribeCampaignOutput, error) {
	req, out := c.DescribeCampaignRequest(input)
	return out, req.Send()
}

// DescribeCampaignWithContext is the same as DescribeCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) DescribeCampaignWithContext(ctx aws.Context, input *DescribeCampaignInput, opts ...request.Option) (*DescribeCampaignOutput, error) {
	req, out := c.DescribeCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignState = "GetCampaignState"

// GetCampaignStateRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignState for more information on using the GetCampaignState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCampaignStateRequest method.
//	req, resp := client.GetCampaignStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignState
func (c *ConnectCampaigns) GetCampaignStateRequest(input *GetCampaignStateInput) (req *request.Request, output *GetCampaignStateOutput) {
	op := &request.Operation{
		Name:       opGetCampaignState,
		HTTPMethod: "GET",
		HTTPPath:   "/campaigns/{id}/state",
	}

	if input == nil {
		input = &GetCampaignStateInput{}
	}

	output = &GetCampaignStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignState API operation for AmazonConnectCampaignService.
//
// Get state of a campaign for the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation GetCampaignState for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignState
func (c *ConnectCampaigns) GetCampaignState(input *GetCampaignStateInput) (*GetCampaignStateOutput, error) {
	req, out := c.GetCampaignStateRequest(input)
	return out, req.Send()
}

// GetCampaignStateWithContext is the same as GetCampaignState with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) GetCampaignStateWithContext(ctx aws.Context, input *GetCampaignStateInput, opts ...request.Option) (*GetCampaignStateOutput, error) {
	req, out := c.GetCampaignStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignStateBatch = "GetCampaignStateBatch"

// GetCampaignStateBatchRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignStateBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignStateBatch for more information on using the GetCampaignStateBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCampaignStateBatchRequest method.
//	req, resp := client.GetCampaignStateBatchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignStateBatch
func (c *ConnectCampaigns) GetCampaignStateBatchRequest(input *GetCampaignStateBatchInput) (req *request.Request, output *GetCampaignStateBatchOutput) {
	op := &request.Operation{
		Name:       opGetCampaignStateBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns-state",
	}

	if input == nil {
		input = &GetCampaignStateBatchInput{}
	}

	output = &GetCampaignStateBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignStateBatch API operation for AmazonConnectCampaignService.
//
// Get state of campaigns for the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation GetCampaignStateBatch for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignStateBatch
func (c *ConnectCampaigns) GetCampaignStateBatch(input *GetCampaignStateBatchInput) (*GetCampaignStateBatchOutput, error) {
	req, out := c.GetCampaignStateBatchRequest(input)
	return out, req.Send()
}

// GetCampaignStateBatchWithContext is the same as GetCampaignStateBatch with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignStateBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) GetCampaignStateBatchWithContext(ctx aws.Context, input *GetCampaignStateBatchInput, opts ...request.Option) (*GetCampaignStateBatchOutput, error) {
	req, out := c.GetCampaignStateBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectInstanceConfig = "GetConnectInstanceConfig"

// GetConnectInstanceConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectInstanceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectInstanceConfig for more information on using the GetConnectInstanceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConnectInstanceConfigRequest method.
//	req, resp := client.GetConnectInstanceConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetConnectInstanceConfig
func (c *ConnectCampaigns) GetConnectInstanceConfigRequest(input *GetConnectInstanceConfigInput) (req *request.Request, output *GetConnectInstanceConfigOutput) {
	op := &request.Operation{
		Name:       opGetConnectInstanceConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/connect-instance/{connectInstanceId}/config",
	}

	if input == nil {
		input = &GetConnectInstanceConfigInput{}
	}

	output = &GetConnectInstanceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectInstanceConfig API operation for AmazonConnectCampaignService.
//
// Get the specific Connect instance config.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation GetConnectInstanceConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetConnectInstanceConfig
func (c *ConnectCampaigns) GetConnectInstanceConfig(input *GetConnectInstanceConfigInput) (*GetConnectInstanceConfigOutput, error) {
	req, out := c.GetConnectInstanceConfigRequest(input)
	return out, req.Send()
}

// GetConnectInstanceConfigWithContext is the same as GetConnectInstanceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectInstanceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) GetConnectInstanceConfigWithContext(ctx aws.Context, input *GetConnectInstanceConfigInput, opts ...request.Option) (*GetConnectInstanceConfigOutput, error) {
	req, out := c.GetConnectInstanceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceOnboardingJobStatus = "GetInstanceOnboardingJobStatus"

// GetInstanceOnboardingJobStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceOnboardingJobStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceOnboardingJobStatus for more information on using the GetInstanceOnboardingJobStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInstanceOnboardingJobStatusRequest method.
//	req, resp := client.GetInstanceOnboardingJobStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetInstanceOnboardingJobStatus
func (c *ConnectCampaigns) GetInstanceOnboardingJobStatusRequest(input *GetInstanceOnboardingJobStatusInput) (req *request.Request, output *GetInstanceOnboardingJobStatusOutput) {
	op := &request.Operation{
		Name:       opGetInstanceOnboardingJobStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/connect-instance/{connectInstanceId}/onboarding",
	}

	if input == nil {
		input = &GetInstanceOnboardingJobStatusInput{}
	}

	output = &GetInstanceOnboardingJobStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceOnboardingJobStatus API operation for AmazonConnectCampaignService.
//
// Get the specific instance onboarding job status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation GetInstanceOnboardingJobStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetInstanceOnboardingJobStatus
func (c *ConnectCampaigns) GetInstanceOnboardingJobStatus(input *GetInstanceOnboardingJobStatusInput) (*GetInstanceOnboardingJobStatusOutput, error) {
	req, out := c.GetInstanceOnboardingJobStatusRequest(input)
	return out, req.Send()
}

// GetInstanceOnboardingJobStatusWithContext is the same as GetInstanceOnboardingJobStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceOnboardingJobStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) GetInstanceOnboardingJobStatusWithContext(ctx aws.Context, input *GetInstanceOnboardingJobStatusInput, opts ...request.Option) (*GetInstanceOnboardingJobStatusOutput, error) {
	req, out := c.GetInstanceOnboardingJobStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCampaigns = "ListCampaigns"

// ListCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the ListCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCampaigns for more information on using the ListCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCampaignsRequest method.
//	req, resp := client.ListCampaignsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns
func (c *ConnectCampaigns) ListCampaignsRequest(input *ListCampaignsInput) (req *request.Request, output *ListCampaignsOutput) {
	op := &request.Operation{
		Name:       opListCampaigns,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns-summary",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCampaignsInput{}
	}

	output = &ListCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCampaigns API operation for AmazonConnectCampaignService.
//
// Provides summary information about the campaigns under the specified Amazon
// Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation ListCampaigns for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListCampaigns
func (c *ConnectCampaigns) ListCampaigns(input *ListCampaignsInput) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	return out, req.Send()
}

// ListCampaignsWithContext is the same as ListCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See ListCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) ListCampaignsWithContext(ctx aws.Context, input *ListCampaignsInput, opts ...request.Option) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCampaignsPages iterates over the pages of a ListCampaigns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCampaigns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCampaigns operation.
//	pageNum := 0
//	err := client.ListCampaignsPages(params,
//	    func(page *connectcampaigns.ListCampaignsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCampaigns) ListCampaignsPages(input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool) error {
	return c.ListCampaignsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCampaignsPagesWithContext same as ListCampaignsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) ListCampaignsPagesWithContext(ctx aws.Context, input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCampaignsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCampaignsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCampaignsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListTagsForResource
func (c *ConnectCampaigns) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AmazonConnectCampaignService.
//
// List tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ListTagsForResource
func (c *ConnectCampaigns) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPauseCampaign = "PauseCampaign"

// PauseCampaignRequest generates a "aws/request.Request" representing the
// client's request for the PauseCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PauseCampaign for more information on using the PauseCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PauseCampaignRequest method.
//	req, resp := client.PauseCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PauseCampaign
func (c *ConnectCampaigns) PauseCampaignRequest(input *PauseCampaignInput) (req *request.Request, output *PauseCampaignOutput) {
	op := &request.Operation{
		Name:       opPauseCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/pause",
	}

	if input == nil {
		input = &PauseCampaignInput{}
	}

	output = &PauseCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PauseCampaign API operation for AmazonConnectCampaignService.
//
// Pauses a campaign for the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation PauseCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InvalidCampaignStateException
//     The request could not be processed because of conflict in the current state
//     of the campaign.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PauseCampaign
func (c *ConnectCampaigns) PauseCampaign(input *PauseCampaignInput) (*PauseCampaignOutput, error) {
	req, out := c.PauseCampaignRequest(input)
	return out, req.Send()
}

// PauseCampaignWithContext is the same as PauseCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See PauseCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) PauseCampaignWithContext(ctx aws.Context, input *PauseCampaignInput, opts ...request.Option) (*PauseCampaignOutput, error) {
	req, out := c.PauseCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDialRequestBatch = "PutDialRequestBatch"

// PutDialRequestBatchRequest generates a "aws/request.Request" representing the
// client's request for the PutDialRequestBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDialRequestBatch for more information on using the PutDialRequestBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDialRequestBatchRequest method.
//	req, resp := client.PutDialRequestBatchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PutDialRequestBatch
func (c *ConnectCampaigns) PutDialRequestBatchRequest(input *PutDialRequestBatchInput) (req *request.Request, output *PutDialRequestBatchOutput) {
	op := &request.Operation{
		Name:       opPutDialRequestBatch,
		HTTPMethod: "PUT",
		HTTPPath:   "/campaigns/{id}/dial-requests",
	}

	if input == nil {
		input = &PutDialRequestBatchInput{}
	}

	output = &PutDialRequestBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDialRequestBatch API operation for AmazonConnectCampaignService.
//
// Creates dials requests for the specified campaign Amazon Connect account.
// This API is idempotent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation PutDialRequestBatch for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InvalidCampaignStateException
//     The request could not be processed because of conflict in the current state
//     of the campaign.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/PutDialRequestBatch
func (c *ConnectCampaigns) PutDialRequestBatch(input *PutDialRequestBatchInput) (*PutDialRequestBatchOutput, error) {
	req, out := c.PutDialRequestBatchRequest(input)
	return out, req.Send()
}

// PutDialRequestBatchWithContext is the same as PutDialRequestBatch with the addition of
// the ability to pass a context and additional request options.
//
// See PutDialRequestBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) PutDialRequestBatchWithContext(ctx aws.Context, input *PutDialRequestBatchInput, opts ...request.Option) (*PutDialRequestBatchOutput, error) {
	req, out := c.PutDialRequestBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeCampaign = "ResumeCampaign"

// ResumeCampaignRequest generates a "aws/request.Request" representing the
// client's request for the ResumeCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeCampaign for more information on using the ResumeCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResumeCampaignRequest method.
//	req, resp := client.ResumeCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ResumeCampaign
func (c *ConnectCampaigns) ResumeCampaignRequest(input *ResumeCampaignInput) (req *request.Request, output *ResumeCampaignOutput) {
	op := &request.Operation{
		Name:       opResumeCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/resume",
	}

	if input == nil {
		input = &ResumeCampaignInput{}
	}

	output = &ResumeCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResumeCampaign API operation for AmazonConnectCampaignService.
//
// Stops a campaign for the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation ResumeCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InvalidCampaignStateException
//     The request could not be processed because of conflict in the current state
//     of the campaign.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/ResumeCampaign
func (c *ConnectCampaigns) ResumeCampaign(input *ResumeCampaignInput) (*ResumeCampaignOutput, error) {
	req, out := c.ResumeCampaignRequest(input)
	return out, req.Send()
}

// ResumeCampaignWithContext is the same as ResumeCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) ResumeCampaignWithContext(ctx aws.Context, input *ResumeCampaignInput, opts ...request.Option) (*ResumeCampaignOutput, error) {
	req, out := c.ResumeCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCampaign = "StartCampaign"

// StartCampaignRequest generates a "aws/request.Request" representing the
// client's request for the StartCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCampaign for more information on using the StartCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCampaignRequest method.
//	req, resp := client.StartCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartCampaign
func (c *ConnectCampaigns) StartCampaignRequest(input *StartCampaignInput) (req *request.Request, output *StartCampaignOutput) {
	op := &request.Operation{
		Name:       opStartCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/start",
	}

	if input == nil {
		input = &StartCampaignInput{}
	}

	output = &StartCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartCampaign API operation for AmazonConnectCampaignService.
//
// Starts a campaign for the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation StartCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InvalidCampaignStateException
//     The request could not be processed because of conflict in the current state
//     of the campaign.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartCampaign
func (c *ConnectCampaigns) StartCampaign(input *StartCampaignInput) (*StartCampaignOutput, error) {
	req, out := c.StartCampaignRequest(input)
	return out, req.Send()
}

// StartCampaignWithContext is the same as StartCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See StartCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) StartCampaignWithContext(ctx aws.Context, input *StartCampaignInput, opts ...request.Option) (*StartCampaignOutput, error) {
	req, out := c.StartCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInstanceOnboardingJob = "StartInstanceOnboardingJob"

// StartInstanceOnboardingJobRequest generates a "aws/request.Request" representing the
// client's request for the StartInstanceOnboardingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInstanceOnboardingJob for more information on using the StartInstanceOnboardingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartInstanceOnboardingJobRequest method.
//	req, resp := client.StartInstanceOnboardingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartInstanceOnboardingJob
func (c *ConnectCampaigns) StartInstanceOnboardingJobRequest(input *StartInstanceOnboardingJobInput) (req *request.Request, output *StartInstanceOnboardingJobOutput) {
	op := &request.Operation{
		Name:       opStartInstanceOnboardingJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/connect-instance/{connectInstanceId}/onboarding",
	}

	if input == nil {
		input = &StartInstanceOnboardingJobInput{}
	}

	output = &StartInstanceOnboardingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInstanceOnboardingJob API operation for AmazonConnectCampaignService.
//
// Onboard the specific Amazon Connect instance to Connect Campaigns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation StartInstanceOnboardingJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StartInstanceOnboardingJob
func (c *ConnectCampaigns) StartInstanceOnboardingJob(input *StartInstanceOnboardingJobInput) (*StartInstanceOnboardingJobOutput, error) {
	req, out := c.StartInstanceOnboardingJobRequest(input)
	return out, req.Send()
}

// StartInstanceOnboardingJobWithContext is the same as StartInstanceOnboardingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartInstanceOnboardingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) StartInstanceOnboardingJobWithContext(ctx aws.Context, input *StartInstanceOnboardingJobInput, opts ...request.Option) (*StartInstanceOnboardingJobOutput, error) {
	req, out := c.StartInstanceOnboardingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCampaign = "StopCampaign"

// StopCampaignRequest generates a "aws/request.Request" representing the
// client's request for the StopCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCampaign for more information on using the StopCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopCampaignRequest method.
//	req, resp := client.StopCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StopCampaign
func (c *ConnectCampaigns) StopCampaignRequest(input *StopCampaignInput) (req *request.Request, output *StopCampaignOutput) {
	op := &request.Operation{
		Name:       opStopCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/stop",
	}

	if input == nil {
		input = &StopCampaignInput{}
	}

	output = &StopCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCampaign API operation for AmazonConnectCampaignService.
//
// Stops a campaign for the specified Amazon Connect account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation StopCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InvalidCampaignStateException
//     The request could not be processed because of conflict in the current state
//     of the campaign.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/StopCampaign
func (c *ConnectCampaigns) StopCampaign(input *StopCampaignInput) (*StopCampaignOutput, error) {
	req, out := c.StopCampaignRequest(input)
	return out, req.Send()
}

// StopCampaignWithContext is the same as StopCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See StopCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) StopCampaignWithContext(ctx aws.Context, input *StopCampaignInput, opts ...request.Option) (*StopCampaignOutput, error) {
	req, out := c.StopCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/TagResource
func (c *ConnectCampaigns) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AmazonConnectCampaignService.
//
// Tag a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/TagResource
func (c *ConnectCampaigns) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UntagResource
func (c *ConnectCampaigns) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AmazonConnectCampaignService.
//
// Untag a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UntagResource
func (c *ConnectCampaigns) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaignDialerConfig = "UpdateCampaignDialerConfig"

// UpdateCampaignDialerConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaignDialerConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaignDialerConfig for more information on using the UpdateCampaignDialerConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCampaignDialerConfigRequest method.
//	req, resp := client.UpdateCampaignDialerConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignDialerConfig
func (c *ConnectCampaigns) UpdateCampaignDialerConfigRequest(input *UpdateCampaignDialerConfigInput) (req *request.Request, output *UpdateCampaignDialerConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaignDialerConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/dialer-config",
	}

	if input == nil {
		input = &UpdateCampaignDialerConfigInput{}
	}

	output = &UpdateCampaignDialerConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCampaignDialerConfig API operation for AmazonConnectCampaignService.
//
// Updates the dialer config of a campaign. This API is idempotent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation UpdateCampaignDialerConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignDialerConfig
func (c *ConnectCampaigns) UpdateCampaignDialerConfig(input *UpdateCampaignDialerConfigInput) (*UpdateCampaignDialerConfigOutput, error) {
	req, out := c.UpdateCampaignDialerConfigRequest(input)
	return out, req.Send()
}

// UpdateCampaignDialerConfigWithContext is the same as UpdateCampaignDialerConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaignDialerConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) UpdateCampaignDialerConfigWithContext(ctx aws.Context, input *UpdateCampaignDialerConfigInput, opts ...request.Option) (*UpdateCampaignDialerConfigOutput, error) {
	req, out := c.UpdateCampaignDialerConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaignName = "UpdateCampaignName"

// UpdateCampaignNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaignName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaignName for more information on using the UpdateCampaignName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCampaignNameRequest method.
//	req, resp := client.UpdateCampaignNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignName
func (c *ConnectCampaigns) UpdateCampaignNameRequest(input *UpdateCampaignNameInput) (req *request.Request, output *UpdateCampaignNameOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaignName,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/name",
	}

	if input == nil {
		input = &UpdateCampaignNameInput{}
	}

	output = &UpdateCampaignNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCampaignName API operation for AmazonConnectCampaignService.
//
// Updates the name of a campaign. This API is idempotent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation UpdateCampaignName for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignName
func (c *ConnectCampaigns) UpdateCampaignName(input *UpdateCampaignNameInput) (*UpdateCampaignNameOutput, error) {
	req, out := c.UpdateCampaignNameRequest(input)
	return out, req.Send()
}

// UpdateCampaignNameWithContext is the same as UpdateCampaignName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaignName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) UpdateCampaignNameWithContext(ctx aws.Context, input *UpdateCampaignNameInput, opts ...request.Option) (*UpdateCampaignNameOutput, error) {
	req, out := c.UpdateCampaignNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaignOutboundCallConfig = "UpdateCampaignOutboundCallConfig"

// UpdateCampaignOutboundCallConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaignOutboundCallConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaignOutboundCallConfig for more information on using the UpdateCampaignOutboundCallConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCampaignOutboundCallConfigRequest method.
//	req, resp := client.UpdateCampaignOutboundCallConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignOutboundCallConfig
func (c *ConnectCampaigns) UpdateCampaignOutboundCallConfigRequest(input *UpdateCampaignOutboundCallConfigInput) (req *request.Request, output *UpdateCampaignOutboundCallConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaignOutboundCallConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/campaigns/{id}/outbound-call-config",
	}

	if input == nil {
		input = &UpdateCampaignOutboundCallConfigInput{}
	}

	output = &UpdateCampaignOutboundCallConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCampaignOutboundCallConfig API operation for AmazonConnectCampaignService.
//
// Updates the outbound call config of a campaign. This API is idempotent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonConnectCampaignService's
// API operation UpdateCampaignOutboundCallConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/UpdateCampaignOutboundCallConfig
func (c *ConnectCampaigns) UpdateCampaignOutboundCallConfig(input *UpdateCampaignOutboundCallConfigInput) (*UpdateCampaignOutboundCallConfigOutput, error) {
	req, out := c.UpdateCampaignOutboundCallConfigRequest(input)
	return out, req.Send()
}

// UpdateCampaignOutboundCallConfigWithContext is the same as UpdateCampaignOutboundCallConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaignOutboundCallConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCampaigns) UpdateCampaignOutboundCallConfigWithContext(ctx aws.Context, input *UpdateCampaignOutboundCallConfigInput, opts ...request.Option) (*UpdateCampaignOutboundCallConfigOutput, error) {
	req, out := c.UpdateCampaignOutboundCallConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Agentless Dialer config
type AgentlessDialerConfig struct {
	_ struct{} `type:"structure"`

	// Allocates dialing capacity for this campaign between multiple active campaigns
	DialingCapacity *float64 `locationName:"dialingCapacity" min:"0.01" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentlessDialerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentlessDialerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentlessDialerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AgentlessDialerConfig"}
	if s.DialingCapacity != nil && *s.DialingCapacity < 0.01 {
		invalidParams.Add(request.NewErrParamMinValue("DialingCapacity", 0.01))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDialingCapacity sets the DialingCapacity field's value.
func (s *AgentlessDialerConfig) SetDialingCapacity(v float64) *AgentlessDialerConfig {
	s.DialingCapacity = &v
	return s
}

// Answering Machine Detection config
type AnswerMachineDetectionConfig struct {
	_ struct{} `type:"structure"`

	// Enable or disable answering machine detection
	//
	// EnableAnswerMachineDetection is a required field
	EnableAnswerMachineDetection *bool `locationName:"enableAnswerMachineDetection" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerMachineDetectionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerMachineDetectionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnswerMachineDetectionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnswerMachineDetectionConfig"}
	if s.EnableAnswerMachineDetection == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableAnswerMachineDetection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableAnswerMachineDetection sets the EnableAnswerMachineDetection field's value.
func (s *AnswerMachineDetectionConfig) SetEnableAnswerMachineDetection(v bool) *AnswerMachineDetectionConfig {
	s.EnableAnswerMachineDetection = &v
	return s
}

// An Amazon Connect campaign.
type Campaign struct {
	_ struct{} `type:"structure"`

	// The resource name of an Amazon Connect campaign.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `locationName:"connectInstanceId" type:"string" required:"true"`

	// The possible types of dialer config parameters
	//
	// DialerConfig is a required field
	DialerConfig *DialerConfig `locationName:"dialerConfig" type:"structure" required:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of an Amazon Connect Campaign name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The configuration used for outbound calls.
	//
	// OutboundCallConfig is a required field
	OutboundCallConfig *OutboundCallConfig `locationName:"outboundCallConfig" type:"structure" required:"true"`

	// Tag map with key and value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Campaign) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Campaign) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Campaign) SetArn(v string) *Campaign {
	s.Arn = &v
	return s
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *Campaign) SetConnectInstanceId(v string) *Campaign {
	s.ConnectInstanceId = &v
	return s
}

// SetDialerConfig sets the DialerConfig field's value.
func (s *Campaign) SetDialerConfig(v *DialerConfig) *Campaign {
	s.DialerConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *Campaign) SetId(v string) *Campaign {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Campaign) SetName(v string) *Campaign {
	s.Name = &v
	return s
}

// SetOutboundCallConfig sets the OutboundCallConfig field's value.
func (s *Campaign) SetOutboundCallConfig(v *OutboundCallConfig) *Campaign {
	s.OutboundCallConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Campaign) SetTags(v map[string]*string) *Campaign {
	s.Tags = v
	return s
}

// Filter model by type
type CampaignFilters struct {
	_ struct{} `type:"structure"`

	// Connect instance identifier filter
	InstanceIdFilter *InstanceIdFilter `locationName:"instanceIdFilter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CampaignFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CampaignFilters"}
	if s.InstanceIdFilter != nil {
		if err := s.InstanceIdFilter.Validate(); err != nil {
			invalidParams.AddNested("InstanceIdFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceIdFilter sets the InstanceIdFilter field's value.
func (s *CampaignFilters) SetInstanceIdFilter(v *InstanceIdFilter) *CampaignFilters {
	s.InstanceIdFilter = v
	return s
}

// An Amazon Connect campaign summary.
type CampaignSummary struct {
	_ struct{} `type:"structure"`

	// The resource name of an Amazon Connect campaign.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `locationName:"connectInstanceId" type:"string" required:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of an Amazon Connect Campaign name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CampaignSummary) SetArn(v string) *CampaignSummary {
	s.Arn = &v
	return s
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *CampaignSummary) SetConnectInstanceId(v string) *CampaignSummary {
	s.ConnectInstanceId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CampaignSummary) SetId(v string) *CampaignSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignSummary) SetName(v string) *CampaignSummary {
	s.Name = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request for Create Campaign API.
type CreateCampaignInput struct {
	_ struct{} `type:"structure"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `locationName:"connectInstanceId" type:"string" required:"true"`

	// The possible types of dialer config parameters
	//
	// DialerConfig is a required field
	DialerConfig *DialerConfig `locationName:"dialerConfig" type:"structure" required:"true"`

	// The name of an Amazon Connect Campaign name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The configuration used for outbound calls.
	//
	// OutboundCallConfig is a required field
	OutboundCallConfig *OutboundCallConfig `locationName:"outboundCallConfig" type:"structure" required:"true"`

	// Tag map with key and value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.ConnectInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectInstanceId"))
	}
	if s.DialerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DialerConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutboundCallConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutboundCallConfig"))
	}
	if s.DialerConfig != nil {
		if err := s.DialerConfig.Validate(); err != nil {
			invalidParams.AddNested("DialerConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutboundCallConfig != nil {
		if err := s.OutboundCallConfig.Validate(); err != nil {
			invalidParams.AddNested("OutboundCallConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *CreateCampaignInput) SetConnectInstanceId(v string) *CreateCampaignInput {
	s.ConnectInstanceId = &v
	return s
}

// SetDialerConfig sets the DialerConfig field's value.
func (s *CreateCampaignInput) SetDialerConfig(v *DialerConfig) *CreateCampaignInput {
	s.DialerConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCampaignInput) SetName(v string) *CreateCampaignInput {
	s.Name = &v
	return s
}

// SetOutboundCallConfig sets the OutboundCallConfig field's value.
func (s *CreateCampaignInput) SetOutboundCallConfig(v *OutboundCallConfig) *CreateCampaignInput {
	s.OutboundCallConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCampaignInput) SetTags(v map[string]*string) *CreateCampaignInput {
	s.Tags = v
	return s
}

// The response for Create Campaign API
type CreateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The resource name of an Amazon Connect campaign.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Identifier representing a Campaign
	Id *string `locationName:"id" type:"string"`

	// Tag map with key and value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCampaignOutput) SetArn(v string) *CreateCampaignOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCampaignOutput) SetId(v string) *CreateCampaignOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCampaignOutput) SetTags(v map[string]*string) *CreateCampaignOutput {
	s.Tags = v
	return s
}

// DeleteCampaignRequest
type DeleteCampaignInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteCampaignInput) SetId(v string) *DeleteCampaignInput {
	s.Id = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

// DeleteCampaignRequest
type DeleteConnectInstanceConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `location:"uri" locationName:"connectInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectInstanceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectInstanceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectInstanceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectInstanceConfigInput"}
	if s.ConnectInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectInstanceId"))
	}
	if s.ConnectInstanceId != nil && len(*s.ConnectInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *DeleteConnectInstanceConfigInput) SetConnectInstanceId(v string) *DeleteConnectInstanceConfigInput {
	s.ConnectInstanceId = &v
	return s
}

type DeleteConnectInstanceConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectInstanceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectInstanceConfigOutput) GoString() string {
	return s.String()
}

// The request for DeleteInstanceOnboardingJob API.
type DeleteInstanceOnboardingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `location:"uri" locationName:"connectInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceOnboardingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceOnboardingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceOnboardingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceOnboardingJobInput"}
	if s.ConnectInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectInstanceId"))
	}
	if s.ConnectInstanceId != nil && len(*s.ConnectInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *DeleteInstanceOnboardingJobInput) SetConnectInstanceId(v string) *DeleteInstanceOnboardingJobInput {
	s.ConnectInstanceId = &v
	return s
}

type DeleteInstanceOnboardingJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceOnboardingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceOnboardingJobOutput) GoString() string {
	return s.String()
}

// DescribeCampaignRequests
type DescribeCampaignInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCampaignInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeCampaignInput) SetId(v string) *DescribeCampaignInput {
	s.Id = &v
	return s
}

// DescribeCampaignResponse
type DescribeCampaignOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Connect campaign.
	Campaign *Campaign `locationName:"campaign" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaign sets the Campaign field's value.
func (s *DescribeCampaignOutput) SetCampaign(v *Campaign) *DescribeCampaignOutput {
	s.Campaign = v
	return s
}

// A dial request for a campaign.
type DialRequest struct {
	_ struct{} `type:"structure"`

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like
	// any other contact attributes.
	//
	// Attributes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DialRequest's
	// String and GoString methods.
	//
	// Attributes is a required field
	Attributes map[string]*string `locationName:"attributes" type:"map" required:"true" sensitive:"true"`

	// Client provided parameter used for idempotency. Its value must be unique
	// for each request.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// Timestamp with no UTC offset or timezone
	//
	// ExpirationTime is a required field
	ExpirationTime *time.Time `locationName:"expirationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The phone number of the customer, in E.164 format.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DialRequest's
	// String and GoString methods.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `locationName:"phoneNumber" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialRequest"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ExpirationTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpirationTime"))
	}
	if s.PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *DialRequest) SetAttributes(v map[string]*string) *DialRequest {
	s.Attributes = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DialRequest) SetClientToken(v string) *DialRequest {
	s.ClientToken = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *DialRequest) SetExpirationTime(v time.Time) *DialRequest {
	s.ExpirationTime = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *DialRequest) SetPhoneNumber(v string) *DialRequest {
	s.PhoneNumber = &v
	return s
}

// The possible types of dialer config parameters
type DialerConfig struct {
	_ struct{} `type:"structure"`

	// Agentless Dialer config
	AgentlessDialerConfig *AgentlessDialerConfig `locationName:"agentlessDialerConfig" type:"structure"`

	// Predictive Dialer config
	PredictiveDialerConfig *PredictiveDialerConfig `locationName:"predictiveDialerConfig" type:"structure"`

	// Progressive Dialer config
	ProgressiveDialerConfig *ProgressiveDialerConfig `locationName:"progressiveDialerConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialerConfig"}
	if s.AgentlessDialerConfig != nil {
		if err := s.AgentlessDialerConfig.Validate(); err != nil {
			invalidParams.AddNested("AgentlessDialerConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.PredictiveDialerConfig != nil {
		if err := s.PredictiveDialerConfig.Validate(); err != nil {
			invalidParams.AddNested("PredictiveDialerConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ProgressiveDialerConfig != nil {
		if err := s.ProgressiveDialerConfig.Validate(); err != nil {
			invalidParams.AddNested("ProgressiveDialerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentlessDialerConfig sets the AgentlessDialerConfig field's value.
func (s *DialerConfig) SetAgentlessDialerConfig(v *AgentlessDialerConfig) *DialerConfig {
	s.AgentlessDialerConfig = v
	return s
}

// SetPredictiveDialerConfig sets the PredictiveDialerConfig field's value.
func (s *DialerConfig) SetPredictiveDialerConfig(v *PredictiveDialerConfig) *DialerConfig {
	s.PredictiveDialerConfig = v
	return s
}

// SetProgressiveDialerConfig sets the ProgressiveDialerConfig field's value.
func (s *DialerConfig) SetProgressiveDialerConfig(v *ProgressiveDialerConfig) *DialerConfig {
	s.ProgressiveDialerConfig = v
	return s
}

// Encryption config for Connect Instance. Note that sensitive data will always
// be encrypted. If disabled, service will perform encryption with its own key.
// If enabled, a KMS key id needs to be provided and KMS charges will apply.
// KMS is only type supported
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// Boolean to indicate if custom encryption has been enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// Server-side encryption type.
	EncryptionType *string `locationName:"encryptionType" type:"string" enum:"EncryptionType"`

	// KMS key id/arn for encryption config.
	KeyArn *string `locationName:"keyArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfig"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *EncryptionConfig) SetEnabled(v bool) *EncryptionConfig {
	s.Enabled = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *EncryptionConfig) SetEncryptionType(v string) *EncryptionConfig {
	s.EncryptionType = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *EncryptionConfig) SetKeyArn(v string) *EncryptionConfig {
	s.KeyArn = &v
	return s
}

// Failed response of campaign state
type FailedCampaignStateResponse struct {
	_ struct{} `type:"structure"`

	// Identifier representing a Campaign
	CampaignId *string `locationName:"campaignId" type:"string"`

	// A predefined code indicating the error that caused the failure in getting
	// state of campaigns
	FailureCode *string `locationName:"failureCode" type:"string" enum:"GetCampaignStateBatchFailureCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCampaignStateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCampaignStateResponse) GoString() string {
	return s.String()
}

// SetCampaignId sets the CampaignId field's value.
func (s *FailedCampaignStateResponse) SetCampaignId(v string) *FailedCampaignStateResponse {
	s.CampaignId = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *FailedCampaignStateResponse) SetFailureCode(v string) *FailedCampaignStateResponse {
	s.FailureCode = &v
	return s
}

// A failed request identified by the unique client token.
type FailedRequest struct {
	_ struct{} `type:"structure"`

	// Client provided parameter used for idempotency. Its value must be unique
	// for each request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// A predefined code indicating the error that caused the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"FailureCode"`

	// Identifier representing a Dial request
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedRequest) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *FailedRequest) SetClientToken(v string) *FailedRequest {
	s.ClientToken = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *FailedRequest) SetFailureCode(v string) *FailedRequest {
	s.FailureCode = &v
	return s
}

// SetId sets the Id field's value.
func (s *FailedRequest) SetId(v string) *FailedRequest {
	s.Id = &v
	return s
}

// GetCampaignStateBatchRequest
type GetCampaignStateBatchInput struct {
	_ struct{} `type:"structure"`

	// List of CampaignId
	//
	// CampaignIds is a required field
	CampaignIds []*string `locationName:"campaignIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignStateBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignStateBatchInput"}
	if s.CampaignIds == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignIds"))
	}
	if s.CampaignIds != nil && len(s.CampaignIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignIds sets the CampaignIds field's value.
func (s *GetCampaignStateBatchInput) SetCampaignIds(v []*string) *GetCampaignStateBatchInput {
	s.CampaignIds = v
	return s
}

// GetCampaignStateBatchResponse
type GetCampaignStateBatchOutput struct {
	_ struct{} `type:"structure"`

	// List of failed requests of campaign state
	FailedRequests []*FailedCampaignStateResponse `locationName:"failedRequests" type:"list"`

	// List of successful response of campaign state
	SuccessfulRequests []*SuccessfulCampaignStateResponse `locationName:"successfulRequests" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateBatchOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *GetCampaignStateBatchOutput) SetFailedRequests(v []*FailedCampaignStateResponse) *GetCampaignStateBatchOutput {
	s.FailedRequests = v
	return s
}

// SetSuccessfulRequests sets the SuccessfulRequests field's value.
func (s *GetCampaignStateBatchOutput) SetSuccessfulRequests(v []*SuccessfulCampaignStateResponse) *GetCampaignStateBatchOutput {
	s.SuccessfulRequests = v
	return s
}

// GetCampaignStateRequest
type GetCampaignStateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignStateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCampaignStateInput) SetId(v string) *GetCampaignStateInput {
	s.Id = &v
	return s
}

// GetCampaignStateResponse
type GetCampaignStateOutput struct {
	_ struct{} `type:"structure"`

	// State of a campaign
	State *string `locationName:"state" type:"string" enum:"CampaignState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignStateOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *GetCampaignStateOutput) SetState(v string) *GetCampaignStateOutput {
	s.State = &v
	return s
}

// GetConnectInstanceConfigRequest
type GetConnectInstanceConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `location:"uri" locationName:"connectInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectInstanceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectInstanceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectInstanceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectInstanceConfigInput"}
	if s.ConnectInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectInstanceId"))
	}
	if s.ConnectInstanceId != nil && len(*s.ConnectInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *GetConnectInstanceConfigInput) SetConnectInstanceId(v string) *GetConnectInstanceConfigInput {
	s.ConnectInstanceId = &v
	return s
}

// GetConnectInstanceConfigResponse
type GetConnectInstanceConfigOutput struct {
	_ struct{} `type:"structure"`

	// Instance config object
	ConnectInstanceConfig *InstanceConfig `locationName:"connectInstanceConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectInstanceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectInstanceConfigOutput) GoString() string {
	return s.String()
}

// SetConnectInstanceConfig sets the ConnectInstanceConfig field's value.
func (s *GetConnectInstanceConfigOutput) SetConnectInstanceConfig(v *InstanceConfig) *GetConnectInstanceConfigOutput {
	s.ConnectInstanceConfig = v
	return s
}

// GetInstanceOnboardingJobStatusRequest
type GetInstanceOnboardingJobStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `location:"uri" locationName:"connectInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceOnboardingJobStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceOnboardingJobStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceOnboardingJobStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceOnboardingJobStatusInput"}
	if s.ConnectInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectInstanceId"))
	}
	if s.ConnectInstanceId != nil && len(*s.ConnectInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *GetInstanceOnboardingJobStatusInput) SetConnectInstanceId(v string) *GetInstanceOnboardingJobStatusInput {
	s.ConnectInstanceId = &v
	return s
}

// GetInstanceOnboardingJobStatusResponse
type GetInstanceOnboardingJobStatusOutput struct {
	_ struct{} `type:"structure"`

	// Instance onboarding job status object
	ConnectInstanceOnboardingJobStatus *InstanceOnboardingJobStatus `locationName:"connectInstanceOnboardingJobStatus" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceOnboardingJobStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceOnboardingJobStatusOutput) GoString() string {
	return s.String()
}

// SetConnectInstanceOnboardingJobStatus sets the ConnectInstanceOnboardingJobStatus field's value.
func (s *GetInstanceOnboardingJobStatusOutput) SetConnectInstanceOnboardingJobStatus(v *InstanceOnboardingJobStatus) *GetInstanceOnboardingJobStatusOutput {
	s.ConnectInstanceOnboardingJobStatus = v
	return s
}

// Instance config object
type InstanceConfig struct {
	_ struct{} `type:"structure"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `locationName:"connectInstanceId" type:"string" required:"true"`

	// Encryption config for Connect Instance. Note that sensitive data will always
	// be encrypted. If disabled, service will perform encryption with its own key.
	// If enabled, a KMS key id needs to be provided and KMS charges will apply.
	// KMS is only type supported
	//
	// EncryptionConfig is a required field
	EncryptionConfig *EncryptionConfig `locationName:"encryptionConfig" type:"structure" required:"true"`

	// Service linked role arn
	//
	// ServiceLinkedRoleArn is a required field
	ServiceLinkedRoleArn *string `locationName:"serviceLinkedRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfig) GoString() string {
	return s.String()
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *InstanceConfig) SetConnectInstanceId(v string) *InstanceConfig {
	s.ConnectInstanceId = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *InstanceConfig) SetEncryptionConfig(v *EncryptionConfig) *InstanceConfig {
	s.EncryptionConfig = v
	return s
}

// SetServiceLinkedRoleArn sets the ServiceLinkedRoleArn field's value.
func (s *InstanceConfig) SetServiceLinkedRoleArn(v string) *InstanceConfig {
	s.ServiceLinkedRoleArn = &v
	return s
}

// Connect instance identifier filter
type InstanceIdFilter struct {
	_ struct{} `type:"structure"`

	// Operators for Connect instance identifier filter
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"InstanceIdFilterOperator"`

	// Amazon Connect Instance Id
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceIdFilter"}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperator sets the Operator field's value.
func (s *InstanceIdFilter) SetOperator(v string) *InstanceIdFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *InstanceIdFilter) SetValue(v string) *InstanceIdFilter {
	s.Value = &v
	return s
}

// Instance onboarding job status object
type InstanceOnboardingJobStatus struct {
	_ struct{} `type:"structure"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `locationName:"connectInstanceId" type:"string" required:"true"`

	// Enumeration of the possible failure codes for instance onboarding job
	FailureCode *string `locationName:"failureCode" type:"string" enum:"InstanceOnboardingJobFailureCode"`

	// Enumeration of the possible states for instance onboarding job
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"InstanceOnboardingJobStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceOnboardingJobStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceOnboardingJobStatus) GoString() string {
	return s.String()
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *InstanceOnboardingJobStatus) SetConnectInstanceId(v string) *InstanceOnboardingJobStatus {
	s.ConnectInstanceId = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *InstanceOnboardingJobStatus) SetFailureCode(v string) *InstanceOnboardingJobStatus {
	s.FailureCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceOnboardingJobStatus) SetStatus(v string) *InstanceOnboardingJobStatus {
	s.Status = &v
	return s
}

// Request processing failed because of an error or failure with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request could not be processed because of conflict in the current state
// of the campaign.
type InvalidCampaignStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// State of a campaign
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"CampaignState"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCampaignStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCampaignStateException) GoString() string {
	return s.String()
}

func newErrorInvalidCampaignStateException(v protocol.ResponseMetadata) error {
	return &InvalidCampaignStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCampaignStateException) Code() string {
	return "InvalidCampaignStateException"
}

// Message returns the exception's message.
func (s *InvalidCampaignStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCampaignStateException) OrigErr() error {
	return nil
}

func (s *InvalidCampaignStateException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCampaignStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCampaignStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request could not be processed because of conflict in the current state.
type InvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) GoString() string {
	return s.String()
}

func newErrorInvalidStateException(v protocol.ResponseMetadata) error {
	return &InvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateException) Code() string {
	return "InvalidStateException"
}

// Message returns the exception's message.
func (s *InvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateException) OrigErr() error {
	return nil
}

func (s *InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// ListCampaignsRequest
type ListCampaignsInput struct {
	_ struct{} `type:"structure"`

	// Filter model by type
	Filters *CampaignFilters `locationName:"filters" type:"structure"`

	// The maximum number of results to return per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCampaignsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListCampaignsInput) SetFilters(v *CampaignFilters) *ListCampaignsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCampaignsInput) SetMaxResults(v int64) *ListCampaignsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsInput) SetNextToken(v string) *ListCampaignsInput {
	s.NextToken = &v
	return s
}

// ListCampaignsResponse
type ListCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Connect campaigns.
	CampaignSummaryList []*CampaignSummary `locationName:"campaignSummaryList" type:"list"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaignSummaryList sets the CampaignSummaryList field's value.
func (s *ListCampaignsOutput) SetCampaignSummaryList(v []*CampaignSummary) *ListCampaignsOutput {
	s.CampaignSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsOutput) SetNextToken(v string) *ListCampaignsOutput {
	s.NextToken = &v
	return s
}

// ListTagsForResource
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

// ListTagsForResponse
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tag map with key and value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The configuration used for outbound calls.
type OutboundCallConfig struct {
	_ struct{} `type:"structure"`

	// Answering Machine Detection config
	AnswerMachineDetectionConfig *AnswerMachineDetectionConfig `locationName:"answerMachineDetectionConfig" type:"structure"`

	// The identifier of the contact flow for the outbound call.
	//
	// ConnectContactFlowId is a required field
	ConnectContactFlowId *string `locationName:"connectContactFlowId" type:"string" required:"true"`

	// The queue for the call. If you specify a queue, the phone displayed for caller
	// ID is the phone number specified in the queue. If you do not specify a queue,
	// the queue defined in the contact flow is used. If you do not specify a queue,
	// you must specify a source phone number.
	ConnectQueueId *string `locationName:"connectQueueId" type:"string"`

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	ConnectSourcePhoneNumber *string `locationName:"connectSourcePhoneNumber" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundCallConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundCallConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutboundCallConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutboundCallConfig"}
	if s.ConnectContactFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectContactFlowId"))
	}
	if s.AnswerMachineDetectionConfig != nil {
		if err := s.AnswerMachineDetectionConfig.Validate(); err != nil {
			invalidParams.AddNested("AnswerMachineDetectionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnswerMachineDetectionConfig sets the AnswerMachineDetectionConfig field's value.
func (s *OutboundCallConfig) SetAnswerMachineDetectionConfig(v *AnswerMachineDetectionConfig) *OutboundCallConfig {
	s.AnswerMachineDetectionConfig = v
	return s
}

// SetConnectContactFlowId sets the ConnectContactFlowId field's value.
func (s *OutboundCallConfig) SetConnectContactFlowId(v string) *OutboundCallConfig {
	s.ConnectContactFlowId = &v
	return s
}

// SetConnectQueueId sets the ConnectQueueId field's value.
func (s *OutboundCallConfig) SetConnectQueueId(v string) *OutboundCallConfig {
	s.ConnectQueueId = &v
	return s
}

// SetConnectSourcePhoneNumber sets the ConnectSourcePhoneNumber field's value.
func (s *OutboundCallConfig) SetConnectSourcePhoneNumber(v string) *OutboundCallConfig {
	s.ConnectSourcePhoneNumber = &v
	return s
}

// PauseCampaignRequest
type PauseCampaignInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PauseCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PauseCampaignInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *PauseCampaignInput) SetId(v string) *PauseCampaignInput {
	s.Id = &v
	return s
}

type PauseCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseCampaignOutput) GoString() string {
	return s.String()
}

// Predictive Dialer config
type PredictiveDialerConfig struct {
	_ struct{} `type:"structure"`

	// The bandwidth allocation of a queue resource.
	//
	// BandwidthAllocation is a required field
	BandwidthAllocation *float64 `locationName:"bandwidthAllocation" type:"double" required:"true"`

	// Allocates dialing capacity for this campaign between multiple active campaigns
	DialingCapacity *float64 `locationName:"dialingCapacity" min:"0.01" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveDialerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveDialerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveDialerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveDialerConfig"}
	if s.BandwidthAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthAllocation"))
	}
	if s.DialingCapacity != nil && *s.DialingCapacity < 0.01 {
		invalidParams.Add(request.NewErrParamMinValue("DialingCapacity", 0.01))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthAllocation sets the BandwidthAllocation field's value.
func (s *PredictiveDialerConfig) SetBandwidthAllocation(v float64) *PredictiveDialerConfig {
	s.BandwidthAllocation = &v
	return s
}

// SetDialingCapacity sets the DialingCapacity field's value.
func (s *PredictiveDialerConfig) SetDialingCapacity(v float64) *PredictiveDialerConfig {
	s.DialingCapacity = &v
	return s
}

// Progressive Dialer config
type ProgressiveDialerConfig struct {
	_ struct{} `type:"structure"`

	// The bandwidth allocation of a queue resource.
	//
	// BandwidthAllocation is a required field
	BandwidthAllocation *float64 `locationName:"bandwidthAllocation" type:"double" required:"true"`

	// Allocates dialing capacity for this campaign between multiple active campaigns
	DialingCapacity *float64 `locationName:"dialingCapacity" min:"0.01" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProgressiveDialerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProgressiveDialerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProgressiveDialerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProgressiveDialerConfig"}
	if s.BandwidthAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthAllocation"))
	}
	if s.DialingCapacity != nil && *s.DialingCapacity < 0.01 {
		invalidParams.Add(request.NewErrParamMinValue("DialingCapacity", 0.01))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthAllocation sets the BandwidthAllocation field's value.
func (s *ProgressiveDialerConfig) SetBandwidthAllocation(v float64) *ProgressiveDialerConfig {
	s.BandwidthAllocation = &v
	return s
}

// SetDialingCapacity sets the DialingCapacity field's value.
func (s *ProgressiveDialerConfig) SetDialingCapacity(v float64) *ProgressiveDialerConfig {
	s.DialingCapacity = &v
	return s
}

// PutDialRequestBatchRequest
type PutDialRequestBatchInput struct {
	_ struct{} `type:"structure"`

	// A list of dial requests.
	//
	// DialRequests is a required field
	DialRequests []*DialRequest `locationName:"dialRequests" min:"1" type:"list" required:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDialRequestBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDialRequestBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDialRequestBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDialRequestBatchInput"}
	if s.DialRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("DialRequests"))
	}
	if s.DialRequests != nil && len(s.DialRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DialRequests", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.DialRequests != nil {
		for i, v := range s.DialRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DialRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDialRequests sets the DialRequests field's value.
func (s *PutDialRequestBatchInput) SetDialRequests(v []*DialRequest) *PutDialRequestBatchInput {
	s.DialRequests = v
	return s
}

// SetId sets the Id field's value.
func (s *PutDialRequestBatchInput) SetId(v string) *PutDialRequestBatchInput {
	s.Id = &v
	return s
}

// PutDialRequestBatchResponse
type PutDialRequestBatchOutput struct {
	_ struct{} `type:"structure"`

	// A list of failed requests.
	FailedRequests []*FailedRequest `locationName:"failedRequests" type:"list"`

	// A list of successful requests identified by the unique client token.
	SuccessfulRequests []*SuccessfulRequest `locationName:"successfulRequests" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDialRequestBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDialRequestBatchOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *PutDialRequestBatchOutput) SetFailedRequests(v []*FailedRequest) *PutDialRequestBatchOutput {
	s.FailedRequests = v
	return s
}

// SetSuccessfulRequests sets the SuccessfulRequests field's value.
func (s *PutDialRequestBatchOutput) SetSuccessfulRequests(v []*SuccessfulRequest) *PutDialRequestBatchOutput {
	s.SuccessfulRequests = v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// ResumeCampaignRequest
type ResumeCampaignInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResumeCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResumeCampaignInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ResumeCampaignInput) SetId(v string) *ResumeCampaignInput {
	s.Id = &v
	return s
}

type ResumeCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeCampaignOutput) GoString() string {
	return s.String()
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// StartCampaignRequest
type StartCampaignInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCampaignInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StartCampaignInput) SetId(v string) *StartCampaignInput {
	s.Id = &v
	return s
}

type StartCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCampaignOutput) GoString() string {
	return s.String()
}

// The request for StartInstanceOnboardingJob API.
type StartInstanceOnboardingJobInput struct {
	_ struct{} `type:"structure"`

	// Amazon Connect Instance Id
	//
	// ConnectInstanceId is a required field
	ConnectInstanceId *string `location:"uri" locationName:"connectInstanceId" type:"string" required:"true"`

	// Encryption config for Connect Instance. Note that sensitive data will always
	// be encrypted. If disabled, service will perform encryption with its own key.
	// If enabled, a KMS key id needs to be provided and KMS charges will apply.
	// KMS is only type supported
	//
	// EncryptionConfig is a required field
	EncryptionConfig *EncryptionConfig `locationName:"encryptionConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceOnboardingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceOnboardingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceOnboardingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInstanceOnboardingJobInput"}
	if s.ConnectInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectInstanceId"))
	}
	if s.ConnectInstanceId != nil && len(*s.ConnectInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectInstanceId", 1))
	}
	if s.EncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfig"))
	}
	if s.EncryptionConfig != nil {
		if err := s.EncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectInstanceId sets the ConnectInstanceId field's value.
func (s *StartInstanceOnboardingJobInput) SetConnectInstanceId(v string) *StartInstanceOnboardingJobInput {
	s.ConnectInstanceId = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *StartInstanceOnboardingJobInput) SetEncryptionConfig(v *EncryptionConfig) *StartInstanceOnboardingJobInput {
	s.EncryptionConfig = v
	return s
}

// The response for StartInstanceOnboardingJob API.
type StartInstanceOnboardingJobOutput struct {
	_ struct{} `type:"structure"`

	// Instance onboarding job status object
	ConnectInstanceOnboardingJobStatus *InstanceOnboardingJobStatus `locationName:"connectInstanceOnboardingJobStatus" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceOnboardingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceOnboardingJobOutput) GoString() string {
	return s.String()
}

// SetConnectInstanceOnboardingJobStatus sets the ConnectInstanceOnboardingJobStatus field's value.
func (s *StartInstanceOnboardingJobOutput) SetConnectInstanceOnboardingJobStatus(v *InstanceOnboardingJobStatus) *StartInstanceOnboardingJobOutput {
	s.ConnectInstanceOnboardingJobStatus = v
	return s
}

// StopCampaignRequest
type StopCampaignInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCampaignInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopCampaignInput) SetId(v string) *StopCampaignInput {
	s.Id = &v
	return s
}

type StopCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCampaignOutput) GoString() string {
	return s.String()
}

// Successful response of campaign state
type SuccessfulCampaignStateResponse struct {
	_ struct{} `type:"structure"`

	// Identifier representing a Campaign
	CampaignId *string `locationName:"campaignId" type:"string"`

	// State of a campaign
	State *string `locationName:"state" type:"string" enum:"CampaignState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuccessfulCampaignStateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuccessfulCampaignStateResponse) GoString() string {
	return s.String()
}

// SetCampaignId sets the CampaignId field's value.
func (s *SuccessfulCampaignStateResponse) SetCampaignId(v string) *SuccessfulCampaignStateResponse {
	s.CampaignId = &v
	return s
}

// SetState sets the State field's value.
func (s *SuccessfulCampaignStateResponse) SetState(v string) *SuccessfulCampaignStateResponse {
	s.State = &v
	return s
}

// A successful request identified by the unique client token.
type SuccessfulRequest struct {
	_ struct{} `type:"structure"`

	// Client provided parameter used for idempotency. Its value must be unique
	// for each request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Identifier representing a Dial request
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuccessfulRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuccessfulRequest) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *SuccessfulRequest) SetClientToken(v string) *SuccessfulRequest {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *SuccessfulRequest) SetId(v string) *SuccessfulRequest {
	s.Id = &v
	return s
}

// TagResourceRequest
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Arn
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" min:"20" type:"string" required:"true"`

	// Tag map with key and value.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// UntagResourceRequest
type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" min:"20" type:"string" required:"true"`

	// List of tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// UpdateCampaignDialerConfigRequest
type UpdateCampaignDialerConfigInput struct {
	_ struct{} `type:"structure"`

	// The possible types of dialer config parameters
	//
	// DialerConfig is a required field
	DialerConfig *DialerConfig `locationName:"dialerConfig" type:"structure" required:"true"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignDialerConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignDialerConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignDialerConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignDialerConfigInput"}
	if s.DialerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DialerConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.DialerConfig != nil {
		if err := s.DialerConfig.Validate(); err != nil {
			invalidParams.AddNested("DialerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDialerConfig sets the DialerConfig field's value.
func (s *UpdateCampaignDialerConfigInput) SetDialerConfig(v *DialerConfig) *UpdateCampaignDialerConfigInput {
	s.DialerConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCampaignDialerConfigInput) SetId(v string) *UpdateCampaignDialerConfigInput {
	s.Id = &v
	return s
}

type UpdateCampaignDialerConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignDialerConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignDialerConfigOutput) GoString() string {
	return s.String()
}

// UpdateCampaignNameRequest
type UpdateCampaignNameInput struct {
	_ struct{} `type:"structure"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The name of an Amazon Connect Campaign name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignNameInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateCampaignNameInput) SetId(v string) *UpdateCampaignNameInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCampaignNameInput) SetName(v string) *UpdateCampaignNameInput {
	s.Name = &v
	return s
}

type UpdateCampaignNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignNameOutput) GoString() string {
	return s.String()
}

// UpdateCampaignOutboundCallConfigRequest
type UpdateCampaignOutboundCallConfigInput struct {
	_ struct{} `type:"structure"`

	// Answering Machine Detection config
	AnswerMachineDetectionConfig *AnswerMachineDetectionConfig `locationName:"answerMachineDetectionConfig" type:"structure"`

	// The identifier of the contact flow for the outbound call.
	ConnectContactFlowId *string `locationName:"connectContactFlowId" type:"string"`

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	ConnectSourcePhoneNumber *string `locationName:"connectSourcePhoneNumber" type:"string"`

	// Identifier representing a Campaign
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutboundCallConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutboundCallConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignOutboundCallConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignOutboundCallConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.AnswerMachineDetectionConfig != nil {
		if err := s.AnswerMachineDetectionConfig.Validate(); err != nil {
			invalidParams.AddNested("AnswerMachineDetectionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnswerMachineDetectionConfig sets the AnswerMachineDetectionConfig field's value.
func (s *UpdateCampaignOutboundCallConfigInput) SetAnswerMachineDetectionConfig(v *AnswerMachineDetectionConfig) *UpdateCampaignOutboundCallConfigInput {
	s.AnswerMachineDetectionConfig = v
	return s
}

// SetConnectContactFlowId sets the ConnectContactFlowId field's value.
func (s *UpdateCampaignOutboundCallConfigInput) SetConnectContactFlowId(v string) *UpdateCampaignOutboundCallConfigInput {
	s.ConnectContactFlowId = &v
	return s
}

// SetConnectSourcePhoneNumber sets the ConnectSourcePhoneNumber field's value.
func (s *UpdateCampaignOutboundCallConfigInput) SetConnectSourcePhoneNumber(v string) *UpdateCampaignOutboundCallConfigInput {
	s.ConnectSourcePhoneNumber = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCampaignOutboundCallConfigInput) SetId(v string) *UpdateCampaignOutboundCallConfigInput {
	s.Id = &v
	return s
}

type UpdateCampaignOutboundCallConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutboundCallConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutboundCallConfigOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A header that defines the error encountered while processing the request.
	XAmzErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// State of a campaign
const (
	// CampaignStateInitialized is a CampaignState enum value
	CampaignStateInitialized = "Initialized"

	// CampaignStateRunning is a CampaignState enum value
	CampaignStateRunning = "Running"

	// CampaignStatePaused is a CampaignState enum value
	CampaignStatePaused = "Paused"

	// CampaignStateStopped is a CampaignState enum value
	CampaignStateStopped = "Stopped"

	// CampaignStateFailed is a CampaignState enum value
	CampaignStateFailed = "Failed"
)

// CampaignState_Values returns all elements of the CampaignState enum
func CampaignState_Values() []string {
	return []string{
		CampaignStateInitialized,
		CampaignStateRunning,
		CampaignStatePaused,
		CampaignStateStopped,
		CampaignStateFailed,
	}
}

// Server-side encryption type.
const (
	// EncryptionTypeKms is a EncryptionType enum value
	EncryptionTypeKms = "KMS"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeKms,
	}
}

// A predefined code indicating the error that caused the failure.
const (
	// FailureCodeInvalidInput is a FailureCode enum value
	FailureCodeInvalidInput = "InvalidInput"

	// FailureCodeRequestThrottled is a FailureCode enum value
	FailureCodeRequestThrottled = "RequestThrottled"

	// FailureCodeUnknownError is a FailureCode enum value
	FailureCodeUnknownError = "UnknownError"
)

// FailureCode_Values returns all elements of the FailureCode enum
func FailureCode_Values() []string {
	return []string{
		FailureCodeInvalidInput,
		FailureCodeRequestThrottled,
		FailureCodeUnknownError,
	}
}

// A predefined code indicating the error that caused the failure in getting
// state of campaigns
const (
	// GetCampaignStateBatchFailureCodeResourceNotFound is a GetCampaignStateBatchFailureCode enum value
	GetCampaignStateBatchFailureCodeResourceNotFound = "ResourceNotFound"

	// GetCampaignStateBatchFailureCodeUnknownError is a GetCampaignStateBatchFailureCode enum value
	GetCampaignStateBatchFailureCodeUnknownError = "UnknownError"
)

// GetCampaignStateBatchFailureCode_Values returns all elements of the GetCampaignStateBatchFailureCode enum
func GetCampaignStateBatchFailureCode_Values() []string {
	return []string{
		GetCampaignStateBatchFailureCodeResourceNotFound,
		GetCampaignStateBatchFailureCodeUnknownError,
	}
}

// Operators for Connect instance identifier filter
const (
	// InstanceIdFilterOperatorEq is a InstanceIdFilterOperator enum value
	InstanceIdFilterOperatorEq = "Eq"
)

// InstanceIdFilterOperator_Values returns all elements of the InstanceIdFilterOperator enum
func InstanceIdFilterOperator_Values() []string {
	return []string{
		InstanceIdFilterOperatorEq,
	}
}

// Enumeration of the possible failure codes for instance onboarding job
const (
	// InstanceOnboardingJobFailureCodeEventBridgeAccessDenied is a InstanceOnboardingJobFailureCode enum value
	InstanceOnboardingJobFailureCodeEventBridgeAccessDenied = "EVENT_BRIDGE_ACCESS_DENIED"

	// InstanceOnboardingJobFailureCodeEventBridgeManagedRuleLimitExceeded is a InstanceOnboardingJobFailureCode enum value
	InstanceOnboardingJobFailureCodeEventBridgeManagedRuleLimitExceeded = "EVENT_BRIDGE_MANAGED_RULE_LIMIT_EXCEEDED"

	// InstanceOnboardingJobFailureCodeIamAccessDenied is a InstanceOnboardingJobFailureCode enum value
	InstanceOnboardingJobFailureCodeIamAccessDenied = "IAM_ACCESS_DENIED"

	// InstanceOnboardingJobFailureCodeKmsAccessDenied is a InstanceOnboardingJobFailureCode enum value
	InstanceOnboardingJobFailureCodeKmsAccessDenied = "KMS_ACCESS_DENIED"

	// InstanceOnboardingJobFailureCodeKmsKeyNotFound is a InstanceOnboardingJobFailureCode enum value
	InstanceOnboardingJobFailureCodeKmsKeyNotFound = "KMS_KEY_NOT_FOUND"

	// InstanceOnboardingJobFailureCodeInternalFailure is a InstanceOnboardingJobFailureCode enum value
	InstanceOnboardingJobFailureCodeInternalFailure = "INTERNAL_FAILURE"
)

// InstanceOnboardingJobFailureCode_Values returns all elements of the InstanceOnboardingJobFailureCode enum
func InstanceOnboardingJobFailureCode_Values() []string {
	return []string{
		InstanceOnboardingJobFailureCodeEventBridgeAccessDenied,
		InstanceOnboardingJobFailureCodeEventBridgeManagedRuleLimitExceeded,
		InstanceOnboardingJobFailureCodeIamAccessDenied,
		InstanceOnboardingJobFailureCodeKmsAccessDenied,
		InstanceOnboardingJobFailureCodeKmsKeyNotFound,
		InstanceOnboardingJobFailureCodeInternalFailure,
	}
}

// Enumeration of the possible states for instance onboarding job
const (
	// InstanceOnboardingJobStatusCodeInProgress is a InstanceOnboardingJobStatusCode enum value
	InstanceOnboardingJobStatusCodeInProgress = "IN_PROGRESS"

	// InstanceOnboardingJobStatusCodeSucceeded is a InstanceOnboardingJobStatusCode enum value
	InstanceOnboardingJobStatusCodeSucceeded = "SUCCEEDED"

	// InstanceOnboardingJobStatusCodeFailed is a InstanceOnboardingJobStatusCode enum value
	InstanceOnboardingJobStatusCodeFailed = "FAILED"
)

// InstanceOnboardingJobStatusCode_Values returns all elements of the InstanceOnboardingJobStatusCode enum
func InstanceOnboardingJobStatusCode_Values() []string {
	return []string{
		InstanceOnboardingJobStatusCodeInProgress,
		InstanceOnboardingJobStatusCodeSucceeded,
		InstanceOnboardingJobStatusCodeFailed,
	}
}
