// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package lexruntimev2iface provides an interface to enable mocking the Amazon Lex Runtime V2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lexruntimev2iface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/lexruntimev2"
)

// LexRuntimeV2API provides an interface to enable mocking the
// lexruntimev2.LexRuntimeV2 service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Lex Runtime V2.
//	func myFunc(svc lexruntimev2iface.LexRuntimeV2API) bool {
//	    // Make svc.DeleteSession request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := lexruntimev2.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockLexRuntimeV2Client struct {
//	    lexruntimev2iface.LexRuntimeV2API
//	}
//	func (m *mockLexRuntimeV2Client) DeleteSession(input *lexruntimev2.DeleteSessionInput) (*lexruntimev2.DeleteSessionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockLexRuntimeV2Client{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type LexRuntimeV2API interface {
	DeleteSession(*lexruntimev2.DeleteSessionInput) (*lexruntimev2.DeleteSessionOutput, error)
	DeleteSessionWithContext(aws.Context, *lexruntimev2.DeleteSessionInput, ...request.Option) (*lexruntimev2.DeleteSessionOutput, error)
	DeleteSessionRequest(*lexruntimev2.DeleteSessionInput) (*request.Request, *lexruntimev2.DeleteSessionOutput)

	GetSession(*lexruntimev2.GetSessionInput) (*lexruntimev2.GetSessionOutput, error)
	GetSessionWithContext(aws.Context, *lexruntimev2.GetSessionInput, ...request.Option) (*lexruntimev2.GetSessionOutput, error)
	GetSessionRequest(*lexruntimev2.GetSessionInput) (*request.Request, *lexruntimev2.GetSessionOutput)

	PutSession(*lexruntimev2.PutSessionInput) (*lexruntimev2.PutSessionOutput, error)
	PutSessionWithContext(aws.Context, *lexruntimev2.PutSessionInput, ...request.Option) (*lexruntimev2.PutSessionOutput, error)
	PutSessionRequest(*lexruntimev2.PutSessionInput) (*request.Request, *lexruntimev2.PutSessionOutput)

	RecognizeText(*lexruntimev2.RecognizeTextInput) (*lexruntimev2.RecognizeTextOutput, error)
	RecognizeTextWithContext(aws.Context, *lexruntimev2.RecognizeTextInput, ...request.Option) (*lexruntimev2.RecognizeTextOutput, error)
	RecognizeTextRequest(*lexruntimev2.RecognizeTextInput) (*request.Request, *lexruntimev2.RecognizeTextOutput)

	RecognizeUtterance(*lexruntimev2.RecognizeUtteranceInput) (*lexruntimev2.RecognizeUtteranceOutput, error)
	RecognizeUtteranceWithContext(aws.Context, *lexruntimev2.RecognizeUtteranceInput, ...request.Option) (*lexruntimev2.RecognizeUtteranceOutput, error)
	RecognizeUtteranceRequest(*lexruntimev2.RecognizeUtteranceInput) (*request.Request, *lexruntimev2.RecognizeUtteranceOutput)

	StartConversation(*lexruntimev2.StartConversationInput) (*lexruntimev2.StartConversationOutput, error)
	StartConversationWithContext(aws.Context, *lexruntimev2.StartConversationInput, ...request.Option) (*lexruntimev2.StartConversationOutput, error)
	StartConversationRequest(*lexruntimev2.StartConversationInput) (*request.Request, *lexruntimev2.StartConversationOutput)
}

var _ LexRuntimeV2API = (*lexruntimev2.LexRuntimeV2)(nil)
