package contentmoderator

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// ReviewsClient is the you use the API to scan your content as it is generated. Content Moderator then processes your
// content and sends the results along with relevant information either back to your systems or to the built-in review
// tool. You can use this information to take decisions e.g. take it down, send to human judge, etc.
//
// When using the API, images need to have a minimum of 128 pixels and a maximum file size of 4MB.
// Text can be at most 1024 characters long.
// If the content passed to the text API or the image API exceeds the size limits, the API will return an error code
// that informs about the issue.
type ReviewsClient struct {
	BaseClient
}

// NewReviewsClient creates an instance of the ReviewsClient client.
func NewReviewsClient(endpoint string) ReviewsClient {
	return ReviewsClient{New(endpoint)}
}

// AddVideoFrame the reviews created would show up for Reviewers on your team. As Reviewers complete reviewing, results
// of the Review would be POSTED (i.e. HTTP POST) on the specified CallBackEndpoint.
//
// <h3>CallBack Schemas </h3>
// <h4>Review Completion CallBack Sample</h4>
// <p>
// {<br/>
// "ReviewId": "<Review Id>",<br/>
// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",<br/>
// "ModifiedBy": "<Name of the Reviewer>",<br/>
// "CallBackType": "Review",<br/>
// "ContentId": "<The ContentId that was specified input>",<br/>
// "Metadata": {<br/>
// "adultscore": "0.xxx",<br/>
// "a": "False",<br/>
// "racyscore": "0.xxx",<br/>
// "r": "True"<br/>
// },<br/>
// "ReviewerResultTags": {<br/>
// "a": "False",<br/>
// "r": "True"<br/>
// }<br/>
// }<br/>
//
// </p>.
// Parameters:
// teamName - your team name.
// reviewID - id of the review.
// timescale - timescale of the video you are adding frames to.
func (client ReviewsClient) AddVideoFrame(ctx context.Context, teamName string, reviewID string, timescale *int32) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.AddVideoFrame")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddVideoFramePreparer(ctx, teamName, reviewID, timescale)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrame", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddVideoFrameSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrame", resp, "Failure sending request")
		return
	}

	result, err = client.AddVideoFrameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrame", resp, "Failure responding to request")
	}

	return
}

// AddVideoFramePreparer prepares the AddVideoFrame request.
func (client ReviewsClient) AddVideoFramePreparer(ctx context.Context, teamName string, reviewID string, timescale *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{}
	if timescale != nil {
		queryParameters["timescale"] = autorest.Encode("query", *timescale)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddVideoFrameSender sends the AddVideoFrame request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) AddVideoFrameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddVideoFrameResponder handles the response to the AddVideoFrame request. The method always
// closes the http.Response Body.
func (client ReviewsClient) AddVideoFrameResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// AddVideoFrameStream use this method to add frames for a video review.Timescale: This parameter is a factor which is
// used to convert the timestamp on a frame into milliseconds. Timescale is provided in the output of the Content
// Moderator video media processor on the Azure Media Services platform.Timescale in the Video Moderation output is
// Ticks/Second.
// Parameters:
// contentType - the content type.
// teamName - your team name.
// reviewID - id of the review.
// frameImageZip - zip file containing frame images.
// frameMetadata - metadata of the frame.
// timescale - timescale of the video .
func (client ReviewsClient) AddVideoFrameStream(ctx context.Context, contentType string, teamName string, reviewID string, frameImageZip io.ReadCloser, frameMetadata string, timescale *int32) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.AddVideoFrameStream")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddVideoFrameStreamPreparer(ctx, contentType, teamName, reviewID, frameImageZip, frameMetadata, timescale)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrameStream", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddVideoFrameStreamSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrameStream", resp, "Failure sending request")
		return
	}

	result, err = client.AddVideoFrameStreamResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrameStream", resp, "Failure responding to request")
	}

	return
}

// AddVideoFrameStreamPreparer prepares the AddVideoFrameStream request.
func (client ReviewsClient) AddVideoFrameStreamPreparer(ctx context.Context, contentType string, teamName string, reviewID string, frameImageZip io.ReadCloser, frameMetadata string, timescale *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{}
	if timescale != nil {
		queryParameters["timescale"] = autorest.Encode("query", *timescale)
	}

	formDataParameters := map[string]interface{}{
		"frameImageZip": frameImageZip,
		"frameMetadata": frameMetadata,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithMultiPartFormData(formDataParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddVideoFrameStreamSender sends the AddVideoFrameStream request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) AddVideoFrameStreamSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddVideoFrameStreamResponder handles the response to the AddVideoFrameStream request. The method always
// closes the http.Response Body.
func (client ReviewsClient) AddVideoFrameStreamResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// AddVideoFrameURL use this method to add frames for a video review.Timescale: This parameter is a factor which is
// used to convert the timestamp on a frame into milliseconds. Timescale is provided in the output of the Content
// Moderator video media processor on the Azure Media Services platform.Timescale in the Video Moderation output is
// Ticks/Second.
// Parameters:
// contentType - the content type.
// teamName - your team name.
// reviewID - id of the review.
// videoFrameBody - body for add video frames API
// timescale - timescale of the video.
func (client ReviewsClient) AddVideoFrameURL(ctx context.Context, contentType string, teamName string, reviewID string, videoFrameBody []VideoFrameBodyItem, timescale *int32) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.AddVideoFrameURL")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: videoFrameBody,
			Constraints: []validation.Constraint{{Target: "videoFrameBody", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("contentmoderator.ReviewsClient", "AddVideoFrameURL", err.Error())
	}

	req, err := client.AddVideoFrameURLPreparer(ctx, contentType, teamName, reviewID, videoFrameBody, timescale)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrameURL", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddVideoFrameURLSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrameURL", resp, "Failure sending request")
		return
	}

	result, err = client.AddVideoFrameURLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoFrameURL", resp, "Failure responding to request")
	}

	return
}

// AddVideoFrameURLPreparer prepares the AddVideoFrameURL request.
func (client ReviewsClient) AddVideoFrameURLPreparer(ctx context.Context, contentType string, teamName string, reviewID string, videoFrameBody []VideoFrameBodyItem, timescale *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{}
	if timescale != nil {
		queryParameters["timescale"] = autorest.Encode("query", *timescale)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames", pathParameters),
		autorest.WithJSON(videoFrameBody),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddVideoFrameURLSender sends the AddVideoFrameURL request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) AddVideoFrameURLSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddVideoFrameURLResponder handles the response to the AddVideoFrameURL request. The method always
// closes the http.Response Body.
func (client ReviewsClient) AddVideoFrameURLResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// AddVideoTranscript this API adds a transcript file (text version of all the words spoken in a video) to a video
// review. The file should be a valid WebVTT format.
// Parameters:
// teamName - your team name.
// reviewID - id of the review.
// vttfile - transcript file of the video.
func (client ReviewsClient) AddVideoTranscript(ctx context.Context, teamName string, reviewID string, vttfile io.ReadCloser) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.AddVideoTranscript")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddVideoTranscriptPreparer(ctx, teamName, reviewID, vttfile)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoTranscript", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddVideoTranscriptSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoTranscript", resp, "Failure sending request")
		return
	}

	result, err = client.AddVideoTranscriptResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoTranscript", resp, "Failure responding to request")
	}

	return
}

// AddVideoTranscriptPreparer prepares the AddVideoTranscript request.
func (client ReviewsClient) AddVideoTranscriptPreparer(ctx context.Context, teamName string, reviewID string, vttfile io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/transcript", pathParameters),
		autorest.WithFile(vttfile),
		autorest.WithHeader("Content-Type", "text/plain"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddVideoTranscriptSender sends the AddVideoTranscript request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) AddVideoTranscriptSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddVideoTranscriptResponder handles the response to the AddVideoTranscript request. The method always
// closes the http.Response Body.
func (client ReviewsClient) AddVideoTranscriptResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// AddVideoTranscriptModerationResult this API adds a transcript screen text result file for a video review. Transcript
// screen text result file is a result of Screen Text API . In order to generate transcript screen text result file , a
// transcript file has to be screened for profanity using Screen Text API.
// Parameters:
// contentType - the content type.
// teamName - your team name.
// reviewID - id of the review.
// transcriptModerationBody - body for add video transcript moderation result API
func (client ReviewsClient) AddVideoTranscriptModerationResult(ctx context.Context, contentType string, teamName string, reviewID string, transcriptModerationBody []TranscriptModerationBodyItem) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.AddVideoTranscriptModerationResult")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: transcriptModerationBody,
			Constraints: []validation.Constraint{{Target: "transcriptModerationBody", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("contentmoderator.ReviewsClient", "AddVideoTranscriptModerationResult", err.Error())
	}

	req, err := client.AddVideoTranscriptModerationResultPreparer(ctx, contentType, teamName, reviewID, transcriptModerationBody)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoTranscriptModerationResult", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddVideoTranscriptModerationResultSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoTranscriptModerationResult", resp, "Failure sending request")
		return
	}

	result, err = client.AddVideoTranscriptModerationResultResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "AddVideoTranscriptModerationResult", resp, "Failure responding to request")
	}

	return
}

// AddVideoTranscriptModerationResultPreparer prepares the AddVideoTranscriptModerationResult request.
func (client ReviewsClient) AddVideoTranscriptModerationResultPreparer(ctx context.Context, contentType string, teamName string, reviewID string, transcriptModerationBody []TranscriptModerationBodyItem) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/transcriptmoderationresult", pathParameters),
		autorest.WithJSON(transcriptModerationBody),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddVideoTranscriptModerationResultSender sends the AddVideoTranscriptModerationResult request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) AddVideoTranscriptModerationResultSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddVideoTranscriptModerationResultResponder handles the response to the AddVideoTranscriptModerationResult request. The method always
// closes the http.Response Body.
func (client ReviewsClient) AddVideoTranscriptModerationResultResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateJob a job Id will be returned for the content posted on this endpoint.
//
// Once the content is evaluated against the Workflow provided the review will be created or ignored based on the
// workflow expression.
//
// <h3>CallBack Schemas </h3>
//
// <p>
// <h4>Job Completion CallBack Sample</h4><br/>
//
// {<br/>
// "JobId": "<Job Id>,<br/>
// "ReviewId": "<Review Id, if the Job resulted in a Review to be created>",<br/>
// "WorkFlowId": "default",<br/>
// "Status": "<This will be one of Complete, InProgress, Error>",<br/>
// "ContentType": "Image",<br/>
// "ContentId": "<This is the ContentId that was specified on input>",<br/>
// "CallBackType": "Job",<br/>
// "Metadata": {<br/>
// "adultscore": "0.xxx",<br/>
// "a": "False",<br/>
// "racyscore": "0.xxx",<br/>
// "r": "True"<br/>
// }<br/>
// }<br/>
//
// </p>
// <p>
// <h4>Review Completion CallBack Sample</h4><br/>
//
// {
// "ReviewId": "<Review Id>",<br/>
// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",<br/>
// "ModifiedBy": "<Name of the Reviewer>",<br/>
// "CallBackType": "Review",<br/>
// "ContentId": "<The ContentId that was specified input>",<br/>
// "Metadata": {<br/>
// "adultscore": "0.xxx",
// "a": "False",<br/>
// "racyscore": "0.xxx",<br/>
// "r": "True"<br/>
// },<br/>
// "ReviewerResultTags": {<br/>
// "a": "False",<br/>
// "r": "True"<br/>
// }<br/>
// }<br/>
//
// </p>.
// Parameters:
// teamName - your team name.
// contentType - image, Text or Video.
// contentID - id/Name to identify the content submitted.
// workflowName - workflow Name that you want to invoke.
// jobContentType - the content type.
// content - content to evaluate.
// callBackEndpoint - callback endpoint for posting the create job result.
func (client ReviewsClient) CreateJob(ctx context.Context, teamName string, contentType string, contentID string, workflowName string, jobContentType string, content Content, callBackEndpoint string) (result JobID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.CreateJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: content,
			Constraints: []validation.Constraint{{Target: "content.ContentValue", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("contentmoderator.ReviewsClient", "CreateJob", err.Error())
	}

	req, err := client.CreateJobPreparer(ctx, teamName, contentType, contentID, workflowName, jobContentType, content, callBackEndpoint)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateJob", resp, "Failure sending request")
		return
	}

	result, err = client.CreateJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateJob", resp, "Failure responding to request")
	}

	return
}

// CreateJobPreparer prepares the CreateJob request.
func (client ReviewsClient) CreateJobPreparer(ctx context.Context, teamName string, contentType string, contentID string, workflowName string, jobContentType string, content Content, callBackEndpoint string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{
		"ContentId":    autorest.Encode("query", contentID),
		"ContentType":  autorest.Encode("query", contentType),
		"WorkflowName": autorest.Encode("query", workflowName),
	}
	if len(callBackEndpoint) > 0 {
		queryParameters["CallBackEndpoint"] = autorest.Encode("query", callBackEndpoint)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/jobs", pathParameters),
		autorest.WithJSON(content),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(jobContentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateJobSender sends the CreateJob request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) CreateJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateJobResponder handles the response to the CreateJob request. The method always
// closes the http.Response Body.
func (client ReviewsClient) CreateJobResponder(resp *http.Response) (result JobID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateReviews the reviews created would show up for Reviewers on your team. As Reviewers complete reviewing, results
// of the Review would be POSTED (i.e. HTTP POST) on the specified CallBackEndpoint.
//
// <h3>CallBack Schemas </h3>
// <h4>Review Completion CallBack Sample</h4>
// <p>
// {<br/>
// "ReviewId": "<Review Id>",<br/>
// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",<br/>
// "ModifiedBy": "<Name of the Reviewer>",<br/>
// "CallBackType": "Review",<br/>
// "ContentId": "<The ContentId that was specified input>",<br/>
// "Metadata": {<br/>
// "adultscore": "0.xxx",<br/>
// "a": "False",<br/>
// "racyscore": "0.xxx",<br/>
// "r": "True"<br/>
// },<br/>
// "ReviewerResultTags": {<br/>
// "a": "False",<br/>
// "r": "True"<br/>
// }<br/>
// }<br/>
//
// </p>.
// Parameters:
// URLContentType - the content type.
// teamName - your team name.
// createReviewBody - body for create reviews API
// subTeam - subTeam of your team, you want to assign the created review to.
func (client ReviewsClient) CreateReviews(ctx context.Context, URLContentType string, teamName string, createReviewBody []CreateReviewBodyItem, subTeam string) (result ListString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.CreateReviews")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: createReviewBody,
			Constraints: []validation.Constraint{{Target: "createReviewBody", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("contentmoderator.ReviewsClient", "CreateReviews", err.Error())
	}

	req, err := client.CreateReviewsPreparer(ctx, URLContentType, teamName, createReviewBody, subTeam)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateReviews", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateReviewsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateReviews", resp, "Failure sending request")
		return
	}

	result, err = client.CreateReviewsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateReviews", resp, "Failure responding to request")
	}

	return
}

// CreateReviewsPreparer prepares the CreateReviews request.
func (client ReviewsClient) CreateReviewsPreparer(ctx context.Context, URLContentType string, teamName string, createReviewBody []CreateReviewBodyItem, subTeam string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{}
	if len(subTeam) > 0 {
		queryParameters["subTeam"] = autorest.Encode("query", subTeam)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews", pathParameters),
		autorest.WithJSON(createReviewBody),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("UrlContentType", autorest.String(URLContentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateReviewsSender sends the CreateReviews request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) CreateReviewsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateReviewsResponder handles the response to the CreateReviews request. The method always
// closes the http.Response Body.
func (client ReviewsClient) CreateReviewsResponder(resp *http.Response) (result ListString, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateVideoReviews the reviews created would show up for Reviewers on your team. As Reviewers complete reviewing,
// results of the Review would be POSTED (i.e. HTTP POST) on the specified CallBackEndpoint.
//
// <h3>CallBack Schemas </h3>
// <h4>Review Completion CallBack Sample</h4>
// <p>
// {<br/>
// "ReviewId": "<Review Id>",<br/>
// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",<br/>
// "ModifiedBy": "<Name of the Reviewer>",<br/>
// "CallBackType": "Review",<br/>
// "ContentId": "<The ContentId that was specified input>",<br/>
// "Metadata": {<br/>
// "adultscore": "0.xxx",<br/>
// "a": "False",<br/>
// "racyscore": "0.xxx",<br/>
// "r": "True"<br/>
// },<br/>
// "ReviewerResultTags": {<br/>
// "a": "False",<br/>
// "r": "True"<br/>
// }<br/>
// }<br/>
//
// </p>.
// Parameters:
// contentType - the content type.
// teamName - your team name.
// createVideoReviewsBody - body for create reviews API
// subTeam - subTeam of your team, you want to assign the created review to.
func (client ReviewsClient) CreateVideoReviews(ctx context.Context, contentType string, teamName string, createVideoReviewsBody []CreateVideoReviewsBodyItem, subTeam string) (result ListString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.CreateVideoReviews")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: createVideoReviewsBody,
			Constraints: []validation.Constraint{{Target: "createVideoReviewsBody", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("contentmoderator.ReviewsClient", "CreateVideoReviews", err.Error())
	}

	req, err := client.CreateVideoReviewsPreparer(ctx, contentType, teamName, createVideoReviewsBody, subTeam)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateVideoReviews", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateVideoReviewsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateVideoReviews", resp, "Failure sending request")
		return
	}

	result, err = client.CreateVideoReviewsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "CreateVideoReviews", resp, "Failure responding to request")
	}

	return
}

// CreateVideoReviewsPreparer prepares the CreateVideoReviews request.
func (client ReviewsClient) CreateVideoReviewsPreparer(ctx context.Context, contentType string, teamName string, createVideoReviewsBody []CreateVideoReviewsBodyItem, subTeam string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{}
	if len(subTeam) > 0 {
		queryParameters["subTeam"] = autorest.Encode("query", subTeam)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews", pathParameters),
		autorest.WithJSON(createVideoReviewsBody),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateVideoReviewsSender sends the CreateVideoReviews request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) CreateVideoReviewsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateVideoReviewsResponder handles the response to the CreateVideoReviews request. The method always
// closes the http.Response Body.
func (client ReviewsClient) CreateVideoReviewsResponder(resp *http.Response) (result ListString, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetJobDetails get the Job Details for a Job Id.
// Parameters:
// teamName - your Team Name.
// jobID - id of the job.
func (client ReviewsClient) GetJobDetails(ctx context.Context, teamName string, jobID string) (result Job, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.GetJobDetails")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetJobDetailsPreparer(ctx, teamName, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetJobDetails", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetJobDetailsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetJobDetails", resp, "Failure sending request")
		return
	}

	result, err = client.GetJobDetailsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetJobDetails", resp, "Failure responding to request")
	}

	return
}

// GetJobDetailsPreparer prepares the GetJobDetails request.
func (client ReviewsClient) GetJobDetailsPreparer(ctx context.Context, teamName string, jobID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"JobId":    autorest.Encode("path", jobID),
		"teamName": autorest.Encode("path", teamName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/jobs/{JobId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetJobDetailsSender sends the GetJobDetails request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) GetJobDetailsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetJobDetailsResponder handles the response to the GetJobDetails request. The method always
// closes the http.Response Body.
func (client ReviewsClient) GetJobDetailsResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetReview returns review details for the review Id passed.
// Parameters:
// teamName - your Team Name.
// reviewID - id of the review.
func (client ReviewsClient) GetReview(ctx context.Context, teamName string, reviewID string) (result Review, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.GetReview")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetReviewPreparer(ctx, teamName, reviewID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetReview", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetReviewSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetReview", resp, "Failure sending request")
		return
	}

	result, err = client.GetReviewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetReview", resp, "Failure responding to request")
	}

	return
}

// GetReviewPreparer prepares the GetReview request.
func (client ReviewsClient) GetReviewPreparer(ctx context.Context, teamName string, reviewID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetReviewSender sends the GetReview request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) GetReviewSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetReviewResponder handles the response to the GetReview request. The method always
// closes the http.Response Body.
func (client ReviewsClient) GetReviewResponder(resp *http.Response) (result Review, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVideoFrames the reviews created would show up for Reviewers on your team. As Reviewers complete reviewing,
// results of the Review would be POSTED (i.e. HTTP POST) on the specified CallBackEndpoint.
//
// <h3>CallBack Schemas </h3>
// <h4>Review Completion CallBack Sample</h4>
// <p>
// {<br/>
// "ReviewId": "<Review Id>",<br/>
// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",<br/>
// "ModifiedBy": "<Name of the Reviewer>",<br/>
// "CallBackType": "Review",<br/>
// "ContentId": "<The ContentId that was specified input>",<br/>
// "Metadata": {<br/>
// "adultscore": "0.xxx",<br/>
// "a": "False",<br/>
// "racyscore": "0.xxx",<br/>
// "r": "True"<br/>
// },<br/>
// "ReviewerResultTags": {<br/>
// "a": "False",<br/>
// "r": "True"<br/>
// }<br/>
// }<br/>
//
// </p>.
// Parameters:
// teamName - your team name.
// reviewID - id of the review.
// startSeed - time stamp of the frame from where you want to start fetching the frames.
// noOfRecords - number of frames to fetch.
// filter - get frames filtered by tags.
func (client ReviewsClient) GetVideoFrames(ctx context.Context, teamName string, reviewID string, startSeed *int32, noOfRecords *int32, filter string) (result Frames, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.GetVideoFrames")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetVideoFramesPreparer(ctx, teamName, reviewID, startSeed, noOfRecords, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetVideoFrames", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVideoFramesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetVideoFrames", resp, "Failure sending request")
		return
	}

	result, err = client.GetVideoFramesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "GetVideoFrames", resp, "Failure responding to request")
	}

	return
}

// GetVideoFramesPreparer prepares the GetVideoFrames request.
func (client ReviewsClient) GetVideoFramesPreparer(ctx context.Context, teamName string, reviewID string, startSeed *int32, noOfRecords *int32, filter string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	queryParameters := map[string]interface{}{}
	if startSeed != nil {
		queryParameters["startSeed"] = autorest.Encode("query", *startSeed)
	}
	if noOfRecords != nil {
		queryParameters["noOfRecords"] = autorest.Encode("query", *noOfRecords)
	}
	if len(filter) > 0 {
		queryParameters["filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVideoFramesSender sends the GetVideoFrames request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) GetVideoFramesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetVideoFramesResponder handles the response to the GetVideoFrames request. The method always
// closes the http.Response Body.
func (client ReviewsClient) GetVideoFramesResponder(resp *http.Response) (result Frames, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PublishVideoReview publish video review to make it available for review.
// Parameters:
// teamName - your team name.
// reviewID - id of the review.
func (client ReviewsClient) PublishVideoReview(ctx context.Context, teamName string, reviewID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReviewsClient.PublishVideoReview")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PublishVideoReviewPreparer(ctx, teamName, reviewID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "PublishVideoReview", nil, "Failure preparing request")
		return
	}

	resp, err := client.PublishVideoReviewSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "PublishVideoReview", resp, "Failure sending request")
		return
	}

	result, err = client.PublishVideoReviewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ReviewsClient", "PublishVideoReview", resp, "Failure responding to request")
	}

	return
}

// PublishVideoReviewPreparer prepares the PublishVideoReview request.
func (client ReviewsClient) PublishVideoReviewPreparer(ctx context.Context, teamName string, reviewID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"reviewId": autorest.Encode("path", reviewID),
		"teamName": autorest.Encode("path", teamName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/publish", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PublishVideoReviewSender sends the PublishVideoReview request. The method will close the
// http.Response Body if it receives an error.
func (client ReviewsClient) PublishVideoReviewSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PublishVideoReviewResponder handles the response to the PublishVideoReview request. The method always
// closes the http.Response Body.
func (client ReviewsClient) PublishVideoReviewResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
