/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "game.h"
#include "intl.h"
#include "options_dialog.h"

OptionsDialog::OptionsDialog(Game* game) : Dialog(_("Preferences")), 
					   _game(game)
{
   GtkWidget* box = gtk_hbox_new(FALSE, 1);;
   gtk_container_border_width(GTK_CONTAINER(box), 10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->vbox), box, TRUE, TRUE, 10);
   _tooltips = gtk_check_button_new_with_mnemonic(_("_Show Tooltips"));
   gtk_container_add(GTK_CONTAINER(box), _tooltips);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(_tooltips), TRUE);

   AddCancelButton();
}

void
OptionsDialog::OnOk()
{
   _game->EnableTooltips((GTK_TOGGLE_BUTTON(_tooltips)->active) 
			 ? true : false);      
}
