/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains factory API for creating instances of type {@link com.gs.collections.api.list.ListIterable}.
 * <p>
 *      This package contains the following interfaces:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.api.factory.list.FixedSizeListFactory} - a factory which creates instances of type {@link com.gs.collections.api.list.FixedSizeList}.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.api.factory.list.ImmutableListFactory} - a factory which creates instances of type {@link com.gs.collections.api.list.ImmutableList}.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.api.factory.list.MutableListFactory} - a factory which creates instances of type {@link com.gs.collections.api.list.MutableList}.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.factory.list;
