/* 
 Project: GShisen
 
 Copyright (C) 2003-2009 The GNUstep Application Project
 
 Author: Enrico Sersale, Riccardo Mottola
 
 Main Application
 
 This application is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This application is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU General Public
 License along with this library; if not, write to the Free
 Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#import "gshisen.h"

static GShisen *sharedshisen = nil;

@implementation GShisen

+ (GShisen *)sharedshisen
{
    if(!sharedshisen) {
        NS_DURING
            {
                sharedshisen = [[self alloc] init];
            }
        NS_HANDLER
            {
                [localException raise];
            }
        NS_ENDHANDLER
            }
    return sharedshisen;
}

- (id)init
{
  sharedshisen = self;
  return sharedshisen;
}

- (void)dealloc
{
    [board release];
    [win release];
    [super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    [win center];
    [win display];
    [win orderFront:nil];
}

- (BOOL)applicationShouldTerminate:(id)sender 
{
    return YES;
}

- (void)newGame:(id)sender
{
    [board newGame];
}

- (void)pause:(id)sender
{
    [board pause];
}

- (void)undo:(id)sender
{
    [board undo];
}

- (void)getHint:(id)sender
{
    [board getHint];
}

- (NSString *)getUserName
{
  NSString *username;

  [[NSApplication sharedApplication] runModalForWindow:askNamePanel];
  username = [nameField stringValue];
  
  return username;
}

- (IBAction)buttonOk:(id)sender
{	
  [askNamePanel orderOut: self];
  [[NSApplication sharedApplication] stopModal];
}

- (void)showHallOfFame:(id)sender
{
  NSMutableArray *scores;
  NSDictionary *scoresEntry;
  NSString *userName, *minutes, *seconds, *totTime;
  NSRect myRect = {{0, 0}, {150, 300}};
  NSRect matrixRect = {{0, 0}, {150, 300}};
  int i;
  NSButtonCell *buttonCell;
  NSScrollView *scoresScroll;
  
  scores = [board scores];
  if ([scores count] >= 20) {
    matrixRect.size.height = [scores count] * 15;
  }

  [hallOfFamePanel makeKeyAndOrderFront:self];
  myView = [[NSView alloc] initWithFrame: [hallOfFamePanel frame]];
  [hallOfFamePanel setContentView: myView];


  buttonCell = [[NSButtonCell new] autorelease];
  [buttonCell setButtonType: NSPushOnPushOffButton];
  [buttonCell setBordered:NO];
  [buttonCell setAlignment:NSLeftTextAlignment];	
  //	NSLog(@"Height: %d", [buttonCell cellSize].height);

  scoresMatrix = [[NSMatrix alloc] initWithFrame:matrixRect mode:NSRadioModeMatrix
				   prototype:buttonCell 
				   numberOfRows:[scores count] 
				   numberOfColumns:2];

  [scoresMatrix setAutoresizingMask: NSViewWidthSizable];
											
  scoresScroll = [[NSScrollView alloc] initWithFrame: myRect];
  [scoresScroll setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
  [scoresScroll setHasVerticalScroller: YES];
  [scoresScroll setHasHorizontalScroller: NO];
		
  for(i = 0; i < [scores count]; i++) {
    scoresEntry = [scores objectAtIndex: i];
    userName = [scoresEntry objectForKey: @"username"];
    minutes = [scoresEntry objectForKey: @"minutes"];
    seconds = [scoresEntry objectForKey: @"seconds"];
    totTime = [NSString stringWithFormat:@"%@:%@", minutes, seconds];
    //		[scoresMatrix addRow];
    [[scoresMatrix cellAtRow:i column:0] setTitle: userName];
    [[scoresMatrix cellAtRow:i column:1] setTitle: totTime];
  }
		
  [scoresScroll setDocumentView: scoresMatrix];
  [myView addSubview: scoresScroll];
	
  [hallOfFamePanel makeKeyAndOrderFront:self];
}


@end

