//*****************************************************************************
//                              CmdNgSpiceAC.hpp                              *
//                             ------------------                             *
// Description : This class contains values associated with the NG-Spice      *
//               AC command. It inherits from the class CmdBase.              *
// Started     : 11/10/2007                                                   *
// Last Update : 24/12/2010                                                   *
// Copyright   : (C) 2007 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSAC_HPP
#define CMDNGSAC_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "gnucap/commands/CmdGnuCapAC.hpp"
#include "utility/ConvertType.hpp"

struct CmdGnuCapAC;

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdNgSpiceAC : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;  // The sweep start value
    wxString    m_osStop;   // The sweep stop  value
    wxString    m_osStep;   // The sweep step  value
    eScaleType  m_eScale;   // The sweep scale type

              CmdNgSpiceAC( void );
    virtual  ~CmdNgSpiceAC( );

    virtual  bool  bSetDefaults( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdNgSpiceAC & operator = ( const CmdGnuCapAC & roCmdAC );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDNGSAC_HPP
