// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MAPINFO_H
#define _GSTREAMERMM_MAPINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * mapinfo.hg
 *
 *  Created on: Jul 31, 2013
 *      Author: m.kolny
 */
/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/memory.h>
#include <gstreamermm/object.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var MapFlags MAP_READ
 *  Map for read access.
 * 
 *  @var MapFlags MAP_WRITE
 *  Map for write access.
 * 
 *  @var MapFlags MAP_FLAG_LAST
 *  First flag that can be used for custom purposes.
 * 
 *  @enum MapFlags
 * 
 * Flags used when mapping memory
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MapFlags operator|(MapFlags, MapFlags)</tt><br>
 * <tt>%MapFlags operator&(MapFlags, MapFlags)</tt><br>
 * <tt>%MapFlags operator^(MapFlags, MapFlags)</tt><br>
 * <tt>%MapFlags operator~(MapFlags)</tt><br>
 * <tt>%MapFlags& operator|=(MapFlags&, MapFlags)</tt><br>
 * <tt>%MapFlags& operator&=(MapFlags&, MapFlags)</tt><br>
 * <tt>%MapFlags& operator^=(MapFlags&, MapFlags)</tt><br>
 */
enum MapFlags
{
  MAP_READ = GST_LOCK_FLAG_READ,
  MAP_WRITE = GST_LOCK_FLAG_WRITE,
  MAP_FLAG_LAST = (1 << 16)
};

/** @ingroup gstreamermmEnums */
inline MapFlags operator|(MapFlags lhs, MapFlags rhs)
  { return static_cast<MapFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MapFlags operator&(MapFlags lhs, MapFlags rhs)
  { return static_cast<MapFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MapFlags operator^(MapFlags lhs, MapFlags rhs)
  { return static_cast<MapFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MapFlags operator~(MapFlags flags)
  { return static_cast<MapFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MapFlags& operator|=(MapFlags& lhs, MapFlags rhs)
  { return (lhs = static_cast<MapFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MapFlags& operator&=(MapFlags& lhs, MapFlags rhs)
  { return (lhs = static_cast<MapFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MapFlags& operator^=(MapFlags& lhs, MapFlags rhs)
  { return (lhs = static_cast<MapFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MapFlags> : public Glib::Value_Flags<Gst::MapFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/* A structure containing the result of a map operation such as
 * Memory::Map(). It contains the data and size.
 */
class MapInfo : public Glib::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MapInfo CppObjectType;
  typedef GstMapInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  MapInfo();

  explicit MapInfo(GstMapInfo& castitem,
    bool take_ownership = false);

  MapInfo(const MapInfo& other);

  virtual ~MapInfo();


   MapFlags get_flags() const;
    guint8* get_data() const;
    gsize get_maxsize() const;
    gsize get_size() const;
 
  GstMapInfo* gobj() { return m_spec; };
  const GstMapInfo* gobj() const { return m_spec; };

protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  GstMapInfo* m_spec;
  bool take_ownership;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};

}//namespace Gst


#endif /* _GSTREAMERMM_MAPINFO_H */

