// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"MSAM",

  0xf4,
  "TeX math symbols",
  0x00500000,
  0x22891c78,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38d },
  { 0x06, "quad", 0x00178e4d },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000ecdca },
  { 0x09, "num2", 0x0006330d },
  { 0x0a, "num3", 0x000810ed },
  { 0x0b, "denom1", 0x00106763 },
  { 0x0c, "denom2", 0x000882b3 },
  { 0x0d, "sup1", 0x00080e90 },
  { 0x0e, "sup2", 0x000674f6 },
  { 0x0f, "sup3", 0x0004b60d },
  { 0x10, "sub1", 0x00033333 },
  { 0x11, "sub2", 0x00066666 },
  { 0x12, "supdrop", 0x0007e940 },
  { 0x13, "subdrop", 0x0001999a },
  { 0x14, "delim1", 0x001fae13 },
  { 0x15, "delim2", 0x0016b853 },
  { 0x16, "axis_height", 0x00040000 }
};



static TFM::Character character[] = {
  { 0x00, 0x00115566, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00115566, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x00115566, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00115566, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x00115566, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x0007555a, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000f1c80, 0x000ae393, 0x00022d43, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000f1c80, 0x000ae393, 0x00022d43, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x00115566, 0x000ae393, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x00115566, 0x000ae393, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x0015c733, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x0015c733, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x00115566, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x001038f3, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00138e4d, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x000e000d, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x0015c733, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x0015c733, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x0015c733, 0x000b779d, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x0015c733, 0x000b779d, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x001271da, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x001271da, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000a1c7a, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000a1c7a, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000a1c7a, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000a1c7a, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x0018001a, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x0018001a, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x0015c733, 0x000b779d, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x0015c733, 0x000b779d, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000bc726, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000bc726, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x001d8e5a, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x0015c733, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x0015c733, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00115566, 0x000da216, 0x00055fe6, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00115566, 0x000d1c9d, 0x00055fe6, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x00115566, 0x000d1c9d, 0x00055fe6, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x00115566, 0x000e08ba, 0x0005f15d, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x0018001a, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x000f1c80, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000f1c80, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x00115566, 0x000ae393, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x000f8e4d, 0x00115566, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00115566, 0x000d1c9d, 0x0004f4a0, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00115566, 0x000d1c9d, 0x0004f4a0, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00115566, 0x000e08ba, 0x0005f15d, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00115566, 0x000da216, 0x0005f15d, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00115566, 0x000c3ded, 0x00047bdd, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x00070e3d, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000a000d, 0x00080826, 0x000042e6, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x00115566, 0x000a5afa, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x00115566, 0x000a5afa, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x00115566, 0x000da216, 0x0005f15d, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00115566, 0x000c3ded, 0x00047bdd, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x42, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x45, 0x00115566, 0x000b779d, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x00111c73, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x47, 0x000bc726, 0x000c3ded, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x000e0003, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x4a, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x000a000d, 0x00080826, 0x000042e6, 0x00000000, 0, 0, 0, 0 },
  { 0x4c, 0x000a000d, 0x00080826, 0x000042e6, 0x00000000, 0, 0, 0, 0 },
  { 0x4d, 0x000e0003, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x000e0003, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x000e0003, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x50, 0x00115566, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x51, 0x00115566, 0x00105693, 0x00085693, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x00115566, 0x00105693, 0x00085693, 0x00000000, 0, 0, 0, 0 },
  { 0x53, 0x00115566, 0x00123b90, 0x000a3b90, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x00115566, 0x00123b90, 0x000a3b90, 0x00000000, 0, 0, 0, 0 },
  { 0x55, 0x001093fa, 0x000ae393, 0x00000000, 0x00008000, 0, 0, 0, 0 },
  { 0x56, 0x0015c733, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x57, 0x0015c733, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x58, 0x001271da, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x59, 0x000e000d, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x5a, 0x000e000d, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x000e000d, 0x000c3ded, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x001038f3, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x001038f3, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x001038f3, 0x0008b1c6, 0x000087d3, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x00115566, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x00115566, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x00115566, 0x000ae393, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x000f1c80, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x000f1c80, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00108e3a, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x00108e3a, 0x0008b1c6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00115566, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x00115566, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00115566, 0x000da216, 0x0005f15d, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x00115566, 0x000da216, 0x0005f15d, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x00115566, 0x000a5afa, 0x00022d43, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x00115566, 0x000a5afa, 0x00022d43, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x001c71e6, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x001c71e6, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000bc726, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000bc726, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x001093fa, 0x000b779d, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x000fd28d, 0x000b779d, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x000f1c80, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x00115566, 0x000d1c9d, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x00115566, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x00115566, 0x00080826, 0x000042e6, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x000bc726, 0x00080826, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x000bc726, 0x00080826, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x001271da, 0x000ae393, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000bc726, 0x000d1c9d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000ce39a, 0x0006e38d, 0x00031f0a, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x00115566, 0x000ae393, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x00115566, 0x000ae393, 0x00029f83, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x00115566, 0x000ae393, 0x00029f83, 0x00000000, 0, 0, 0, 0 }
};

void
msam5_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
