// generated by ../../../../tools/tube_transfer.py
// tube: EL34
// plate current function: pentode
// mu: 12.3
// kx: 1.17
// kg1: 353.9
// kg2: 4500
// kp: 61.1
// kvb: 29.9
// Uin_min: -20
// Uin_max: 20
// Vp: 495
// Rp: 3500

table1d_imp<2001> tubetable_EL34[2] __rt_data = {
	{ // Ri = 68k
	-20,20,50,2001, {
	288.9476929184571,288.7948610045677,288.6419831295935,288.4890593106638,288.3360895649282,
	288.18307390955687,288.0300123617398,287.8769049386881,287.7237516576333,287.5705525358279,
	287.41730759054553,287.26401683908085,287.1106802987498,286.9572979868899,286.8038699208604,
	286.650396118042,286.49687659583776,286.34331137167237,286.189700462993,286.0360438872694,
	285.8823416619933,285.7285938046796,285.57480033286583,285.4209612641127,285.2670766160039,
	285.11314640614654,284.95917065217117,284.8051493717319,284.65108258250694,284.496970302198,
	284.3428125485313,284.18860933925697,284.03436069214996,283.88006662500953,283.72572715565997,
	283.57134230195004,283.4169120817541,283.2624365129714,283.1079156135268,282.95334940137064,
	282.7987378944792,282.64408111085436,282.4893790685243,282.3346317855434,282.1798392799925,
	282.0250015699791,281.87011867363714,281.71519060912783,281.56021739463944,281.4051990483874,
	281.25013558861457,281.0950270335916,280.93987340161675,280.7846747110164,280.6294309801451,
	280.4741422273855,280.31880847114905,280.16342972987565,280.00800602203407,279.85253736612236,
	279.69702378066756,279.54146528422615,279.3858618953842,279.2302136327576,279.0745205149921,
	278.9187825607637,278.7629997887784,278.6071722177732,278.4512998665154,278.29538275380315,
	278.1394208984661,277.9834143193645,277.82736303539053,277.6712670654678,277.5151264285517,
	277.3589411436298,277.2027112297216,277.0464367058792,276.8901175911873,276.733753904763,
	276.5773456657569,276.42089289335235,276.26439560676636,276.1078538252492,275.9512675680851,
	275.79463685459217,275.6379617041227,275.48124213606326,275.324478169835,275.1676698248939,
	275.01081712073085,274.85392007687176,274.69697871287804,274.5399930483466,274.3829631029103,
	274.2258888962377,274.06877044803366,273.9116077780394,273.7544009060329,273.5971498518288,
	273.4398546352787,273.2825152762715,273.12513179473353,272.9677042106289,272.8102325439593,
	272.6527168147647,272.49515704312347,272.3375532491522,272.1799054530064,272.02221367488056,
	271.86447793500815,271.7066982536621,271.54887465115496,271.3910071478393,271.23309576410725,
	271.0751405203917,270.91714143716575,270.7590985349433,270.60101183427923,270.4428813557695,
	270.2847071200514,270.126489147804,269.96822745974833,269.80992207664707,269.6515730193056,
	269.49318030857177,269.33474396533603,269.1762640105319,269.01774046513634,268.85917335016956,
	268.7005626866955,268.5419084958222,268.3832107987017,268.22446961653066,268.0656849705502,
	267.9068568820465,267.7479853723508,267.5890704628398,267.43011217493574,267.27111053010697,
	267.11206554986745,266.9529772557781,266.7938456694461,266.63467081252566,266.47545270671793,
	266.3161913737715,266.1568868354828,265.99753911369567,265.83814823030247,265.6787142072439,
	265.5192370665089,265.35971683013577,265.2001535202116,265.0405471588732,264.88089776830674,
	264.72120537074846,264.56146998848476,264.40169164385253,264.24187035923916,264.08200615708336,
	263.92209905987465,263.76214909015437,263.60215627051554,263.44212062360316,263.2820421721146,
	263.1219209387997,262.9617569464613,262.80155021795525,262.6413007761908,262.4810086441309,
	262.3206738447924,262.16029640124634,261.9998763366184,261.839413674089,261.6789084368933,
	261.51836064832224,261.3577703317222,261.19713751049534,261.03646220810015,260.8757444480514,
	260.71498425392105,260.55418164933764,260.3933366579872,260.23244930361346,260.0715196100179,
	259.91054760106044,259.74953330065927,259.58847673279143,259.4273779214932,259.26623689086,
	259.10505366504714,258.9438282682698,258.7825607248034,258.6212510589841,258.45989929520886,
	258.2985054579358,258.13706957168444,257.9755916610363,257.8140717506349,257.65250986518635,
	257.4909060294591,257.3292602682848,257.16757260655885,257.00584306923963,256.84407168135,
	256.68225846797674,256.5204034542717,256.3585066654512,256.196568126797,256.03458786365644,
	255.87256590144264,255.71050226563517,255.54839698177977,255.38625007548933,255.2240615724438,
	255.0618314983906,254.8995598791452,254.73724674059096,254.57489210867993,254.41249600943297,
	254.25005846893998,254.0875795133606,253.92505916892412,253.76249746193005,253.59989441874853,
	253.43725006582045,253.2745644296579,253.11183753684455,252.94906941403593,252.78626008795993,
	252.62340958541688,252.4605179332801,252.29758515849622,252.13461128808547,251.9715963491421,
	251.80854036883466,251.6454433744064,251.48230539317566,251.31912645253627,251.15590657995762,
	250.99264580298546,250.82934414924188,250.66600164642594,250.50261832231388,250.33919420475948,
	250.17572932169455,250.01222370112927,249.8486773711524,249.6850903599319,249.5214626957151,
	249.35779440682916,249.1940855216815,249.03033606876005,248.8665460766337,248.70271557395273,
	248.53884458944913,248.37493315193697,248.21098129031284,248.04698903355612,247.88295641072958,
	247.7188834509796,247.55477018353668,247.39061663771545,247.22642284291584,247.06218882862268,
	246.89791462440652,246.7336002599241,246.5692457649182,246.40485116921886,246.24041650274307,
	246.0759417954955,245.9114270775691,245.7468723791449,245.58227773049308,245.41764316197302,
	245.25296870403378,245.08825438721442,244.92350024214466,244.75870629954514,244.5938725902278,
	244.42899914509638,244.26408599514684,244.09913317146774,243.93414070524068,243.7691086277408,
	243.6040369703371,243.4389257644928,243.27377504176616,243.1085848338104,242.94335517237448,
	242.77808608930346,242.61277761653886,242.4474297861191,242.28204263018017,242.11661618095576,
	241.95115047077786,241.7856455320773,241.62010139738396,241.4545180993274,241.28889567063734,
	241.12323414414394,240.9575335527783,240.79179392957317,240.62601530766315,240.46019772028515,
	240.29434120077883,240.1284457825874,239.96251149925763,239.79653838444068,239.63052647189224,
	239.46447579547333,239.2983863891505,239.13225828699657,238.9660915231909,238.7998861320198,
	238.6336421478774,238.46735960526567,238.30103853879515,238.1346789831855,237.96828097326568,
	237.8018445439749,237.63536973036264,237.46885656758948,237.30230509092743,237.1357153357605,
	236.96908733758508,236.80242113201064,236.63571675476015,236.4689742416703,236.30219362869266,
	236.13537495189348,235.96851824745468,235.80162355167406,235.63469090096612,235.46772033186224,
	235.3007118810115,235.13366558518092,234.96658148125627,234.79945960624238,234.63229999726374,
	234.46510269156502,234.29786772651167,234.1305951395902,233.96328496840914,233.79593725069924,
	233.62855202431402,233.46112932723042,233.29366919754946,233.12617167349646,232.95863679342182,
	232.79106459580154,232.62345511923775,232.45580840245918,232.28812448432186,232.12040340380955,
	231.9526452000344,231.78484991223743,231.61701757978912,231.44914824219006,231.28124193907124,
	231.11329871019495,230.94531859545526,230.77730163487843,230.60924786862364,230.44115733698357,
	230.2730300803849,230.10486613938883,229.93666555469198,229.76842836712657,229.60015461766122,
	229.43184434740155,229.26349759759074,229.09511440961012,228.92669482497976,228.758238885359,
	228.58974663254722,228.42121810848428,228.25265335525117,228.08405241507077,227.91541533030824,
	227.7467421434716,227.57803289721267,227.40928763432737,227.2405063977565,227.07168923058623,
	226.90283617604877,226.73394727752313,226.5650225785357,226.39606212276055,226.22706595402065,
	226.05803411628796,225.88896665368443,225.7198636104824,225.55072503110537,225.38155096012872,
	225.21234144228006,225.04309652244024,224.87381624564375,224.70450065707945,224.53514980209127,
	224.36576372617887,224.19634247499798,224.02688609436169,223.8573946302406,223.68786812876363,
	223.51830663621874,223.34871019905356,223.17907886387604,223.00941267745526,222.83971168672193,
	222.66997593876908,222.5002054808529,222.33040036039344,222.160560624975,221.99068632234705,
	221.82077750042504,221.6508342072907,221.48085649119326,221.31084440054974,221.1407979839457,
	220.97071729013618,220.80060236804624,220.63045326677155,220.46027003557944,220.2900527239093,
	220.11980138137355,219.94951605775793,219.77919680302296,219.60884366730377,219.43845670091164,
	219.26803595433427,219.09758147823652,218.92709332346135,218.7565715410305,218.58601618214502,
	218.41542729818624,218.24480494071662,218.07414916148016,217.90346001240334,217.7327375455959,
	217.5619818133516,217.39119286814878,217.22037076265147,217.04951554970984,216.8786272823611,
	216.70770601383023,216.53675179753097,216.36576468706613,216.19474473622884,216.02369199900306,
	215.85260652956438,215.68148838228097,215.51033761171425,215.3391542726196,215.1679384199473,
	214.9966901088432,214.8254093946498,214.65409633290653,214.4827509793512,214.31137338992016,
	214.1399636207496,213.96852172817614,213.7970477687377,213.62554179917439,213.45400387642903,
	213.28243405764837,213.11083240018363,212.9391989615916,212.76753379963515,212.59583697228425,
	212.42410853771688,212.25234855431964,212.08055708068878,211.90873417563094,211.73687989816415,
	211.56499430751862,211.39307746313725,211.22112942467714,211.0491502520099,210.8771400052227,
	210.7050987446194,210.53302653072075,210.36092342426602,210.18878948621338,210.01662477774096,
	209.8444293602477,209.67220329535417,209.4999466449036,209.32765947096266,209.15534183582233,
	208.9829938019988,208.8106154322345,208.63820678949892,208.46576793698935,208.29329893813204,
	208.120799856583,207.94827075622885,207.7757117011878,207.60312275581072,207.4305039846816,
	207.25785545261897,207.0851772246766,206.9124693661445,206.7397319425498,206.56696501965757,
	206.39416866347196,206.221342940237,206.04848791643784,205.87560365880117,205.70269023429657,
	205.5297477101374,205.35677615378162,205.18377563293296,205.01074621554153,204.83768796980524,
	204.66460096417046,204.491485267333,204.3183409482393,204.145168076087,203.97196672032646,
	203.7987369506612,203.62547883704943,203.4521924497045,203.27887785909618,203.10553513595175,
	202.9321643512567,202.7587655762559,202.58533888245472,202.41188434161984,202.23840202578032,
	202.06489200722856,201.89135435852148,201.71778915248137,201.54419646219696,201.37057636102455,
	201.19692892258877,201.023254220784,200.84955232977498,200.67582332399817,200.50206727816266,
	200.32828426725115,200.15447436652119,199.98063765150602,199.8067741980157,199.63288408213822,
	199.45896738024047,199.28502416896936,199.11105452525285,198.93705852630103,198.7630362496072,
	198.5889877729489,198.41491317438903,198.24081253227695,198.06668592524946,197.89253343223203,
	197.71835513243968,197.54415110537832,197.3699214308457,197.19566618893245,197.02138546002334,
	196.84707932479824,196.67274786423343,196.49839115960233,196.32400929247703,196.1496023447291,
	195.97517039853096,195.80071353635682,195.62623184098373,195.45172539549304,195.27719428327117,
	195.102638588011,194.92805839371275,194.75345378468546,194.57882484554776,194.40417166122936,
	194.22949431697197,194.05479289833042,193.8800674911741,193.70531818168774,193.53054505637294,
	193.35574820204894,193.1809277058542,193.00608365524727,192.83121613800807,192.65632524223906,
	192.4814110563664,192.30647366914118,192.1315131696405,191.95652964726884,191.78152319175905,
	191.60649389317354,191.43144184190584,191.25636712868123,191.08126984455842,190.90615008093047,
	190.73100792952624,190.55584348241132,190.38065683198943,190.2054480710035,190.03021729253723,
	189.85496459001587,189.67969005720758,189.5043937882249,189.32907587752572,189.15373641991457,
	188.9783755105439,188.80299324491529,188.62758971888076,188.4521650286439,188.27671927076113,
	188.1012525421432,187.925764940056,187.75025656212225,187.57472750632243,187.39917787099634,
	187.22360775484404,187.04801725692747,186.87240647667142,186.69677551386488,186.52112446866252,
	186.34545344158573,186.169762533524,185.99405184573612,185.81832147985168,185.64257153787216,
	185.4668021221722,185.29101333550108,185.11520528098393,184.93937806212293,184.7635317827988,
	184.58766654727197,184.41178246018396,184.23587962655867,184.05995815180367,183.88401814171152,
	183.70805970246116,183.53208294061918,183.35608796314108,183.18007487737282,183.00404379105188,
	182.82799481230876,182.65192804966824,182.47584361205077,182.29974160877376,182.12362214955309,
	181.94748534450412,181.7713313041434,181.5951601393898,181.4189719615659,181.24276688239948,
	181.0665450140247,180.89030646898348,180.71405136022705,180.53777980111707,180.3614919054272,
	180.18518778734426,180.00886756146994,179.83253134282177,179.65617924683477,179.47981138936274,
	179.30342788667969,179.12702885548117,178.9506144128856,178.77418467643594,178.5977397641007,
	178.4212797942755,178.24480488578467,178.06831515788227,177.89181073025378,177.7152917230174,
	177.53875825672534,177.3622104523656,177.1856484313629,177.00907231558037,176.83248222732095,
	176.65587828932877,176.47926062479044,176.30262935733685,176.1259846110441,175.94932651043527,
	175.77265518048168,175.59597074660442,175.4192733346757,175.2425630710203,175.06584008241717,
	174.8891044961004,174.7123564397612,174.5355960415492,174.35882343007356,174.18203873440467,
	174.00524208407577,173.8284336090841,173.65161343989232,173.47478170743025,173.29793854309605,
	173.12108407875792,172.94421844675531,172.76734177990042,172.59045421147985,172.4135558752559,
	172.23664690546792,172.05972743683412,171.8827976045526,171.70585754430323,171.52890739224878,
	171.35194728503657,171.17497735979995,170.99799775415968,170.82100860622538,170.6440100545971,
	170.46700223836677,170.28998529711973,170.11295937093598,169.93592460039196,169.75888112656168,
	169.5818290910187,169.40476863583703,169.2276999035931,169.05062303736685,168.87353818074357,
	168.6964454778151,168.51934507318146,168.34223711195236,168.16512173974857,167.98799910270353,
	167.8108693474647,167.6337326211952,167.45658907157525,167.2794388468036,167.10228209559904,
	166.925118967202,166.74794961137587,166.57077417840867,166.39359281911445,166.21640568483474,
	166.0392129274401,165.8620146993317,165.68481115344275,165.5076024432398,165.33038872272456,
	165.15317014643531,164.97594686944817,164.798719047379,164.62148683638435,164.44425039316363,
	164.26700987496005,164.08976543956229,163.91251724530622,163.73526545107603,163.55801021630606,
	163.38075170098205,163.20349006564268,163.02622547138137,162.84895807984728,162.67168805324724,
	162.49441555434692,162.31714074647263,162.13986379351257,161.96258485991848,161.78530411070702,
	161.6080217114614,161.43073782833275,161.25345262804174,161.07616627787988,160.8988789457113,
	160.72159079997388,160.54430200968122,160.36701274442353,160.18972317436982,160.0124334702686,
	159.8351438034502,159.65785434582753,159.4805652698981,159.3032767487452,159.12598895603946,
	158.94870206604043,158.77141625359795,158.59413169415362,158.4168485637425,158.2395670389942,
	158.06228729713482,157.88500951598797,157.70773387397662,157.53046055012445,157.35318972405716,
	157.1759215760041,156.9986562867999,156.82139403788563,156.6441350113104,156.46687938973275,
	156.2896273564224,156.11237909526133,155.93513479074554,155.75789462798622,155.58065879271152,
	155.40342747126783,155.22620085062118,155.0489791183589,154.87176246269078,154.69455107245085,
	154.51734513709852,154.34014484672022,154.16295039203078,153.9857619643748,153.8085797557282,
	153.63140395869968,153.4542347665319,153.2770723731032,153.09991697292895,152.92276876116279,
	152.74562793359829,152.5684946866703,152.3913692174562,152.21425172367765,152.0371424037016,
	151.86004145654204,151.6829490818612,151.50586547997105,151.3287908518345,151.15172539906723,
	150.9746693239386,150.79762282937324,150.62058611895262,150.4435593969161,150.26654286816247,
	150.0895367382514,149.9125412134047,149.73555650050773,149.55858280711072,149.3816203414302,
	149.20466931235043,149.02772992942454,148.85080240287604,148.67388694360017,148.49698376316528,
	148.32009307381398,148.14321508846479,147.9663500207131,147.789498084833,147.61265949577827,
	147.43583446918362,147.25902322136633,147.08222596932754,146.9054429307533,146.7286743240164,
	146.5519203681772,146.3751812829853,146.19845728888072,146.02174860699537,145.84505545915448,
	145.66837806787757,145.49171665638042,145.31507144857588,145.13844266907583,144.96183054319215,
	144.7852352969385,144.60865715703162,144.432096350893,144.25555310665032,144.07902765313918,
	143.90252021990472,143.72603103720328,143.54956033600453,143.37310834799314,143.196675305571,
	143.0202614418593,142.84386699070086,142.6674921866629,142.49113726503955,142.31480246185512,
	142.13848801386717,141.96219415857047,141.78592113420106,141.6096691797406,141.43343853492198,
	141.2572294402348,141.0810421369321,140.90487686703813,140.72873387335673,140.55261339948117,
	140.37651568980573,140.20044098953835,140.02438954471626,139.8483616022226,139.67235740980706,
	139.49637721610893,139.32042127068394,139.14448982403565,138.96858312765207,138.7927014340473,
	138.61684499681112,138.44101407066603,138.26520891153382,138.08942977661312,137.91367692446968,
	137.7379506151417,137.5622511102627,137.3865786732043,137.2109335692435,137.03531606575723,
	136.85972643244918,136.68416494161525,136.50863186845214,136.33312749141848,136.15765209265544,
	135.98220595847818,135.80678937994898,135.6314026535462,135.45604608194523,135.2807199749299,
	135.1054246504561,134.93016043589344,134.75492766947428,134.57972670198527,134.4045578987414,
	134.22942164189038,134.05431833310215,133.87924839670785,133.7042122833638,133.52921047432704,
	133.35424348644605,133.17931187798465,133.00441625541805,132.82955728136412,132.6547356838372,
	132.47995226704546,132.30520792398806,132.1305036511499,131.95584056564186,131.78121992519135,
	131.606643151452,131.43211185717965,131.25762787790947,131.08319330886852,130.90881054797887,
	130.73448234593675,130.56021186450997,130.3860027443696,130.21185918397254,130.0377860312346,
	129.8637888899897,129.6898742435101,129.51604959767272,129.3423236466966,129.16870646473635,
	128.9952097269955,128.82184696440663,128.64863385629735,128.475588565789,128.30273212293395,
	128.130088860716,127.95768690896422,127.7855587508584,127.61374184591209,127.44227932196424,
	127.27122073659383,127.10062290528607,126.93055078937803,126.76107843104948,126.59228991517308,
	126.42428032856164,126.25715667603531,126.09103870004991,125.92605953699048,125.76236612977613,
	125.60011930487588,125.43949341456859,125.28067544522291,125.12386350267231,124.96926460926011,
	124.8170917855365,124.66756044255118,124.5208841749354,124.37727011395334,124.23691406396385,
	124.09999569432095,123.96667408147225,123.83708388608207,123.71133240613655,123.5894976742954,
	123.47162767689238,123.35774067674588,123.2478265360823,123.14184887016725,123.03974782262299,
	122.94144324059832,122.8468380383453,122.75582156508152,122.66827283015749,122.58406347896506,
	122.50306045165193,122.42512829025183,122.35013108667022,122.27793408375264,122.20840495494741,
	122.14141479588399,122.07683886471203,122.01455710845278,121.954454510914,121.8964212947374,
	121.84035300650288,121.78615050995245,121.73371990860461,121.68297241552371,121.63382418477768,
	121.58619611644237,121.54001364452176,121.49520651521894,121.4517085613016,121.40945747694245,
	121.36839459630747,121.32846467827444,121.28961569895857,121.25179865316348,121.21496736544509,
	121.17907831114212,121.1440904474741,121.10996505462059,121.07666558655656,121.04415753132258,
	121.01240828034082,120.981387006347,120.95106454948393,120.92141331109181,120.89240715473302,
	120.86402131399147,120.83623230662813,120.8090178546076,120.78235680967843,120.75622908405309,
	120.73061558585721,120.70549815900351,120.68085952717216,120.65668324160195,120.6329536324156,
	120.60965576322306,120.58677538876417,120.56429891537019,120.54221336403903,120.52050633593558,
	120.49916598014104,120.47818096348985,120.45754044234437,120.43723403616859,120.41725180277332,
	120.3975842151144,120.37822213953483,120.35915681534985,120.34037983568133,120.3218831294556,
	120.30365894448478,120.28569983155742,120.26799862947041,120.25054845093908,120.23334266932612,
	120.21637490613305,120.19963901922256,120.18312909167314,120.16683942129744,120.15076451072387,
	120.13489905802996,120.1192379478885,120.10377624319403,120.08850917713946,120.07343214571546,
	120.05854070060607,120.04383054245712,120.02929751449403,120.01493759646873,120.00074689891585,
	119.98672165769997,119.97285822883634,119.95915308357046,119.94560280369991,119.93220407712597,
	119.91895369362116,119.90584854080065,119.89288560028653,119.88006194405384,119.867374730948,
	119.8548212033657,119.84239868408821,119.83010457326088,119.81793634550996,119.80589154718969,
	119.79396779375274,119.78216276723545,119.77047421386644,119.75889994175313,119.74743781869768,
	119.73608577009195,119.72484177690507,119.71370387375705,119.70267014707395,119.69173873331938,
	119.68090781730022,119.67017563054183,119.65954044972987,119.64900059521524,119.63855442957978,
	119.62820035625877,119.61793681821885,119.60776229668753,119.59767530993295,119.5876744120909,
	119.57775819203722,119.56792527229956,119.55817430803252,119.5485039859817,119.53891302354484,
	119.52940016783292,119.51996419477503,119.51060390825623,119.50131813928681,119.49210574520188,
	119.48296560888976,119.47389663804715,119.46489776446326,119.45596794332634,119.4471061525563,
	119.43831139216049,119.42958268361129,119.42091906924556,119.4123196116844,119.40378339328042,
	119.3953095155544,119.38689709869868,119.37854528105666,119.37025321863746,119.36202008464286,
	119.35384506901029,119.3457273779708,119.33766623362072,119.3296608735077,119.32171055023014,
	119.31381453104851,119.30597209750998,119.29818254508427,119.29044518281106,119.2827593329583,
	119.27512433069114,119.26753952375108,119.26000427214483,119.25251794784269,119.24507993448601,
	119.23768962710344,119.23034643183574,119.22304976566859,119.21579905617351,119.20859374125187,
	119.2014332689065,119.19431709698272,119.18724469295165,119.18021553368332,119.17322910522947,
	119.16628490261235,119.15938242961987,119.15252119860587,119.14570073029675,119.13892055360296,
	119.13218020543567,119.12547923052901,119.11881718126655,119.11219361751292,119.10560810644995,
	119.09906022241705,119.09254954675599,119.08607566765997,119.07963818002636,119.07323668531366,
	119.06687079140201,119.06054011245749,119.05424426879998,119.04798288677414,119.04175559862409,
	119.03556204237132,119.02940186169515,119.02327470581703,119.01718022938715,119.01111809237423,
	119.00508795995792,118.9990895024239,118.99312239506177,118.98718631806518,118.98128095643453,
	118.97540599988208,118.96956114273954,118.96374608386736,118.95796052656696,118.95220417849437,
	118.9464767515764,118.94077796192852,118.93510752977498,118.92946517937058,118.92385063892425,
	118.91826364052461,118.9127039200671,118.90717121718296,118.90166527516959,118.89618584091771,
	118.8907326648642,118.88530550089989,118.8799041063237,118.87452824177639,118.8691776711801,
	118.86385216167929,118.85855148358264,118.85327541030674,118.84802371832045,118.84279618709117,
	118.83759259903162,118.83241273944813,118.82725639649013,118.82212336110034,118.81701342696662,
	118.81192639047424,118.80686205065956,118.80182020916465,118.79680067019267,118.79180324046452,
	118.78682772917588,118.78187394795604,118.77694171082636,118.77203083416079,118.76714113664637,
	118.76227243924502,118.75742456515592,118.75259733977856,118.7477905906768,118.74300414754352,
	118.7382378421659,118.73349150839161,118.72876498209537,118.72405810114661,118.71937070537732,
	118.71470263655078,118.71005373833107,118.7054238562527,118.70081283769119,118.69622053183429,
	118.69164678965349,118.68709146387631,118.68255440895877,118.67803548105904,118.67353453801087,
	118.66905143929804,118.66458604602889,118.66013822091197,118.65570782823119,118.65129473382248,
	118.64689880505009,118.64251991078365,118.63815792137574,118.63381270863978,118.62948414582821,
	118.6251721076112,118.62087647005593,118.61659711060562,118.61233390805992,118.60808674255466,
	118.60385549554265,118.59964004977455,118.59544028927998,118.59125609934938,118.58708736651572,
	118.5829339785367,118.57879582437758,118.5746727941937,118.57056477931391,118.56647167222827,
	118.562393366555,118.55832975704875,118.55428073956936,118.55024621107022,118.54622606958316,
	118.54222021420323,118.53822854507465,118.5342509633757,118.53028737130528,118.52633767206846,
	118.52240176986312,118.51847956986636,118.51457097822131,118.5106759020242,118.50679424931154,
	118.5029259290475,118.49907085111164,118.49522892628673,118.49140006624671,118.48758418354504,
	118.48378119160314,118.47999100469893,118.47621353795567,118.472448707331,118.46869642960603,
	118.46495662237471,118.46122920403334,118.45751409377034,118.45381121155589,118.45012047813218,
	118.44644181500337,118.44277514442592,118.43912038939932,118.43547747365646,118.43184632165439,
	118.42822685856537,118.42461901026778,118.42102270333758,118.41743786503928,118.41386442331766,
	118.41030230678922,118.406751444734,118.40321176708746,118.39968320443221,118.39616568799049,
	118.39265914961602,118.38916352178663,118.38567873759641,118.38220473074855,118.37874143554782,
	118.37528878689358,118.37184672027227,118.36841517175084,118.36499407796961,118.36158337613544,
	118.3581830040153,118.35479289992932,118.35141300274444,118.34804325186812,118.34468358724187,
	118.34133394933498,118.33799427913858,118.33466451815944,118.33134460841407,118.32803449242282,
	118.32473411320409,118.32144341426869,118.3181623396141,118.31489083371903,118.31162884153787,
	118.3083763084953,118.30513318048112,118.30189940384484,118.29867492539056,118.29545969237189,
	118.29225365248689,118.28905675387327,118.28586894510329,118.28269017517901,118.27952039352766,
	118.2763595499968,118.273207594845,118.27006447875546,118.26693015280539,118.26380456847828,
	118.26068767765547,118.25757943261198,118.25447978601206,118.25138869090513,118.24830610072152,
	118.24523196926849,118.24216625072613,118.23910889964337,118.2360598709341,118.23301911987326,
	118.22998660209302,118.22696227357898,118.22394609066647,118.22093801003689,118.21793798871406,
	118.21494598406062,118.21196195377453,118.20898585588556,118.2060176487518,118.2030572910564,
	118.20010474180403,118.19715996031776,118.19422290623554,118.19129353950721,118.18837182039132,
	118.18545770945167,118.18255116755454,118.17965215586547,118.17676063584625,118.17387656925197,
	118.17099991812799,118.16813064480702,118.16526871190645,118.16241408232509,118.15956671924081,
	118.15672658610744,118.15389364665226,118.15106786487308,118.14824920503573,118.14543763167131,
	118.14263310957372,118.13983560379691,118.13704507965245,118.13426150270705,118.13148483877987,
	118.1287150539403,118.12595211450551,118.12319598703786,118.1204466383427,118.1177040354661,
	118.11496814569229,118.11223893654163,118.10951637576822,118.10680043135767,118.10409107152493,
	118.1013882647122,118.09869197958658,118.09600218503815,118.09331885017777,118.09064194433488,
	118.08797143705578,118.08530729810128,118.08264949744492,118.07999800527075,118.07735279197159,
	118.07471382814713,118.07208108460169,118.06945453234265,118.0668341425786,118.06421988671718,
	118.0616117363635,118.0590096633183,118.05641363957618,118.05382363732375,118.05123962893795,
	118.04866158698424,118.0460894842151,118.04352329356811,118.04096298816441,118.03840854130216,
	118.03585992647344,118.03331711733605,118.03078008772894,118.02824881166644,118.02572326333689,
	118.02320341710093,118.02068924749007,118.01818072920513,118.01567783711481,118.01318054625408,
	118.0106888318229,118.00820266918474,118.00572203386491,118.00324690154956,118.0007772480839,
	117.99831304947107,117.99585428187069,117.99340092159743,117.99095294511982,117.9885103290588,
	117.98607305018652,117.98364108542495,117.9812144118446,117.97879300666338,117.97637684724516,
	117.97396591109873,117.97156017587639,117.96915961937279,117.96676421952382,117.96437395440533,
	117.96198880223191,117.95960874135591,117.95723375026606,117.95486380758648,117.95249889207541,
	117.95013898262437,117.94778405825679,117.94543409812692,117.94308908151892,117.94074898784568,
	117.93841379664774,117.93608348759234,117.93375804047217,117.93143743520474,117.92912165183084,
	117.92681067051399,117.92450447153918,117.92220303531194,117.91990634235741,117.91761437331932,
	117.91532710895909,117.91304453015485,117.9107666179004,117.90849335330454,117.90622471758986,
	117.90396069209201,117.9017012582587,117.89944639764897,117.89719609193202,117.89495032288661,
	117.89270907240014,117.89047232246763,117.88824005519096,117.88601225277822,117.88378889754249,
	117.88156997190143,117.87935545837611,117.87714533959046,117.87493959827022,117.87273821724251,
	117.87054117943464,117.86834846787359,117.86616006568516,117.86397595609323,117.86179612241892,
	117.85962054808,117.85744921659423,117.85528211156253,117.85311921669148,117.85096051577776,
	117.84880599271087,117.84665563147259,117.84450941613623,117.8423673308659,117.84022935991587,
	117.83809548762981,117.83596569844022,117.83383997686771,117.83171830752036,117.82960067509295,
	117.82748706436657,117.82537746020768,117.82327184756764,117.82117021148206,117.81907253707024,
	117.8169788095343,117.81488901415888,117.81280313631032,117.81072116143618,117.80864307506451,
	117.80656886280346,117.80449851034045,117.80243200344172,117.80036932795183,117.79831046979301,
	117.79625541496445,117.79420414954201,117.79215665967745,117.79011293159806,117.78807295160594,
	117.78603670607757,117.78400418146325,117.78197536428652,117.77995024114375,117.77792879870343,
	117.77591102370597,117.77389690296278,117.77188642335605,117.7698795718382,117.76787633543132,
	117.7658767012267,117.76388065638436,117.7618881881325,117.75989928376718,117.75791393065164,
	117.75593211621592,117.75395382795651,117.75197905343553,117.75000778028081,117.74803999618481,
	117.74607568890482,117.7441148462619,117.74215745614084,117.74020350648966,117.73825298531894,
	117.7363058807017,117.73436218077276,117.73242187372834,117.73048494782583,117.72855139138304,
	117.72662119277805,117.72469434044872,117.7227708228923,117.72085062866492,117.71893374638132,
	117.7170201647144,117.71510987239061,117.71320285820553,117.71129911100077,117.70939861967783,
	117.70750137319463,117.70560736056484,117.70371657085761,117.70182899319718,117.69994461676255,
	117.69806343078704,117.69618542455804,117.6943105874165,117.69243890875677,117.69057037802597,
	117.68870498472388,117.68684271840266,117.68498356866604,117.68312752516964,117.68127457762007,
	117.67942471577489,117.67757792944214,117.67573420848018,117.67389354279703,117.67205592235057,
	117.67022133714767,117.66838977724419,117.66656123274461,117.66473569380163,117.66291315061598,
	117.66109359343595,117.65927701255731,117.65746339832273,117.65565274112174,117.65384503139019,
	117.65204025961016,117.65023841630962,117.64843949206194,117.64664347748585,117.64485036324504,
	117.64306014004792,117.64127279864724,117.63948832983988,117.63770672446664,117.63592797341175,
	117.63415206760286,117.63237899801057,117.63060875564827,117.62884133157175,117.62707671687909,
	117.62531490271026,117.62355588024695,117.62179964071228,117.62004617537056,117.61829547552686,
	117.61654753252714,117.61480233775757,117.61305988264452,117.61132015865437,117.60958315729306,
	117.60784887010593,117.60611728867758,117.60438840463145,117.6026622096253,117.60093869536757,
	117.59921785359352,117.59749967607992,117.59578415464136,117.59407128112983,117.59236104743485,
	117.59065344548273,117.58894846723679,117.5872461046969,117.5855463498994,117.5838491949167,
	117.58215463185729,117.5804626528653,117.5787732501204,117.5770864158377,117.57540214226721,
	117.57372042169392,117.57204124643765,117.57036460885247,117.56869050132684,117.56701891628326,
	117.5653498461781,117.5636832835014,117.56201922077666,117.56035765056065,117.55869856544318,
	117.55704195804698,117.55538782102741,117.55373614707239,117.55208692890207,117.55044015926876,
	117.54879583095664,117.54715393678165,117.54551446959131,117.54387742226446,117.54224278771107,
	117.54061055887226,117.53898072871985,117.53735329025638,117.5357282365147,117.5341055605582,
	117.53248525548017,117.53086731440389,117.52925173048249,117.52763849689862,117.5260276068643,
	117.52441905362096,117.52281283043901,117.52120893061782,117.51960734748545,117.51800807439867,
	117.51641110474253,117.51481643193051,117.51322404940404,117.51163395063789,117.51004612912014,
	117.50846057837988,117.50687729196952,117.5052962634687,117.50371748648436,117.5021409546504,
	117.50056666162762,117.49899460110353,117.49742476679216,117.49585715243398,117.49429175179577,
	117.49272855867041,117.49116756687673,117.48960877025941,117.48805216268886,117.48649773806103,
	117.48494549029722,117.48339541334401,117.48184750117316,117.48030174778145,117.47875814719038,
	117.47721669344621,117.47567738061987,117.4741402028066,117.47260515412611,117.47107222872211,
	117.46954142076254,117.46801272443908,117.46648613396722,117.46496164358634,117.46343924755892,
	117.46191894017129,117.46040071573273,117.45888456857581,117.45737049305609,117.45585848355203,
	117.45434853446483,117.45284064021845,117.45133479525923,117.44983099405603,117.44832923109998,
	117.44682950090433,117.4453317980044,117.44383611695758,117.44234245234291,117.44085079876122,
	117.43936115083052,117.43787350320207,117.43638785053776,117.43490418752398,117.43342250886833,
	117.43194280929937,117.43046508356657,117.42898932644016,117.42751553271121,117.42604369719116,
	117.42457381471206,117.42310588012631,117.42163988830656,117.42017583414555,117.41871371255611,
	117.4172535184711,117.41579524684303,117.41433889264431,117.41288445086693,117.41143191652236,
	117.40998128464156,117.40853255027481,117.40708570849159,117.40564075438056,117.40419768304936,
	117.40275648962455,117.40131716925163,117.39987971709472,117.39844412833665,117.39701039817874,
	117.39557852184087,117.39414849456114,117.39272031159607,117.39129396822018,117.38986945972623,
	117.38844678142488,117.3870259286447,117.38560689673209,117.38418968105113,117.38277427698361,
	117.38136067992886,117.37994888530355,117.37853888853759,117.37713068508943,117.37572427042437,
	117.37431964002806,117.37291678940316,117.3715157140692,117.37011640956263,117.36871887143657,
	117.36732309526084,117.36592907662191,117.36453681112272,117.36314629438262,117.36175752203732,
	117.36037048973884,117.3589851931553,117.35760162797105,117.3562197898863,117.35483967461735,
	117.35346127789629,117.35208459547104,117.35070962310522,117.34933635657806,117.34796479168442,
	117.3465949242345,117.3452267500541,117.34386026498419,117.34249546488105,117.34113234561619,
	117.33977090307619,117.33841113316257,117.33705303179198,117.33569659489585,117.3343418184204,
	117.33298869832673,117.33163723059042,117.33028741120172,117.32893923616541,117.32759270150073,
	117.32624780324655,117.32490453744226,117.32356290015395,117.32222288745797,117.32088449544499,
	117.31954772021959,117.31821255790037,117.31687900461989,117.31554705652455,117.31421670977446,
	117.31288796054359,117.31156080501941,117.31023523940314,117.30891125990935,117.3075888627662,
	117.30626804421517,117.30494880051118,117.30363112792237,117.30231502273001,117.30100048122858,
	117.29968749972575,117.29837607454198,117.29706620201092,117.29575787847901,117.29445110030557,
	117.29314586386263,117.29184216553507,117.29054000172036,117.28923936882863,117.28794026328242,
	117.28664268151701,117.28534661997999,117.28405207513133,117.2827590434388,117.2814675213941,
	117.28017750549084,117.27888899223785,117.27760197815597,117.27631645977826,117.27503243364957,
	117.27374989632679,117.27246884437861,117.27118927438555,117.26991118293995,117.26863456664574,
	117.26735942211867,117.26608574598589,117.26481353488624,117.26354278547002,117.26227349439895,
	117.26100565834612,117.25973927399605,117.2584743380444,117.2572108471983,117.25594879817577,
	117.25468818770621,117.25342901253,117.25217126939856,117.25091495507435,117.2496600663307,
	117.24840659995196,117.24715455273324,117.24590392148059,117.244654703006,117.24340689414399,
	117.24216049172941,117.24091549261082,117.23967189364726,117.23842969170842,117.2371888836742,
	117.23594946643517,117.23471143689207,117.23347479195607,117.23223952854859,117.23100564360121,
	117.2297731340558,117.22854199686425,117.22731222898868,117.22608382740111,117.22485678908369,
	117.22363111102844,117.22240679023737,117.2211838237223,117.21996220850484,117.21874194161653,
	117.21752302009851,117.21630544100161,117.21508920138642,117.21387429832295,117.21266072889078,
	117.21144849018354,117.21023757929336,117.20902799333125,117.20781972941488,117.20661278467124,
	117.2054071562366,117.20420284125674,117.20299983688645,117.2017981402898,117.20059774864009,
	117.19939865911968,117.1982008689201,117.19700437524182,117.19580917529441,117.19461526629638,
	117.19342264547521,117.19223131006723,117.1910412573176,117.18985248448048,117.18866498881859,
	117.18747876760362,117.18629381811583,117.18511013764422,117.18392772348662,117.18274657294933,
	117.18156668334207,117.18038805199579,117.1792106762391,117.1780345534122,117.17685968086369,
	117.17568605595065,117.17451367603846,117.17334253850075,117.17217264071952,117.17100398008495,
	117.16983655399554,117.16867035985779,117.16750539508644,117.16634165710443,117.16517914334256,
	117.16401785123989,117.1628577782433,117.16169892180784,117.16054127939634,117.15938484847972,
	117.15822962653668,117.15707561105398,117.15592279952631,117.15477118944898,117.15362077834179,
	117.1524715637182,117.15132354310347,117.1501767140305,117.14903107403974,117.1478866206793,
	117.1467433515048,117.14560126407936,117.14446035597376,117.14332062476598,117.14218206804168,
	117.14104468339373,117.13990846842248,117.1387734207356,117.13763953794805,117.13650681768206,
	117.13537525756705,117.13424485523964,117.13311560834347,117.13198751453399,117.13086057146319,
	117.12973477679887,117.12861012821355,117.12748662338664,117.12636426000466,117.12524303576117,
	117.12412294835649,117.12300399549812,117.1218861749004,117.12076948428437,117.11965392137822,
	117.11853948391678,117.1174261696417,117.11631397630151,117.11520290165136,117.11409294345329,
	117.11298409947601
	}},
	{ // Ri = 250k
	-20,20,50,2001, {
	288.9476929184571,288.7948610045677,288.6419831295935,288.4890593106638,288.3360895649282,
	288.18307390955687,288.0300123617398,287.8769049386881,287.7237516576333,287.5705525358279,
	287.41730759054553,287.26401683908085,287.1106802987498,286.9572979868899,286.8038699208604,
	286.650396118042,286.49687659583776,286.34331137167237,286.189700462993,286.0360438872694,
	285.8823416619933,285.7285938046796,285.57480033286583,285.4209612641127,285.2670766160039,
	285.11314640614654,284.95917065217117,284.8051493717319,284.65108258250694,284.496970302198,
	284.3428125485313,284.18860933925697,284.03436069214996,283.88006662500953,283.72572715565997,
	283.57134230195004,283.4169120817541,283.2624365129714,283.1079156135268,282.95334940137064,
	282.7987378944792,282.64408111085436,282.4893790685243,282.3346317855434,282.1798392799925,
	282.0250015699791,281.87011867363714,281.71519060912783,281.56021739463944,281.4051990483874,
	281.25013558861457,281.0950270335916,280.93987340161675,280.7846747110164,280.6294309801451,
	280.4741422273855,280.31880847114905,280.16342972987565,280.00800602203407,279.85253736612236,
	279.69702378066756,279.54146528422615,279.3858618953842,279.2302136327576,279.0745205149921,
	278.9187825607637,278.7629997887784,278.6071722177732,278.4512998665154,278.29538275380315,
	278.1394208984661,277.9834143193645,277.82736303539053,277.6712670654678,277.5151264285517,
	277.3589411436298,277.2027112297216,277.0464367058792,276.8901175911873,276.733753904763,
	276.5773456657569,276.42089289335235,276.26439560676636,276.1078538252492,275.9512675680851,
	275.79463685459217,275.6379617041227,275.48124213606326,275.324478169835,275.1676698248939,
	275.01081712073085,274.85392007687176,274.69697871287804,274.5399930483467,274.3829631029103,
	274.2258888962377,274.06877044803366,273.9116077780394,273.7544009060329,273.5971498518288,
	273.4398546352787,273.2825152762715,273.12513179473353,272.9677042106288,272.8102325439593,
	272.6527168147647,272.49515704312347,272.3375532491522,272.1799054530064,272.02221367488056,
	271.86447793500815,271.7066982536621,271.54887465115496,271.3910071478393,271.23309576410725,
	271.0751405203917,270.91714143716575,270.7590985349433,270.60101183427923,270.4428813557695,
	270.2847071200514,270.126489147804,269.96822745974833,269.80992207664707,269.6515730193056,
	269.49318030857177,269.33474396533603,269.1762640105319,269.01774046513634,268.85917335016956,
	268.7005626866955,268.5419084958222,268.3832107987017,268.22446961653066,268.0656849705502,
	267.9068568820465,267.7479853723508,267.5890704628398,267.43011217493574,267.27111053010697,
	267.11206554986745,266.9529772557781,266.7938456694461,266.63467081252566,266.47545270671793,
	266.3161913737715,266.1568868354828,265.99753911369567,265.83814823030247,265.6787142072439,
	265.5192370665089,265.35971683013577,265.2001535202116,265.0405471588732,264.88089776830674,
	264.72120537074846,264.56146998848476,264.40169164385253,264.24187035923916,264.08200615708336,
	263.92209905987465,263.76214909015437,263.60215627051554,263.44212062360316,263.2820421721146,
	263.1219209387997,262.9617569464613,262.80155021795525,262.6413007761908,262.4810086441309,
	262.3206738447924,262.16029640124634,261.9998763366184,261.839413674089,261.6789084368933,
	261.51836064832224,261.3577703317222,261.19713751049534,261.03646220810015,260.87574444805153,
	260.71498425392105,260.55418164933764,260.3933366579872,260.23244930361346,260.0715196100179,
	259.91054760106044,259.7495333006592,259.58847673279143,259.4273779214932,259.26623689086,
	259.10505366504714,258.9438282682698,258.7825607248034,258.6212510589841,258.45989929520886,
	258.2985054579358,258.13706957168444,257.9755916610363,257.8140717506349,257.65250986518635,
	257.4909060294591,257.32926026828494,257.16757260655885,257.00584306923963,256.84407168135,
	256.68225846797674,256.5204034542717,256.3585066654512,256.196568126797,256.03458786365644,
	255.87256590144264,255.71050226563514,255.54839698177977,255.38625007548933,255.2240615724438,
	255.0618314983906,254.8995598791452,254.73724674059096,254.57489210867993,254.41249600943297,
	254.25005846893998,254.0875795133606,253.92505916892412,253.76249746193005,253.59989441874853,
	253.43725006582045,253.2745644296579,253.11183753684455,252.94906941403593,252.78626008795993,
	252.62340958541688,252.4605179332801,252.29758515849622,252.13461128808547,251.9715963491421,
	251.80854036883466,251.6454433744064,251.48230539317566,251.31912645253627,251.15590657995762,
	250.99264580298546,250.82934414924188,250.66600164642594,250.50261832231388,250.33919420475948,
	250.17572932169455,250.01222370112927,249.8486773711524,249.6850903599319,249.5214626957151,
	249.35779440682916,249.1940855216815,249.03033606876005,248.8665460766337,248.70271557395273,
	248.53884458944913,248.37493315193697,248.21098129031284,248.04698903355612,247.88295641072958,
	247.7188834509796,247.55477018353668,247.39061663771545,247.22642284291584,247.06218882862268,
	246.89791462440652,246.73360025992403,246.5692457649182,246.40485116921886,246.24041650274307,
	246.07594179549554,245.91142707756904,245.7468723791449,245.58227773049308,245.41764316197302,
	245.25296870403378,245.08825438721442,244.92350024214466,244.75870629954514,244.59387259022776,
	244.42899914509638,244.26408599514684,244.09913317146774,243.93414070524068,243.7691086277408,
	243.6040369703371,243.4389257644928,243.27377504176616,243.10858483381043,242.94335517237448,
	242.77808608930343,242.61277761653886,242.4474297861191,242.28204263018017,242.11661618095576,
	241.95115047077786,241.7856455320773,241.62010139738396,241.4545180993274,241.28889567063734,
	241.12323414414394,240.9575335527783,240.7917939295732,240.62601530766315,240.46019772028515,
	240.29434120077883,240.1284457825874,239.96251149925763,239.79653838444068,239.63052647189224,
	239.46447579547333,239.2983863891505,239.13225828699657,238.9660915231909,238.7998861320198,
	238.6336421478774,238.46735960526567,238.30103853879515,238.1346789831855,237.96828097326568,
	237.8018445439749,237.63536973036264,237.46885656758948,237.30230509092743,237.1357153357605,
	236.96908733758508,236.80242113201064,236.63571675476015,236.4689742416703,236.30219362869266,
	236.13537495189348,235.96851824745468,235.80162355167406,235.63469090096612,235.46772033186224,
	235.3007118810115,235.13366558518092,234.96658148125627,234.79945960624238,234.63229999726374,
	234.46510269156502,234.29786772651167,234.1305951395902,233.96328496840914,233.79593725069924,
	233.62855202431405,233.46112932723042,233.29366919754946,233.12617167349646,232.95863679342182,
	232.79106459580157,232.62345511923775,232.45580840245918,232.28812448432183,232.12040340380955,
	231.9526452000344,231.78484991223743,231.61701757978912,231.44914824219006,231.28124193907124,
	231.11329871019495,230.94531859545526,230.77730163487843,230.60924786862364,230.44115733698357,
	230.2730300803849,230.10486613938883,229.93666555469198,229.76842836712657,229.60015461766122,
	229.43184434740155,229.26349759759074,229.09511440961018,228.92669482497976,228.758238885359,
	228.58974663254722,228.42121810848428,228.25265335525117,228.08405241507077,227.91541533030824,
	227.7467421434716,227.57803289721267,227.40928763432737,227.2405063977565,227.07168923058623,
	226.90283617604877,226.73394727752316,226.5650225785357,226.39606212276055,226.22706595402065,
	226.05803411628798,225.88896665368443,225.7198636104824,225.5507250311054,225.38155096012872,
	225.21234144228006,225.04309652244024,224.87381624564375,224.70450065707945,224.53514980209127,
	224.36576372617887,224.19634247499798,224.02688609436169,223.8573946302406,223.68786812876363,
	223.51830663621874,223.34871019905353,223.17907886387604,223.0094126774553,222.83971168672193,
	222.66997593876908,222.50020548085297,222.33040036039344,222.160560624975,221.99068632234705,
	221.82077750042504,221.6508342072907,221.48085649119326,221.3108444005497,221.1407979839457,
	220.97071729013618,220.8006023680462,220.63045326677155,220.46027003557944,220.2900527239093,
	220.11980138137352,219.94951605775793,219.77919680302296,219.60884366730377,219.43845670091164,
	219.26803595433427,219.09758147823652,218.92709332346132,218.7565715410305,218.58601618214502,
	218.41542729818624,218.24480494071662,218.07414916148016,217.90346001240337,217.7327375455959,
	217.5619818133516,217.39119286814878,217.22037076265147,217.04951554970984,216.8786272823611,
	216.70770601383023,216.53675179753097,216.36576468706613,216.19474473622884,216.0236919990031,
	215.85260652956438,215.681488382281,215.51033761171425,215.3391542726196,215.1679384199473,
	214.9966901088432,214.8254093946498,214.65409633290656,214.4827509793512,214.31137338992016,
	214.1399636207496,213.96852172817614,213.7970477687377,213.62554179917436,213.45400387642903,
	213.28243405764835,213.11083240018363,212.9391989615916,212.76753379963517,212.59583697228425,
	212.42410853771688,212.2523485543196,212.08055708068878,211.90873417563094,211.73687989816415,
	211.56499430751862,211.39307746313725,211.22112942467714,211.0491502520099,210.8771400052227,
	210.7050987446194,210.53302653072075,210.36092342426602,210.18878948621338,210.01662477774096,
	209.8444293602477,209.67220329535417,209.4999466449036,209.32765947096266,209.15534183582233,
	208.9829938019988,208.8106154322345,208.63820678949892,208.46576793698935,208.29329893813204,
	208.120799856583,207.94827075622885,207.7757117011878,207.60312275581066,207.4305039846816,
	207.25785545261897,207.0851772246766,206.91246936614456,206.73973194254978,206.56696501965757,
	206.39416866347196,206.221342940237,206.04848791643786,205.87560365880117,205.70269023429657,
	205.5297477101374,205.35677615378162,205.18377563293296,205.01074621554153,204.83768796980524,
	204.66460096417046,204.491485267333,204.3183409482393,204.145168076087,203.97196672032644,
	203.79873695066124,203.62547883704943,203.4521924497045,203.27887785909618,203.10553513595175,
	202.93216435125666,202.7587655762559,202.58533888245472,202.41188434161984,202.23840202578032,
	202.06489200722856,201.89135435852148,201.71778915248137,201.54419646219696,201.37057636102455,
	201.19692892258877,201.02325422078397,200.84955232977492,200.67582332399817,200.50206727816263,
	200.32828426725115,200.15447436652119,199.98063765150604,199.8067741980157,199.63288408213822,
	199.45896738024047,199.28502416896936,199.11105452525285,198.93705852630103,198.7630362496072,
	198.5889877729489,198.41491317438903,198.24081253227695,198.0666859252495,197.89253343223203,
	197.71835513243968,197.54415110537832,197.36992143084566,197.19566618893245,197.02138546002334,
	196.84707932479824,196.67274786423343,196.49839115960233,196.32400929247703,196.1496023447291,
	195.97517039853096,195.8007135363568,195.62623184098373,195.45172539549304,195.27719428327117,
	195.102638588011,194.92805839371275,194.75345378468546,194.5788248455478,194.40417166122936,
	194.22949431697197,194.05479289833042,193.8800674911741,193.70531818168774,193.53054505637294,
	193.35574820204894,193.1809277058542,193.00608365524727,192.83121613800807,192.65632524223906,
	192.4814110563664,192.30647366914118,192.1315131696405,191.95652964726884,191.78152319175902,
	191.60649389317354,191.43144184190587,191.25636712868123,191.08126984455842,190.90615008093047,
	190.73100792952624,190.55584348241135,190.38065683198943,190.2054480710035,190.03021729253723,
	189.85496459001587,189.67969005720758,189.5043937882249,189.32907587752572,189.15373641991457,
	188.9783755105439,188.80299324491529,188.62758971888073,188.4521650286439,188.2767192707612,
	188.1012525421432,187.925764940056,187.75025656212225,187.57472750632243,187.39917787099634,
	187.22360775484404,187.04801725692747,186.87240647667142,186.69677551386488,186.52112446866252,
	186.34545344158573,186.169762533524,185.99405184573612,185.81832147985168,185.64257153787216,
	185.4668021221722,185.29101333550108,185.11520528098393,184.93937806212293,184.7635317827988,
	184.58766654727197,184.41178246018396,184.23587962655867,184.05995815180367,183.88401814171152,
	183.70805970246116,183.53208294061915,183.35608796314108,183.18007487737282,183.00404379105188,
	182.82799481230876,182.65192804966824,182.47584361205077,182.29974160877376,182.12362214955309,
	181.94748534450412,181.7713313041434,181.5951601393898,181.4189719615659,181.2427668823995,
	181.0665450140247,180.89030646898348,180.71405136022705,180.53777980111707,180.3614919054272,
	180.18518778734426,180.00886756146994,179.83253134282177,179.65617924683477,179.47981138936274,
	179.30342788667969,179.12702885548117,178.9506144128856,178.77418467643594,178.5977397641007,
	178.4212797942755,178.24480488578467,178.06831515788227,177.89181073025375,177.7152917230174,
	177.53875825672534,177.3622104523656,177.1856484313629,177.00907231558037,176.83248222732095,
	176.65587828932877,176.47926062479044,176.30262935733685,176.1259846110441,175.94932651043527,
	175.77265518048168,175.59597074660442,175.4192733346757,175.2425630710203,175.06584008241714,
	174.8891044961004,174.71235643976124,174.5355960415492,174.35882343007356,174.18203873440467,
	174.00524208407577,173.8284336090841,173.65161343989232,173.47478170743022,173.29793854309605,
	173.12108407875792,172.94421844675531,172.76734177990042,172.59045421147985,172.4135558752559,
	172.23664690546792,172.05972743683412,171.8827976045526,171.7058575443032,171.52890739224878,
	171.35194728503657,171.17497735979995,170.99799775415968,170.82100860622538,170.6440100545971,
	170.46700223836677,170.2899852971197,170.112959370936,169.93592460039193,169.75888112656168,
	169.58182909101873,169.40476863583703,169.22769990359313,169.05062303736685,168.87353818074357,
	168.6964454778151,168.51934507318148,168.34223711195236,168.16512173974857,167.98799910270355,
	167.8108693474647,167.6337326211952,167.45658907157525,167.2794388468036,167.10228209559904,
	166.925118967202,166.74794961137587,166.57077417840867,166.39359281911445,166.21640568483474,
	166.03921292744013,165.8620146993317,165.68481115344275,165.5076024432398,165.33038872272456,
	165.15317014643531,164.97594686944817,164.79871904737897,164.62148683638435,164.44425039316363,
	164.26700987496005,164.08976543956229,163.91251724530622,163.73526545107603,163.55801021630606,
	163.38075170098205,163.2034900656427,163.02622547138134,162.84895807984728,162.67168805324724,
	162.49441555434692,162.3171407464726,162.13986379351257,161.96258485991848,161.78530411070702,
	161.6080217114614,161.43073782833275,161.25345262804174,161.07616627787988,160.8988789457113,
	160.72159079997388,160.54430200968125,160.36701274442356,160.18972317436982,160.01243347026866,
	159.8351438034502,159.65785434582756,159.48056526989814,159.30327674874525,159.1259889560395,
	158.94870206604048,158.77141625359798,158.59413169415367,158.41684856374255,158.23956703899427,
	158.06228729713487,157.88500951598803,157.70773387397676,157.53046055012453,157.35318972405727,
	157.17592157600427,156.99865628680013,156.82139403788588,156.64413501131065,156.46687938973307,
	156.28962735642276,156.11237909526182,155.93513479074608,155.75789462798684,155.58065879271228,
	155.4034274712687,155.2262008506222,155.04897911836008,154.87176246269217,154.69455107245244,
	154.51734513710042,154.3401448467224,154.1629503920333,153.9857619643778,153.8085797557317,
	153.6314039587037,153.45423476653662,153.2770723731087,153.0999169729354,152.9227687611703,
	152.74562793360712,152.56849468668057,152.3913692174682,152.21425172369163,152.03714240371795,
	151.86004145656113,151.6829490818835,151.50586547999706,151.32879085186494,151.15172539910267,
	150.97466932398,150.79762282942158,150.62058611900906,150.443559396982,150.26654286823938,
	150.08953673834125,149.91254121350966,149.73555650063022,149.55858280725377,149.3816203415972,
	149.2046693125454,149.02772992965214,148.85080240314184,148.67388694391053,148.4969837635276,
	148.32009307423704,148.14321508895873,147.96635002128983,147.7894980855064,147.6126594965645,
	147.43583447010158,147.25902322243812,147.08222597057886,146.90544293221444,146.72867432572232,
	146.55192037016894,146.37518128531076,146.19845729159584,146.02174861016547,145.8450554628557,
	145.66837807219898,145.49171666142578,145.3150714544667,145.13844267595357,144.96183055122228,
	144.78523530631406,144.608657167978,144.4320963636734,144.25555312157198,144.07902767056075,
	143.90252024024502,143.72603106095139,143.54956036373127,143.37310838036504,143.19667534336625,
	143.02026148598637,142.84386704222047,142.66749224681342,142.49113733526687,142.31480254384715,
	142.13848810959473,141.9621942703344,141.78592126468757,141.60966933208593,141.43343871278753,
	141.2572296478954,141.08104237937846,140.904877150097,140.72873420383064,140.55261378531193,
	140.37651614026552,140.20044151545224,140.02439015872213,139.84836231907516,139.67235824673205,
	139.49637819321688,139.32042241145354,139.14449115587766,138.9685846825676,138.79270324939688,
	138.6168471162118,138.44101654503925,138.26521180032844,138.0894331492333,137.91368086194205,
	137.7379552120611,137.56225647706438,137.38658493881601,137.21094088418164,137.0353246057414,
	136.85973640262213,136.6841765814683,136.50864545757622,136.33314335621665,136.1576706141796,
	135.982227581577,135.80681462394654,135.63143212470763,135.4560804880279,135.28076014216884,
	135.1054715433904,134.93021518050847,134.7549915802135,134.57980131327776,134.40464500179854,
	134.22952332765107,134.05443704235063,133.87938697856035,133.7043740635156,133.52939933468429,
	133.35446395803234,133.1795692493256,133.00471669896683,132.82990800095172,132.6551450866159,
	132.4804301639583,132.30576576344507,132.131154791345,131.9566005918062,131.78210701907162,
	131.6076785214402,131.43332023881598,131.2590381159544,131.08483903380795,130.9107309616949,
	130.7367231333665,130.56282625041533,130.38905271685317,130.21541690906767,130.04193548572695,
	129.86862774250855,129.6955160167388,129.52262614708263,129.3499879932421,129.17763602009808,
	129.00560994973043,128.8339554831156,128.662725090815,128.49197886842546,128.3217854476881,
	128.15222294772977,127.98337994272008,127.81535641217717,127.64826462833919,127.48222992181705,
	127.3173912529761,127.15390150351676,126.99192739253739,126.83164891658241,126.67325821688118,
	126.51695779228669,126.36295800582883,126.21147387731091,126.0627212125623,125.916912187239,
	125.77425057159883,125.63492684216865,125.4991134656886,125.36696065099439,125.23859284077395,
	125.1141061586759,124.99356694558803,124.87701142434496,124.76444643886069,124.65585113462022,
	124.55117939161522,124.4503627919974,124.35331390177329,124.25992966388304,124.17009473216307,
	124.08368461494219,124.00056853732546,123.92061196820264,123.84367878906797,123.7696331057997,
	123.69834072167963,123.62967030092588,123.56349425798201,123.49968940996102,123.43813742909748,
	123.37872512976021,123.32134462125838,123.2658933539075,123.21227408190133,123.16039476292016,
	123.11016841090618,123.06151291547695,123.01435083880246,122.96860919854282,122.92421924357329,
	122.88111622767939,122.83923918514228,122.79853071111742,122.75893674889174,122.72040638546272,
	122.68289165637572,122.64634736036459,122.6107308840421,122.57600203666003,122.54212289479204,
	122.50905765667221,122.47677250583645,122.44523548365972,122.41441637034573,122.38428657390925,
	122.35481902668522,122.32598808890265,122.29776945887282,122.27014008935242,122.24307810968237,
	122.21656275325827,122.1905742900244,122.16509396358391,122.14010393261768,122.11558721629753,
	122.0915276434056,122.06790980489045,122.04471900961116,122.02194124303658,121.99956312868638,
	121.97757189211363,121.95595532724643,121.9347017649167,121.91380004342054,121.89323948096349,
	121.87300984985654,121.85310135233912,121.8335045979138,121.8142105820866,121.79521066641524,
	121.77649655977446,121.75806030075428,121.7398942411141,121.72199103022065,121.70434360040325,
	121.68694515316538,121.66978914619483,121.6528692811203,121.63617949196517,121.61971393425307,
	121.60346697472356,121.58743318161773,121.57160731549878,121.55598432057302,121.54055931647979,
	121.52532759052178,121.51028459030795,121.4954259167842,121.48074731762784,121.46624468098472,
	121.45191402952365,121.43775151481252,121.42375341194014,121.40991611444663,121.39623612948546,
	121.38271007322753,121.36933466648978,121.35610673057586,121.343023183316,121.33008103529603,
	121.31727738626441,121.30460942170768,121.29207440958514,121.27966969721423,121.26739270829839,
	121.25524094008972,121.24321196067976,121.23130340641106,121.21951297940355,121.20783844518986,
	121.19627763045402,121.18482842086756,121.17348875901949,121.16225664243382,121.15113012167167,
	121.14010729851262,121.12918632421233,121.11836539783224,121.10764276463767,121.09701671456163,
	121.08648558073075,121.0760477380503,121.06570160184609,121.05544562655977,121.04527830449587,
	121.03519816461747,121.02520377138897,121.01529372366313,121.0054666536108,120.99572122569151,
	120.98605613566262,120.9764701096258,120.96696190310887,120.95753030018189,120.94817411260534,
	120.9388921790094,120.9296833641035,120.92054655791364,120.9114806750474,120.90248465398477,
	120.89355745639465,120.88469806647433,120.87590549031285,120.86717875527607,120.85851690941273,
	120.84991902088119,120.84138417739528,120.83291148568914,120.82450007099985,120.8161490765673,
	120.80785766315076,120.7996250085613,120.79145030720959,120.78333276966794,120.77527162224742,
	120.76726610658783,120.75931547926086,120.75141901138255,120.74357598825621,120.73578570898883,
	120.72804748615813,120.72036064547021,120.71272452543175,120.7051384770321,120.69760186343538,
	120.69011405968185,120.6826744523979,120.67528243951536,120.66793742999864,120.66063884358033,
	120.65338611050412,120.64617867127605,120.63901597642207,120.63189748625345,120.62482267063834,
	120.61779100878027,120.61080198900288,120.60385510854054,120.59694987333532,120.59008579783911,
	120.58326240482182,120.57647922518441,120.56973579777751,120.5630316692247,120.55636639375088,
	120.54973953301507,120.5431506559479,120.53659933859348,120.5300851639554,120.52360772184689,
	120.517166608745,120.51076142764846,120.50439178793968,120.49805730524966,120.49175760132727,
	120.4854923039111,120.4792610466051,120.47306346875749,120.46689921534214,120.46076793684371,
	120.45466928914517,120.44860293341843,120.44256853601753,120.43656576837449,120.43059430689806,
	120.42465383287436,120.41874403237067,120.41286459614085,120.40701521953373,120.40119560240335,
	120.39540544902114,120.3896444679909,120.3839123721651,120.37820887856358,120.37253370829397,
	120.36688658647422,120.36126724215666,120.35567540825406,120.3501108214672,120.3445732222143,
	120.33906235456212,120.33357796615819,120.32811980816535,120.32268763519703,120.31728120525443,
	120.31190027966501,120.30654462302226,120.30121400312707,120.29590819093004,120.29062696047536,
	120.28537008884594,120.28013735610939,120.27492854526561,120.26974344219532,120.26458183560965,
	120.25944351700095,120.2543282805946,120.2492359233019,120.2441662446737,120.23911904685549,
	120.23409413454311,120.22909131493941,120.22411039771191,120.21915119495127,120.21421352113067,
	120.2092971930661,120.20440202987743,120.19952785294998,120.19467448589748,120.18984175452519,
	120.18502948679021,120.18023751278271,120.17546566466596,120.17071377666035,120.16598168500546,
	120.16126922792795,120.15657624560961,120.15190258015623,120.14724807556712,120.14261257770524,
	120.13799593426779,120.13339799475739,120.12881861045386,120.1242576343867,120.11971492130795,
	120.1151903276653,120.11068371157637,120.10619493280278,120.10172385272521,120.09727033431875,
	120.09283424212866,120.0884154422466,120.08401380228746,120.07962919136651,120.0752614800768,
	120.07091054046745,120.06657624602167,120.06225847163583,120.05795709359872,120.0536719895707,
	120.04940303856402,120.045150120923,120.04091311830464,120.0366919136596,120.03248639121362,
	120.02829643644922,120.0241219360875,120.0199627780707,120.01581885154475,120.01169004684209,
	120.00757625546507,120.00347737006943,119.999393284448,119.99532389351505,119.99126909329041,
	119.98722878088425,119.98320285448196,119.97919121332933,119.9751937577179,119.97121038897086,
	119.96724100942852,119.96328552243497,119.95934383232412,119.95541584440635,119.95150146495561,
	119.94760060119614,119.94371316128992,119.93983905432408,119.93597819029878,119.93213048011476,
	119.92829583556184,119.92447416930686,119.9206653948823,119.91686942667498,119.91308617991496,
	119.90931557066445,119.90555751580689,119.90181193303677,119.8980787408487,119.8943578585275,
	119.89064920613784,119.8869527045144,119.88326827525202,119.87959584069608,119.87593532393305,
	119.87228664878104,119.86864973978075,119.86502452218619,119.86141092195601,119.85780886574467,
	119.85421828089359,119.85063909542295,119.8470712380231,119.84351463804639,119.83996922549906,
	119.83643493103318,119.83291168593887,119.82939942213642,119.82589807216877,119.82240756919393,
	119.81892784697746,119.81545883988547,119.81200048287701,119.80855271149738,119.8051154618709,
	119.80168867069405,119.79827227522884,119.79486621329602,119.79147042326849,119.78808484406485,
	119.78470941514301,119.78134407649394,119.777988768632,119.77464343260279,119.77130800995553,
	119.76798244275206,119.7646666735571,119.76136064543242,119.75806430193117,119.75477758709248,
	119.75150044543545,119.7482328219543,119.74497466211253,119.74172591183773,119.7384865175166,
	119.73525642598946,119.73203558454536,119.72882394091702,119.72562144327595,119.72242804022744,
	119.71924368080589,119.71606831447005,119.71290189109833,119.70974436098406,119.70659567483125,
	119.70345578374973,119.70032463925112,119.69720219324405,119.69408839803023,119.69098320629996,
	119.687886571128,119.6847984459696,119.68171878465607,119.67864754139109,119.67558467074659,
	119.67253012765883,119.66948386742456,119.66644584569724,119.6634160184831,119.66039434213778,
	119.65738077336219,119.65437526919938,119.65137778703047,119.64838828457161,119.64540671987011,
	119.6424330513013,119.6394672375648,119.63650923768162,119.63355901099041,119.63061651714445,
	119.62768171610847,119.62475456815521,119.62183503386252,119.61892307411028,119.61601865007702,
	119.61312172323734,119.61023225535854,119.60735020849799,119.6044755449999,119.60160822749275,
	119.59874821888623,119.5958954823685,119.59304998140358,119.59021167972831,119.58738054135,
	119.5845565305434,119.5817396118483,119.57892975006698,119.5761269102614,119.57333105775082,
	119.57054215810932,119.56776017715808,119.56498508098484,119.56221683590648,119.55945540849171,
	119.55670076555181,119.5539528741385,119.5512117015415,119.54847721528611,119.54574938313142,
	119.54302817306758,119.54031355331392,119.5376054923166,119.53490395874663,119.53220892149763,
	119.5295203496837,119.52683821263747,119.52416247990817,119.52149312125911,119.51883010666629,
	119.51617340631593,119.51352299060298,119.51087883012862,119.50824089569893,119.50560915832273,
	119.5029835892095,119.50036415976801,119.49775084160409,119.49514360651841,119.49254242650792,
	119.48994727375758,119.48735812064484,119.48477493973515,119.4821977037808,119.47962638571808,
	119.47706095866835,119.47450139593344,119.47194767099569,119.46939975751583,119.46685762933147,
	119.46432126045559,119.46179062507484,119.45926569754818,119.45674645240524,119.45423286434483,
	119.45172490823334,119.44922255910367,119.44672579215319,119.4442345827428,119.4417489063952,
	119.43926873879361,119.43679405578035,119.4343248333555,119.43186104767541,119.42940267505155,
	119.4269496919489,119.4245020749849,119.42205980092808,119.41962284669654,119.41719118935697,
	119.41476480612327,119.41234367435518,119.4099277715573,119.40751707538456,119.40511156361515,
	119.40271121418594,119.4003160051682,119.39792591477189,119.39554092134458,119.39316100337022,
	119.39078613946799,119.38841630839124,119.38605148902627,119.38369166039138,119.38133680163558,
	119.37898689203773,119.37664191100535,119.37430183807348,119.37196665290371,119.36963633528333,
	119.36731086512397,119.36499022246072,119.36267438745128,119.36036334037473,119.35805706163066,
	119.35575553173818,119.35345873133494,119.35116664117618,119.34887924213383,119.34659651519553,
	119.34431844146359,119.34204500215425,119.33977617859682,119.33751195223243,119.33525230461362,
	119.33299721740302,119.3307466723727,119.32850065140335,119.32625913648323,119.32402210970758,
	119.32178955327748,119.31956144949922,119.31733778078349,119.3151185296444,119.31290367869889,
	119.31069321066569,119.30848710836467,119.30628535471625,119.30408793274009,119.30189482555474,
	119.29970601637699,119.29752148852059,119.29534122539602,119.2931652105095,119.29099342746221,
	119.2888258599498,119.28666249176149,119.28450330677921,119.28234828897737,119.28019742242167,
	119.27805069126863,119.27590807976496,119.27376957224666,119.27163515313866,119.26950480695385,
	119.26737851829255,119.26525627184192,119.26313805237523,119.2610238447512,119.2589136339134,
	119.25680740488963,119.25470514279131,119.25260683281276,119.2505124602307,119.2484220104036,
	119.2463354687711,119.24425282085336,119.24217405225046,119.24009914864197,119.23802809578613,
	119.23596087951948,119.23389748575622,119.23183790048755,119.22978210978128,119.22773009978116,
	119.22568185670632,119.22363736685085,119.22159661658313,119.21955959234135,119.21752628064851,
	119.21549666808922,119.21347074132389,119.21144848708467,119.20942989217497,119.20741494346869,
	119.20540362791014,119.20339593251316,119.20139184436094,119.19939135060524,119.19739443846613,
	119.19540109523136,119.19341130825607,119.19142506496196,119.18944235283729,119.18746315943613,
	119.18548747237786,119.18351527934689,119.18154656809205,119.17958132642634,119.17761954222622,
	119.17566120343142,119.17370629804435,119.17175481412968,119.16980673981404,119.16786206328537,
	119.16592077279272,119.16398285664575,119.16204830321419,119.16011710092765,119.15818923827507,
	119.15626470380434,119.15434348612193,119.15242557389249,119.15051095583834,119.14859962073928,
	119.14669155743208,119.14478675481006,119.14288520182282,119.14098688747583,119.13909180082997,
	119.13719993100123,119.1353112671604,119.13342579853251,119.13154351439674,119.12966440408577,
	119.12778845698581,119.12591566253569,119.12404601022703,119.12217948960364,119.12031609026126,
	119.11845580184709,119.11659861405964,119.11474451664824,119.1128934994128,119.11104555220336,
	119.10920066492005,119.10735882751229,119.1055200299789,119.10368426236764,119.10185151477471,
	119.10002177734475,119.09819504027034,119.09637129379165,119.0945505281963,119.09273273381885,
	119.09091790104073,119.08910602028972,119.0872970820398,119.08549107681078,119.08368799516805,
	119.08188782772223,119.08009056512896,119.07829619808858,119.07650471734584,119.0747161136896,
	119.07293037795252,119.07114750101097,119.06936747378452,119.06759028723579,119.06581593237016,
	119.06404440023546,119.06227568192175,119.06050976856118,119.0587466513274,119.05698632143559,
	119.05522877014207,119.05347398874413,119.0517219685797,119.04997270102709,119.04822617750484,
	119.04648238947134,119.0447413284247,119.04300298590243,119.04126735348115,119.03953442277661,
	119.03780418544301,119.03607663317324,119.03435175769826,119.03262955078714,119.03091000424666,
	119.02919310992107,119.02747885969202,119.02576724547824,119.02405825923522,119.02235189295519,
	119.02064813866669,119.01894698843456,119.01724843435949,119.015552468578,119.01385908326216,
	119.01216827061933,119.01048002289194,119.00879433235747,119.00711119132794,119.0054305921499,
	119.00375252720428,119.00207698890596,119.00040396970378,118.99873346208021,118.99706545855123,
	118.9953999516661,118.99373693400712,118.99207639818954,118.99041833686124,118.98876274270268,
	118.9871096084265,118.98545892677761,118.98381069053278,118.98216489250048,118.9805215255209,
	118.97888058246541,118.97724205623672,118.97560593976849,118.97397222602523,118.97234090800211,
	118.97071197872475,118.96908543124907,118.96746125866122,118.96583945407718,118.9642200106427,
	118.96260292153327,118.96098817995373,118.95937577913818,118.95776571234987,118.95615797288097,
	118.95455255405238,118.9529494492137,118.9513486517429,118.94975015504627,118.94815395255823,
	118.94656003774108,118.94496840408507,118.943379045108,118.94179195435514,118.94020712539924,
	118.93862455184006,118.93704422730454,118.93546614544637,118.93389029994609,118.93231668451075,
	118.93074529287382,118.92917611879508,118.92760915606051,118.92604439848198,118.9244818398972,
	118.92292147416974,118.92136329518858,118.91980729686813,118.9182534731482,118.9167018179936,
	118.91515232538976,118.91360498936005,118.91205980393977,118.91051676319297,118.9089758612082,
	118.90743709209823,118.90590045000015,118.90436592907501,118.90283352350787,118.90130322750748,
	118.89977503530645,118.89824894116069,118.89672493934971,118.89520302417618,118.89368318996605,
	118.8921654310682,118.89064974185445,118.8891361167194,118.88762455008039,118.8861150363772,
	118.8846075700721,118.88310214564963,118.8815987576165,118.88009740050154,118.87859806885545,
	118.87710075725083,118.87560546028196,118.87411217256472,118.87262088873646,118.87113160345592,
	118.86964431140308,118.8681590072791,118.86667568580613,118.86519434172727,118.8637149698064,
	118.86223756482809,118.86076212159757,118.85928863494058,118.85781709970306,118.85634751075139,
	118.85487986297207,118.85341415127164,118.85195037057657,118.85048851583328,118.84902858200783,
	118.84757056408603,118.8461144570731,118.84466025599384,118.84320795589231,118.84175755183183,
	118.84030903889484,118.83886241218292,118.83741766681648,118.8359747979348,118.83453380069598,
	118.8330946702768,118.8316574018724,118.83022199069659,118.8287884319815,118.8273567209775,
	118.82592685295315,118.82449882319514,118.82307262700814,118.82164825971475,118.82022571665532,
	118.81880499318798,118.81738608468851,118.81596898655023,118.81455369418394,118.81314020301771,
	118.81172850849703,118.81031860608455,118.80891049125994,118.80750415952002,118.8060996063785,
	118.80469682736593,118.80329581802965,118.80189657393373,118.80049909065879,118.79910336380199,
	118.79770938897693,118.79631716181355,118.79492667795813,118.79353793307308,118.79215092283695,
	118.79076564294438,118.78938208910591,118.78800025704794,118.78662014251272,118.78524174125822,
	118.78386504905806,118.78249006170145,118.78111677499304,118.7797451847529,118.7783752868165,
	118.77700707703454,118.77564055127296,118.77427570541269,118.77291253534993,118.77155103699562,
	118.77019120627575,118.76883303913112,118.76747653151723,118.76612167940432,118.76476847877726,
	118.76341692563534,118.76206701599253,118.76071874587697,118.75937211133137,118.75802710841255,
	118.75668373319155,118.75534198175366,118.75400185019804,118.75266333463797,118.75132643120067,
	118.74999113602718,118.74865744527237,118.74732535510476,118.7459948617066,118.74466596127387,
	118.74333865001577,118.7420129241553,118.74068877992867,118.73936621358553,118.73804522138875,
	118.73672579961446,118.73540794455197,118.73409165250361,118.73277691978485,118.73146374272405,
	118.73015211766254,118.72884204095443,118.72753350896673,118.72622651807905,118.72492106468381,
	118.72361714518601,118.72231475600314,118.72101389356523,118.71971455431478,118.71841673470664,
	118.71712043120796,118.71582564029825,118.71453235846911,118.71324058222446,118.71195030808013,
	118.71066153256407,118.7093742522163,118.70808846358878,118.70680416324511,118.70552134776095,
	118.70424001372369,118.70296015773238,118.70168177639782,118.7004048663423,118.69912942419981,
	118.69785544661572,118.69658293024688,118.6953118717616,118.69404226783949,118.69277411517149,
	118.69150741045972,118.69024215041762,118.68897833176962,118.68771595125136,118.68645500560947,
	118.68519549160166,118.68393740599645,118.68268074557336,118.68142550712268,118.68017168744561,
	118.67891928335398,118.67766829167047,118.67641870922823,118.67517053287115,118.67392375945364,
	118.67267838584068,118.67143440890761,118.67019182554027,118.6689506326348,118.66771082709782,
	118.66647240584604,118.66523536580655,118.66399970391659,118.6627654171235,118.6615325023848,
	118.66030095666802,118.65907077695071,118.65784196022042,118.65661450347457,118.65538840372048,
	118.6541636579754,118.65294026326626,118.65171821662976,118.65049751511235,118.64927815577016,
	118.64806013566894,118.64684345188394,118.64562810150004,118.64441408161169,118.64320138932258,
	118.64199002174604,118.64077997600471,118.63957124923047,118.63836383856466,118.6371577411578,
	118.6359529541696,118.63474947476892,118.63354730013393,118.63234642745172,118.63114685391851,
	118.62994857673954,118.6287515931291,118.62755590031026,118.6263614955152,118.62516837598476,
	118.62397653896878,118.62278598172584,118.62159670152326,118.6204086956371,118.61922196135203,
	118.61803649596148,118.61685229676746,118.61566936108048,118.61448768621963,118.61330726951255,
	118.61212810829525,118.61095019991227,118.60977354171645,118.60859813106904,118.6074239653396,
	118.60625104190602,118.60507935815438,118.60390891147901,118.60273969928237,118.60157171897521,
	118.60040496797619,118.59923944371226,118.59807514361832,118.59691206513723,118.59575020572,
	118.59458956282539,118.59343013392021,118.5922719164791,118.59111490798458,118.58995910592697,
	118.58880450780855,118.58765111112703,118.58649891339998,118.58534791214866,118.58419810490206,
	118.58304948919664,118.58190206257666,118.58075582259376,118.57961076680726,118.57846689278388,
	118.57732419809787,118.57618268033092,118.57504233707202,118.57390316591774,118.57276516447186,
	118.5716283303455,118.57049266115709,118.56935815453235,118.56822480810416,118.56709261951269,
	118.56596158640522,118.56483170643615,118.56370297726711,118.56257539656673,118.56144896201072,
	118.56032367128178,118.5591995220697,118.55807651207112,118.55695463898982,118.55583390053624,
	118.55471429442797,118.55359581838928,118.55247847015131,118.55136224745212,118.55024714803643,
	118.54913316965569,118.54802031006821,118.54690856703893,118.54579793833939,118.54468842174792,
	118.54358001504943,118.5424727160353,118.5413665225036,118.54026143225893,118.53915744311243,
	118.53805455288165
	}}
};
table1d_imp<2001> tubetable2_EL34[2] __rt_data = {
	{ // Ri = 68k
	-20,20,50,2001, {
	1169.6765993724734,1169.020805767464,1168.3659269756686,1167.7119619531907,1167.0589096582794,
	1166.4067690518293,1165.7555390967755,1165.1052187584373,1164.4558070045434,1163.8073028048918,
	1163.1597051318488,1162.513012959748,1161.8672252654628,1161.2223410279921,1160.5783592285666,
	1159.935278850938,1159.2930988807836,1158.6518183060234,1158.0114361173926,1157.3719513069734,
	1156.7333628698623,1156.095669802877,1155.4588711053002,1154.8229657785384,1154.1879528263241,
	1153.5538312544772,1152.920600070797,1152.288258285911,1151.6568049119396,1151.026238963725,
	1150.396559457884,1149.7677654133495,1149.1398558513572,1148.5128297951262,1147.8866862700122,
	1147.2614243036496,1146.6370429257865,1146.0135411682909,1145.390918065122,1144.769172652318,
	1144.1483039681975,1143.528311053056,1142.9091929495557,1142.2909487019065,1141.6735773569744,
	1141.0570779635336,1140.4414495723436,1139.8266912363931,1139.2128020105565,1138.5997809521193,
	1137.9876271200233,1137.3763395755782,1136.765917381952,1136.1563596044743,1135.54766531053,
	1134.9398335693384,1134.332863452558,1133.726754033454,1133.1215043875316,1132.5171135923135,
	1131.9135807272237,1131.3109048737367,1130.709085115374,1130.1081205376884,1129.5080102279787,
	1128.9087532758342,1128.310348772736,1127.7127958120195,1127.1160934890308,1126.520240901184,
	1125.9252371475955,1125.3310813296625,1124.737772550508,1124.1453099153193,1123.5536925310835,
	1122.9629195067937,1122.3729899533064,1121.783902983546,1121.1956577121298,1120.608253255783,
	1120.0216887330157,1119.4359632642995,1118.8510759719177,1118.267025980028,1117.6838124147857,
	1117.1014344040905,1116.5198910779259,1115.9391815676786,1115.3593050071433,1114.7802605316374,
	1114.20204727835,1113.624664386367,1113.0481109966395,1112.4723862519263,1111.8974892967738,
	1111.3234192774362,1110.7501753422207,1110.177756641082,1109.6061623257851,1109.0353915500245,
	1108.4654434691192,1107.8963172401648,1107.3280120221498,1106.7605269757717,1106.1938612635577,
	1105.628014049687,1105.062984500142,1104.4987717827769,1103.9353750669409,1103.372793523956,
	1102.8110263267317,1102.2500726499845,1101.6899316700294,1101.1306025651222,1100.5720845149995,
	1100.0143767013267,1099.457478307086,1098.9013885174254,1098.3461065189915,1097.7916314999084,
	1097.2379626501815,1096.6850991616336,1096.1330402273807,1095.5817850424974,1095.031332803556,
	1094.4816827088928,1093.9328339582876,1093.3847857534577,1092.8375372974456,1092.2910877950178,
	1091.7454364527691,1091.2005824785554,1090.6565250821252,1090.1132634747655,1089.5707968691681,
	1089.029124479869,1088.4882455228656,1087.948159215628,1087.4088647774834,1086.8703614290341,
	1086.332648392676,1085.7957248922119,1085.2595901529412,1084.7242434018383,1084.1896838674845,
	1083.6559107797032,1083.1229233701947,1082.590720871938,1082.05930251947,1081.5286675488014,
	1080.9988151975951,1080.4697447048404,1079.941455311184,1079.413946258555,1078.8872167905124,
	1078.3612661520692,1077.8360935895648,1077.3116983510283,1076.788079685771,1076.2652368446138,
	1075.7431690797546,1075.2218756449283,1074.7013557951852,1074.1816087871698,1073.662633878729,
	1073.144430329235,1072.626997399544,1072.1103343516907,1071.5944404494094,1071.0793149573067,
	1070.5649571421375,1070.0513662712835,1069.5385416138702,1069.026482440423,1068.5151880226347,
	1068.004657633655,1067.4948905478675,1066.985886041205,1066.477643390704,1065.9701618749762,
	1065.463440773549,1064.9574793676186,1064.452276939625,1063.9478327731674,1063.4441461533506,
	1062.9412163663058,1062.4390426995324,1061.937624441997,1061.4369608835805,1060.9370513158965,
	1060.4378950312216,1059.9394913236165,1059.4418394881038,1058.944938820877,1058.4487886195543,
	1057.9533881828866,1057.4587368108403,1056.9648338045793,1056.4716784664001,1055.9792701000163,
	1055.4876080100444,1054.996691502479,1054.506519884424,1054.0170924640388,1053.5284085509516,
	1053.0404674555584,1052.5532684897785,1052.06681096624,1051.5810941991188,1051.0961175034754,
	1050.6118801955383,1050.1283815927216,1049.64562101338,1049.1635977772203,1048.6823112048237,
	1048.2017606178288,1047.7219453391906,1047.2428646927362,1046.7645180032998,1046.2869045970426,
	1045.8100238009401,1045.3338749431189,1044.8584573525804,1044.3837703596096,1043.90981329539,
	1043.4365854920495,1042.9640862827255,1042.4923150016682,1042.021270984077,1041.550953566105,
	1041.0813620848116,1040.6124958785226,1040.1443542860818,1039.6769366476133,1039.2102423040924,
	1038.7442705974229,1038.2790208704707,1037.8144924670255,1037.350684731747,1036.8875970102192,
	1036.4252286490398,1035.9635789954586,1035.502647397936,1035.0424332055097,1034.5829357682499,
	1034.1241544370562,1033.66608856373,1033.2087375008498,1032.7521006018587,1032.2961772210308,
	1031.8409667135963,1031.386468435306,1030.9326817429414,1030.4796059941468,1030.0272405471455,
	1029.5755847610797,1029.1246379958843,1028.674399612199,1028.2248689714395,1027.7760454358859,
	1027.3279283683448,1026.8805171325603,1026.4338110928745,1025.9878096144244,1025.5425120631066,
	1025.0979178054,1024.6540262085077,1024.2108366404123,1023.7683484696441,1023.3265610656374,
	1022.8854737981636,1022.4450860378812,1022.0053971560529,1021.566406524529,1021.1281135157667,
	1020.6905175029524,1020.2536178598453,1019.8174139606908,1019.3819051805543,1018.947090894901,
	1018.512970479843,1018.0795433120527,1017.6468087686587,1017.2147662276309,1016.783415067137,
	1016.3527546661354,1015.9227844039413,1015.4935036604551,1015.0649118160752,1014.6370082517874,
	1014.2097923488719,1013.7832634893007,1013.357421055274,1012.9322644296903,1012.5077929957796,
	1012.0840061371969,1011.6609032381263,1011.2384836830541,1010.8167468569812,1010.3956921452889,
	1009.9753189337031,1009.5556266083463,1009.1366145558136,1008.7182821629308,1008.3006288169962,
	1007.8836539055073,1007.4673568165298,1007.0517369382264,1006.6367936591943,1006.222526368374,
	1005.8089344548712,1005.3960173081387,1004.9837743180209,1004.57220487446,1004.161308367774,
	1003.7510841884222,1003.3415317272764,1002.9326503752329,1002.5244395235273,1002.1168985635567,
	1001.7100268870113,1001.3038238855481,1000.8982889512874,1000.4934214763266,1000.0892208529104,
	999.6856864734839,999.2828177306775,998.8806140171163,998.4790747256759,998.0781992492688,
	997.6779869809001,997.2784373136296,996.8795496405864,996.4813233550768,996.0837578502635,
	995.6868525194806,995.2906067560558,994.8950199534403,994.5000915047652,994.1058208034824,
	993.7122072429438,993.319250216379,992.9269491170404,992.5353033381565,992.1443122727959,
	991.7539753140412,991.3642918548644,990.9752612881201,990.5868830065322,990.1991564028297,
	989.812080869414,989.4256557986912,989.0398805828183,988.6547546138659,988.2702772836125,
	987.8864479837287,987.5032661056968,987.1207310407174,986.7388421797585,986.3575989135817,
	985.9770006326805,985.5970467273572,985.2177365874717,984.8390696026675,984.4610451623665,
	984.0836626555437,983.7069214709518,983.3308209969177,982.9553606214904,982.5805397322141,
	982.206357716446,981.8328139609733,981.4599078523097,981.0876387764866,980.716006119053,
	980.3450092651841,979.9746475995421,979.6049205064489,979.2358273695219,978.8673675720436,
	978.499540496798,978.1323455258098,977.7657820408245,977.39984942301,977.034547052798,
	976.6698743101703,976.3058305744191,975.942415224416,975.5796276381253,975.2174671931225,
	974.8559332661897,974.4950252335059,974.1347424705239,973.7750843520286,973.4160502521419,
	973.0576395441102,972.699851600636,972.3426857935414,971.9861414939629,971.630218072063,
	971.274914897552,970.9202313389413,970.5661667642337,970.2127205403534,969.8598920335356,
	969.507680609019,969.1560856312655,968.8051064637682,968.4547424690455,968.1049930088183,
	967.7558574438165,967.4073351336784,967.0594254372166,966.7121277122045,966.3654413153008,
	966.0193656022734,965.6738999278274,965.3290436454932,964.9847961078982,964.6411566664287,
	964.2981246713965,963.9556994720087,963.6138804163845,963.2726668513608,962.9320581227215,
	962.5920535749716,962.252652551442,961.9138543941777,961.5756584441401,961.2380640408605,
	960.9010705226958,960.5646772266458,960.2288834884145,959.893688642475,959.559092021759,
	959.2250929580464,958.891690781624,958.5588848212901,958.2266744046234,957.8950588576464,
	957.5640375049634,957.2336096697361,956.9037746735542,956.5745318365322,956.2458804774158,
	955.9178199130675,955.5903494591718,955.2634684295693,954.9371761366195,954.6114718910001,
	954.2863550017998,953.9618247765173,953.6378805207747,953.3145215386861,952.9917471326215,
	952.6695566031848,952.3479492492683,952.0269243678714,951.7064812543886,951.3866192022956,
	951.067337503265,950.7486354471143,950.4305123218078,950.1129674133946,949.7960000060743,
	949.4796093820029,949.1637948215202,948.8485556029825,948.5338910026936,948.2198002949024,
	947.9062827519916,947.5933376441836,947.2809642395553,946.9691618043522,946.6579296024319,
	946.3472668956264,946.0371729436533,945.7276470040067,945.4186883319176,945.1102961805776,
	944.8024698008218,944.4952084411177,944.1885113479784,943.8823777651282,943.5768069344745,
	943.2717980951736,942.9673504842592,942.6634633362094,942.3601358832378,942.0573673550228,
	941.7551569787912,941.4535039792631,941.1524075787637,940.851866996912,940.551881451016,
	940.2524501554767,939.9535723224138,939.6552471612044,939.3574738784869,939.0602516784024,
	938.7635797622448,938.4674573287167,938.1718835737717,937.876857690451,937.5823788691741,
	937.2884462974586,936.9950591600546,936.7022166388336,936.4099179126773,936.1181621577239,
	935.8269485471042,935.5362762509593,935.2461444364782,934.9565522679318,934.6674989062797,
	934.3789835097714,934.0910052333121,933.8035632289002,933.5166566452375,933.2302846279656,
	932.9444463194864,932.659140858988,932.3743673824748,932.0901250226246,931.8064129089032,
	931.5232301673785,931.2405759208737,930.958449288676,930.6768493869116,930.3957753280641,
	930.115226221365,929.8352011723542,929.5556992832766,929.2767196527307,928.9982613757583,
	928.7203235439052,928.4429052449773,928.1660055633153,927.8896235793368,927.6137583700868,
	927.3384090085483,927.0635745642394,926.7892541027524,926.5154466859409,926.2421513717027,
	925.9693672142305,925.6970932636862,925.4253285664707,925.1540721648876,924.8833230972763,
	924.6130803980308,924.3433430974707,924.0741102218939,923.8053807934369,923.5371538302057,
	923.2694283459715,923.0022033505207,922.7354778493478,922.4692508436643,922.2035213304457,
	921.9382883023538,921.6735507477499,921.4093076504788,921.1455579902241,920.8823007420674,
	920.619534876745,920.3572593603503,920.0954731546763,919.8341752167134,919.5733644990381,
	919.3130399496126,919.0532005116621,918.7938451238148,918.534972719875,918.2765822291561,
	918.0186725758329,917.7612426796336,917.5042914551497,917.2478178123828,916.9918206561504,
	916.7362988865825,916.4812513986207,916.2266770824679,915.9725748229716,915.7189435002279,
	915.4657819890365,915.213089159073,914.9608638749198,914.7091049959347,914.4578113762658,
	914.2069818646476,913.9566153047508,913.7067105347186,913.4572663874086,913.2082816902182,
	912.9597552652996,912.7116859290079,912.4640724924185,912.2169137610018,911.9702085347334,
	911.7239556077285,911.4781537687404,911.2328018007277,910.9878984809188,910.7434425807685,
	910.4994328660051,910.2558680964848,910.0127470262137,909.7700684033289,909.5278309699997,
	909.286033462423,909.0446746108369,908.8037531393961,908.5632677662124,908.3232172032424,
	908.0836001563014,907.8444153250985,907.6056614029968,907.3673370771317,907.1294410284039,
	906.8919719313396,906.654928454064,906.4183092582788,906.1821129993622,905.9463383260937,
	905.7109838806979,905.4760482989652,905.2415302100442,905.00742823633,904.7737409936857,
	904.5404670911695,904.3076051311682,904.0751537092459,903.843111414035,903.6114768275231,
	903.3802485245908,903.1494250732804,902.9190050345351,902.688986962396,902.4593694038558,
	902.2301508986221,902.0013299794974,901.7729051719024,901.5448749942558,901.3172379574588,
	901.0899925652387,900.8631373140014,900.6366706928128,900.4105911831816,900.1848972592655,
	899.9595873876675,899.7346600275243,899.5101136302698,899.2859466397819,899.0621574923254,
	898.83874461641,898.6157064327132,898.393041354332,898.1707477863406,897.948824126037,
	897.7272687628434,897.5060800781073,897.2852564453498,897.0647962299646,896.8446977892095,
	896.6249594723199,896.4055796203822,896.1865565662811,895.9678886345491,895.7495741415922,
	895.5316113953809,895.3139986955358,895.0967343333507,894.8798165915935,894.6632437444554,
	894.4470140577929,894.2311257887576,894.0155771858252,893.8003664890047,893.5854919293981,
	893.3709517295034,893.1567441029226,892.942867254424,892.7293193800557,892.5160986667298,
	892.3032032925552,892.0906314265491,891.8783812287538,891.6664508500008,891.4548384321432,
	891.2435421078042,891.0325600002384,890.8218902235963,890.6115308827522,890.4014800730813,
	890.1917358807353,889.9822963822289,889.7731596447367,889.5643237259188,889.3557866737758,
	889.1475465268022,888.9396013137126,888.7319490536388,888.5245877558974,888.3175154200233,
	888.110730035802,887.904229583035,887.6980120316639,887.4920753416507,887.2864174630146,
	887.0810363356312,886.8759298893116,886.6710960438434,886.4665327086198,886.2622377829709,
	886.0582091559547,885.8544447061869,885.6509423021403,885.447699801724,885.2447150524067,
	885.0419858912489,884.8395101447315,884.6372856288075,884.4353101487502,884.2335814991897,
	884.0320974640899,883.8308558166282,883.629854319141,883.4290907232783,883.2285627697096,
	883.0282681881068,882.8282046972646,882.6283700050247,882.4287618080717,882.2293777919984,
	882.0302156313381,881.8312729892888,881.6325475180238,881.4340368583063,881.2357386395553,
	881.0376504799225,880.8397699861874,880.6420947535634,880.4446223658067,880.2473503952081,
	880.0502764025118,879.8533979367128,879.6567125352299,879.4602177238523,879.2639110163395,
	879.0677899150572,878.8718519103512,878.6760944805532,878.4805150923672,878.2851112002791,
	878.0898802469615,877.89481966307,877.6999268669922,877.5051992650657,877.3106342515522,
	877.1162292084292,876.9219815054196,876.7278884999524,876.5339475372313,876.3401559499792,
	876.1465110584783,875.9530101706948,875.7596505819581,875.5664295752057,875.3733444205897,
	875.1803923758856,874.9875706861303,874.7948765835512,874.6023072877666,874.4098600055398,
	874.2175319309348,874.0253202450851,873.8332221161908,873.6412346995577,873.4493551375864,
	873.2575805596158,873.0659080818943,872.8743348076122,872.6828578268972,872.4914742166369,
	872.3001810405065,872.1089753490979,871.9178541794867,871.7268145556457,871.5358534881374,
	871.3449679740459,871.1541549971924,870.9634115278496,870.7727345227171,870.582120925167,
	870.391567664906,870.2010716579016,870.0106298067152,869.8202390001592,869.6298961131833,
	869.439598007318,869.2493415300651,869.0591235152284,868.8689407826593,868.6787901384644,
	868.4886683748169,868.2985722698987,868.108498588022,867.9184440793799,867.7284054801955,
	867.5383795126137,867.3483628846933,867.1583522903242,866.9683444092759,866.7783359071553,
	866.5883234352854,866.3983036307982,866.2082731164639,866.0182285009063,865.8281663782657,
	865.6380833283919,865.4479759166414,865.2578406941277,865.0676741973674,864.8774729484882,
	864.6872334550619,864.4969522102543,864.3066256924817,864.1162503657225,863.9258226793851,
	863.7353390681574,863.544795952105,863.3541897366595,863.1635168124923,862.9727735556652,
	862.7819563273905,862.5910614740698,862.4000853274316,862.2090242044998,862.0178744071897,
	861.8266322227888,861.6352939236544,861.4438557672047,861.2523139960389,861.0606648377203,
	860.8689045049575,860.6770291954806,860.4850350920631,860.2929183624609,860.1006751594224,
	859.9083016206172,859.7157938687498,859.5231480114322,859.3303601412282,859.1374263355956,
	858.9443426568895,858.751105152421,858.5577098542478,858.3641527793831,858.1704299297788,
	857.9765372920374,857.7824708377369,857.5882265232551,857.3938002897379,857.1991880632248,
	857.0043857544345,856.8093892589903,856.6141944572487,856.4187972144651,856.223193380359,
	856.027378789793,855.8313492622816,855.63510060194,855.4386285977469,855.2419290235423,
	855.0449976378342,854.8478301838993,854.6504223897227,854.452769968201,854.2548686167341,
	854.0567140178247,853.8583018384674,853.6596277305579,853.460687330757,853.2614762605685,
	853.0619901260749,852.8622245184978,852.6621750135703,852.4618371721438,852.2612065396787,
	852.0602786466656,851.8590490084467,851.6575131251686,851.4556664820997,851.2535045493274,
	851.0510227821028,850.848216620581,850.6450814901813,850.4416128012533,850.2378059496173,
	850.0336563161875,849.8291592673819,849.6243101551368,849.4191043168217,849.2135370756938,
	849.0076037407714,848.8012996072882,848.5946199567625,848.38756005712,848.1801151633474,
	847.9722805173413,847.7640513489764,847.5554228759927,847.3463903048373,847.1369488314559,
	846.9270936417577,846.7168199130148,846.5061228144335,846.2949975090297,846.0834391547946,
	845.8714429068417,845.6590039191592,845.4461173478323,845.2327783536529,845.0189821058116,
	844.8047237865391,844.5899985957325,844.3748017574259,844.1591285268988,843.9429741992276,
	843.7263341193673,843.5092036943912,843.291578407782,843.0734538365256,842.8548256714633,
	842.6356897415355,842.4160420428043,842.1958787728173,841.975196372111,841.7539915733164,
	841.5322614601837,841.3100035391122,841.0872158235763,840.8638969371184,840.6400462362635,
	840.4156639603314,840.1907514104392,839.9653111681401,839.7393473588843,839.5128659721905,
	839.2858752503945,839.0583861595705,838.8304129613256,838.6019739051741,838.3730920644188,
	838.1437963422526,837.9141226753156,837.6841154632842,837.4538292500087,837.2233306754536,
	836.9927007056648,836.7620371271726,836.5314572636903,836.3011008321597,836.0711328047602,
	835.8417460884267,835.6131637692704,835.3856406232198,835.1594635575502,834.934950653382,
	834.7124485246974,834.4923278137564,834.2749767933944,834.0607932380675,833.8501749305026,
	833.6435093491654,833.4411632146938,833.2434726185669,833.0507344160264,832.8631994356364,
	832.6810678661391,832.5044869636465,832.3335510053627,832.1683032405166,832.0087394652328,
	831.854812786344,831.70643913105,831.5635030990487,831.4258638142711,831.293360516312,
	831.1658177049816,831.0430497290001,830.9248647633243,830.8110681709949,830.7014652742286,
	830.5958635823725,830.4940745358522,830.3959148287039,830.3012073736191,830.2097819691098,
	830.121475722177,830.0361332756875,829.9536068802935,829.8737563447779,829.7964488990408,
	829.7215589856322,829.6489680083122,829.5785640431333,829.5102415335996,829.4439009737612,
	829.3794485888917,829.3167960167699,829.2558599982458,829.1965620753458,829.1388283016463,
	829.082588965882,829.027778327313,828.9743343693733,828.9221985616048,828.8713156411656,
	828.8216334035112,828.7731025094421,828.7256763014176,828.6793106356631,828.6339637224532,
	828.5895959770277,828.5461698834229,828.5036498642995,828.4620021617441,828.421194725002,
	828.381197106363,828.3419803644408,828.3035169731601,828.2657807379261,828.2287467156965,
	828.1923911435887,828.1566913691522,828.1216257856995,828.0871737748496,828.0533156481232,
	828.0200325965369,827.9873066421702,827.9551205907644,827.9234579906089,827.8923030920208,
	827.8616408097021,827.8314566874623,827.8017368669707,827.772468053644,827.7436374913759,
	827.7152329309489,827.6872426096938,827.6596552227653,827.6324599020768,827.6056461952684,
	827.579204046576,827.553123775413,827.527396059225,827.5020119193409,827.4769627012237,
	827.4522400606406,827.4278359516227,827.4037426107272,827.3799525437114,827.3564585161039,
	827.3332535394817,827.3103308629817,827.2876839609568,827.2653065236047,827.243192449028,
	827.2213358340641,827.1997309642696,827.1783723096793,827.1572545128331,827.1363723858304,
	827.1157209007818,827.0952951850755,827.075090514095,827.0551023060596,827.0353261166216,
	827.0157576312876,826.9963926653502,826.977227154733,826.9582571516314,826.9394788233108,
	826.9208884436014,826.9024823936438,826.8842571539836,826.8662093027259,826.8483355113025,
	826.8306325444498,826.8130972512705,826.7957265663472,826.7785175049211,826.761467163012,
	826.7445727094902,826.7278313899137,826.7112405174896,826.6947974748947,826.6784997134504,
	826.6623447460611,826.64633014718,826.6304535534026,826.6147126584191,826.599105211137,
	826.5836290160878,826.5682819295565,826.5530618606156,826.5379667665161,826.5229946508894,
	826.5081435693444,826.4934116148249,826.4787969300677,826.4642976968503,826.4499121417824,
	826.4356385269662,826.4214751554634,826.4074203691403,826.3934725434315,826.3796300935597,
	826.3658914637931,826.3522551370802,826.338719625459,826.3252834735133,826.311945257554,
	826.2987035832964,826.2855570852755,826.2725044255931,826.2595442966145,826.2466754150745,
	826.2338965234873,826.2212063919458,826.2086038139116,826.1960876047641,826.1836566083667,
	826.1713096877004,826.1590457289165,826.1468636395908,826.1347623497138,826.1227408075712,
	826.1107979837402,826.0989328669651,826.0871444657009,826.0754318071702,826.0637939366922,
	826.0522299159445,826.0407388268914,826.029319763165,826.0179718411943,826.0066941897556,
	825.995485952817,825.984346293078,825.9732743834836,825.9622694159882,825.9513305935965,
	825.9404571342747,825.9296482738764,825.9189032514848,825.9082213295943,825.8976017757885,
	825.8870438765242,825.8765469254487,825.8661102312776,825.8557331103149,825.8454148962967,
	825.8351549270218,825.8249525559529,825.814807148456,825.8047180756431,825.794684720176,
	825.7847064771854,825.7747827494471,825.7649129484779,825.7550964973476,825.7453328266984,
	825.7356213782739,825.725961599948,825.7163529475166,825.7067948902757,825.6972869002458,
	825.687828459209,825.6784190603308,825.6690581969909,825.6597453793011,825.6504801172813,
	825.6412619323108,825.6320903518542,825.6229649098709,825.6138851463523,825.60485061329,
	825.5958608628113,825.5869154546021,825.578013959534,825.5691559498487,825.5603410039278,
	825.5515687113015,825.5428386593627,825.5341504494146,825.5255036829576,825.5168979682428,
	825.5083329219692,825.4998081602413,825.4913233110549,825.4828780042043,825.4744718732233,
	825.4661045599123,825.4577757081101,825.4494849681442,825.4412319946957,825.4330164470314,
	825.4248379899898,825.4166962904546,825.4085910183428,825.4005218564074,825.3924884824598,
	825.3844905830567,825.3765278462778,825.3685999681167,825.3607066418078,825.3528475736339,
	825.345022466209,825.3372310296081,825.3294729750044,825.3217480191859,825.3140558827414,
	825.3063962888159,825.2987689640878,825.2911736378599,825.2836100472057,825.2760779251972,
	825.2685770150376,825.2611070553061,825.2536677968334,825.2462589901455,825.2388803830216,
	825.2315317345386,825.2242128012487,825.2169233457333,825.209663132485,825.2024319268504,
	825.1952294987528,825.1880556249339,825.1809100768595,825.1737926312002,825.1667030710273,
	825.1596411760892,825.1526067369005,825.1455995373022,825.1386193688488,825.13166602474,
	825.1247392966468,825.1178389891218,825.1109648945419,825.1041168188939,825.097294564624,
	825.0904979402931,825.0837267523221,825.0769808117321,825.0702599339437,825.0635639311222,
	825.0568926201612,825.0502458203688,825.0436233516282,825.0370250379242,825.0304507043692,
	825.0239001779249,825.0173732848574,825.0108698561228,825.0043897268141,824.9979327257424,
	824.9914986940588,824.9850874650975,824.9786988792846,824.9723327769132,824.9659890026377,
	824.959667397289,824.9533678084567,824.947090082497,824.9408340705079,824.934599621151,
	824.9283865887483,824.9221948208385,824.9160241779675,824.909874516478,824.9037456915362,
	824.897637564283,824.8915499933232,824.88548284496,824.8794359776365,824.8734092614503,
	824.8674025565831,824.8614157378856,824.8554486671616,824.8495012196422,824.8435732624531,
	824.837664672321,824.8317753209008,824.8259050856163,824.8200538392429,824.8142214615868,
	824.8084078321953,824.8026128267741,824.7968363296904,824.791078224208,824.7853383913655,
	824.7796167164071,824.7739130839974,824.7682273813701,824.7625594942333,824.7569093154699,
	824.7512767302941,824.7456616319,824.7400639125302,824.7344834641805,824.7289201774943,
	824.7233739494322,824.7178446786684,824.7123322579075,824.7068365853203,824.7013575620509,
	824.6958950826179,824.6904490530579,824.6850193678822,824.67960593499,824.6742086554538,
	824.6688274295744,824.6634621705134,824.6581127743214,824.6527791526855,824.6474612116457,
	824.642158860239,824.6368720023488,824.6316005543176,824.6263444232573,824.6211035210926,
	824.6158777583431,824.6106670481072,824.6054713032329,824.6002904395783,824.5951243724827,
	824.5899730135808,824.5848362826802,824.5797140990971,824.574606376136,824.569513031484,
	824.5644339901826,824.5593691649229,824.5543184821724,824.5492818583433,824.544259218561,
	824.5392504837246,824.534255575309,824.5292744196478,824.5243069437574,824.5193530669068,
	824.5144127175608,824.5094858227201,824.5045723064263,824.4996720956984,824.4947851241559,
	824.4899113136423,824.4850505954897,824.4802029024142,824.4753681625645,824.4705463041641,
	824.4657372622248,824.4609409695101,824.4561573509446,824.451386350409,824.4466278926843,
	824.441881914266,824.4371483543204,824.432427141763,824.4277182158141,824.42302150678,
	824.418336961783,824.4136645089957,824.4090040883011,824.4043556407516,824.3997190985003,
	824.3950944075285,824.3904815029747,824.3858803274254,824.3812908192978,824.3767129180312,
	824.3721465671413,824.3675917077993,824.3630482818363,824.3585162314188,824.3539955032962,
	824.3494860367383,824.3449877769759,824.3405006677804,824.3360246551805,824.331559681304,
	824.3271056949839,824.3226626431117,824.3182304672464,824.3138091181467,824.3093985395025,
	824.3049986802688,824.3006094914971,824.2962309155973,824.2918629073309,824.2875054096481,
	824.2831583755665,824.2788217572946,824.2744954976938,824.2701795536377,824.2658738716539,
	824.2615784064451,824.2572931053069,824.2530179258085,824.2487528131038,824.2444977265809,
	824.2402526156437,824.2360174312668,824.2317921312602,824.2275766703549,824.2233709957096,
	824.2191750665858,824.2149888403982,824.2108122665644,824.2066453015884,824.2024879064863,
	824.1983400305621,824.1942016358845,824.1900726708891,824.1859531057196,824.1818428837951,
	824.177741969888,824.1736503238687,824.1695678989786,824.1654946520039,824.1614305473571,
	824.1573755395182,824.1533295871515,824.1492926560736,824.1452647018735,824.1412456850544,
	824.1372355623007,824.1332342974825,824.1292418537344,824.1252581896515,824.1212832698546,
	824.1173170460602,824.1133594858461,824.1094105562273,824.1054702161888,824.101538426115,
	824.0976151499483,824.0937003504079,824.0897939945235,824.0858960408796,824.0820064527924,
	824.0781251970583,824.0742522391411,824.0703875436004,824.0665310690432,824.0626827875386,
	824.0588426621305,824.0550106549738,824.0511867369702,824.0473708659218,824.0435630171885,
	824.0397631526076,824.035971236382,824.0321872387977,824.0284111283488,824.024642867577,
	824.0208824241579,824.0171297683304,824.013384863379,824.009647682529,824.0059181903866,
	824.0021963561419,823.9984821510717,823.9947755382684,823.9910764898326,823.9873849775689,
	823.9837009659149,823.9800244267033,823.9763553261421,823.9726936406565,823.9690393324395,
	823.9653923789116,823.9617527451492,823.9581204025103,823.9544953292959,823.9508774831496,
	823.9472668435664,823.9436633800158,823.940067065893,823.9364778664062,823.93289576185,
	823.9293207177698,823.9257527133373,823.9221917104079,823.918637688925,823.9150906220602,
	823.9115504756335,823.9080172267347,823.904490851277,823.9009713219594,823.8974586048887,
	823.8939526795876,823.8904535224508,823.886961098064,823.8834753904765,823.8799963636924,
	823.8765240017484,823.8730582783878,823.8695991561445,823.8661466240027,823.8627006505296,
	823.8592612093553,823.8558282787533,823.8524018322989,823.8489818465546,823.8455682988804,
	823.8421611566562,823.8387604046978,823.835366014989,823.8319779681904,823.8285962310579,
	823.8252207885527,823.8218516180654,823.8184886889833,823.8151319779986,823.8117814695739,
	823.8084371367878,823.8050989584505,823.8017669104587,823.7984409642038,823.7951211104842,
	823.7918073161783,823.7884995613254,823.7851978260477,823.7819020869641,823.7786123223843,
	823.7753285092741,823.7720506328043,823.7687786654868,823.7655125790621,823.762252366858,
	823.7589979993265,823.7557494548421,823.752506711634,823.7492697587342,823.7460385657538,
	823.7428131123885,823.7395933809224,823.7363793507074,823.7331710022765,823.7299683161096,
	823.7267712689039,823.7235798395217,823.7203940115058,823.7172137711764,823.714039084359,
	823.7108699420696,823.7077063228733,823.7045482082544,823.701395576338,823.6982484076149,
	823.69510668773,823.6919703946446,823.6888395052134,823.6857140096105,823.6825938849324,
	823.6794791087013,823.6763696696673,823.6732655427842,823.6701667141341,823.6670731680407,
	823.663984878074,823.660901835049,823.6578240140065,823.6547514063989,823.6516839824408,
	823.648621729822,823.6455646358661,823.6425126781276,823.6394658365004,823.6364241044463,
	823.6333874484325,823.6303558680909,823.6273293381028,823.6243078396674,823.6212913604285,
	823.6182798796063,823.6152733860421,823.6122718607451,823.6092752863938,823.6062836467532,
	823.6032969213439,823.6003151024099,823.5973381698038,823.5943661053569,823.5913988970093,
	823.5884365216177,823.5854789686808,823.5825262297424,823.5795782762993,823.5766350997397,
	823.573696682189,823.5707630078557,823.5678340683132,823.5649098314705,823.5619903003013,
	823.5590754478555,823.5561652684431,823.5532597379488,823.5503588489546,823.5474625803328,
	823.5445709203705,823.5416838498253,823.5388013653408,823.5359234408389,823.5330500668025,
	823.5301812304766,823.5273169135004,823.5244571020403,823.5216017858526,823.5187509448912,
	823.5159045705695,823.5130626428437,823.5102251586277,823.5073920892125,823.5045634313444,
	823.5017391668904,823.4989192840031,823.4961037673332,823.4932926061081,823.490485785821,
	823.4876832869548,823.4848851020097,823.4820912202375,823.4793016202473,823.4765162993059,
	823.4737352349133,823.4709584213086,823.4681858422382,823.4654174803204,823.4626533278596,
	823.4598933707729,823.457137601321,823.4543859925603,823.45163854691,823.4488952427607,
	823.4461560748522,823.443421022681,823.4406900733985,823.4379632282177,823.435240459292,
	823.4325217628074,823.4298071168799,823.4270965284069,823.4243899623087,823.4216874276699,
	823.4189888945302,823.4162943633651,823.4136038158521,823.4109172437009,823.4082346329275,
	823.4055559675181,823.4028812486695,823.4002104529196,823.3975435703982,823.3948805960354,
	823.3922215093693,823.389566304203,823.3869149671609,823.3842674926836,823.3816238613557,
	823.3789840673759,823.3763480968647,823.3737159383,823.3710875876295,823.3684630187835,
	823.3658422376141,823.3632252189017,823.3606119638224,823.3580024571729,823.3553966836363,
	823.3527946363016,823.35019630595,823.3476016770202,823.3450107451362,823.3424234938466,
	823.3398399169109,823.3372600057006,823.3346837427989,823.3321111145975,823.3295421277759,
	823.3269767539922,823.3244149952931,823.3218568361808,823.3193022671586,823.3167512771976,
	823.3142038583018,823.3116599973828,823.3091196889952,823.3065829218474,823.304049679234,
	823.301519956297,823.2989937513161,823.2964710406686,823.2939518228567,823.2914360838987,
	823.2889238206523,823.2864150129656,823.2839096618122,823.2814077498922,823.2789092735221,
	823.2764142213586,823.2739225826714,823.2714343474963,823.2689495092683,823.2664680552335,
	823.263989979114,823.2615152732494,823.2590439202304,823.2565759219749,823.2541112600402,
	823.2516499286522,823.2491919229493,823.2467372254406,823.2442858352036,823.2418377376197,
	823.2393929290055,823.2369513946935,823.23451313208,823.232078126491,823.229646367919,
	823.2272178557857,823.2247925729187,823.2223705198853,823.2199516839928,823.2175360583096,
	823.21512362165,823.2127143793547,823.210308319028,823.2079054292348,823.2055057077524,
	823.203109148176,823.2007157292362,823.1983254567693,823.1959383118591,823.1935542920442,
	823.1911733823246,823.1887955846903,823.1864208840302,823.1840492709587,823.1816807475486,
	823.1793152961083,823.1769529088897,823.1745935844787,823.172237307109,823.1698840733426,
	823.1675338717785,823.1651867028957,823.1628425487779,823.1605014069047,823.1581632723398,
	823.1558281282271,823.1534959699333,823.1511667981919,823.1488405946332,823.1465173590259,
	823.1441970874781,823.1418797551426,823.1395653653442,823.1372539136212,823.1349453885705,
	823.1326397828061,823.1303370909214,823.1280372996112,823.1257404114392,823.1234464109426,
	823.1211552928016,823.1188670521865,823.1165816828708,823.1142991687916,823.112019511611,
	823.1097426956954,823.1074687300523,823.105197585766,823.1029292730227,823.1006637782078,
	823.098401092809,823.0961412139876,823.0938841307202,823.0916298409537,823.0893783314684,
	823.0871296031409,823.0848836364261,823.0826404357659,823.0803999929634,823.078162299464,
	823.0759273411162,823.0736951245166,823.0714656401483,823.0692388744019,823.0670148169272,
	823.0647934785192,823.0625748368129,823.0603588877744,823.0581456335425,823.0559350617967,
	823.0537271608881,823.0515219347909,823.0493193686926,823.0471194538147,823.0449221975772,
	823.0427275766682,823.040535596403,823.0383462474861,823.0361595268887,823.0339754166223,
	823.0317939206875,823.0296150301289,823.0274387356546,823.025265036949,823.0230939250177,
	823.0209253993706,823.0187594386385,823.0165960540286,823.0144352217071,823.0122769518202,
	823.0101212307455,823.0079680531911,823.0058174104004,823.0036693034425,823.0015237168681,
	822.9993806563733,822.9972401093845,822.9951020688833,822.992966525784,822.9908334830911,
	822.9887029275352,822.9865748588963,822.9844492639083,822.9823261425191,822.9802054972561,
	822.9780873065453,822.9759715669356,822.9738582874677,822.9717474449608,822.9696390420418,
	822.9675330686067,822.9654295238594,822.9633283958646,822.961229690353,822.9591333910133,
	822.9570394978963,822.9549480060981,822.9528589041571,822.9507721936016,822.948687863273,
	822.9466059077788,822.9445263276173,822.9424491120981,822.9403742508498,822.938301750115,
	822.93623159974,822.934163792155,822.9320983283526,822.9300351994412,822.9279743874112,
	822.9259159048528,822.9238597458094,822.9218058886636,822.9197543450007,822.9177051063339,
	822.9156581603263,822.9136135135683,822.9115711430493,822.9095310547999,822.9074932424173,
	822.9054577073723,822.9034244415487,822.9013934276572,822.8993646706741,822.8973381681602,
	822.8953139100979,822.8932918921993,822.8912721123965,822.8892545619259,822.8872392418914,
	822.8852261352677,822.8832152465762,822.8812065783712,822.879200110446,822.8771958345615,
	822.8751937668193,822.8731938855193,822.8711961911297,822.8692006807651,822.8672073510216,
	822.8652161923986,822.8632272005996,822.8612403633069,822.859255700185,822.8572731762516,
	822.8552928010926,822.8533145782861,822.8513384905013,822.8493645354315,822.847392715096,
	822.8454230263684,822.843455446111,822.8414899890432,822.8395266418237,822.8375654001103,
	822.8356062632002,822.8336492244813,822.8316942763194,822.8297414203458,822.8277906475223,
	822.8258419559459,822.8238953418784,822.8219507975074,822.8200083108553,822.8180678951448,
	822.8161295364215,822.8141932317782,822.8122589781393,822.8103267695263,822.8083965920971,
	822.8064684579635,822.804542352904,822.802618275189,822.8006962236682,822.7987761907171,
	822.7968581703473,822.794942163828,822.7930281551918,822.7911161519588,822.7892061519535,
	822.7872981388609,822.7853921138523,822.7834880785393,822.7815860216406,822.7796859432642,
	822.777787835696,822.7758916989734,822.7739975221814,822.7721053122917,822.7702150518583,
	822.7683267470363,822.7664403904982,822.7645559711058,822.762673504092,822.7607929638522,
	822.7589143616455,822.7570376812218,822.7551629239363,822.7532900854133,822.7514191684966,
	822.7495501602655,822.7476830671653,822.7458178741291,822.7439545772351,822.7420931845229,
	822.7402336781751,822.7383760551946,822.7365203260831,822.7346664751466,822.7328145002014,
	822.730964400418,822.7291161678519,822.7272697992324,822.7254252966043,822.7235826468045,
	822.721741859336,822.719902913197,822.718065825644,822.7162305681727,822.7143971577577,
	822.7125655780751,822.7107358381768,822.7089079199034,822.707081828724,822.7052575536567,
	822.7034351034484,822.7016144552862,822.6997956226128,822.6979785989083,822.6961633839065,
	822.69434995492,822.6925383221204,822.6907284935917,822.6889204452532,822.6871141780537,
	822.6853097043015,822.6835069965709,822.6817060658806,822.6799069080797,822.6781095154593,
	822.6763138859201
	}},
	{ // Ri = 250k
	-20,20,50,2001, {
	1169.6765993724734,1169.0208057675259,1168.3659269756686,1167.7119619531907,1167.0589096582794,
	1166.4067690518293,1165.7555390967755,1165.1052187584373,1164.4558070045434,1163.8073028048918,
	1163.1597051318488,1162.513012959748,1161.8672252654628,1161.2223410279921,1160.5783592285666,
	1159.935278850938,1159.2930988807836,1158.6518183060234,1158.0114361173926,1157.3719513069734,
	1156.7333628698623,1156.095669802877,1155.4588711053002,1154.8229657785384,1154.1879528263241,
	1153.5538312544772,1152.920600070797,1152.288258285911,1151.6568049119396,1151.026238963725,
	1150.396559457884,1149.7677654133495,1149.1398558513572,1148.5128297951262,1147.8866862700122,
	1147.2614243036496,1146.6370429257865,1146.0135411682909,1145.390918065122,1144.769172652318,
	1144.1483039681975,1143.528311053056,1142.9091929495557,1142.2909487019065,1141.6735773569744,
	1141.0570779635336,1140.4414495723436,1139.8266912363931,1139.2128020105565,1138.5997809521193,
	1137.9876271200233,1137.3763395755782,1136.765917381952,1136.1563596044743,1135.54766531053,
	1134.9398335693384,1134.332863452558,1133.726754033454,1133.1215043875316,1132.5171135923135,
	1131.9135807272237,1131.3109048737367,1130.709085115374,1130.1081205376884,1129.5080102279787,
	1128.9087532758372,1128.310348772736,1127.7127958120195,1127.1160934890308,1126.520240901184,
	1125.9252371475955,1125.3310813296625,1124.737772550508,1124.1453099153193,1123.5536925310835,
	1122.9629195067937,1122.3729899533064,1121.783902983546,1121.1956577121298,1120.608253255783,
	1120.0216887330157,1119.4359632642995,1118.8510759719177,1118.267025980028,1117.6838124147857,
	1117.1014344040905,1116.5198910779259,1115.9391815676786,1115.3593050071433,1114.7802605316335,
	1114.202047278306,1113.624664386367,1113.0481109966395,1112.472386251952,1111.8974892967738,
	1111.3234192774362,1110.7501753422207,1110.177756641082,1109.6061623257851,1109.0353915500245,
	1108.4654434691192,1107.8963172401648,1107.3280120221498,1106.7605269757566,1106.1938612635577,
	1105.628014049687,1105.062984500142,1104.4987717827769,1103.9353750669409,1103.372793523956,
	1102.8110263267317,1102.2500726499845,1101.6899316700294,1101.1306025651222,1100.5720845149995,
	1100.0143767013267,1099.457478307086,1098.9013885174254,1098.3461065189915,1097.7916314999084,
	1097.2379626501815,1096.6850991616336,1096.1330402273807,1095.5817850424974,1095.031332803556,
	1094.4816827088928,1093.9328339582876,1093.3847857534577,1092.8375372974456,1092.2910877950178,
	1091.7454364527691,1091.2005824785554,1090.6565250821252,1090.1132634747655,1089.5707968691681,
	1089.029124479869,1088.4882455228656,1087.948159215628,1087.4088647774834,1086.8703614290341,
	1086.332648392676,1085.7957248922119,1085.2595901529412,1084.7242434018383,1084.1896838674845,
	1083.6559107797032,1083.1229233701947,1082.590720871938,1082.05930251947,1081.5286675488014,
	1080.9988151975951,1080.4697447048404,1079.941455311184,1079.413946258555,1078.8872167905124,
	1078.3612661520692,1077.8360935895648,1077.3116983510283,1076.788079685771,1076.2652368446138,
	1075.7431690797546,1075.2218756449283,1074.7013557951852,1074.1816087871698,1073.662633878729,
	1073.144430329235,1072.626997399544,1072.1103343516907,1071.5944404494094,1071.0793149573067,
	1070.5649571421375,1070.0513662712835,1069.5385416138702,1069.026482440423,1068.5151880226347,
	1068.004657633655,1067.4948905478675,1066.985886041205,1066.477643390704,1065.970161874931,
	1065.463440773549,1064.9574793676186,1064.452276939625,1063.9478327731674,1063.4441461533506,
	1062.9412163663058,1062.4390426995546,1061.937624441997,1061.436960883561,1060.9370513158965,
	1060.4378950312216,1059.9394913236165,1059.4418394881038,1058.944938820877,1058.4487886195543,
	1057.9533881828866,1057.4587368108187,1056.9648338045793,1056.4716784664001,1055.9792701000354,
	1055.4876080100444,1054.9966915025318,1054.506519884403,1054.0170924640388,1053.5284085509516,
	1053.0404674555584,1052.5532684897585,1052.06681096624,1051.5810941991188,1051.0961175034754,
	1050.6118801955383,1050.1283815927225,1049.64562101338,1049.1635977772014,1048.682311204805,
	1048.2017606178288,1047.7219453391906,1047.2428646926987,1046.7645180032998,1046.2869045970426,
	1045.8100238009401,1045.3338749431189,1044.8584573526005,1044.3837703596096,1043.90981329539,
	1043.4365854920318,1042.9640862827255,1042.4923150016682,1042.021270984077,1041.550953566105,
	1041.0813620848307,1040.6124958785226,1040.1443542860818,1039.6769366476133,1039.2102423040924,
	1038.7442705974229,1038.2790208704703,1037.8144924670255,1037.350684731747,1036.8875970102192,
	1036.4252286490398,1035.9635789954586,1035.502647397936,1035.0424332055097,1034.5829357682499,
	1034.1241544370562,1033.66608856373,1033.2087375008498,1032.7521006018587,1032.2961772210308,
	1031.8409667135963,1031.386468435306,1030.9326817429414,1030.4796059941468,1030.0272405471455,
	1029.5755847610797,1029.1246379958843,1028.674399612199,1028.2248689714395,1027.7760454358859,
	1027.3279283683448,1026.8805171325603,1026.4338110928745,1025.9878096144244,1025.5425120631066,
	1025.0979178054176,1024.6540262085077,1024.2108366404123,1023.7683484696441,1023.3265610656374,
	1022.8854737981812,1022.4450860378811,1022.0053971560707,1021.566406524529,1021.1281135157492,
	1020.6905175029524,1020.2536178598453,1019.8174139606908,1019.3819051805543,1018.9470908949182,
	1018.512970479843,1018.0795433120527,1017.6468087686587,1017.2147662276307,1016.783415067137,
	1016.3527546661184,1015.9227844039413,1015.4935036604551,1015.0649118160754,1014.6370082517874,
	1014.2097923488543,1013.7832634893007,1013.3574210553086,1012.9322644296903,1012.5077929957621,
	1012.0840061371969,1011.6609032381263,1011.2384836830541,1010.8167468569812,1010.3956921453059,
	1009.9753189337031,1009.5556266083463,1009.1366145558311,1008.7182821629308,1008.3006288169962,
	1007.8836539055073,1007.4673568165298,1007.0517369382264,1006.6367936591943,1006.222526368374,
	1005.8089344548712,1005.3960173081387,1004.9837743180209,1004.57220487446,1004.1613083677572,
	1003.7510841884222,1003.3415317272764,1002.9326503752329,1002.5244395235106,1002.1168985635567,
	1001.7100268870113,1001.3038238855481,1000.8982889512874,1000.4934214763266,1000.0892208529104,
	999.6856864734839,999.2828177306775,998.8806140171163,998.4790747256759,998.0781992492688,
	997.6779869809001,997.2784373136296,996.8795496405864,996.4813233550439,996.0837578502635,
	995.6868525194806,995.2906067560558,994.8950199534403,994.5000915047652,994.1058208034815,
	993.7122072429592,993.319250216379,992.9269491170404,992.5353033381565,992.1443122727959,
	991.7539753140412,991.3642918548644,990.9752612881201,990.5868830065333,990.1991564028297,
	989.8120808694314,989.4256557986912,989.0398805828183,988.6547546138324,988.2702772836125,
	987.8864479837448,987.5032661056968,987.1207310407174,986.7388421797585,986.3575989135817,
	985.9770006326805,985.5970467273572,985.2177365874717,984.8390696026675,984.4610451623665,
	984.0836626555437,983.7069214709518,983.3308209969177,982.9553606214904,982.5805397322141,
	982.206357716446,981.8328139609733,981.4599078523456,981.0876387764866,980.7160061190372,
	980.3450092651826,979.9746475995421,979.6049205064489,979.2358273695219,978.8673675720436,
	978.499540496798,978.1323455258098,977.7657820408245,977.39984942301,977.034547052798,
	976.6698743101703,976.305830574452,975.942415224416,975.5796276381238,975.2174671931225,
	974.8559332661602,974.4950252335059,974.1347424705239,973.7750843520457,973.4160502521247,
	973.0576395441102,972.699851600636,972.3426857935414,971.9861414939629,971.630218072063,
	971.274914897552,970.9202313389413,970.5661667642337,970.2127205403672,969.8598920335356,
	969.5076806090497,969.1560856312756,968.8051064637835,968.4547424690779,968.1049930088183,
	967.7558574438165,967.4073351336667,967.0594254371862,966.7121277122062,966.3654413153008,
	966.0193656022734,965.6738999278293,965.3290436454932,964.9847961079,964.6411566664287,
	964.2981246714136,963.9556994719917,963.6138804163845,963.2726668513608,962.9320581227215,
	962.5920535749547,962.252652551442,961.9138543941797,961.5756584441401,961.2380640408605,
	960.9010705226958,960.5646772266458,960.2288834884125,959.893688642458,959.559092021759,
	959.2250929580464,958.891690781624,958.5588848212901,958.2266744046553,957.8950588576464,
	957.5640375050081,957.2336096697361,956.9037746735689,956.5745318365322,956.2458804774137,
	955.9178199130675,955.5903494591845,955.2634684295693,954.9371761366195,954.6114718910022,
	954.2863550018145,953.9618247765047,953.6378805207872,953.3145215386861,952.9917471326215,
	952.6695566031973,952.3479492492683,952.0269243678882,951.7064812544055,951.3866192022956,
	951.0673375032673,950.748635447129,950.4305123218078,950.1129674133754,949.7960000060743,
	949.4796093820152,949.1637948215372,948.8485556029825,948.5338910026524,948.2198002949024,
	947.9062827519916,947.5933376441668,947.2809642395553,946.9691618043522,946.6579296024319,
	946.3472668956264,946.0371729436533,945.7276470040067,945.4186883319176,945.1102961805776,
	944.8024698008218,944.4952084411177,944.1885113479784,943.8823777651282,943.5768069344457,
	943.2717980951736,942.9673504842592,942.6634633362094,942.3601358832378,942.0573673550228,
	941.7551569787912,941.4535039792631,941.1524075787637,940.851866996912,940.551881451016,
	940.2524501554767,939.9535723224138,939.6552471611735,939.3574738784702,939.0602516784024,
	938.7635797622448,938.4674573287399,938.1718835737884,937.8768576904342,937.5823788691741,
	937.2884462974586,936.9950591600546,936.7022166388363,936.4099179126773,936.1181621577239,
	935.8269485471042,935.5362762509593,935.2461444364782,934.9565522679318,934.6674989062824,
	934.3789835097687,934.0910052333121,933.8035632289002,933.5166566452375,933.230284627935,
	932.944446319478,932.659140858988,932.3743673824608,932.0901250226246,931.8064129089032,
	931.5232301673897,931.2405759208737,930.958449288676,930.6768493869116,930.3957753280641,
	930.115226221365,929.8352011723571,929.5556992833099,929.2767196527307,928.9982613757749,
	928.7203235439052,928.4429052450433,928.1660055633067,927.8896235793779,927.6137583700977,
	927.3384090085483,927.0635745642394,926.789254102769,926.5154466859439,926.2421513717027,
	925.9693672142305,925.6970932636862,925.4253285664707,925.1540721648846,924.8833230972763,
	924.6130803980308,924.3433430974707,924.0741102218968,923.8053807934399,923.5371538302057,
	923.2694283459656,923.0022033505207,922.7354778493449,922.4692508436508,922.2035213304457,
	921.9382883023403,921.6735507477259,921.4093076504788,921.1455579902241,920.8823007420674,
	920.619534876745,920.3572593603338,920.0954731546763,919.8341752167195,919.5733644990381,
	919.3130399496126,919.0532005116621,918.7938451238148,918.534972719908,918.2765822291561,
	918.0186725758329,917.7612426796336,917.5042914551764,917.2478178123828,916.9918206561504,
	916.7362988865825,916.4812513986207,916.2266770824679,915.9725748229716,915.7189435002309,
	915.4657819890365,915.2130891590698,914.9608638749198,914.7091049959347,914.4578113762361,
	914.2069818646476,913.9566153047243,913.7067105347186,913.4572663873954,913.2082816902182,
	912.9597552652996,912.7116859290243,912.4640724924185,912.2169137610018,911.9702085347334,
	911.7239556077285,911.4781537687404,911.2328018007178,910.9878984809188,910.7434425807488,
	910.4994328660051,910.2558680964848,910.0127470262235,909.7700684033289,909.5278309699933,
	909.286033462423,909.0446746108369,908.8037531393961,908.5632677662124,908.3232172032424,
	908.0836001563014,907.8444153250985,907.6056614029968,907.3673370771317,907.1294410284039,
	906.8919719313396,906.654928454064,906.4183092582788,906.1821129993622,905.9463383260937,
	905.7109838806979,905.4760482989652,905.2415302100442,905.00742823633,904.7737409936599,
	904.5404670911695,904.3076051311587,904.0751537092459,903.843111414035,903.6114768275231,
	903.3802485245908,903.1494250732642,902.9190050345351,902.688986962396,902.4593694038558,
	902.2301508986221,902.0013299794974,901.7729051719024,901.5448749942558,901.3172379574426,
	901.0899925652387,900.8631373140014,900.6366706928128,900.4105911831816,900.184897259269,
	899.9595873876675,899.7346600275243,899.5101136302698,899.2859466397819,899.0621574923254,
	898.83874461641,898.6157064327132,898.393041354332,898.1707477863406,897.948824126037,
	897.7272687628434,897.5060800781073,897.2852564453498,897.0647962299429,896.8446977892095,
	896.6249594723199,896.4055796203822,896.1865565662811,895.9678886345455,895.7495741415922,
	895.5316113953809,895.3139986955358,895.0967343333507,894.8798165915935,894.6632437444554,
	894.4470140577929,894.2311257887576,894.0155771858252,893.8003664890047,893.5854919293893,
	893.3709517295034,893.1567441029315,892.942867254424,892.7293193800557,892.5160986667387,
	892.3032032925552,892.0906314265652,891.8783812287663,891.6664508500295,891.4548384321557,
	891.2435421078042,891.0325600002135,890.8218902235963,890.6115308827235,890.4014800730813,
	890.1917358807353,889.9822963822289,889.7731596447367,889.5643237259475,889.3557866737758,
	889.1475465268022,888.9396013137126,888.7319490536388,888.5245877558813,888.3175154200233,
	888.1107300357774,887.9042295829893,887.69801203166,887.4920753416668,887.2864174630146,
	887.0810363356151,886.8759298893201,886.6710960438187,886.4665327086036,886.2622377829709,
	886.0582091559216,885.8544447062322,885.6509423021072,885.447699801724,885.2447150523906,
	885.0419858912489,884.8395101447231,884.6372856288075,884.4353101487502,884.2335814991935,
	884.0320974640899,883.8308558166282,883.629854319141,883.4290907232783,883.2285627697096,
	883.0282681881351,882.8282046972646,882.6283700050247,882.4287618080717,882.2293777919984,
	882.0302156313543,881.8312729892888,881.6325475180034,881.4340368583063,881.2357386395553,
	881.0376504799225,880.8397699861874,880.642094753535,880.444622365831,880.2473503952081,
	880.0502764025118,879.8533979367088,879.6567125352299,879.4602177238523,879.2639110163637,
	879.0677899150572,878.8718519103068,878.6760944805491,878.4805150923672,878.2851112002791,
	878.0898802469615,877.8948196630902,877.6999268669922,877.5051992650657,877.3106342515481,
	877.1162292084292,876.9219815054155,876.7278884999483,876.5339475372552,876.3401559499832,
	876.1465110584783,875.9530101706828,875.75965058197,875.5664295751897,875.3733444205938,
	875.1803923758774,874.9875706861424,874.794876583527,874.6023072877666,874.4098600055596,
	874.2175319309587,874.0253202450568,873.8332221161785,873.6412346995894,873.449355137614,
	873.257580559607,873.0659080818815,872.8743348076075,872.6828578268605,872.491474216584,
	872.3001810405012,872.1089753490844,871.9178541794809,871.7268145556272,871.5358534881303,
	871.3449679740542,871.1541549971846,870.9634115278249,870.7727345227468,870.5821209251881,
	870.391567664862,870.2010716578839,870.0106298067315,869.8202390001136,869.6298961131943,
	869.4395980073338,869.2493415300881,869.0591235151759,868.8689407826525,868.678790138467,
	868.4886683748108,868.2985722699391,868.1084985880234,867.9184440793838,867.7284054802307,
	867.5383795126348,867.348362884668,867.1583522903555,866.9683444092757,866.7783359071386,
	866.5883234352949,866.3983036307792,866.2082731165044,866.018228500911,865.8281663782564,
	865.6380833283821,865.4479759166397,865.2578406941501,865.0676741973688,864.8774729484669,
	864.6872334550924,864.4969522102308,864.306625692449,864.1162503657124,863.9258226793972,
	863.7353390681642,863.5447959521144,863.3541897366916,863.1635168125265,862.972773555656,
	862.7819563273332,862.5910614740147,862.4000853274638,862.2090242044775,862.0178744072078,
	861.8266322228028,861.635293923643,861.4438557671764,861.2523139959607,861.0606648377023,
	860.8689045049248,860.6770291954659,860.4850350920328,860.2929183624608,860.1006751593917,
	859.9083016206181,859.7157938687537,859.523148011416,859.3303601412475,859.1374263356157,
	858.9443426569634,858.7511051525206,858.5577098543731,858.3641527796257,858.1704299300901,
	857.976537292436,857.7824708382641,857.5882265239358,857.3938002905793,857.1991880643051,
	857.0043857558284,856.8093892607786,856.6141944595208,856.4187972172524,856.2231933838445,
	856.0273787942236,855.8313492676181,855.6351006085328,855.4386286058912,855.2419290336389,
	855.0449976501458,854.8478301989815,854.6504224081584,854.4527699906436,854.2548686441526,
	854.056714051195,853.8583018790254,853.6596277797875,853.4606873904729,853.261476332813,
	853.0619902135207,852.8622246242007,852.6621751413053,852.4618373263185,852.2612067256125,
	852.0602788707679,851.8590492783164,851.6575134500101,851.4556668726993,851.2535050188684,
	851.0510233461604,850.848217297841,850.6450823029293,850.4416137761165,850.2378071183565,
	850.0336577168467,849.8291609451394,849.6243121639058,849.419106721043,849.2135399520495,
	849.0076071808365,848.8013037199131,848.5946248717938,848.3875659292622,848.1801221766633,
	847.9722888912515,847.7640613444217,847.5554348036333,847.3464045344682,847.1369658029926,
	846.9271138787201,846.7168440378756,846.5061515680015,846.2950317721438,846.0834799752012,
	845.8714915303848,845.6590618276758,845.4461863034646,845.2328604519369,845.0190798392247,
	844.804840119438,844.5901370546153,844.3749665379593,844.1593246219037,843.9432075516378,
	843.726611805368,843.5095341421902,843.2919716605106,843.0739218674894,842.8553827632282,
	842.6363529421692,842.416831716302,842.1968192636306,841.9763168091923,841.7553268448552,
	841.5338533966342,841.3119023506505,841.0894818503241,840.8666027807726,840.6432793581283,
	840.4195298460419,840.1953774238602,839.9708512335644,839.7459876340037,839.5208316921115,
	839.295438934914,839.0698773795099,838.8442298439453,838.6185965160133,838.3930977272922,
	838.1678768325562,837.9431030420743,837.7189739964294,837.4957178123872,837.2735942836488,
	837.0528948997694,836.8339413615425,836.6170823426055,836.4026883638986,836.1911448222675,
	835.982843407331,835.778172343044,835.5775060549631,835.3811949625006,835.1895561098595,
	835.0028652726821,834.8213510206365,834.6451910122735,834.474510579544,834.309383455378,
	834.1498343446972,833.9958429392576,833.8473489349352,833.7042576291319,833.5664457152371,
	833.4337669712481,833.3060576108527,833.1831411458064,833.0648326738261,832.9509425568634,
	832.841279502006,832.7356530734114,832.6338756946118,832.5357641947197,832.4411409680603,
	832.3498348011833,832.2616814311547,832.1765238809612,832.09421261881,832.0146055798982,
	831.9375680797456,831.8629726501705,831.790698815648,831.7206328292766,831.6526673834186,
	831.5867013017372,831.5226392275308,831.4603913097309,831.3998728909379,831.341004208106,
	831.2837100981702,831.2279197204064,831.173566287458,831.1205868136776,831.0689218745283,
	831.0185153827649,830.9693143749614,830.9212688127736,830.8743313987936,830.8284573997212,
	830.7836044859605,830.7397325789466,830.6968037094526,830.654781886722,830.6136329748794,
	830.5733245765592,830.5338259302783,830.4951078069893,830.4571424186116,830.4199033334116,
	830.3833653919858,830.3475046349579,830.3122982316995,830.2777244158849,830.2437624225086,
	830.210392432062,830.1775955184787,830.145353596235,830.1136493770093,830.0824663242394,
	830.051788612004,830.0216010884376,829.991889239051,829.9626391526573,829.9338374896075,
	829.9054714544061,829.877528765634,829.8499976298982,829.8228667196736,829.7961251479811,
	829.7697624466044,829.7437685473966,829.7181337609069,829.6928487606137,829.6679045633116,
	829.6432925146008,829.6190042732939,829.595031795769,829.5713673255725,829.5480033764791,
	829.5249327230457,829.5021483883015,829.4796436336375,829.4574119447128,829.435447029473,
	829.4137427983446,829.3922933658175,829.3710930349262,829.3501362921659,829.3294177995787,
	829.3089323877537,829.2886750489708,829.2686409286913,829.2488253237119,829.2292236727486,
	829.2098315512235,829.1906446680449,829.1716588575454,829.152870077817,829.1342744026622,
	829.1158680194123,829.0976472266834,829.0796084253363,829.0617481169427,829.0440629026087,
	829.0265494759553,829.0092046218313,828.9920252108147,828.975008200661,828.9581506275379,
	828.9414496078908,828.9249023321053,828.908506066157,828.8922581463929,828.8761559750141,
	828.8601970227855,828.8443788244816,828.8286989754256,828.8131551310134,828.7977450050145,
	828.7824663670568,828.7673170407255,828.7522949024485,828.7373978791317,828.7226239483753,
	828.7079711326422,828.6934375037031,828.6790211770797,828.6647203109991,828.6505331068373,
	828.6364578064771,828.6224926931698,828.6086360860064,828.594886343993,828.5812418597803,
	828.567701064898,828.5542624215261,828.5409244267286,828.5276856121227,828.5145445361663,
	828.5014997932121,828.4885500026672,828.4756938154734,828.4629299089551,828.4502569905619,
	828.4376737919735,828.4251790709418,828.4127716126792,828.4004502221519,828.3882137339824,
	828.3760610025656,828.363990905555,828.3520023427626,828.3400942368975,828.3282655292684,
	828.3165151822091,828.3048421802142,828.2932455228903,828.2817242346302,828.2702773508045,
	828.2589039331659,828.2476030559912,828.23637380889,828.2252153031051,828.2141266638635,
	828.2031070317425,828.1921555618326,828.1812714300526,828.1704538194545,828.1597019316803,
	828.1490149847536,828.1383922046018,828.1278328358704,828.1173361341403,828.1069013658945,
	828.0965278145661,828.0862147736525,828.075961547998,828.0657674545179,828.0556318233934,
	828.0455539935895,828.0355333157368,828.0255691508609,828.0156608743555,828.005807865223,
	827.996009518764,827.9862652368146,827.9765744309794,827.9669365220548,827.9573509422411,
	827.9478171312303,827.9383345368715,827.9289026176934,827.9195208381965,827.9101886746795,
	827.9009056069195,827.8916711256472,827.882484730467,827.8733459262608,827.8642542281344,
	827.8552091516405,827.8462102307963,827.8372569972798,827.8283489918632,827.8194857678274,
	827.8106668749361,827.8018918790242,827.7931603456636,827.7844718515305,827.7758259766164,
	827.7672223079394,827.7586604363274,827.7501399614838,827.7416604887936,827.7332216264729,
	827.724822993156,827.716464202779,827.7081448882352,827.6998646758724,827.6916232048907,
	827.6834201150857,827.6752550540913,827.6671276719222,827.6590376247677,827.6509845703705,
	827.6429681795327,827.6349881161128,827.6270440573204,827.6191356814796,827.6112626679401,
	827.6034247065832,827.5956214892283,827.5878527062462,827.5801180604393,827.5724172517054,
	827.5647499886862,827.5571159821042,827.5495149450354,827.5419465951888,827.5344106521125,
	827.526906845823,827.5194348966514,827.5119945438751,827.5045855192345,827.4972075607593,
	827.4898604117187,827.4825438147172,827.4752575203242,827.4680012755886,827.4607748392023,
	827.4535779638965,827.4464104125485,827.4392719471435,827.4321623331404,827.4250813399417,
	827.4180287397907,827.4110043034711,827.4040078081637,827.3970390341593,827.3900977640403,
	827.3831837810903,827.376296874265,827.369436829212,827.3626034413785,827.3557965024297,
	827.3490158105275,827.3422611626889,827.3355323653017,827.3288292156938,827.3221515217543,
	827.3154990932738,827.3088717364554,827.3022692656197,827.2956914950742,827.2891382412539,
	827.28260932166,827.2761045575994,827.269623771088,827.2631667842528,827.2567334280211,
	827.2503235264869,827.2439369101048,827.2375734111794,827.2312328639558,827.2249151002494,
	827.2186199635586,827.2123472871402,827.206096913154,827.1998686832767,827.1936624462479,
	827.1874780402264,827.1813153149571,827.1751741222524,827.1690543070472,827.1629557269816,
	827.156878229297,827.1508216739504,827.1447859145343,827.1387708121264,827.1327762218781,
	827.1268020053232,827.1208480261286,827.1149141461578,827.1090002329462,827.1031061500684,
	827.097231765644,827.0913769480386,827.0855415703197,827.0797255005565,827.0739286118604,
	827.0681507820883,827.0623918822614,827.0566517880073,827.0509303799518,827.0452275350103,
	827.0395431343438,827.033877060403,827.0282291927974,827.0225994145202,827.0169876116338,
	827.0113936686944,827.0058174758532,827.0002589156006,826.99471788062,826.9891942585895,
	826.9836879422821,826.9781988220635,826.9727267928702,826.967271744721,826.9618335768777,
	826.9564121792775,826.9510074560566,826.9456193028357,826.9402476156777,826.934892293417,
	826.9295532404474,826.9242303553624,826.9189235424853,826.9136327053858,826.9083577464285,
	826.9030985690273,826.8978550827168,826.8926271914544,826.8874148039697,826.8822178249455,
	826.8770361691687,826.8718697449256,826.8667184613081,826.8615822294879,826.8564609640017,
	826.85135457416,826.8462629769684,826.8411860862345,826.8361238155524,826.8310760803133,
	826.8260428018883,826.821023894989,826.8160192743738,826.8110288623817,826.8060525798553,
	826.8010903435841,826.7961420761874,826.7912076973527,826.7862871318822,826.7813803019172,
	826.7764871291715,826.7716075366448,826.7667414556952,826.7618888047404,826.7570495136222,
	826.7522235028938,826.7474107072876,826.7426110502635,826.7378244615184,826.7330508719874,
	826.7282902071245,826.7235423992931,826.7188073765207,826.7140850739162,826.7093754223271,
	826.7046783499794,826.6999937953647,826.6953216909517,826.6906619673739,826.6860145595547,
	826.6813794026831,826.6767564350378,826.672145588724,826.6675468051587,826.6629600143349,
	826.6583851618728,826.653822180875,826.6492710071919,826.6447315845174,826.6402038500679,
	826.6356877442947,826.6311832073939,826.6266901783989,826.6222086035948,826.6177384196735,
	826.6132795682444,826.608831996424,826.6043956441898,826.5999704535968,826.5955563724249,
	826.5911533431223,826.5867613051856,826.582380214385,826.5780100055488,826.573650633767,
	826.5693020360676,826.5649641650418,826.5606369695528,826.5563203915169,826.5520143845565,
	826.5477188897911,826.5434338619003,826.5391592486651,826.534894998236,826.5306410595919,
	826.526397384906,826.522163924875,826.5179406291594,826.5137274445223,826.5095243299821,
	826.5053312345701,826.5011481115221,826.4969749106519,826.492811586022,826.4886580916218,
	826.4845143817354,826.4803804059767,826.4762561247109,826.4721414874948,826.4680364505361,
	826.463940970869,826.4598550031608,826.4557785034211,826.4517114209975,826.4476537272286,
	826.4436053671373,826.439566296617,826.4355364796818,826.4315158708426,826.4275044268448,
	826.423502105408,826.4195088720729,826.4155246807337,826.4115494839097,826.407583251135,
	826.403625934593,826.3996775004267,826.3957379034748,826.3918071085797,826.3878850745654,
	826.3839717576269,826.3800671245516,826.3761711395682,826.3722837521533,826.3684049396638,
	826.364534652145,826.3606728581452,826.3568195212848,826.3529745979907,826.3491380576601,
	826.3453098612833,826.3414899725337,826.3376783556308,826.3338749747104,826.330079796675,
	826.3262927830089,826.3225138958036,826.3187431052022,826.3149803741143,826.3112256687252,
	826.3074789541357,826.3037401949937,826.3000093625984,826.2962864170155,826.2925713309108,
	826.2888640660663,826.2851645903662,826.2814728722146,826.277788877147,826.2741125795402,
	826.2704439336368,826.2667829216145,826.2631295066312,826.2594836546024,826.2558453339753,
	826.2522145157576,826.2485911734328,826.2449752663291,826.2413667703387,826.237765653133,
	826.234171883978,826.2305854369463,826.2270062745159,826.2234343743627,826.2198697054662,
	826.2163122359069,826.212761936438,826.2092187813577,826.2056827375472,826.2021537808298,
	826.1986318801981,826.1951170040998,826.1916091318398,826.188108232124,826.1846142729794,
	826.1811272320092,826.1776470827846,826.1741737947436,826.1707073395339,826.1672476944416,
	826.1637948309656,826.1603487228062,826.1569093400448,826.153476661818,826.150050652231,
	826.1466312997175,826.1432185635421,826.1398124304507,826.1364128713226,826.1330198542921,
	826.1296333580727,826.1262533617502,826.1228798363292,826.1195127587225,826.1161521006496,
	826.1127978390081,826.1094499562179,826.1061084112406,826.1027732010994,826.0994442859022,
	826.09612164753,826.0928052655242,826.0894951121657,826.0861911616179,826.0828933945378,
	826.0796017825247,826.0763163128854,826.0730369555566,826.0697636875667,826.066496487479,
	826.063235331327,826.0599801953549,826.0567310660136,826.053487912895,826.0502507143796,
	826.0470194513457,826.0437940951615,826.0405746384289,826.0373610459885,826.0341533010208,
	826.0309513855419,826.0277552724316,826.0245649456969,826.0213803793415,826.0182015520157,
	826.0150284488874,826.0118610498436,826.0086993279933,826.0055432600493,826.0023928423885,
	825.9992480379609,825.9961088322323,825.9929752040607,825.9898471400505,825.9867246110524,
	825.9836076006465,825.9804960948774,825.9773900666951,825.9742895002205,825.9711943758546,
	825.9681046714026,825.9650203723135,825.9619414570356,825.9588679117056,825.9557997133721,
	825.9527368388291,825.949679275311,825.9466270027635,825.9435800080414,825.9405382635169,
	825.9375017550258,825.9344704636117,825.931444377856,825.9284234744489,825.9254077289377,
	825.922397136701,825.9193916714486,825.9163913161278,825.913396058395,825.9104058735667,
	825.9074207533924,825.9044406747423,825.9014656181396,825.8984955703423,825.8955305155598,
	825.892570438509,825.8896153167926,825.8866651322106,825.8837198776183,825.8807795274653,
	825.8778440691873,825.8749134900993,825.8719877673132,825.8690668867376,825.8661508351008,
	825.8632395920071,825.8603331443533,825.857431477314,825.854534571521,825.8516424118093,
	825.8487549886091,825.8458722773021,825.8429942698293,825.8401209478635,825.8372522947539,
	825.8343882978942,825.8315289402933,825.8286742005834,825.8258240808015,825.8229785521163,
	825.8201375992408,825.8173012151327,825.8144693833361,825.8116420846774,825.8088193046567,
	825.8060010362565,825.8031872565341,825.8003779574516,825.7975731196718,825.7947727282937,
	825.7919767774988,825.7891852437493,825.7863981178291,825.7836153842394,825.7808370286384,
	825.7780630423699,825.775293401051,825.7725281000485,825.7697671259194,825.7670104608464,
	825.7642580903781,825.7615100069428,825.7587661861312,825.7560266282832,825.7532913210517,
	825.7505602292674,825.7478333587809,825.7451106973152,825.7423922219788,825.73967792993,
	825.7369677950097,825.734261819546,825.7315599847027,825.7288622702991,825.7261686700334,
	825.7234791780528,825.7207937695493,825.7181124407355,825.715435173775,825.7127619578589,
	825.7100927809366,825.7074276335248,825.7047664992683,825.7021093681467,825.6994562313591,
	825.6968070666081,825.6941618756368,825.6915206326603,825.6888833328113,825.6862499686796,
	825.6836205205353,825.680994980833,825.6783733354961,825.6757555757947,825.6731416875336,
	825.6705316624742,825.6679254858147,825.665323147822,825.6627246353617,825.6601299387119,
	825.6575390466637,825.6549519501649,825.6523686320439,825.6497890872585,825.6472133027866,
	825.6446412653418,825.6420729645508,825.6395083898417,825.6369475321983,825.6343903808483,
	825.631836922922,825.629287150451,825.6267410493421,825.6241986124627,825.6216598269712,
	825.6191246767924,825.6165931645663,825.6140652728972,825.611540992512,825.6090203046757,
	825.6065032114487,825.6039896929483,825.6014797458519,825.5989733541078,825.5964705145155,
	825.5939712111136,825.5914754361396,825.5889831817361,825.5864944328678,825.5840091816008,
	825.5815274222963,825.5790491385446,825.5765743267107,825.5741029685871,825.5716350652032,
	825.5691705985844,825.5667095607713,825.5642519469947,825.5617977475149,825.5593469420764,
	825.5568995283616,825.5544554987907,825.5520148455233,825.5495775572482,825.5471436146955,
	825.5447130216071,825.542285767869,825.5398618342097,825.5374412207047,825.5350239187952,
	825.5326099109826,825.5301991939197,825.5277917608315,825.5253875994335,825.5229867011678,
	825.5205890537644,825.5181946549819,825.5158034961222,825.5134155650752,825.5110308443994,
	825.5086493373518,825.5062710373469,825.5038959278099,825.5015239980668,825.4991552496001,
	825.4967896682906,825.4944272407116,825.4920679686834,825.4897118375718,825.4873588382662,
	825.4850089624825,825.4826622116007,825.480318556918,825.4779780081025,825.4756405529633,
	825.4733061785605,825.4709748797852,825.4686466482275,825.4663214792793,825.4639993602831,
	825.4616802832471,825.4593642378707,825.4570512241207,825.4547412282728,825.4524342396359,
	825.4501302579441,825.4478292777733,825.4455312742847,825.4432362582037,825.4409442129798,
	825.438655127604,825.4363690016316,825.4340858221035,825.4318055852973,825.4295282850192,
	825.4272539117165,825.4249824517132,825.4227139085034,825.420448258519,825.4181855141948,
	825.4159256527033,825.4136686766245,825.4114145673227,825.4091633338569,825.4069149523634,
	825.4046694252526,825.4024267413695,825.4001868943924,825.3979498787232,825.3957156822268,
	825.3934843060528,825.3912557338804,825.389029974027,825.3868069959616,825.3845868117729,
	825.3823694024187,825.3801547705649,825.3779429045106,825.3757337964797,825.3735274357309,
	825.3713238300033,825.3691229569469,825.3669248202717,825.3647294008524,825.3625367086349,
	825.3603467243673,825.3581594393554,825.3559748541737,825.3537929641129,825.3516137584934,
	825.3494372298821,825.3472633712353,825.3450921739316,825.3429236418588,825.3407577513834,
	825.3385945175963,825.3364339113175,825.3342759473765,825.3321206029955,825.3299678792811,
	825.3278177633902,825.3256702685185,825.3235253576801,825.3213830424468,825.3192433258142,
	825.3171061789326,825.3149716111383,825.3128396133427,825.3107101772011,825.3085832972091,
	825.306458961548,825.3043371724076,825.3022179205333,825.3001012148767,825.2979870189627,
	825.2958753442553,825.2937661827764,825.2916595296077,825.2895553771716,825.2874537252974,
	825.2853545560299,825.2832578752104,825.281163673137,825.2790719378078,825.2769826717514,
	825.2748958690166,825.2728115074539,825.2707296044814,825.2686501458945,825.2665731214491,
	825.2644985221561,825.2624263561937,825.2603565999785,825.2582892688466,825.2562243411215,
	825.2541618191326,825.2521016939061,825.250043954011,825.2479886003507,825.2459356307713,
	825.243885035682,825.2418368134541,825.2397909474656,825.2377474396593,825.2357062935971,
	825.2336674881484,825.2316310236536,825.2295968974009,825.2275651041743,825.2255356367833,
	825.2235084862665,825.2214836505105,825.2194611231256,825.2174409046859,825.2154229832412,
	825.2134073566544,825.2113940145164,825.2093829619681,825.2073741765561,825.2053676774538,
	825.2033634416357,825.2013614631253,825.1993617462834,825.1973642810841,825.1953690636883,
	825.193376088482,825.1913853502748,825.1893968418219,825.187410559033,825.1854265025759,
	825.1834446650622,825.1814650392536,825.1794876132739,825.1775123885367,825.1755393659429,
	825.1735685383311,825.1715998916504,825.169633425866,825.1676691491782,825.1657070367977,
	825.1637470958295,825.161789310502,825.1598336884219,825.1578802180969,825.155928901518,
	825.1539797233994,825.1520326846901,825.1500877881773,825.148145007742,825.1462043641875,
	825.1442658353343,825.142329420306,825.1403951164829,825.1384629251012,825.136532829745,
	825.13460483841,825.1326789286198,825.1307551156859,825.1288333811743,825.1269137275324,
	825.1249961486793,825.1230806347774,825.121167201688,825.1192558091727,825.1173464812082,
	825.1154392106566,825.1135339850421,825.1116307964099,825.1097296537487,825.1078305378024,
	825.1059334572992,825.1040384077824,825.1021453702517,825.1002543509675,825.0983653450162,
	825.09647834645,825.0945933565939,825.0927103651485,825.0908293594587,825.0889503523819,
	825.0870733309979,825.0851982997672,825.0833252344929,825.0814541536859,825.0795850372837,
	825.0777178830912,825.0758526962293,825.0739894675717,825.0721281901237,825.0702688610733,
	825.0684114787731,825.0665560345872,825.064702531638,825.0628509603085,825.0610013195509,
	825.0591535984182,825.0573077980955,825.055463921968,825.0536219489411,825.0517818940449,
	825.0499437387398,825.0481074862556,825.0462731265173,825.0444406552531,825.0426100812974,
	825.0407813966957,825.038954586985,825.0371296554154,825.035306590337,825.0334854001082,
	825.031666086676,825.0298486190285,825.0280330146646,825.0262192659,825.0244073677129,
	825.0225973104714,825.0207891052295,825.0189827326062,825.0171781919554,825.0153754867554,
	825.0135746089371,825.0117755520284,825.0099783246799,825.0081829093111,825.0063892992216,
	825.0045975035641,825.0028075151428,825.0010193216781,824.999232934453,824.9974483440018,
	824.9956655359193,824.9938845205259,824.9921052871506,824.9903278307169,824.9885521588108,
	824.9867782487092,824.9850061139614,824.983235745465,824.9814671295559,824.9797002831259,
	824.9779351954343,824.976171849349,824.9744102516319,824.9726504066743,824.9708923031983,
	824.9691359272418,824.967381289902,824.9656283884544,824.963877208741,824.9621277595105,
	824.9603800217425,824.9586340035115,824.9568897048129,824.9551471076376,824.953406219159,
	824.9516670390891,824.9499295559859,824.9481937666853,824.9464596745082,824.944727282314,
	824.9429965622887
	}}
};
