module Main where

import qualified Test.Data.List     as ListHT
import qualified Test.Data.Function as FunctionHT


prefix :: String -> [(String, IO ())] -> [(String, IO ())]
prefix msg =
   map (\(str,test) -> (msg ++ "." ++ str, test))

main :: IO ()
main =
   mapM_ (\(msg,io) -> putStr (msg++": ") >> io) $
   concat $
      prefix "List"     ListHT.tests :
      prefix "Function" FunctionHT.tests :
      []
