<?hh

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.reflection.php )
 *
 * The reflection class.
 *
 */
class Reflection {
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/reflection.export.php )
   *
   * Exports a reflection. Warning: This function is currently not
   * documented; only its argument list is available.
   *
   * @refl       mixed   The reflection to export.
   * @return     mixed   Setting to TRUE will return the export, as opposed
   *                     to emitting it. Setting to FALSE (the default) will
   *                     do the opposite.
   *
   * @return     mixed   If the return parameter is set to TRUE, then the
   *                     export is returned as a string, otherwise NULL is
   *                     returned.
   */
  public static function export(Reflector $refl, $return = false) {
    $s = $refl->__toString();
    if ($return) {
      return $s;
    }
    print $s;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/reflection.getmodifiernames.php
   * )
   *
   * Gets modifier names. Warning: This function is currently not documented;
   * only its argument list is available.
   *
   * @modifiers  mixed   The modifiers to get, which is from a numeric value.
   *
   * @return     mixed   An array of modifier names.
   */
  public static function getModifierNames($modifiers) {
    $ret = array();

    $abstract = ReflectionMethod::IS_ABSTRACT |
                ReflectionClass::IS_EXPLICIT_ABSTRACT;
    $final = ReflectionMethod::IS_FINAL | ReflectionClass::IS_FINAL;
    $implicit_public = 4096;

    $map = array(
      $abstract => 'abstract',
      $final => 'final',
      $implicit_public => 'public'
    );

    $ppp_mask = ReflectionMethod::IS_PUBLIC |
                ReflectionMethod::IS_PRIVATE |
                ReflectionMethod::IS_PROTECTED;

    // match zend on order of which properties are stored
    foreach ($map as $mask => $mod) {
      if ($modifiers & $mask) {
        $ret[] = $mod;
      }
    }
    switch ($modifiers & $ppp_mask) {
      case ReflectionMethod::IS_PUBLIC:     $ret[] = 'public'; break;
      case ReflectionMethod::IS_PRIVATE:    $ret[] = 'private'; break;
      case ReflectionMethod::IS_PROTECTED:  $ret[] = 'protected'; break;
    }
    if ($modifiers & ReflectionMethod::IS_STATIC) {
      $ret[] = 'static';
    }

    return $ret;
  }
}
