{- This module was generated from data in the Kate syntax
   highlighting file zsh.xml, version 1, by Jonathan Kolberg (bulldog98@kubuntu-de.org) -}

module Text.Highlighting.Kate.Syntax.Zsh
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Zsh"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sh;*.zsh;.zshrc;.zprofile;.zlogin;.zlogout;.profile"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Zsh","Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Zsh","Start") -> return ()
      ("Zsh","FindAll") -> return ()
      ("Zsh","FindMost") -> return ()
      ("Zsh","FindComments") -> (popContext) >> pEndLine
      ("Zsh","Comment") -> (popContext) >> pEndLine
      ("Zsh","FindCommentsParen") -> (popContext) >> pEndLine
      ("Zsh","CommentParen") -> (popContext) >> pEndLine
      ("Zsh","FindCommentsBackq") -> (popContext) >> pEndLine
      ("Zsh","CommentBackq") -> (popContext) >> pEndLine
      ("Zsh","FindCommands") -> return ()
      ("Zsh","FindOthers") -> return ()
      ("Zsh","FindStrings") -> return ()
      ("Zsh","FindSubstitutions") -> return ()
      ("Zsh","FindTests") -> return ()
      ("Zsh","ExprDblParen") -> return ()
      ("Zsh","ExprDblParenSubst") -> return ()
      ("Zsh","ExprSubParen") -> return ()
      ("Zsh","ExprBracket") -> return ()
      ("Zsh","ExprDblBracket") -> return ()
      ("Zsh","Group") -> return ()
      ("Zsh","SubShell") -> return ()
      ("Zsh","Assign") -> (popContext) >> pEndLine
      ("Zsh","AssignArray") -> (popContext) >> pEndLine
      ("Zsh","AssignSubscr") -> (popContext) >> pEndLine
      ("Zsh","Subscript") -> return ()
      ("Zsh","FunctionDef") -> (popContext) >> pEndLine
      ("Zsh","VarName") -> (popContext) >> pEndLine
      ("Zsh","ProcessSubst") -> return ()
      ("Zsh","StringSQ") -> return ()
      ("Zsh","StringDQ") -> return ()
      ("Zsh","StringEsc") -> return ()
      ("Zsh","VarBrace") -> return ()
      ("Zsh","VarAlt") -> return ()
      ("Zsh","VarSubst") -> return ()
      ("Zsh","VarSubst2") -> return ()
      ("Zsh","VarSub") -> return ()
      ("Zsh","VarSub2") -> return ()
      ("Zsh","SubstFile") -> return ()
      ("Zsh","SubstCommand") -> return ()
      ("Zsh","SubstBackq") -> return ()
      ("Zsh","Case") -> return ()
      ("Zsh","CaseIn") -> return ()
      ("Zsh","CaseExpr") -> return ()
      ("Zsh","HereDoc") -> return ()
      ("Zsh","HereDocRemainder") -> (popContext) >> pEndLine
      ("Zsh","HereDocQ") -> return ()
      ("Zsh","HereDocNQ") -> return ()
      ("Zsh","HereDocIQ") -> return ()
      ("Zsh","HereDocINQ") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "else for function in select until while elif then set"
list_builtins = Set.fromList $ words $ "- . : alias autoload bg bindkey break builtin bye cap cd chdir clone command comparguments compcall compctl compdescribe compfiles compgroups compquote comptags comptry compvalues continue dirs disable disown echo echotc echoti emulate enable eval exec exit false fc fg functions getcap getopts hash history jobs kill let limit log logout noglob popd print printf pushd pushln pwd r rehash return sched set setcap setopt shift source stat suspend test times trap true ttyctl type ulimit umask unalias unfunction unhash unlimit unset unsetopt vared wait whence where which zcompile zformat zftp zle zmodload zparseopts zprof zpty zregexparse zsocket zstyle ztcp"
list_builtins'5fvar = Set.fromList $ words $ "declare export float getln integer unset declare typeset local read readonly"
list_unixcommands = Set.fromList $ words $ "arch awk bash bunzip2 bzcat bzcmp bzdiff bzegrep bzfgrep bzgrep bzip2 bzip2recover bzless bzmore cat chattr chgrp chmod chown chvt cp date dd deallocvt df dir dircolors dmesg dnsdomainname domainname du dumpkeys echo ed egrep false fgconsole fgrep fuser gawk getkeycodes gocr grep groff groups gunzip gzexe gzip hostname igawk install kbd_mode kbdrate killall last lastb link ln loadkeys loadunimap login ls lsattr lsmod lsmod.old lzcat lzcmp lzdiff lzegrep lzfgrep lzgrep lzless lzcat lzma lzmainfo lzmore mapscrn mesg mkdir mkfifo mknod mktemp more mount mv nano netstat nisdomainname nroff openvt pgawk pidof ping ps pstree pwd rbash readlink red resizecons rm rmdir run-parts sash sed setfont setkeycodes setleds setmetamode setserial sh showkey shred sleep ssed stat stty su sync tar tempfile touch troff true umount uname unicode_start unicode_stop unlink unlzma unxz utmpdump uuidgen vdir wall wc xz xzcat ypdomainname zcat zcmp zdiff zegrep zfgrep zforce zgrep zless zmore znew zsh aclocal aconnect aplay apm apmsleep apropos ar arecord as as86 autoconf autoheader automake awk basename bc bison c++ cal cat cc cdda2wav cdparanoia cdrdao cd-read cdrecord chfn chgrp chmod chown chroot chsh clear cmp co col comm cp cpio cpp cut dc dd df diff diff3 dir dircolors directomatic dirname du env expr fbset file find flex flex++ fmt free ftp funzip fuser g++ gawk gc gcc gdb getent getopt gettext gettextize gimp gimp-remote gimptool gmake gs head hexdump id install join kill killall ld ld86 ldd less lex ln locate lockfile logname lp lpr ls lynx m4 make man mkdir mknod msgfmt mv namei nasm nawk nice nl nm nm86 nmap nohup nop od passwd patch pcregrep pcretest perl perror pidof pr printf procmail prune ps2ascii ps2epsi ps2frag ps2pdf ps2ps psbook psmerge psnup psresize psselect pstops rcs rev rm scp sed seq setterm shred size size86 skill slogin snice sort sox split ssh ssh-add ssh-agent ssh-keygen ssh-keyscan stat strings strip sudo suidperl sum tac tail tee test tr uniq unlink unzip updatedb updmap uptime users vmstat w wc wget whatis whereis which who whoami write xargs yacc yes zip zsoelim dcop kdialog kfile xhost xmodmap xset"

regex_'5b'5cs'3b'5d'28'3f'3d'23'29 = compileRegex True "[\\s;](?=#)"
regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 = compileRegex True "[^)](?=\\))"
regex_'5b'5e'60'5d'28'3f'3d'60'29 = compileRegex True "[^`](?=`)"
regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\[\\[(?=($|\\s))"
regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\s\\[\\[(?=($|\\s))"
regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\[(?=($|\\s))"
regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\s\\[(?=($|\\s))"
regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\{(?=($|\\s))"
regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bdo(?![\\w$+-])"
regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bdone(?![\\w$+-])"
regex_'5cbif'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\bif(?=($|\\s))"
regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bfi(?![\\w$+-])"
regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bcase(?![\\w$+-])"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "-[A-Za-z0-9][A-Za-z0-9_]*"
regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a = compileRegex True "--[a-z][A-Za-z0-9_-]*"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*\\+?="
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*(?=\\[.+\\]\\+?=)"
regex_'5cbfunction'5cb = compileRegex True "\\bfunction\\b"
regex_'5c'2e'28'3f'3d'5cs'29 = compileRegex True "\\.(?=\\s)"
regex_'5cd'2a'3c'3c'3c = compileRegex True "\\d*<<<"
regex_'5b'3c'3e'5d'5c'28 = compileRegex True "[<>]\\("
regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 = compileRegex True "([0-9]*(>{1,2}|<)(&[0-9]+-?)?|&>|>&|[0-9]*<>)"
regex_'28'5b'7c'26'5d'29'5c1'3f = compileRegex True "([|&])\\1?"
regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 = compileRegex True "[A-Za-z_:][A-Za-z0-9_:#%@-]*\\s*\\(\\)"
regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d = compileRegex True "\\\\[][;\\\\$`{}()|&<>* ]"
regex_'5c'5c'24 = compileRegex True "\\\\$"
regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d = compileRegex True "\\{(?!(\\s|$))\\S*\\}"
regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 = compileRegex True "([\\w_@.%*?+-]|\\\\ )*(?=/)"
regex_'7e'5cw'2a = compileRegex True "~\\w*"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex True "/([\\w_@.%*?+-]|\\\\ )*(?=([\\s/):;$`'\"]|$))"
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b = compileRegex True "\\$[A-Za-z_][A-Za-z0-9_]*\\["
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\$[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d = compileRegex True "\\$[*@#?$!_0-9-]"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d = compileRegex True "\\$\\{[*@#?$!_0-9-]\\}"
regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d = compileRegex True "\\$\\{#[A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\])?\\}"
regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d = compileRegex True "\\$\\{![A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\]|[*@])?\\}"
regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\$\\{[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 = compileRegex True "\\$\\{[*@#?$!_0-9-](?=[:#%/=?+-])"
regex_'5c'5c'5b'60'24'5c'5c'5d = compileRegex True "\\\\[`$\\\\]"
regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 = compileRegex True "-[abcdefghkprstuwxOGLSNozn](?=\\s)"
regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 = compileRegex True "-([no]t|ef)(?=\\s)"
regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 = compileRegex True "([!=]=?|[><])(?=\\s)"
regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 = compileRegex True "-(eq|ne|[gl][te])(?=\\s)"
regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\s\\](?=($|[\\s;|&]))"
regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\](?=($|[\\s;|&]))"
regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\s\\]\\](?=($|[\\s;|&]))"
regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\]\\](?=($|[\\s;|&]))"
regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d = compileRegex True "[\\w:,+_./-]"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f = compileRegex True "\\s+[A-Za-z_:][A-Za-z0-9_:#%@-]*(\\s*\\(\\))?"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b = compileRegex True "-[A-Za-z0-9]+"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*"
regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d = compileRegex True "[^]})|;`&><]"
regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d = compileRegex True "\\\\[`\"\\\\$\\n]"
regex_'5c'5c'5babefnrtv'5c'5c'27'5d = compileRegex True "\\\\[abefnrtv\\\\']"
regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 = compileRegex True "\\\\([0-7]{1,3}|x[A-Fa-f0-9]{1,2}|c.)"
regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 = compileRegex True "(:?[-=?+]|##?|%%?)"
regex_'2f'2f'3f = compileRegex True "//?"
regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "[A-Za-z_][A-Za-z0-9_]*"
regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 = compileRegex True "[0-9]+(?=[:}])"
regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 = compileRegex True "[0-9](?=[:}])"
regex_'5csin'5cb = compileRegex True "\\sin\\b"
regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex True "\\besac(?=$|[\\s;)])"
regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex True "esac(?=$|[\\s;)])"
regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex True "(<<-\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex True "(<<-\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<-\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<-\\s*([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex True "(<<\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex True "(<<\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<\\s*([^|&;()<>\\s]+))"

parseRules ("Zsh","Start") =
  (((parseRules ("Zsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindAll") =
  (((parseRules ("Zsh","FindComments")))
   <|>
   ((parseRules ("Zsh","FindCommands")))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindAll")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindMost") =
  (((parseRules ("Zsh","FindComments")))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindMost")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindComments") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Zsh","Comment"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Zsh","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindComments")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Zsh","FindCommentsParen") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Zsh","CommentParen"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Zsh","CommentParen"))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindCommentsParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","CommentParen") =
  (((pRegExpr regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","CommentParen")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Zsh","FindCommentsBackq") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Zsh","CommentBackq"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Zsh","CommentBackq"))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindCommentsBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","CommentBackq") =
  (((pRegExpr regex_'5b'5e'60'5d'28'3f'3d'60'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","CommentBackq")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Zsh","FindCommands") =
  (((pDetect2Chars False '(' '(' >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","ExprDblParen"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","ExprDblBracket"))
   <|>
   ((pRegExpr regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","ExprDblBracket"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","ExprBracket"))
   <|>
   ((pRegExpr regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","ExprBracket"))
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","Group"))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","SubShell"))
   <|>
   ((pRegExpr regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","Case"))
   <|>
   ((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Assign"))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 >>= withAttribute OtherTok) >>~ pushContext ("Zsh","AssignSubscr"))
   <|>
   ((pString False ":()" >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","FunctionDef"))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'2e'28'3f'3d'5cs'29 >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_unixcommands >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins'5fvar >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","VarName"))
   <|>
   ((pRegExpr regex_'5cd'2a'3c'3c'3c >>= withAttribute KeywordTok))
   <|>
   ((lookAhead (pString False "<<") >> pushContext ("Zsh","HereDoc") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5b'3c'3e'5d'5c'28 >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","ProcessSubst"))
   <|>
   ((pRegExpr regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5b'7c'26'5d'29'5c1'3f >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 >>= withAttribute FunctionTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindCommands")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindOthers") =
  (((pRegExpr regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'7e'5cw'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindOthers")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindStrings") =
  (((pDetect2Chars False '\\' '\'' >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False '\\' '"' >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Zsh","StringSQ"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Zsh","StringDQ"))
   <|>
   ((pDetect2Chars False '$' '\'' >>= withAttribute StringTok) >>~ pushContext ("Zsh","StringEsc"))
   <|>
   ((pDetect2Chars False '$' '"' >>= withAttribute StringTok) >>~ pushContext ("Zsh","StringDQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindStrings")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindSubstitutions") =
  (((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Subscript"))
   <|>
   ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarBrace"))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarBrace"))
   <|>
   ((pString False "$((" >>= withAttribute OtherTok) >>~ pushContext ("Zsh","ExprDblParenSubst"))
   <|>
   ((pString False "$(<" >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","SubstFile"))
   <|>
   ((pString False "$(" >>= withAttribute OtherTok) >>~ pushContext ("Zsh","SubstCommand"))
   <|>
   ((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","SubstBackq"))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'24'5c'5c'5d >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindSubstitutions")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","FindTests") =
  (((pRegExpr regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","FindTests")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","ExprDblParen") =
  (((pDetect2Chars False ')' ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Zsh","ExprSubParen"))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","ExprDblParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","ExprDblParenSubst") =
  (((pDetect2Chars False ')' ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Zsh","ExprSubParen"))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","ExprDblParenSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","ExprSubParen") =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Zsh","ExprSubParen"))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","ExprSubParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","ExprBracket") =
  (((pRegExpr regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Zsh","ExprSubParen"))
   <|>
   ((parseRules ("Zsh","FindTests")))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","ExprBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","ExprDblBracket") =
  (((pRegExpr regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Zsh","ExprSubParen"))
   <|>
   ((parseRules ("Zsh","FindTests")))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","ExprDblBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","Group") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","Group")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","SubShell") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","SubShell")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","Assign") =
  (((pDetectChar False '(' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","AssignArray"))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   ((pRegExpr regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Zsh","AssignArray") =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Assign"))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","AssignArray")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","AssignSubscr") =
  (((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Subscript"))
   <|>
   ((pDetect2Chars False '+' '=' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Assign"))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Assign"))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Zsh","Subscript") =
  (((pDetectChar False ']' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","Subscript")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Zsh","FunctionDef") =
  (((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Zsh","VarName") =
  (((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Assign"))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   ((pRegExpr regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Zsh","ProcessSubst") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindCommentsParen")))
   <|>
   ((parseRules ("Zsh","FindCommands")))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","ProcessSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","StringSQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","StringSQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Zsh","StringDQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d >>= withAttribute DataTypeTok))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","StringDQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Zsh","StringEsc") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5babefnrtv'5c'5c'27'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","StringEsc")) >> pDefault >>= withAttribute StringTok))

parseRules ("Zsh","VarBrace") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","Subscript"))
   <|>
   ((pRegExpr regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarAlt"))
   <|>
   ((pRegExpr regex_'2f'2f'3f >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarSubst"))
   <|>
   ((pDetectChar False ':' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarSub"))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","VarBrace")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Zsh","VarAlt") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","VarAlt")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","VarSubst") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '/' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarSubst2"))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","VarSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","VarSubst2") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","VarSubst2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","VarSub") =
  (((pDetectChar False ':' >>= withAttribute OtherTok) >>~ pushContext ("Zsh","VarSub2"))
   <|>
   ((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute OtherTok))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","VarSub")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Zsh","VarSub2") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute OtherTok))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","VarSub2")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Zsh","SubstFile") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindCommentsParen")))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","SubstFile")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","SubstCommand") =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindCommentsParen")))
   <|>
   ((parseRules ("Zsh","FindCommands")))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","SubstCommand")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","SubstBackq") =
  (((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Zsh","FindCommentsBackq")))
   <|>
   ((parseRules ("Zsh","FindCommands")))
   <|>
   ((parseRules ("Zsh","FindStrings")))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   ((parseRules ("Zsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","SubstBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","Case") =
  (((pRegExpr regex_'5csin'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","CaseIn"))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","Case")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","CaseIn") =
  (((pRegExpr regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","CaseExpr"))
   <|>
   ((pAnyChar "(|" >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("Zsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","CaseIn")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","CaseExpr") =
  (((pDetect2Chars False ';' ';' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> lookAhead (pRegExpr regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("Zsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","CaseExpr")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","HereDoc") =
  (((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext ("Zsh","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext ("Zsh","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Zsh","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Zsh","HereDocINQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext ("Zsh","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext ("Zsh","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Zsh","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Zsh","HereDocNQ") >> currentContext >>= parseRules))
   <|>
   ((pString False "<<" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","HereDoc")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","HereDocRemainder") =
  (((parseRules ("Zsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","HereDocRemainder")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","HereDocQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","HereDocQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","HereDocNQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","HereDocNQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","HereDocIQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","HereDocIQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Zsh","HereDocINQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Zsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Zsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Zsh","HereDocINQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("Zsh","Start") <|> fail ("Unknown context" ++ show x)
