#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "hoz.h"
#include "hozgtk.h"
#include "hozgtk_c.h"
#include "hozgtk_i.h"
#include "hozgtk_s.h"

extern char outpath[MAXLEN];
extern size_t fullsize, partsize, headersize;
extern int showprogress, forceow, simulate;

extern GtkWidget *window_hoz;
extern GtkWidget *window_bs;
extern GtkWidget *window_ra;
extern GtkWidget *window_fd;
extern GtkTextView *rprttextview;
extern GtkTextBuffer *rprtbuf;
extern char hozfile[MAXLEN + 1];
extern int hozaction;


void on_window_hoz_destroy(GtkObject * object, gpointer user_data)
{
    gtk_main_quit();
}


void on_entry_size_changed(GtkEditable * editable, gpointer user_data)
{
    /* do nothing here */
    hoz_getsize();
}


void on_button_cut_clicked(GtkButton * button, gpointer user_data)
{
    hozaction = 1;
    if (hoz_getsize() && !hoz_getoutpdir() && !hoz_fileop(0)) {
    }
}


void on_button_paste_clicked(GtkButton * button, gpointer user_data)
{
    hozaction = 2;
    if (!hoz_getoutpdir() && !hoz_fileop(1)) {
    }
}




void on_ok_button_fd_clicked(GtkButton * button, gpointer user_data)
{
    strcpy(hozfile,
           gtk_file_selection_get_filename(GTK_FILE_SELECTION(window_fd)));
    gtk_widget_destroy(window_fd);
    window_fd = NULL;

    showprogress = (int)
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                     (lookup_widget
                                      (GTK_WIDGET(window_hoz),
                                       "checkbutton_prgr")));

    if (hozaction == 1) {
        hoz_cut_main(hozfile);
    } else if (hozaction == 2) {
        hoz_paste_main(hozfile);
    } else {
        hoz_print(hozfile);
        hoz_lf();
    }
    hozaction = 0;
    hoz_ready();
}


void on_cancel_button_fd_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_destroy(window_fd);
    window_fd = NULL;
}


void on_button_yes_ra_clicked(GtkButton * button, gpointer user_data)
{
    forceow = 1;
    gtk_widget_destroy(window_ra);
    window_ra = NULL;
    hoz_paste_main(hozfile);
    forceow = 0;
    hozaction = 0;
    hoz_ready();
}


void on_button_no_ra_clicked(GtkButton * button, gpointer user_data)
{
    forceow = 0;
    gtk_widget_destroy(window_ra);
    window_ra = NULL;
}


void on_okbutton_bs_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_destroy(window_bs);
    window_bs = NULL;
}

void
on_combo_entry_size_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
    /* do nothing here */
    hoz_getsize();
}

