'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) fileselectiondialog.n 1.21 94/12/17 16:04:44
'\"
.so man.macros
.HS iwidgets::fileselectiondialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::fileselectiondialog \- Create and manipulate a file selection dialog widget
.SH SYNOPSIS
\fBiwidgets::fileselectiondialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- iwidgets::Shell <- iwidgets::Dialogshell <- iwidgets::Dialog <- iwidgets::Fileselectiondialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground   background         borderWidth         cursor
foreground         highlightColor     highlightThickness  insertBackground
insertBorderWidth  insertOffTime      insertOnTime        insertWidth
selectBackground   selectBorderWidth  selectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above associated
options.
.LP
.nf
.ta 4c 8c 12c
\fBchildSitePos\fR	\fBdirectory\fR	\fBdirsLabel\fR	\fBdirSearchCommand\fR
\fBdirsOn\fR	\fBfilesLabel\fR	\fBfilesLabelOn\fR	\fBfileSearchCommand\fR
\fBfilesOn\fR	\fBfileType\fR	\fBfilterLabel\fR	\fBfilterOn\fR
\fBinvalid\fR	\fBmask\fR	\fBnoMatchString\fR	\fBselectionLabel\fR
\fBselectionOn\fR
.fi
.LP
See the "fileselectionbox" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "scrolledlistbox" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget class manual entry for details on the above
associated options.

.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBheight\fR	\fBmaster\fR	\fBmodality\fR	\fBwidth\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBtitle\fR 
.fi
.LP
See the "Toplevel" widget  manual entry for details on the above
inherited options.
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::fileselectiondialog\fR command creates a file selection dialog 
similar to the OSF/Motif standard composite widget.  The
fileselectiondialog is derived from the Dialog class and is composed of 
a FileSelectionBox with attributes set to manipulate the dialog buttons.

.SH "METHODS"
.PP
The \fBiwidgets::fileselectiondialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for fileselectiondialog widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBget\fR	\fBchildsite\fR	\fBfilter\fR
.fi
.LP
See the "fileselectionbox" class manual entry for details on the 
associated methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinsert\fR	\fBinvoke\fR	\fBshow\fR	
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by 
the \fBiwidgets::fileselectiondialog\fR command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by 
the \fBiwidgets::fileselectiondialog\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBfsb\fR
Class:	\fBFileselectionbox\fR
.fi
.IP
The fsb component is the file selection box for the file selection dialog.
See the "fileselectionbox" widget manual entry for details on the fsb
component item.
.fi

.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 #
 # Non-modal example
 #
 proc okCallback {} {
     puts "You selected [.nmfsd get]"
     .nmfsd deactivate
 }

 iwidgets::fileselectiondialog .nmfsd -title Non-Modal
 .nmfsd buttonconfigure OK -command okCallback

 .nmfsd activate

 #
 # Modal example
 #
 iwidgets::fileselectiondialog .mfsd -modality application
 .mfsd center

 if {[.mfsd activate]} {
     puts "You selected [.mfsd get]"
 } else {
     puts "You cancelled the dialog"
 }
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
fileselectiondialog, fileselectionbox, dialog, dialogshell, shell, widget
