/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

final class PLPXMLInputStream
extends BufferedInputStream {
    private static final byte[] xmlBOM = new byte[]{-1, -2};
    private final PLPInputStream plpStream;

    static final PLPXMLInputStream makeXMLStream(TDSReader tDSReader, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        PLPInputStream pLPInputStream = PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, serverDTVImpl);
        if (null == pLPInputStream) {
            return null;
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(pLPInputStream, 2);
        try {
            pushbackInputStream.unread(xmlBOM);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new PLPXMLInputStream(tDSReader, pLPInputStream, pushbackInputStream);
    }

    public void close() throws IOException {
        this.plpStream.close();
        super.close();
    }

    PLPXMLInputStream(TDSReader tDSReader, PLPInputStream pLPInputStream, InputStream inputStream) {
        super(inputStream);
        this.plpStream = pLPInputStream;
    }

    int getLength() {
        return this.plpStream.getLength() + xmlBOM.length;
    }

    byte[] getBytes() throws SQLServerException {
        byte[] byArray = this.plpStream.getBytes();
        byte[] byArray2 = new byte[byArray.length + xmlBOM.length];
        System.arraycopy(xmlBOM, 0, byArray2, 0, xmlBOM.length);
        System.arraycopy(byArray, 0, byArray2, xmlBOM.length, byArray.length);
        return byArray2;
    }

    int getLengthWithoutBOM() {
        return this.plpStream.getLength();
    }
}

