/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtil<T> {
    private static final Log log = Log.getInstance(ResolverUtil.class);
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ResolverUtil<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> find(Test test, String packageName) {
        Enumeration<URL> urls;
        packageName = packageName.replace('.', '/');
        ClassLoader loader = this.getClassLoader();
        try {
            urls = loader.getResources(packageName);
        }
        catch (IOException ioe) {
            log.warn("Could not read package: " + packageName, ioe);
            return this;
        }
        while (urls.hasMoreElements()) {
            String urlPath = urls.nextElement().getFile();
            if ((urlPath = StringUtil.urlDecode(urlPath)).startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
            log.info("Scanning for classes in [", urlPath, "] matching criteria: ", test);
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageName, file);
                continue;
            }
            this.loadImplementationsInJar(test, packageName, file);
        }
        return this;
    }

    private void loadImplementationsInDirectory(Test test, String parent, File location) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        if (files == null) {
            log.warn("Could not list directory " + location.getAbsolutePath() + " when looking for classes matching: " + test);
            return;
        }
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            builder.append(parent).append("/").append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass);
        }
    }

    private void loadImplementationsInJar(Test test, String parent, File jarfile) {
        try {
            JarEntry entry;
            JarInputStream jarStream = new JarInputStream(new FileInputStream(jarfile));
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.addIfMatching(test, name);
            }
        }
        catch (IOException ioe) {
            log.error("Could not search jar file '", jarfile, "' for classes matching criteria: ", test, "due to an IOException: ", ioe.getMessage());
        }
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            log.trace("Checking to see if class ", externalName, " matches criteria [", test, "]");
            Class<?> type = loader.loadClass(externalName);
            if (test.matches(type)) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '", fqn, "'", " due to a ", t.getClass().getName(), " with message: ", t.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public boolean matches(Class type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        public boolean matches(Class type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

