/*
 * Copyright 1998-2009 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/* @test
 * @summary Passed: Execution successful
 * @run junit/othervm -DtestSysProp=testVal VMOptsPassed
 */

import org.junit.*;
import static org.junit.Assert.*;

public class VMOptsPassed
{
    @Test
    public void test1() {
        String sysprop = System.getProperty("testSysProp");
        if (sysprop == null) {
            throw new RuntimeException("unable to find passed system property!");
        } else {
            if (!sysprop.equals("testVal"))
                throw new RuntimeException("passed system property incorrectly set " +
                                           "expected: testVal " +
                                           "found: " + sysprop);
            else
                System.out.println("found passed system property:  testSysProp=" + sysprop);
        }
    }
}
