/*
Polyester widget style for KDE 4
Copyright (C) 2006 Marco Martin <notmart@gmail.com>
based on the Keramik and Plastik configuration dialog:

Plastik:
Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

Keramik:
Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#ifndef POLYESTER_CONF_H
#define POLYESTER_CONF_H

#include "ui_configdialog.h"

class QCheckBox;
class QComboBox;
class ConfigDialog;

class PolyesterStyleConfig: public QWidget
{
	Q_OBJECT
public:
	PolyesterStyleConfig(QWidget* parent);
	~PolyesterStyleConfig();

	//This signal and the next two slots are the plugin
	//page interface
signals:
	void changed(bool);

public slots:
	void save();
	void defaults();

	//Everything below this is internal.
protected slots:
	void updateChanged();

protected:
	QString buttonType( int listnr );
	int buttonItem( QString kBType );
	QString scrollBarType( int listnr );
	int scrollBarItem( QString kSType );

	//Original settings, for accurate dirtiness tracking
	bool       origUseLowerCaseText;
	bool       origScrollBarLines;
	QString    origScrollBarStyle;
	int        origScrollBarSize;
	bool       origColoredScrollBar;
	bool       origCenteredTabBar;
	bool       origHighLightTab;
	bool       origStatusBarFrame;
	int        origMenuItemSpacing;
	bool       origButtonMenuItem;
	bool       origMenuBarEmphasis;
	bool       origMenuBarEmphasisBorder;
	bool       origCustomMenuBarEmphasisColor;
	QColor     origMenuBarEmphasisColor;
	bool       origMenuStripe;
        bool       origColorizeSortedHeader;
	bool       origShadowedButtonsText;
	bool       origSunkenShadows;
        bool       origShadowedMenuBarText;
	bool       origAnimProgressBar;
	bool       origLightBorder;
	bool       origAnimButton;
	bool       origAnimButtonToDark;
	bool       origDrawToolBarSeparator;
	bool       origDrawToolBarItemSeparator;
//	bool       origDrawFocusRect;
	bool       origDrawTriangularExpander;
	bool       origInputFocusHighlight;
	QString    origButtonStyle;
	bool       origCustomOverHighlightColor;
	QColor     origOverHighlightColor;
	bool       origCustomFocusHighlightColor;
	QColor     origFocusHighlightColor;
	bool       origCustomCheckMarkColor;
	QColor     origCheckMarkColor;

private:
	Ui_ConfigDialog *dialog_;
};

#endif
