/*
 * Copyright <year> Milian Wolff <mail@milianw.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KDEVPLATFORM_PLUGIN_QUICKOPENTESTBASE_H
#define KDEVPLATFORM_PLUGIN_QUICKOPENTESTBASE_H

#include <QObject>

#include <language/interfaces/quickopenfilter.h>

#include <tests/testcore.h>
#include <tests/testproject.h>

#include <project/projectmodel.h>

#include "../projectfilequickopen.h"

class QuickOpenTestBase : public QObject
{
    Q_OBJECT
public:
    explicit QuickOpenTestBase(KDevelop::TestCore::Setup setup, QObject* parent = 0);

private slots:
    void initTestCase();
    void cleanupTestCase();

    void cleanup();

protected:
    KDevelop::TestCore* core;
    KDevelop::TestCore::Setup setup;
    KDevelop::TestProjectController* projectController;
};

class TestFilter : public KDevelop::FilterWithSeparator<QString>
{
public:
    virtual ~TestFilter() {}
    virtual QString itemText(const QString& data) const
    {
        return data;
    }
};

KDevelop::TestProject* getProjectWithFiles(int files);

template<class T>
T* createChild(KDevelop::ProjectFolderItem* parent, const QString& childName)
{
    KUrl url(parent->url());
    url.addPath(childName);
    return new T(parent->project(), url, parent);
}

QStringList items(const ProjectFileDataProvider& provider);

#endif // KDEVPLATFORM_PLUGIN_QUICKOPENTESTBASE_H
