/***************************************************************************
                          inktransferp2p.h -  description
                             -------------------
    begin                : Sun Mar 23 2008
    copyright            : (C) 2008 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INKTRANSFERP2P_H
#define INKTRANSFERP2P_H

#include "p2papplication.h"
#include "../../contact/contactbase.h"

#include <QBuffer>



/**
 * Ink transfer class.
 *
 * Windows Live Messenger 8.5 always sends winks as seperate P2P messages instead of directly
 * over the switchboard. It uses image/gif as a mime type. Live Messenger 2009 just uses the
 * switchboard and uses image/gif or application/x-ms-ink. Both clients allow receiving
 * switchboard transfers.
 *
 * @author Antonio Nastasi, Diederik van der Boor
 * @ingroup Applications
 */
class InkTransferP2P : public P2PApplication
{
  Q_OBJECT

  public:
    // The fixed session ID used by all ink transfer sessions.
    static const unsigned long SESSION_ID = 64;

    // The constructor
                           InkTransferP2P( ApplicationList *applicationList );

    // The destructor
    virtual               ~InkTransferP2P();

    // Hide standard informative application message (e.g. user invited, cancelled)
    virtual void           showEventMessage( const QString &message, const ChatMessage::ContentsClass contents, bool isIncoming );
    // Show a message to notify about a system error.
    virtual void           showSystemMessage( const QString &message, const ChatMessage::ContentsClass contents, bool isIncoming );
    // Read the buffer, send the inkReceived() signal.
    void                   showTransferComplete();

  protected:
    // Called when data is received
    void                   gotData( const P2PMessage &message );

  signals:
    // Signal that an ink image was received.
    void                   inkReceived( const QString &base64ImageData, const QString& contact, InkFormat format );

  private:
    QBuffer                inkBuffer_;
};

#endif
